/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.jms.client;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.core.config.Credentials;
import io.gatling.jms.client.JmsClient$;
import io.gatling.jms.client.JmsReqReplyClient;
import io.gatling.jms.client.JmsSendClient;
import io.gatling.jms.protocol.JmsProtocol;
import io.gatling.jms.request.JmsDestination;
import io.gatling.jms.request.JmsQueue;
import io.gatling.jms.request.JmsTemporaryQueue$;
import io.gatling.jms.request.JmsTemporaryTopic$;
import io.gatling.jms.request.JmsTopic;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Hashtable;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.compat.java8.JFunction1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ex!B\u0001\u0003\u0011\u0003Y\u0011!\u0003&ng\u000ec\u0017.\u001a8u\u0015\t\u0019A!\u0001\u0004dY&,g\u000e\u001e\u0006\u0003\u000b\u0019\t1A[7t\u0015\t9\u0001\"A\u0004hCRd\u0017N\\4\u000b\u0003%\t!![8\u0004\u0001A\u0011A\"D\u0007\u0002\u0005\u0019)aB\u0001E\u0001\u001f\tI!*\\:DY&,g\u000e^\n\u0003\u001bA\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007\"B\f\u000e\t\u0003A\u0012A\u0002\u001fj]&$h\bF\u0001\f\u0011\u0015QR\u0002\"\u0001\u001c\u0003\u0015\t\u0007\u000f\u001d7z)\rarD\n\t\u0003\u0019uI!A\b\u0002\u0003\u001b)k7oU3oI\u000ec\u0017.\u001a8u\u0011\u0015\u0001\u0013\u00041\u0001\"\u0003!\u0001(o\u001c;pG>d\u0007C\u0001\u0012%\u001b\u0005\u0019#B\u0001\u0011\u0005\u0013\t)3EA\u0006K[N\u0004&o\u001c;pG>d\u0007\"B\u0014\u001a\u0001\u0004A\u0013a\u00033fgRLg.\u0019;j_:\u0004\"!\u000b\u0017\u000e\u0003)R!a\u000b\u0003\u0002\u000fI,\u0017/^3ti&\u0011QF\u000b\u0002\u000f\u00156\u001cH)Z:uS:\fG/[8o\u0011\u0015QR\u0002\"\u00010)\u0011\u00014\u0007N\u001b\u0011\u00051\t\u0014B\u0001\u001a\u0003\u0005EQUn\u001d*fcJ+\u0007\u000f\\=DY&,g\u000e\u001e\u0005\u0006A9\u0002\r!\t\u0005\u0006O9\u0002\r\u0001\u000b\u0005\u0006m9\u0002\r\u0001K\u0001\u0011e\u0016\u0004H.\u001f#fgRLg.\u0019;j_:4QA\u0004\u0002\u0002\u0002a\u001a2a\u000e\t:!\tQ\u0014)D\u0001<\u0015\taT(\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002?\u007f\u0005AA/\u001f9fg\u00064WMC\u0001A\u0003\r\u0019w.\\\u0005\u0003\u0005n\u0012Qb\u0015;sS\u000e$Hj\\4hS:<\u0007\u0002\u0003#8\u0005\u0003\u0005\u000b\u0011B#\u0002+\r|gN\\3di&|gNR1di>\u0014\u0018PT1nKB\u0011a)\u0013\b\u0003#\u001dK!\u0001\u0013\n\u0002\rA\u0013X\rZ3g\u0013\tQ5J\u0001\u0004TiJLgn\u001a\u0006\u0003\u0011JA\u0001bJ\u001c\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\t\u001d^\u0012\t\u0011)A\u0005\u000b\u0006\u0019QO\u001d7\t\u0011A;$\u0011!Q\u0001\nE\u000b1b\u0019:fI\u0016tG/[1mgB\u0019\u0011C\u0015+\n\u0005M\u0013\"AB(qi&|g\u000e\u0005\u0002V56\taK\u0003\u0002X1\u000611m\u001c8gS\u001eT!!\u0017\u0004\u0002\t\r|'/Z\u0005\u00037Z\u00131b\u0011:fI\u0016tG/[1mg\"AQl\u000eB\u0001B\u0003%a,\u0001\tb]>t\u00170\\8vg\u000e{gN\\3diB\u0011\u0011cX\u0005\u0003AJ\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005co\t\u0005\t\u0015!\u0003F\u00039\u0019wN\u001c;fqR4\u0015m\u0019;pefD\u0001\u0002Z\u001c\u0003\u0002\u0003\u0006I!Z\u0001\rI\u0016d\u0017N^3ss6{G-\u001a\t\u0003#\u0019L!a\u001a\n\u0003\u0007%sG\u000fC\u0003\u0018o\u0011\u0005\u0011\u000e\u0006\u0005kW2lgn\u001c9r!\taq\u0007C\u0003EQ\u0002\u0007Q\tC\u0003(Q\u0002\u0007\u0001\u0006C\u0003OQ\u0002\u0007Q\tC\u0003QQ\u0002\u0007\u0011\u000bC\u0003^Q\u0002\u0007a\fC\u0003cQ\u0002\u0007Q\tC\u0003eQ\u0002\u0007Q\rC\u0004to\t\u0007I\u0011\u0001;\u0002\u0015A\u0014x\u000e]3si&,7/F\u0001v!\u0011180R#\u000e\u0003]T!\u0001_=\u0002\tU$\u0018\u000e\u001c\u0006\u0002u\u0006!!.\u0019<b\u0013\taxOA\u0005ICNDG/\u00192mK\"1ap\u000eQ\u0001\nU\f1\u0002\u001d:pa\u0016\u0014H/[3tA!I\u0011\u0011A\u001cC\u0002\u0013\u0005\u00111A\u0001\u0004GRDXCAA\u0003!\u0011\t9!!\u0005\u000e\u0005\u0005%!\u0002BA\u0006\u0003\u001b\taA\\1nS:<'BAA\b\u0003\u0015Q\u0017M^1y\u0013\u0011\t\u0019\"!\u0003\u0003\u001d%s\u0017\u000e^5bY\u000e{g\u000e^3yi\"A\u0011qC\u001c!\u0002\u0013\t)!\u0001\u0003dib\u0004\u0003\"CA\u000eo\t\u0007I\u0011AA\u000f\u0003\r\t8MZ\u000b\u0003\u0003?\u0001B!!\t\u0002&5\u0011\u00111\u0005\u0006\u0004\u000b\u00055\u0011\u0002BA\u0014\u0003G\u0011\u0011cQ8o]\u0016\u001cG/[8o\r\u0006\u001cGo\u001c:z\u0011!\tYc\u000eQ\u0001\n\u0005}\u0011\u0001B9dM\u0002B\u0011\"a\f8\u0005\u0004%\t!!\r\u0002\t\r|gN\\\u000b\u0003\u0003g\u0001B!!\t\u00026%!\u0011qGA\u0012\u0005)\u0019uN\u001c8fGRLwN\u001c\u0005\t\u0003w9\u0004\u0015!\u0003\u00024\u0005)1m\u001c8oA!I\u0011qH\u001cC\u0002\u0013\u0005\u0011\u0011I\u0001\bg\u0016\u001c8/[8o+\t\t\u0019\u0005\u0005\u0003\u0002\"\u0005\u0015\u0013\u0002BA$\u0003G\u0011qaU3tg&|g\u000e\u0003\u0005\u0002L]\u0002\u000b\u0011BA\"\u0003!\u0019Xm]:j_:\u0004\u0003\"CA(o\t\u0007I\u0011AA)\u0003!\u0001(o\u001c3vG\u0016\u0014XCAA*!\u0011\t\t#!\u0016\n\t\u0005]\u00131\u0005\u0002\u0010\u001b\u0016\u001c8/Y4f!J|G-^2fe\"A\u00111L\u001c!\u0002\u0013\t\u0019&A\u0005qe>$WoY3sA!9\u0011qL\u001c\u0005\u0002\u0005\u0005\u0014!E2sK\u0006$X\rR3ti&t\u0017\r^5p]R!\u00111MA5!\u0011\t\t#!\u001a\n\t\u0005\u001d\u00141\u0005\u0002\f\t\u0016\u001cH/\u001b8bi&|g\u000e\u0003\u0004(\u0003;\u0002\r\u0001\u000b\u0005\b\u0003[:D\u0011BA8\u0003M9(/\u001b;f!J|\u0007o\u001d+p\u001b\u0016\u001c8/Y4f)\u0019\t\t(a\u001e\u0002\bB\u0019\u0011#a\u001d\n\u0007\u0005U$C\u0001\u0003V]&$\b\u0002CA=\u0003W\u0002\r!a\u001f\u0002\u000bA\u0014x\u000e]:\u0011\r\u0019\u000bi(RAA\u0013\r\tyh\u0013\u0002\u0004\u001b\u0006\u0004\bcA\t\u0002\u0004&\u0019\u0011Q\u0011\n\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002\n\u0006-\u0004\u0019AAF\u0003\u001diWm]:bO\u0016\u0004B!!\t\u0002\u000e&!\u0011qRA\u0012\u0005\u001diUm]:bO\u0016Dq!a%8\t\u0003\t)*\u0001\ttK:$')\u001f;fg6+7o]1hKRA\u00111RAL\u0003O\u000bI\u000b\u0003\u0005\u0002\u001a\u0006E\u0005\u0019AAN\u0003\u0015\u0011\u0017\u0010^3t!\u0015\t\u0012QTAQ\u0013\r\tyJ\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004#\u0005\r\u0016bAAS%\t!!)\u001f;f\u0011!\tI(!%A\u0002\u0005m\u0004\u0002CAV\u0003#\u0003\r!!,\u0002\u000f)l7\u000fV=qKB\u0019\u0011CU#\t\u000f\u0005Ev\u0007\"\u0001\u00024\u0006q1/\u001a8e\u001b\u0006\u0004X*Z:tC\u001e,G\u0003CAF\u0003k\u000bI,a/\t\u0011\u0005]\u0016q\u0016a\u0001\u0003w\n1!\\1q\u0011!\tI(a,A\u0002\u0005m\u0004\u0002CAV\u0003_\u0003\r!!,\t\u000f\u0005}v\u0007\"\u0001\u0002B\u0006\t2/\u001a8e\u001f\nTWm\u0019;NKN\u001c\u0018mZ3\u0015\u0011\u0005-\u00151YAi\u0003'D\u0001\"!2\u0002>\u0002\u0007\u0011qY\u0001\u0002_B!\u0011\u0011ZAg\u001b\t\tYM\u0003\u0002\ns&!\u0011qZAf\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!\tI(!0A\u0002\u0005m\u0004\u0002CAV\u0003{\u0003\r!!,\t\u000f\u0005]w\u0007\"\u0001\u0002Z\u0006y1/\u001a8e)\u0016DH/T3tg\u0006<W\r\u0006\u0005\u0002\f\u0006m\u0017q\\Aq\u0011\u001d\ti.!6A\u0002\u0015\u000b1\"\\3tg\u0006<W\rV3yi\"A\u0011\u0011PAk\u0001\u0004\tY\b\u0003\u0005\u0002,\u0006U\u0007\u0019AAW\u0011\u001d\t)o\u000eD\u0001\u0003O\f1b]3oI6+7o]1hKR!\u00111RAu\u0011!\tI)a9A\u0002\u0005-\u0005bBAwo\u0011\u0005\u0011q^\u0001\u0006G2|7/\u001a\u000b\u0003\u0003c\u0002")
public abstract class JmsClient
implements StrictLogging {
    private final Hashtable<String, String> properties;
    private final InitialContext ctx;
    private final ConnectionFactory qcf;
    private final Connection conn;
    private final Session session;
    private final MessageProducer producer;
    private final Logger logger;
    private static /* synthetic */ java.util.Map $deserializeLambdaCache$;

    public static JmsReqReplyClient apply(JmsProtocol jmsProtocol, JmsDestination jmsDestination, JmsDestination jmsDestination2) {
        return JmsClient$.MODULE$.apply(jmsProtocol, jmsDestination, jmsDestination2);
    }

    public static JmsSendClient apply(JmsProtocol jmsProtocol, JmsDestination jmsDestination) {
        return JmsClient$.MODULE$.apply(jmsProtocol, jmsDestination);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Hashtable<String, String> properties() {
        return this.properties;
    }

    public InitialContext ctx() {
        return this.ctx;
    }

    public ConnectionFactory qcf() {
        return this.qcf;
    }

    public Connection conn() {
        return this.conn;
    }

    public Session session() {
        return this.session;
    }

    public MessageProducer producer() {
        return this.producer;
    }

    public Destination createDestination(JmsDestination destination) {
        Queue queue;
        JmsDestination jmsDestination = destination;
        if (jmsDestination instanceof JmsQueue) {
            JmsQueue jmsQueue = (JmsQueue)jmsDestination;
            String name = jmsQueue.name();
            queue = this.session().createQueue(name);
        } else if (jmsDestination instanceof JmsTopic) {
            JmsTopic jmsTopic = (JmsTopic)jmsDestination;
            String name = jmsTopic.name();
            queue = this.session().createTopic(name);
        } else if (JmsTemporaryQueue$.MODULE$.equals(jmsDestination)) {
            queue = this.session().createTemporaryQueue();
        } else if (JmsTemporaryTopic$.MODULE$.equals(jmsDestination)) {
            queue = this.session().createTemporaryTopic();
        } else {
            throw new MatchError((Object)jmsDestination);
        }
        return queue;
    }

    private void writePropsToMessage(Map<String, Object> props, Message message) {
        props.foreach((Function1)(JFunction1 & Serializable & scala.Serializable)x0$1 -> {
            JmsClient.io$gatling$jms$client$JmsClient$$$anonfun$2(message, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public Message sendBytesMessage(byte[] bytes, Map<String, Object> props, Option<String> jmsType) {
        BytesMessage message = this.session().createBytesMessage();
        message.writeBytes(bytes);
        this.writePropsToMessage(props, (Message)message);
        jmsType.foreach((Function1)(JFunction1 & Serializable & scala.Serializable)x$1 -> {
            message.setJMSType(x$1);
            return BoxedUnit.UNIT;
        });
        return this.sendMessage((Message)message);
    }

    public Message sendMapMessage(Map<String, Object> map, Map<String, Object> props, Option<String> jmsType) {
        MapMessage message = this.session().createMapMessage();
        map.foreach((Function1)(JFunction1 & Serializable & scala.Serializable)x0$2 -> {
            JmsClient.io$gatling$jms$client$JmsClient$$$anonfun$4(message, x0$2);
            return BoxedUnit.UNIT;
        });
        this.writePropsToMessage(props, (Message)message);
        jmsType.foreach((Function1)(JFunction1 & Serializable & scala.Serializable)x$1 -> {
            message.setJMSType(x$1);
            return BoxedUnit.UNIT;
        });
        return this.sendMessage((Message)message);
    }

    public Message sendObjectMessage(Serializable o, Map<String, Object> props, Option<String> jmsType) {
        ObjectMessage message = this.session().createObjectMessage(o);
        this.writePropsToMessage(props, (Message)message);
        jmsType.foreach((Function1)(JFunction1 & Serializable & scala.Serializable)x$1 -> {
            message.setJMSType(x$1);
            return BoxedUnit.UNIT;
        });
        return this.sendMessage((Message)message);
    }

    public Message sendTextMessage(String messageText, Map<String, Object> props, Option<String> jmsType) {
        TextMessage message = this.session().createTextMessage(messageText);
        this.writePropsToMessage(props, (Message)message);
        jmsType.foreach((Function1)(JFunction1 & Serializable & scala.Serializable)x$1 -> {
            message.setJMSType(x$1);
            return BoxedUnit.UNIT;
        });
        return this.sendMessage((Message)message);
    }

    public abstract Message sendMessage(Message var1);

    public void close() {
        try {
            this.producer().close();
            this.session().close();
            this.conn().stop();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e = (Throwable)option.get();
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder().append((Object)"Exception while closing JmsReplyClient: ").append((Object)e.getMessage()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
            throw throwable;
        }
    }

    public final /* synthetic */ String io$gatling$jms$client$JmsClient$$$anonfun$1(Credentials credentials) {
        this.properties().put("java.naming.security.principal", credentials.username());
        return this.properties().put("java.naming.security.credentials", credentials.password());
    }

    public static final /* synthetic */ void io$gatling$jms$client$JmsClient$$$anonfun$2(Message message$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        Object value = tuple2._2();
        message$1.setObjectProperty(key, value);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void io$gatling$jms$client$JmsClient$$$anonfun$4(MapMessage message$3, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        Object value = tuple2._2();
        message$3.setObject(key, value);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Unable to fully structure code
     */
    public JmsClient(String connectionFactoryName, JmsDestination destination, String url, Option<Credentials> credentials, boolean anonymousConnect, String contextFactory, int deliveryMode) {
        super();
        StrictLogging.class.$init$((StrictLogging)this);
        this.properties = new Hashtable<K, V>();
        this.properties().put("java.naming.factory.initial", contextFactory);
        this.properties().put("java.naming.provider.url", url);
        credentials.foreach((Function1)(JFunction1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, io$gatling$jms$client$JmsClient$$$anonfun$1(io.gatling.core.config.Credentials ), (Lio/gatling/core/config/Credentials;)Ljava/lang/String;)((JmsClient)this));
        this.ctx = new InitialContext(this.properties());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got InitialContext ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ctx()})));
            v0 = BoxedUnit.UNIT;
        } else {
            v0 = BoxedUnit.UNIT;
        }
        this.qcf = (ConnectionFactory)this.ctx().lookup(connectionFactoryName);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got ConnectionFactory ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.qcf()})));
            v1 = BoxedUnit.UNIT;
        } else {
            v1 = BoxedUnit.UNIT;
        }
        var9_8 = credentials;
        if (!(var9_8 instanceof Some)) ** GOTO lbl-1000
        var10_9 = (Some)var9_8;
        creds = (Credentials)var10_9.x();
        if (!anonymousConnect) {
            var8_11 = this.qcf().createConnection(creds.username(), creds.password());
        } else lbl-1000:
        // 2 sources

        {
            var8_11 = this.qcf().createConnection();
        }
        this.conn = var8_11;
        this.conn().start();
        this.session = this.conn().createSession(false, 1);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got Connection ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.conn()})));
            v2 = BoxedUnit.UNIT;
        } else {
            v2 = BoxedUnit.UNIT;
        }
        this.producer = this.session().createProducer(this.createDestination(destination));
        this.producer().setDeliveryMode(deliveryMode);
    }
}

