/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_0.utils;

import io.fabric8.kubernetes.api.model.v4_0.HasMetadata;
import io.fabric8.kubernetes.clnt.v4_0.dsl.base.OperationSupport;
import io.fabric8.kubernetes.clnt.v4_0.utils.Serialization;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;

public class BackwardsCompatibilityInterceptor
implements Interceptor {
    private static final int API_GROUP = 1;
    private static final int API_VERSION = 2;
    private static final int PATH = 3;
    private static final String PATCH = "patch";
    private static final String NAME_REGEX = "[a-z0-9\\-\\.]+";
    private static final Pattern URL_PATTERN = Pattern.compile("[^ ]+/apis/([a-z0-9\\-\\.]+)/([a-z0-9\\-\\.]+)/([a-z0-9\\-\\.]+)[^ ]*");
    private static final Pattern NAMESPACED_URL_PATTERN = Pattern.compile("[^ ]+/apis/([a-z0-9\\-\\.]+)/([a-z0-9\\-\\.]+)/namespaces/[a-z0-9\\-\\.]+/([a-z0-9\\-\\.]+)[^ ]*");
    private static final Map<ResourceKey, ResourceKey> notFoundTransformations = new HashMap<ResourceKey, ResourceKey>();
    private static final Map<ResourceKey, ResourceKey> badRequestTransformations = new HashMap<ResourceKey, ResourceKey>();
    private static final Map<Integer, Map<ResourceKey, ResourceKey>> responseCodeToTransformations = new HashMap<Integer, Map<ResourceKey, ResourceKey>>();

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Response response = chain.proceed(request);
        if (!response.isSuccessful() && responseCodeToTransformations.keySet().contains(response.code())) {
            String url = request.url().toString();
            Matcher matcher = BackwardsCompatibilityInterceptor.getMatcher(url);
            ResourceKey key = BackwardsCompatibilityInterceptor.getKey(matcher);
            ResourceKey target = responseCodeToTransformations.get(response.code()).get(key);
            if (target != null) {
                String newUrl = new StringBuilder(url).replace(matcher.start(2), matcher.end(2), target.version).replace(matcher.start(1), matcher.end(1), target.group).toString();
                Request.Builder newRequest = request.newBuilder().url(newUrl);
                Buffer buffer = new Buffer();
                if (request.body() != null && !request.method().equalsIgnoreCase(PATCH)) {
                    request.body().writeTo((BufferedSink)buffer);
                    Object object = Serialization.unmarshal(buffer.inputStream());
                    if (object instanceof HasMetadata) {
                        HasMetadata h = (HasMetadata)object;
                        h.setApiVersion(target.group + "/" + target.version);
                        newRequest = newRequest.method(request.method(), RequestBody.create((MediaType)OperationSupport.JSON, (String)Serialization.asJson(h)));
                    }
                }
                return chain.proceed(newRequest.build());
            }
        }
        return response;
    }

    private static Matcher getMatcher(String url) {
        Matcher m = NAMESPACED_URL_PATTERN.matcher(url);
        if (m.matches()) {
            return m;
        }
        m = URL_PATTERN.matcher(url);
        if (m.matches()) {
            return m;
        }
        return null;
    }

    private static ResourceKey getKey(Matcher m) {
        return m != null ? new ResourceKey(null, m.group(3), m.group(1), m.group(2)) : null;
    }

    static {
        notFoundTransformations.put(new ResourceKey("Deployment", "deployments", "apps", "v1"), new ResourceKey("Deployment", "deployments", "extensions", "v1beta1"));
        notFoundTransformations.put(new ResourceKey("StatefulSet", "statefulsets", "apps", "v1"), new ResourceKey("StatefulSet", "statefulsets", "apps", "v1beta1"));
        notFoundTransformations.put(new ResourceKey("DaemonSets", "daemonsets", "apps", "v1"), new ResourceKey("DaemonSet", "daemonsets", "extensions", "v1beta1"));
        notFoundTransformations.put(new ResourceKey("ReplicaSets", "replicasets", "apps", "v1"), new ResourceKey("ReplicaSet", "replicasets", "extensions", "v1beta1"));
        notFoundTransformations.put(new ResourceKey("NetworkPolicy", "networkpolicies", "networking.k8s.io", "v1"), new ResourceKey("NetworkPolicy", "networkpolicies", "extensions", "v1beta1"));
        notFoundTransformations.put(new ResourceKey("StorageClass", "storageclasses", "storage.k8s.io", "v1"), new ResourceKey("StorageClass", "storageclasses", "extensions", "v1beta1"));
        notFoundTransformations.put(new ResourceKey("Job", "jobs", "batch", "v1"), new ResourceKey("Job", "jobs", "extensions", "v1beta1"));
        badRequestTransformations.put(new ResourceKey("Deployment", "deployments", "apps", "v1beta1"), new ResourceKey("Deployment", "deployments", "extensions", "v1beta1"));
        responseCodeToTransformations.put(400, badRequestTransformations);
        responseCodeToTransformations.put(404, notFoundTransformations);
    }

    private static class ResourceKey {
        private final String kind;
        private final String path;
        private final String group;
        private final String version;

        public ResourceKey(String kind, String path, String group, String version) {
            this.kind = kind;
            this.path = path;
            this.group = group;
            this.version = version;
        }

        public String getKind() {
            return this.kind;
        }

        public String getPath() {
            return this.path;
        }

        public String getGroup() {
            return this.group;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResourceKey key = (ResourceKey)o;
            return Objects.equals(this.path, key.path) && Objects.equals(this.group, key.group) && Objects.equals(this.version, key.version);
        }

        public int hashCode() {
            return Objects.hash(this.path, this.group, this.version);
        }
    }
}

