/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_0.internal;

import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VersionUsageUtils {
    private static final Logger LOG = LoggerFactory.getLogger(VersionUsageUtils.class);
    private static ConcurrentHashMap<String, Boolean> UNSTABLE_TYPES = new ConcurrentHashMap();
    private static final boolean LOG_EACH_USAGE = false;

    private VersionUsageUtils() {
    }

    public static void log(String type, String version) {
        if (type == null || version == null) {
            return;
        }
        if (VersionUsageUtils.isUnstable(version) && UNSTABLE_TYPES.putIfAbsent(type + "-" + version, true) == null) {
            VersionUsageUtils.alert(type, version);
        }
    }

    private static boolean isUnstable(String version) {
        String lowerCaseVersion = version.toLowerCase();
        return lowerCaseVersion.contains("beta") || lowerCaseVersion.contains("alpha");
    }

    private static void alert(String type, String version) {
        LOG.warn("The client is using resource type '{}' with unstable version '{}'", (Object)type, (Object)version);
    }
}

