/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Initializer;
import io.fabric8.kubernetes.api.model.InitializerFluent;
import io.fabric8.kubernetes.api.model.InitializerFluentImpl;

public class InitializerBuilder
extends InitializerFluentImpl<InitializerBuilder>
implements VisitableBuilder<Initializer, InitializerBuilder> {
    InitializerFluent<?> fluent;
    Boolean validationEnabled;

    public InitializerBuilder() {
        this(true);
    }

    public InitializerBuilder(Boolean validationEnabled) {
        this(new Initializer(), validationEnabled);
    }

    public InitializerBuilder(InitializerFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public InitializerBuilder(InitializerFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Initializer(), validationEnabled);
    }

    public InitializerBuilder(InitializerFluent<?> fluent, Initializer instance) {
        this(fluent, instance, true);
    }

    public InitializerBuilder(InitializerFluent<?> fluent, Initializer instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public InitializerBuilder(Initializer instance) {
        this(instance, (Boolean)true);
    }

    public InitializerBuilder(Initializer instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Initializer build() {
        Initializer buildable = new Initializer(this.fluent.getName());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InitializerBuilder that = (InitializerBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

