/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal;

import io.fabric8.kubernetes.api.model.AuthInfo;
import io.fabric8.kubernetes.api.model.AuthInfoFluent;
import io.fabric8.kubernetes.api.model.Cluster;
import io.fabric8.kubernetes.api.model.Config;
import io.fabric8.kubernetes.api.model.ConfigBuilder;
import io.fabric8.kubernetes.api.model.ConfigFluent;
import io.fabric8.kubernetes.api.model.Context;
import io.fabric8.kubernetes.api.model.NamedAuthInfoFluent;
import io.fabric8.kubernetes.api.model.NamedClusterFluent;
import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.api.model.NamedContextFluent;
import io.fabric8.kubernetes.client.internal.KubeConfigUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class KubeConfigUtilsTest {
    KubeConfigUtilsTest() {
    }

    @Test
    void testGetNamedUserIndexFromConfig() {
        Config config = this.getTestKubeConfig();
        int index = KubeConfigUtils.getNamedUserIndexFromConfig((Config)config, (String)"test/test-cluster:443");
        Assertions.assertEquals((int)2, (int)index);
    }

    @Test
    void testGetCurrentContext() {
        Config config = this.getTestKubeConfig();
        NamedContext namedContext = KubeConfigUtils.getCurrentContext((Config)config);
        Assertions.assertNotNull((Object)namedContext);
        Assertions.assertEquals((Object)"test-context", (Object)namedContext.getName());
        Assertions.assertEquals((Object)"ns1", (Object)namedContext.getContext().getNamespace());
        Assertions.assertEquals((Object)"system:admin/api-testing:6334", (Object)namedContext.getContext().getUser());
        Assertions.assertEquals((Object)"api-testing:6334", (Object)namedContext.getContext().getCluster());
    }

    @Test
    void testParseConfig() throws IOException {
        File configFile = new File(this.getClass().getResource("/test-kubeconfig").getPath());
        Config config = KubeConfigUtils.parseConfig((File)configFile);
        Assertions.assertNotNull((Object)config);
        Assertions.assertEquals((int)1, (int)config.getClusters().size());
        Assertions.assertEquals((int)3, (int)config.getContexts().size());
        Assertions.assertEquals((int)3, (int)config.getUsers().size());
    }

    @Test
    void testGetUserToken() {
        Config config = this.getTestKubeConfig();
        Context context = Objects.requireNonNull(KubeConfigUtils.getCurrentContext((Config)config)).getContext();
        String token = KubeConfigUtils.getUserToken((Config)config, (Context)context);
        Assertions.assertEquals((Object)"test-token-2", (Object)token);
    }

    @Test
    void testGetCluster() {
        Config config = this.getTestKubeConfig();
        Context context = Objects.requireNonNull(KubeConfigUtils.getCurrentContext((Config)config)).getContext();
        Cluster cluster = KubeConfigUtils.getCluster((Config)config, (Context)context);
        Assertions.assertNotNull((Object)cluster);
    }

    @Test
    void testGetUserAuthInfo() {
        Config config = this.getTestKubeConfig();
        Context context = ((NamedContext)config.getContexts().get(0)).getContext();
        AuthInfo authInfo = KubeConfigUtils.getUserAuthInfo((Config)config, (Context)context);
        Assertions.assertNotNull((Object)authInfo);
        Assertions.assertEquals((Object)"test-token-2", (Object)authInfo.getToken());
    }

    private Config getTestKubeConfig() {
        return ((ConfigBuilder)((ConfigFluent.UsersNested)((NamedAuthInfoFluent.UserNested)((ConfigFluent.UsersNested)((ConfigBuilder)((ConfigFluent.UsersNested)((NamedAuthInfoFluent.UserNested)((AuthInfoFluent.AuthProviderNested)((ConfigFluent.UsersNested)((ConfigBuilder)((ConfigFluent.UsersNested)((NamedAuthInfoFluent.UserNested)((NamedAuthInfoFluent.UserNested)((ConfigFluent.UsersNested)((ConfigBuilder)((ConfigFluent.UsersNested)((NamedAuthInfoFluent.UserNested)((ConfigFluent.UsersNested)((ConfigBuilder)((ConfigFluent.ContextsNested)((ConfigFluent.ContextsNested)((NamedContextFluent.ContextNested)((NamedContextFluent.ContextNested)((ConfigBuilder)((ConfigFluent.ContextsNested)((NamedContextFluent.ContextNested)((NamedContextFluent.ContextNested)((NamedContextFluent.ContextNested)((ConfigFluent.ContextsNested)((ConfigBuilder)((ConfigFluent.ClustersNested)((NamedClusterFluent.ClusterNested)((NamedClusterFluent.ClusterNested)((ConfigFluent.ClustersNested)((ConfigBuilder)new ConfigBuilder().withCurrentContext("test-context")).addNewCluster().withName("api-testing:6334")).withNewCluster().withServer("https://api-testing:6334")).withInsecureSkipTlsVerify(Boolean.valueOf(true))).endCluster()).endCluster()).addNewContext().withName("test-context")).withNewContext().withCluster("api-testing:6334")).withNamespace("ns1")).withUser("system:admin/api-testing:6334")).endContext()).endContext()).addNewContext().withNewContext().withCluster("minikube")).withUser("minikube")).endContext()).withName("minikube")).endContext()).addNewUser().withName("test/api-test-com:443")).withNewUser().withToken("token")).endUser()).endUser()).addNewUser().withName("minikube")).withNewUser().withClientCertificate("/home/.minikube/profiles/minikube/client.crt")).withClientKey("/home/.minikube/profiles/minikube/client.key")).endUser()).endUser()).addNewUser().withName("test/test-cluster:443")).withNewUser().withNewAuthProvider().withConfig(Collections.singletonMap("id-token", "token"))).endAuthProvider()).endUser()).endUser()).addNewUser().withName("system:admin/api-testing:6334")).withNewUser().withToken("test-token-2")).endUser()).endUser()).build();
    }
}

