/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.cache;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.client.informers.cache.Cache;
import io.fabric8.kubernetes.client.informers.cache.DeltaFIFO;
import io.fabric8.kubernetes.client.informers.cache.Store;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class DeltaFIFOTest {
    DeltaFIFOTest() {
    }

    @Test
    void testBasic() throws InterruptedException {
        LinkedList receivingDeltas = new LinkedList();
        Pod foo1 = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod1")).withNamespace("default")).endMetadata()).build();
        Cache cache = new Cache();
        DeltaFIFO deltaFIFO = new DeltaFIFO(Cache::deletionHandlingMetaNamespaceKeyFunc, (Store)cache);
        deltaFIFO.add((Object)foo1);
        cache.add((Object)foo1);
        deltaFIFO.pop(deltas -> {
            AbstractMap.SimpleEntry delta = (AbstractMap.SimpleEntry)deltas.peekFirst();
            receivingDeltas.add(delta);
        });
        AbstractMap.SimpleEntry receivingDelta = (AbstractMap.SimpleEntry)receivingDeltas.peekFirst();
        receivingDeltas.removeFirst();
        Assert.assertEquals((Object)foo1, receivingDelta.getValue());
        Assert.assertEquals((Object)DeltaFIFO.DeltaType.ADDITION, receivingDelta.getKey());
        deltaFIFO.update((Object)foo1);
        cache.update((Object)foo1);
        deltaFIFO.pop(deltas -> {
            AbstractMap.SimpleEntry delta = (AbstractMap.SimpleEntry)deltas.peekFirst();
            receivingDeltas.add(delta);
        });
        receivingDelta = (AbstractMap.SimpleEntry)receivingDeltas.peekFirst();
        receivingDeltas.removeFirst();
        Assert.assertEquals((Object)foo1, receivingDelta.getValue());
        Assert.assertEquals((Object)DeltaFIFO.DeltaType.UPDATION, receivingDelta.getKey());
        deltaFIFO.delete((Object)foo1);
        cache.delete((Object)foo1);
        deltaFIFO.pop(deltas -> {
            AbstractMap.SimpleEntry delta = (AbstractMap.SimpleEntry)deltas.peekFirst();
            receivingDeltas.add(delta);
        });
        receivingDelta = (AbstractMap.SimpleEntry)receivingDeltas.peekFirst();
        receivingDeltas.removeFirst();
        Assert.assertEquals((Object)foo1, receivingDelta.getValue());
        Assert.assertEquals((Object)DeltaFIFO.DeltaType.DELETION, receivingDelta.getKey());
        deltaFIFO.replace(Arrays.asList(foo1), "0");
        cache.replace(Arrays.asList(foo1), "0");
        deltaFIFO.pop(deltas -> {
            AbstractMap.SimpleEntry delta = (AbstractMap.SimpleEntry)deltas.peekFirst();
            receivingDeltas.add(delta);
        });
        receivingDelta = (AbstractMap.SimpleEntry)receivingDeltas.peekFirst();
        receivingDeltas.removeFirst();
        Assert.assertEquals((Object)foo1, receivingDelta.getValue());
        Assert.assertEquals((Object)DeltaFIFO.DeltaType.SYNCHRONIZATION, receivingDelta.getKey());
    }

    @Test
    void testDeduplication() {
        Pod foo1 = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("foo1")).withNamespace("default")).endMetadata()).build();
        Cache cache = new Cache();
        DeltaFIFO deltaFIFO = new DeltaFIFO(Cache::deletionHandlingMetaNamespaceKeyFunc, (Store)cache);
        deltaFIFO.add((Object)foo1);
        deltaFIFO.delete((Object)foo1);
        Deque deltas = (Deque)deltaFIFO.getItems().get(Cache.deletionHandlingMetaNamespaceKeyFunc((Object)foo1));
        Assert.assertEquals((Object)DeltaFIFO.DeltaType.DELETION, ((AbstractMap.SimpleEntry)deltas.peekLast()).getKey());
        Assert.assertEquals((Object)foo1, ((AbstractMap.SimpleEntry)deltas.peekLast()).getValue());
        Assert.assertEquals((Object)DeltaFIFO.DeltaType.ADDITION, ((AbstractMap.SimpleEntry)deltas.peekFirst()).getKey());
        Assert.assertEquals((Object)foo1, ((AbstractMap.SimpleEntry)deltas.peekFirst()).getValue());
        Assert.assertEquals((long)2L, (long)deltas.size());
        deltaFIFO.getItems().remove(Cache.deletionHandlingMetaNamespaceKeyFunc((Object)foo1));
        deltaFIFO.add((Object)foo1);
        deltaFIFO.delete((Object)foo1);
        deltaFIFO.delete((Object)foo1);
        deltas = (Deque)deltaFIFO.getItems().get(Cache.deletionHandlingMetaNamespaceKeyFunc((Object)foo1));
        Assert.assertEquals((Object)foo1, ((AbstractMap.SimpleEntry)deltas.peekLast()).getValue());
        Assert.assertEquals((Object)DeltaFIFO.DeltaType.ADDITION, ((AbstractMap.SimpleEntry)deltas.peekFirst()).getKey());
        Assert.assertEquals((Object)foo1, ((AbstractMap.SimpleEntry)deltas.peekFirst()).getValue());
        Assert.assertEquals((long)2L, (long)deltas.size());
        deltaFIFO.getItems().remove(Cache.deletionHandlingMetaNamespaceKeyFunc((Object)foo1));
    }

    @Test
    void testResync() {
        Pod foo1 = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("foo1")).withNamespace("default")).endMetadata()).build();
        Cache cache = new Cache();
        DeltaFIFO deltaFIFO = new DeltaFIFO(Cache::deletionHandlingMetaNamespaceKeyFunc, (Store)cache);
        cache.add((Object)foo1);
        deltaFIFO.resync();
        Deque deltas = (Deque)deltaFIFO.getItems().get(Cache.deletionHandlingMetaNamespaceKeyFunc((Object)foo1));
        Assert.assertEquals((long)1L, (long)deltas.size());
        Assert.assertEquals((Object)foo1, ((AbstractMap.SimpleEntry)deltas.peekLast()).getValue());
        Assert.assertEquals((Object)DeltaFIFO.DeltaType.SYNCHRONIZATION, ((AbstractMap.SimpleEntry)deltas.peekLast()).getKey());
    }

    @Test
    void testReplaceWithDeleteDeltaIn() throws InterruptedException {
        Pod oldPod = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withNamespace("default")).withName("foo1")).endMetadata()).build();
        Pod newPod = ((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withNamespace("default")).withName("foo2")).endMetadata()).build();
        Cache mockCache = (Cache)Mockito.mock(Cache.class);
        ((Cache)Mockito.doReturn((Object)oldPod).when((Object)mockCache)).getByKey(Cache.deletionHandlingMetaNamespaceKeyFunc((Object)oldPod));
        DeltaFIFO deltaFIFO = new DeltaFIFO(Cache::deletionHandlingMetaNamespaceKeyFunc, (Store)mockCache);
        deltaFIFO.delete((Object)oldPod);
        deltaFIFO.replace(Collections.singletonList(newPod), "0");
        deltaFIFO.pop(deltas -> {
            Assert.assertEquals((Object)DeltaFIFO.DeltaType.DELETION, ((AbstractMap.SimpleEntry)deltas.getFirst()).getKey());
            Assert.assertEquals((Object)oldPod, ((AbstractMap.SimpleEntry)deltas.getFirst()).getValue());
        });
        deltaFIFO.pop(deltas -> {
            Assert.assertEquals((Object)DeltaFIFO.DeltaType.SYNCHRONIZATION, ((AbstractMap.SimpleEntry)deltas.getFirst()).getKey());
            Assert.assertEquals((Object)newPod, ((AbstractMap.SimpleEntry)deltas.getFirst()).getValue());
        });
    }
}

