/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.mojo.build;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPath;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathBuilder;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathFluent;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValue;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.api.model.extensions.IngressBackend;
import io.fabric8.kubernetes.api.model.extensions.IngressBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressList;
import io.fabric8.kubernetes.api.model.extensions.IngressRule;
import io.fabric8.kubernetes.api.model.extensions.IngressRuleFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressSpec;
import io.fabric8.kubernetes.api.model.extensions.IngressSpecFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.maven.core.access.ClusterAccess;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.service.ApplyService;
import io.fabric8.maven.core.util.FileUtil;
import io.fabric8.maven.core.util.ResourceUtil;
import io.fabric8.maven.core.util.kubernetes.Fabric8Annotations;
import io.fabric8.maven.core.util.kubernetes.KubernetesClientUtil;
import io.fabric8.maven.core.util.kubernetes.KubernetesHelper;
import io.fabric8.maven.core.util.kubernetes.KubernetesResourceUtil;
import io.fabric8.maven.core.util.kubernetes.OpenshiftHelper;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.plugin.mojo.AbstractFabric8Mojo;
import io.fabric8.maven.plugin.mojo.ResourceDirCreator;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteList;
import io.fabric8.openshift.api.model.RouteSpec;
import io.fabric8.openshift.api.model.RouteTargetReference;
import io.fabric8.openshift.api.model.RouteTargetReferenceBuilder;
import io.fabric8.openshift.client.OpenShiftClient;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="apply", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.INSTALL)
public class ApplyMojo
extends AbstractFabric8Mojo {
    public static final String DEFAULT_KUBERNETES_MANIFEST = "${basedir}/target/classes/META-INF/fabric8/kubernetes.yml";
    public static final String DEFAULT_OPENSHIFT_MANIFEST = "${basedir}/target/classes/META-INF/fabric8/openshift.yml";
    @Parameter(property="fabric8.domain")
    protected String routeDomain;
    @Parameter(property="fabric8.deploy.failOnError", defaultValue="true")
    protected boolean failOnError;
    @Parameter(property="fabric8.recreate", defaultValue="false")
    protected boolean recreate;
    @Parameter(property="fabric8.kubernetesManifest", defaultValue="${basedir}/target/classes/META-INF/fabric8/kubernetes.yml")
    private File kubernetesManifest;
    @Parameter(property="fabric8.openshiftManifest", defaultValue="${basedir}/target/classes/META-INF/fabric8/openshift.yml")
    private File openshiftManifest;
    @Parameter(property="fabric8.deploy.create", defaultValue="true")
    private boolean createNewResources;
    @Parameter(property="fabric8.rolling", defaultValue="false")
    private boolean rollingUpgrades;
    @Parameter(property="fabric8.deploy.failOnNoKubernetesJson", defaultValue="false")
    private boolean failOnNoKubernetesJson;
    @Parameter(property="fabric8.deploy.servicesOnly", defaultValue="false")
    private boolean servicesOnly;
    @Parameter(property="fabric8.deploy.ignoreServices", defaultValue="false")
    private boolean ignoreServices;
    @Parameter(property="fabric8.deploy.processTemplatesLocally", defaultValue="false")
    private boolean processTemplatesLocally;
    @Parameter(property="fabric8.deploy.deletePods", defaultValue="true")
    private boolean deletePodsOnReplicationControllerUpdate;
    @Parameter(property="fabric8.deploy.ignoreRunningOAuthClients", defaultValue="true")
    private boolean ignoreRunningOAuthClients;
    @Parameter(property="fabric8.deploy.createExternalUrls", defaultValue="false")
    private boolean createExternalUrls;
    @Parameter(property="fabric8.deploy.jsonLogDir", defaultValue="${basedir}/target/fabric8/applyJson")
    private File jsonLogDir;
    @Parameter(property="fabric8.serviceUrl.waitSeconds", defaultValue="5")
    protected long serviceUrlWaitTimeSeconds;
    @Parameter(property="fabric8.s2i.buildNameSuffix", defaultValue="-s2i")
    protected String s2iBuildNameSuffix;
    @Parameter
    protected ResourceConfig resources;
    @Parameter(property="fabric8.resourceDir", defaultValue="${basedir}/src/main/fabric8")
    private File resourceDir;
    @Parameter(property="fabric8.environment")
    private String environment;
    @Parameter(property="fabric8.skip.apply", defaultValue="false")
    protected boolean skipApply;
    private ClusterAccess clusterAccess;
    protected ApplyService applyService;

    @Override
    public void executeInternal() throws MojoExecutionException {
        if (this.skipApply) {
            return;
        }
        this.clusterAccess = new ClusterAccess(this.getClusterConfiguration());
        try {
            KubernetesClient kubernetes = this.clusterAccess.createDefaultClient(this.log);
            this.applyService = new ApplyService(kubernetes, this.log);
            this.initServices(kubernetes, this.log);
            URL masterUrl = kubernetes.getMasterUrl();
            File manifest = OpenshiftHelper.isOpenShift((KubernetesClient)kubernetes) ? this.openshiftManifest : this.kubernetesManifest;
            if (!manifest.exists() || !manifest.isFile()) {
                if (this.failOnNoKubernetesJson) {
                    throw new MojoFailureException("No such generated manifest file: " + manifest);
                }
                this.log.warn("No such generated manifest file %s for this project so ignoring", new Object[]{manifest});
                return;
            }
            String clusterKind = "Kubernetes";
            if (OpenshiftHelper.isOpenShift((KubernetesClient)kubernetes)) {
                clusterKind = "OpenShift";
            }
            KubernetesResourceUtil.validateKubernetesMasterUrl((URL)masterUrl);
            this.log.info("Using %s at %s in namespace %s with manifest %s ", new Object[]{clusterKind, masterUrl, this.clusterAccess.getNamespace(), manifest});
            this.applyService.setAllowCreate(this.createNewResources);
            this.applyService.setServicesOnlyMode(this.servicesOnly);
            this.applyService.setIgnoreServiceMode(this.ignoreServices);
            this.applyService.setLogJsonDir(this.jsonLogDir);
            this.applyService.setBasedir(this.getRootProjectFolder());
            this.applyService.setIgnoreRunningOAuthClients(this.ignoreRunningOAuthClients);
            this.applyService.setProcessTemplatesLocally(this.processTemplatesLocally);
            this.applyService.setDeletePodsOnReplicationControllerUpdate(this.deletePodsOnReplicationControllerUpdate);
            this.applyService.setRollingUpgrade(this.rollingUpgrades);
            this.applyService.setRollingUpgradePreserveScale(this.isRollingUpgradePreserveScale());
            boolean openShift = OpenshiftHelper.isOpenShift((KubernetesClient)kubernetes);
            if (openShift) {
                this.getLog().info((CharSequence)"OpenShift platform detected");
            } else {
                this.disableOpenShiftFeatures(this.applyService);
            }
            Set entities = KubernetesResourceUtil.loadResources((File)manifest);
            String namespace = this.clusterAccess.getNamespace();
            boolean namespaceEntityExist = false;
            for (HasMetadata entity : entities) {
                if (entity instanceof Namespace) {
                    Namespace ns = (Namespace)entity;
                    namespace = ns.getMetadata().getName();
                    this.applyService.applyNamespace(ns);
                    namespaceEntityExist = true;
                    entities.remove(entity);
                    break;
                }
                if (!(entity instanceof Project)) continue;
                Project project = (Project)entity;
                namespace = project.getMetadata().getName();
                this.applyService.applyProject(project);
                namespaceEntityExist = true;
                entities.remove(entity);
                break;
            }
            if (!namespaceEntityExist) {
                this.applyService.applyNamespace(namespace);
            }
            this.applyService.setNamespace(namespace);
            if (this.createExternalUrls) {
                if (this.applyService.getOpenShiftClient() != null) {
                    this.createRoutes(entities);
                } else {
                    this.createIngress(kubernetes, entities);
                }
            }
            this.applyEntities(kubernetes, namespace, manifest.getName(), entities);
            this.log.info("[[B]]HINT:[[B]] Use the command `%s get pods -w` to watch your pods start up", new Object[]{this.clusterAccess.isOpenShiftImageStream(this.log) ? "oc" : "kubectl"});
        }
        catch (KubernetesClientException e) {
            KubernetesResourceUtil.handleKubernetesClientException((KubernetesClientException)e, (Logger)this.log);
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected void initServices(KubernetesClient kubernetes, Logger log) {
    }

    private Route createRouteForService(String routeDomainPostfix, String namespace, Service service) {
        Route route = null;
        String id = KubernetesHelper.getName((HasMetadata)service);
        if (StringUtils.isNotBlank((CharSequence)id) && this.hasExactlyOneService(service, id)) {
            String json;
            route = new Route();
            ObjectMeta routeMeta = KubernetesHelper.getOrCreateMetadata((HasMetadata)route);
            routeMeta.setName(id);
            routeMeta.setNamespace(namespace);
            RouteSpec routeSpec = new RouteSpec();
            RouteTargetReference objectRef = ((RouteTargetReferenceBuilder)new RouteTargetReferenceBuilder().withName(id)).build();
            routeSpec.setTo(objectRef);
            if (StringUtils.isNotBlank((CharSequence)routeDomainPostfix)) {
                routeSpec.setHost(this.prepareHostForRoute(routeDomainPostfix, id));
            } else {
                routeSpec.setHost("");
            }
            route.setSpec(routeSpec);
            try {
                json = ResourceUtil.toJson((Object)route);
            }
            catch (JsonProcessingException e) {
                json = e.getMessage() + ". object: " + route;
            }
            this.log.debug("Created route: " + json, new Object[0]);
        }
        return route;
    }

    private String prepareHostForRoute(String routeDomainPostfix, String name) {
        String ret = FileUtil.stripPostfix((String)name, (String)"-service");
        ret = FileUtil.stripPostfix((String)ret, (String)".");
        ret = ret + ".";
        ret = ret + FileUtil.stripPrefix((String)routeDomainPostfix, (String)".");
        return ret;
    }

    private Ingress createIngressForService(String routeDomainPostfix, String namespace, Service service) {
        Ingress ingress = null;
        String serviceName = KubernetesHelper.getName((HasMetadata)service);
        ServiceSpec serviceSpec = service.getSpec();
        if (serviceSpec != null && StringUtils.isNotBlank((CharSequence)serviceName) && this.shouldCreateExternalURLForService(service, serviceName)) {
            String json;
            String ingressId = serviceName;
            String host = "";
            if (StringUtils.isNotBlank((CharSequence)routeDomainPostfix)) {
                host = serviceName + "." + namespace + "." + FileUtil.stripPrefix((String)routeDomainPostfix, (String)".");
            }
            ArrayList<HTTPIngressPath> paths = new ArrayList<HTTPIngressPath>();
            List ports = serviceSpec.getPorts();
            if (ports != null) {
                for (ServicePort port : ports) {
                    Integer portNumber = port.getPort();
                    if (portNumber == null) continue;
                    HTTPIngressPath path = ((HTTPIngressPathBuilder)((HTTPIngressPathFluent.BackendNested)((HTTPIngressPathFluent.BackendNested)new HTTPIngressPathBuilder().withNewBackend().withServiceName(serviceName)).withServicePort(KubernetesHelper.createIntOrString((int)portNumber))).endBackend()).build();
                    paths.add(path);
                }
            }
            if (paths.isEmpty()) {
                return ingress;
            }
            ingress = ((IngressBuilder)((IngressFluent.SpecNested)((IngressSpecFluent.RulesNested)((IngressRuleFluent.HttpNested)((IngressSpecFluent.RulesNested)((IngressBuilder)((IngressFluent.MetadataNested)((IngressFluent.MetadataNested)new IngressBuilder().withNewMetadata().withName(ingressId)).withNamespace(namespace)).endMetadata()).withNewSpec().addNewRule().withHost(host)).withNewHttp().withPaths(paths)).endHttp()).endRule()).endSpec()).build();
            try {
                json = ResourceUtil.toJson((Object)ingress);
            }
            catch (JsonProcessingException e) {
                json = e.getMessage() + ". object: " + ingress;
            }
            this.log.debug("Created ingress: " + json, new Object[0]);
        }
        return ingress;
    }

    private boolean shouldCreateExternalURLForService(Service service, String id) {
        if ("kubernetes".equals(id) || "kubernetes-ro".equals(id)) {
            return false;
        }
        Set<Integer> ports = this.getPorts(service);
        this.log.debug("Service " + id + " has ports: " + ports, new Object[0]);
        if (ports.size() == 1) {
            String type = null;
            ServiceSpec spec = service.getSpec();
            if (spec != null && Objects.equals(type = spec.getType(), "LoadBalancer")) {
                return true;
            }
            this.log.info("Not generating route for service " + id + " type is not LoadBalancer: " + type, new Object[0]);
            return false;
        }
        this.log.info("Not generating route for service " + id + " as only single port services are supported. Has ports: " + ports, new Object[0]);
        return false;
    }

    private boolean hasExactlyOneService(Service service, String id) {
        Set<Integer> ports = this.getPorts(service);
        if (ports.size() != 1) {
            this.log.info("Not generating route for service " + id + " as only single port services are supported. Has ports: " + ports, new Object[0]);
            return false;
        }
        return true;
    }

    private Set<Integer> getPorts(Service service) {
        HashSet<Integer> answer = new HashSet<Integer>();
        if (service != null) {
            ServiceSpec spec = ApplyMojo.getOrCreateSpec(service);
            for (ServicePort port : spec.getPorts()) {
                answer.add(port.getPort());
            }
        }
        return answer;
    }

    public static ServiceSpec getOrCreateSpec(Service entity) {
        ServiceSpec spec = entity.getSpec();
        if (spec == null) {
            spec = new ServiceSpec();
            entity.setSpec(spec);
        }
        return spec;
    }

    protected void applyEntities(KubernetesClient kubernetes, String namespace, String fileName, Set<HasMetadata> entities) throws Exception {
        for (HasMetadata entity : entities) {
            if (entity instanceof Pod) {
                Pod pod = (Pod)entity;
                this.applyService.applyPod(pod, fileName);
                continue;
            }
            if (entity instanceof Service) {
                Service service = (Service)entity;
                this.applyService.applyService(service, fileName);
                continue;
            }
            if (entity instanceof ReplicationController) {
                ReplicationController replicationController = (ReplicationController)entity;
                this.applyService.applyReplicationController(replicationController, fileName);
                continue;
            }
            if (entity == null) continue;
            this.applyService.apply((Object)entity, fileName);
        }
        Logger serviceLogger = this.createExternalProcessLogger("[[G]][SVC][[G]] ");
        long serviceUrlWaitTimeSeconds = this.serviceUrlWaitTimeSeconds;
        for (HasMetadata entity : entities) {
            if (!(entity instanceof Service)) continue;
            Service service = (Service)entity;
            String name = KubernetesHelper.getName((HasMetadata)service);
            Resource serviceResource = (Resource)((NonNamespaceOperation)kubernetes.services().inNamespace(namespace)).withName(name);
            String url = null;
            int i = 0;
            while ((long)i < serviceUrlWaitTimeSeconds) {
                Service s;
                if (i > 0) {
                    Thread.sleep(1000L);
                }
                if ((s = (Service)serviceResource.get()) != null && StringUtils.isNotBlank((CharSequence)(url = this.getExternalServiceURL(s))) || !this.isExposeService(service)) break;
                ++i;
            }
            serviceUrlWaitTimeSeconds = 1L;
            if (!StringUtils.isNotBlank(url) || !url.startsWith("http")) continue;
            serviceLogger.info("" + name + ": " + url, new Object[0]);
        }
        this.processCustomEntities(kubernetes, namespace, this.resources != null ? this.resources.getCrdContexts() : null, false);
    }

    protected String getExternalServiceURL(Service service) {
        return (String)KubernetesHelper.getOrCreateAnnotations((HasMetadata)service).get(Fabric8Annotations.SERVICE_EXPOSE_URL.value());
    }

    protected boolean isExposeService(Service service) {
        String expose = (String)KubernetesHelper.getLabels((HasMetadata)service).get("expose");
        return expose != null && expose.toLowerCase().equals("true");
    }

    public boolean isRollingUpgrades() {
        return this.rollingUpgrades;
    }

    public boolean isRollingUpgradePreserveScale() {
        return false;
    }

    public MavenProject getProject() {
        return this.project;
    }

    protected void disableOpenShiftFeatures(ApplyService applyService) {
        this.processTemplatesLocally = true;
        applyService.setSupportOAuthClients(false);
        applyService.setProcessTemplatesLocally(true);
    }

    protected void createRoutes(Collection<HasMetadata> collection) {
        String routeDomainPostfix = this.routeDomain;
        Log log = this.getLog();
        String namespace = this.clusterAccess.getNamespace();
        try {
            OpenShiftClient openshiftClient = this.applyService.getOpenShiftClient();
            if (openshiftClient == null) {
                return;
            }
            RouteList routes = (RouteList)((NonNamespaceOperation)openshiftClient.routes().inNamespace(namespace)).list();
            if (routes != null) {
                routes.getItems();
            }
        }
        catch (Exception e) {
            log.warn((CharSequence)("Cannot load OpenShift Routes; maybe not connected to an OpenShift platform? " + e), (Throwable)e);
            return;
        }
        ArrayList<Route> routes = new ArrayList<Route>();
        for (HasMetadata object : collection) {
            Service service;
            Route route;
            if (!(object instanceof Service) || (route = this.createRouteForService(routeDomainPostfix, namespace, service = (Service)object)) == null) continue;
            routes.add(route);
        }
        collection.addAll(routes);
    }

    protected void createIngress(KubernetesClient kubernetesClient, Collection<HasMetadata> collection) {
        Object ingresses;
        String routeDomainPostfix = this.routeDomain;
        Log log = this.getLog();
        String namespace = this.clusterAccess.getNamespace();
        List ingressList = null;
        try {
            ingresses = (IngressList)((NonNamespaceOperation)kubernetesClient.extensions().ingresses().inNamespace(namespace)).list();
            if (ingresses != null) {
                ingressList = ingresses.getItems();
            }
        }
        catch (Exception e) {
            log.warn((CharSequence)("Cannot load Ingress instances. Must be an older version of Kubernetes? Error: " + e), (Throwable)e);
            return;
        }
        ingresses = new ArrayList();
        for (HasMetadata object : collection) {
            if (!(object instanceof Service)) continue;
            Service service = (Service)object;
            if (!this.serviceHasIngressRule(ingressList, service)) {
                Ingress ingress = this.createIngressForService(routeDomainPostfix, namespace, service);
                if (ingress != null) {
                    ingresses.add(ingress);
                    log.info((CharSequence)("Created ingress for " + namespace + ":" + KubernetesHelper.getName((HasMetadata)service)));
                    continue;
                }
                log.debug((CharSequence)("No ingress required for " + namespace + ":" + KubernetesHelper.getName((HasMetadata)service)));
                continue;
            }
            log.info((CharSequence)("Already has ingress for service " + namespace + ":" + KubernetesHelper.getName((HasMetadata)service)));
        }
        collection.addAll((Collection<HasMetadata>)ingresses);
    }

    protected void processCustomEntities(KubernetesClient client, String namespace, List<String> customResourceDefinitions, boolean isDelete) throws Exception {
        if (customResourceDefinitions == null) {
            return;
        }
        List crdContexts = KubernetesClientUtil.getCustomResourceDefinitionContext((KubernetesClient)client, customResourceDefinitions);
        Map<File, String> fileToCrdMap = this.getCustomResourcesFileToNamemap();
        for (CustomResourceDefinitionContext customResourceDefinitionContext : crdContexts) {
            for (Map.Entry<File, String> entry : fileToCrdMap.entrySet()) {
                if (!entry.getValue().equals(customResourceDefinitionContext.getGroup())) continue;
                if (isDelete) {
                    this.applyService.deleteCustomResource(entry.getKey(), namespace, customResourceDefinitionContext);
                    continue;
                }
                this.applyService.applyCustomResource(entry.getKey(), namespace, customResourceDefinitionContext);
            }
        }
    }

    protected Map<File, String> getCustomResourcesFileToNamemap() throws IOException {
        File[] resourceFiles;
        HashMap<File, String> fileToCrdGroupMap = new HashMap<File, String>();
        File resourceDirFinal = ResourceDirCreator.getFinalResourceDir(this.resourceDir, this.environment);
        for (File file : resourceFiles = KubernetesResourceUtil.listResourceFragments((File)resourceDirFinal, (List)(this.resources != null ? this.resources.getRemotes() : null), (Logger)this.log)) {
            Map customResource;
            String apiVersion;
            if (!file.getName().endsWith("cr.yml") || !(apiVersion = (customResource = KubernetesClientUtil.doReadCustomResourceFile((File)file)).get("apiVersion").toString()).contains("/")) continue;
            fileToCrdGroupMap.put(file, apiVersion.split("/")[0]);
        }
        return fileToCrdGroupMap;
    }

    private boolean serviceHasIngressRule(List<Ingress> ingresses, Service service) {
        List rules;
        Ingress ingress;
        IngressSpec spec;
        String serviceName = KubernetesHelper.getName((HasMetadata)service);
        Iterator<Ingress> iterator = ingresses.iterator();
        while (iterator.hasNext() && (spec = (ingress = iterator.next()).getSpec()) != null && (rules = spec.getRules()) != null) {
            List paths;
            IngressRule rule;
            HTTPIngressRuleValue http;
            Iterator iterator2 = rules.iterator();
            while (iterator2.hasNext() && (http = (rule = (IngressRule)iterator2.next()).getHttp()) != null && (paths = http.getPaths()) != null) {
                HTTPIngressPath path;
                IngressBackend backend;
                Iterator iterator3 = paths.iterator();
                while (iterator3.hasNext() && (backend = (path = (HTTPIngressPath)iterator3.next()).getBackend()) != null) {
                    if (!Objects.equals(serviceName, backend.getServiceName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected File getRootProjectFolder() {
        File answer = null;
        for (MavenProject project = this.getProject(); project != null; project = project.getParent()) {
            File basedir = project.getBasedir();
            if (basedir == null) continue;
            answer = basedir;
        }
        return answer;
    }

    protected MavenProject getRootProject() {
        MavenProject parent;
        MavenProject project = this.getProject();
        while (project != null && (parent = project.getParent()) != null) {
            project = parent;
        }
        return project;
    }
}

