/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.generator;

import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.util.ClassUtil;
import io.fabric8.maven.core.util.PluginServiceFactory;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.generator.api.Generator;
import io.fabric8.maven.generator.api.GeneratorContext;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;

public class GeneratorManager {
    public static List<ImageConfiguration> generate(List<ImageConfiguration> imageConfigs, GeneratorContext genCtx, boolean prePackagePhase) throws MojoExecutionException {
        List ret = imageConfigs;
        PluginServiceFactory pluginFactory = null;
        try {
            pluginFactory = genCtx.isUseProjectClasspath() ? new PluginServiceFactory((Object)genCtx, new ClassLoader[]{ClassUtil.createProjectClassLoader((List)genCtx.getProject().getCompileClasspathElements(), (Logger)genCtx.getLogger())}) : new PluginServiceFactory((Object)genCtx, new ClassLoader[0]);
        }
        catch (DependencyResolutionRequiredException dependencyResolutionRequiredException) {
            // empty catch block
        }
        List generators = pluginFactory.createServiceObjects(new String[]{"META-INF/fabric8/generator-default", "META-INF/fabric8/fabric8-generator-default", "META-INF/fabric8/generator", "META-INF/fabric8-generator"});
        ProcessorConfig config = genCtx.getConfig();
        Logger log = genCtx.getLogger();
        List usableGenerators = config.prepareProcessors(generators, "generator");
        log.verbose(Logger.LogVerboseCategory.BUILD, "Generators:", new Object[0]);
        for (Generator generator : usableGenerators) {
            log.verbose(Logger.LogVerboseCategory.BUILD, " - %s", new Object[]{generator.getName()});
            if (!generator.isApplicable(ret)) continue;
            log.info("Running generator %s", new Object[]{generator.getName()});
            ret = generator.customize(ret, prePackagePhase);
        }
        return ret;
    }
}

