/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.plugin.enricher;

import com.google.common.base.Function;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.util.ClassUtil;
import io.fabric8.maven.core.util.PluginServiceFactory;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.enricher.api.Enricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.util.Misc;
import java.util.List;
import java.util.Optional;

public class EnricherManager {
    private List<Enricher> enrichers;
    private final ProcessorConfig defaultEnricherConfig;
    private Logger log;

    public EnricherManager(ResourceConfig resourceConfig, EnricherContext enricherContext, Optional<List<String>> extraClasspathElements) {
        PluginServiceFactory pluginFactory = new PluginServiceFactory((Object)enricherContext, new ClassLoader[0]);
        extraClasspathElements.ifPresent(cpElements -> pluginFactory.addAdditionalClassLoader((ClassLoader)ClassUtil.createProjectClassLoader((List)cpElements, (Logger)enricherContext.getLog())));
        this.log = enricherContext.getLog();
        this.defaultEnricherConfig = enricherContext.getConfiguration().getProcessorConfig().orElse(ProcessorConfig.EMPTY);
        this.enrichers = pluginFactory.createServiceObjects(new String[]{"META-INF/fabric8-enricher-default", "META-INF/fabric8/enricher-default", "META-INF/fabric8-enricher", "META-INF/fabric8/enricher"});
        this.logEnrichers(Misc.filterEnrichers((ProcessorConfig)this.defaultEnricherConfig, this.enrichers));
    }

    public void createDefaultResources(PlatformMode platformMode, KubernetesListBuilder builder) {
        this.createDefaultResources(platformMode, this.defaultEnricherConfig, builder);
    }

    public void createDefaultResources(PlatformMode platformMode, ProcessorConfig enricherConfig, KubernetesListBuilder builder) {
        this.loop(enricherConfig, (Function<Enricher, Void>)((Function)enricher -> {
            enricher.create(platformMode, builder);
            return null;
        }));
    }

    public void enrich(PlatformMode platformMode, KubernetesListBuilder builder) {
        this.enrich(platformMode, this.defaultEnricherConfig, builder);
    }

    public void enrich(PlatformMode platformMode, ProcessorConfig config, KubernetesListBuilder builder) {
        this.enrich(platformMode, config, builder, this.enrichers);
        this.adapt(platformMode, config, builder);
    }

    private void enrich(PlatformMode platformMode, ProcessorConfig enricherConfig, KubernetesListBuilder builder, List<Enricher> enricherList) {
        this.loop(enricherConfig, (Function<Enricher, Void>)((Function)enricher -> {
            enricher.create(platformMode, builder);
            return null;
        }));
    }

    private void adapt(PlatformMode platformMode, ProcessorConfig enricherConfig, KubernetesListBuilder builder) {
        this.loop(enricherConfig, (Function<Enricher, Void>)((Function)enricher -> {
            enricher.enrich(platformMode, builder);
            return null;
        }));
    }

    private void logEnrichers(List<Enricher> enrichers) {
        this.log.verbose("Enrichers:", new Object[0]);
        for (Enricher enricher : enrichers) {
            this.log.verbose("- %s", new Object[]{enricher.getName()});
        }
    }

    private void loop(ProcessorConfig config, Function<Enricher, Void> function) {
        for (Enricher enricher : Misc.filterEnrichers((ProcessorConfig)config, this.enrichers)) {
            function.apply((Object)enricher);
        }
    }
}

