/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.util.Base64Util;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FileDataSecretEnricher
extends BaseEnricher {
    protected static final String PREFIX_ANNOTATION = "maven.fabric8.io/secret/";

    public FileDataSecretEnricher(MavenEnricherContext buildContext) {
        super((EnricherContext)buildContext, "fmp-secret-file");
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        this.addAnnotations(builder);
    }

    private void addAnnotations(KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<SecretBuilder>(){

            public void visit(SecretBuilder element) {
                Map annotations = element.buildMetadata().getAnnotations();
                try {
                    Map secretAnnotations = FileDataSecretEnricher.this.createSecretFromAnnotations(annotations);
                    element.addToData(secretAnnotations);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        });
    }

    private Map<String, String> createSecretFromAnnotations(Map<String, String> annotations) throws IOException {
        Set<Map.Entry<String, String>> entries = annotations.entrySet();
        HashMap<String, String> secretFileLocations = new HashMap<String, String>();
        Iterator<Map.Entry<String, String>> it = entries.iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            String key = entry.getKey();
            if (!key.startsWith(PREFIX_ANNOTATION)) continue;
            byte[] bytes = this.readContent(entry.getValue());
            secretFileLocations.put(this.getOutput(key), Base64Util.encodeToString((byte[])bytes));
            it.remove();
        }
        return secretFileLocations;
    }

    private byte[] readContent(String location) throws IOException {
        return Files.readAllBytes(Paths.get(location, new String[0]));
    }

    private String getOutput(String key) {
        return key.substring(PREFIX_ANNOTATION.length());
    }
}

