/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpec;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.util.MapUtil;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import io.fabric8.openshift.api.model.DeploymentConfig;
import java.util.List;
import java.util.Map;

public class PodAnnotationEnricher
extends BaseEnricher {
    public PodAnnotationEnricher(MavenEnricherContext buildContext) {
        super((EnricherContext)buildContext, "fmp-pod-annotations");
    }

    public void enrich(PlatformMode platformMode, KubernetesListBuilder builder) {
        super.enrich(platformMode, builder);
        List items = builder.getItems();
        for (HasMetadata item : items) {
            PodTemplateSpec templateSpec;
            ObjectMeta templateMetadata;
            DeploymentSpec spec;
            ObjectMeta metadata;
            if (platformMode == PlatformMode.kubernetes && item instanceof Deployment) {
                PodTemplateSpec template;
                Deployment deployment = (Deployment)item;
                metadata = deployment.getMetadata();
                spec = deployment.getSpec();
                if (metadata == null || spec == null || (template = spec.getTemplate()) == null) continue;
                templateMetadata = template.getMetadata();
                if (templateMetadata == null) {
                    templateMetadata = new ObjectMeta();
                    template.setMetadata(templateMetadata);
                }
                templateMetadata.setAnnotations(MapUtil.mergeMaps((Map)templateMetadata.getAnnotations(), (Map)metadata.getAnnotations()));
                continue;
            }
            if (platformMode != PlatformMode.openshift || !(item instanceof DeploymentConfig)) continue;
            DeploymentConfig deploymentConfig = (DeploymentConfig)item;
            metadata = deploymentConfig.getMetadata();
            spec = deploymentConfig.getSpec();
            if (metadata == null || spec == null || (templateSpec = spec.getTemplate()) == null) continue;
            templateMetadata = templateSpec.getMetadata();
            if (templateMetadata == null) {
                templateMetadata = new ObjectMeta();
                templateSpec.setMetadata(templateMetadata);
            }
            templateMetadata.setAnnotations(MapUtil.mergeMaps((Map)templateMetadata.getAnnotations(), (Map)metadata.getAnnotations()));
        }
        builder.withItems(items);
    }
}

