/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.apps.DaemonSetBuilder;
import io.fabric8.kubernetes.api.model.apps.DaemonSetFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSetBuilder;
import io.fabric8.kubernetes.api.model.apps.StatefulSetFluent;
import io.fabric8.kubernetes.api.model.batch.JobBuilder;
import io.fabric8.kubernetes.api.model.batch.JobFluent;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.util.kubernetes.Fabric8Annotations;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.project.MavenProject;

public class MavenIssueManagementEnricher
extends BaseEnricher {
    static final String ENRICHER_NAME = "fmp-maven-issue-mgmt";

    public MavenIssueManagementEnricher(MavenEnricherContext buildContext) {
        super((EnricherContext)buildContext, ENRICHER_NAME);
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        builder.accept((Visitor)new TypedVisitor<ServiceBuilder>(){

            public void visit(ServiceBuilder serviceBuilder) {
                ((ServiceFluent.MetadataNested)serviceBuilder.editMetadata().addToAnnotations(MavenIssueManagementEnricher.this.getAnnotations())).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<DeploymentBuilder>(){

            public void visit(DeploymentBuilder builder) {
                ((DeploymentFluent.MetadataNested)builder.editMetadata().addToAnnotations(MavenIssueManagementEnricher.this.getAnnotations())).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<DeploymentConfigBuilder>(){

            public void visit(DeploymentConfigBuilder builder) {
                ((DeploymentConfigFluent.MetadataNested)builder.editMetadata().addToAnnotations(MavenIssueManagementEnricher.this.getAnnotations())).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<ReplicaSetBuilder>(){

            public void visit(ReplicaSetBuilder builder) {
                ((ReplicaSetFluent.MetadataNested)builder.editMetadata().addToAnnotations(MavenIssueManagementEnricher.this.getAnnotations())).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<ReplicationControllerBuilder>(){

            public void visit(ReplicationControllerBuilder builder) {
                ((ReplicationControllerFluent.MetadataNested)builder.editMetadata().addToAnnotations(MavenIssueManagementEnricher.this.getAnnotations())).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<DaemonSetBuilder>(){

            public void visit(DaemonSetBuilder builder) {
                ((DaemonSetFluent.MetadataNested)builder.editMetadata().addToAnnotations(MavenIssueManagementEnricher.this.getAnnotations())).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<StatefulSetBuilder>(){

            public void visit(StatefulSetBuilder builder) {
                ((StatefulSetFluent.MetadataNested)builder.editMetadata().addToAnnotations(MavenIssueManagementEnricher.this.getAnnotations())).endMetadata();
            }
        });
        builder.accept((Visitor)new TypedVisitor<JobBuilder>(){

            public void visit(JobBuilder builder) {
                ((JobFluent.MetadataNested)builder.editMetadata().addToAnnotations(MavenIssueManagementEnricher.this.getAnnotations())).endMetadata();
            }
        });
    }

    private Map<String, String> getAnnotations() {
        MavenEnricherContext mavenEnricherContext;
        MavenProject rootProject;
        HashMap<String, String> annotations = new HashMap<String, String>();
        if (this.getContext() instanceof MavenEnricherContext && this.hasIssueManagement(rootProject = (mavenEnricherContext = (MavenEnricherContext)this.getContext()).getProject())) {
            IssueManagement issueManagement = rootProject.getIssueManagement();
            String system = issueManagement.getSystem();
            String url = issueManagement.getUrl();
            if (StringUtils.isNotEmpty((CharSequence)system) && StringUtils.isNotEmpty((CharSequence)url)) {
                annotations.put(Fabric8Annotations.ISSUE_SYSTEM.value(), system);
                annotations.put(Fabric8Annotations.ISSUE_TRACKER_URL.value(), url);
            }
        }
        return annotations;
    }

    private boolean hasIssueManagement(MavenProject project) {
        return project.getIssueManagement() != null;
    }
}

