/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.apps.DaemonSet;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.batch.Job;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.handler.DaemonSetHandler;
import io.fabric8.maven.core.handler.DeploymentConfigHandler;
import io.fabric8.maven.core.handler.DeploymentHandler;
import io.fabric8.maven.core.handler.HandlerHub;
import io.fabric8.maven.core.handler.JobHandler;
import io.fabric8.maven.core.handler.ReplicaSetHandler;
import io.fabric8.maven.core.handler.ReplicationControllerHandler;
import io.fabric8.maven.core.handler.StatefulSetHandler;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.core.util.kubernetes.KubernetesResourceUtil;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class DefaultControllerEnricher
extends BaseEnricher {
    protected static final String[] POD_CONTROLLER_KINDS = new String[]{"ReplicationController", "ReplicaSet", "Deployment", "DeploymentConfig", "StatefulSet", "DaemonSet", "Job"};
    private final DeploymentHandler deployHandler;
    private final DeploymentConfigHandler deployConfigHandler;
    private final ReplicationControllerHandler rcHandler;
    private final ReplicaSetHandler rsHandler;
    private final StatefulSetHandler statefulSetHandler;
    private final DaemonSetHandler daemonSetHandler;
    private final JobHandler jobHandler;

    public DefaultControllerEnricher(MavenEnricherContext buildContext) {
        super((EnricherContext)buildContext, "fmp-controller");
        HandlerHub handlers = new HandlerHub(this.getContext().getGav(), this.getContext().getConfiguration().getProperties());
        this.rcHandler = handlers.getReplicationControllerHandler();
        this.rsHandler = handlers.getReplicaSetHandler();
        this.deployHandler = handlers.getDeploymentHandler();
        this.deployConfigHandler = handlers.getDeploymentConfigHandler();
        this.statefulSetHandler = handlers.getStatefulSetHandler();
        this.daemonSetHandler = handlers.getDaemonSetHandler();
        this.jobHandler = handlers.getJobHandler();
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        String name = this.getConfig(Config.name, MavenUtil.createDefaultResourceName((String)this.getContext().getGav().getSanitizedArtifactId(), (String[])new String[0]));
        ResourceConfig xmlResourceConfig = this.getConfiguration().getResource().orElse(null);
        ResourceConfig config = new ResourceConfig.Builder(xmlResourceConfig).controllerName(name).imagePullPolicy(this.getImagePullPolicy(xmlResourceConfig, this.getConfig(Config.pullPolicy))).withReplicas(this.getReplicaCount(xmlResourceConfig, Configs.asInt((String)this.getConfig(Config.replicaCount)))).build();
        List images = this.getImages().orElse(Collections.emptyList());
        if (!KubernetesResourceUtil.checkForKind((KubernetesListBuilder)builder, (String[])POD_CONTROLLER_KINDS) && !images.isEmpty()) {
            String type = this.getConfig(Config.type);
            if ("deployment".equalsIgnoreCase(type) || "deploymentConfig".equalsIgnoreCase(type)) {
                if (platformMode == PlatformMode.kubernetes) {
                    this.log.info("Adding a default Deployment", new Object[0]);
                    Deployment deployment = this.deployHandler.getDeployment(config, images);
                    builder.addToDeploymentItems(new Deployment[]{deployment});
                    this.setProcessingInstruction(this.getContainersFromPodSpec(deployment.getSpec().getTemplate()));
                } else {
                    this.log.info("Adding a default DeploymentConfig", new Object[0]);
                    DeploymentConfig deploymentConfig = this.deployConfigHandler.getDeploymentConfig(config, images, this.getOpenshiftDeployTimeoutInSeconds(3600L), this.getImageChangeTriggerFlag(true), this.isAutomaticTriggerEnabled(true), Boolean.valueOf(this.isOpenShiftMode()));
                    builder.addToDeploymentConfigItems(new DeploymentConfig[]{deploymentConfig});
                    this.setProcessingInstruction(this.getContainersFromPodSpec(deploymentConfig.getSpec().getTemplate()));
                }
            } else if ("statefulSet".equalsIgnoreCase(type)) {
                this.log.info("Adding a default StatefulSet", new Object[0]);
                StatefulSet statefulSet = this.statefulSetHandler.getStatefulSet(config, images);
                builder.addToStatefulSetItems(new StatefulSet[]{statefulSet});
                this.setProcessingInstruction(this.getContainersFromPodSpec(statefulSet.getSpec().getTemplate()));
            } else if ("daemonSet".equalsIgnoreCase(type)) {
                this.log.info("Adding a default DaemonSet", new Object[0]);
                DaemonSet daemonSet = this.daemonSetHandler.getDaemonSet(config, images);
                builder.addToDaemonSetItems(new DaemonSet[]{daemonSet});
                this.setProcessingInstruction(this.getContainersFromPodSpec(daemonSet.getSpec().getTemplate()));
            } else if ("replicaSet".equalsIgnoreCase(type)) {
                this.log.info("Adding a default ReplicaSet", new Object[0]);
                ReplicaSet replicaSet = this.rsHandler.getReplicaSet(config, images);
                builder.addToReplicaSetItems(new ReplicaSet[]{replicaSet});
                this.setProcessingInstruction(this.getContainersFromPodSpec(replicaSet.getSpec().getTemplate()));
            } else if ("replicationController".equalsIgnoreCase(type)) {
                this.log.info("Adding a default ReplicationController", new Object[0]);
                ReplicationController replicationController = this.rcHandler.getReplicationController(config, images);
                builder.addToReplicationControllerItems(new ReplicationController[]{replicationController});
                this.setProcessingInstruction(this.getContainersFromPodSpec(replicationController.getSpec().getTemplate()));
            } else if ("job".equalsIgnoreCase(type)) {
                this.log.info("Adding a default Job", new Object[0]);
                Job job = this.jobHandler.getJob(config, images);
                builder.addToJobItems(new Job[]{job});
                this.setProcessingInstruction(this.getContainersFromPodSpec(job.getSpec().getTemplate()));
            }
        }
    }

    public void enrich(PlatformMode platformMode, KubernetesListBuilder builder) {
        if (platformMode == PlatformMode.kubernetes) {
            builder.accept((Visitor)new TypedVisitor<DeploymentBuilder>(){

                public void visit(DeploymentBuilder deploymentBuilder) {
                    ((DeploymentFluent.SpecNested)deploymentBuilder.editSpec().withReplicas(Integer.valueOf(Integer.parseInt(DefaultControllerEnricher.this.getConfig(Config.replicaCount))))).endSpec();
                }
            });
        } else {
            builder.accept((Visitor)new TypedVisitor<DeploymentConfigBuilder>(){

                public void visit(DeploymentConfigBuilder deploymentConfigBuilder) {
                    ((DeploymentConfigFluent.SpecNested)deploymentConfigBuilder.editSpec().withReplicas(Integer.valueOf(Integer.parseInt(DefaultControllerEnricher.this.getConfig(Config.replicaCount))))).endSpec();
                    if (DefaultControllerEnricher.this.isAutomaticTriggerEnabled(true).booleanValue()) {
                        ((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.TriggersNested)deploymentConfigBuilder.editSpec().addNewTrigger().withType("ConfigChange")).endTrigger()).endSpec();
                    }
                }
            });
        }
    }

    private void setProcessingInstruction(List<String> containerNames) {
        HashMap<String, String> processingInstructionsMap = new HashMap<String, String>();
        if (this.enricherContext.getProcessingInstructions() != null) {
            processingInstructionsMap.putAll(this.enricherContext.getProcessingInstructions());
        }
        processingInstructionsMap.put("FABRIC8_GENERATED_CONTAINERS", String.join((CharSequence)",", containerNames));
        this.enricherContext.setProcessingInstructions(processingInstructionsMap);
    }

    private List<String> getContainersFromPodSpec(PodTemplateSpec spec) {
        ArrayList<String> containerNames = new ArrayList<String>();
        spec.getSpec().getContainers().forEach(container -> containerNames.add(container.getName()));
        return containerNames;
    }

    private int getReplicaCount(ResourceConfig xmlResourceConfig, int defaultValue) {
        if (xmlResourceConfig != null) {
            return xmlResourceConfig.getReplicas() > 0 ? xmlResourceConfig.getReplicas() : defaultValue;
        }
        return defaultValue;
    }

    private String getImagePullPolicy(ResourceConfig resourceConfig, String defaultValue) {
        if (resourceConfig != null) {
            return resourceConfig.getImagePullPolicy() != null ? resourceConfig.getImagePullPolicy() : defaultValue;
        }
        return defaultValue;
    }

    private Boolean isAutomaticTriggerEnabled(Boolean defaultValue) {
        if (this.getContext().getProperty("fabric8.openshift.enableAutomaticTrigger") != null) {
            return Boolean.parseBoolean(this.getContext().getProperty("fabric8.openshift.enableAutomaticTrigger").toString());
        }
        return defaultValue;
    }

    private Long getOpenshiftDeployTimeoutInSeconds(Long defaultValue) {
        if (this.getContext().getProperty("fabric8.openshift.deployTimeoutSeconds") != null) {
            return Long.parseLong(this.getContext().getProperty("fabric8.openshift.deployTimeoutSeconds").toString());
        }
        return defaultValue;
    }

    private Boolean getImageChangeTriggerFlag(Boolean defaultValue) {
        if (this.getContext().getProperty("fabric8.openshift.imageChangeTriggers") != null) {
            return Boolean.parseBoolean(this.getContext().getProperty("fabric8.openshift.imageChangeTriggers").toString());
        }
        return defaultValue;
    }

    static {
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(String.class);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Double.class);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Float.class);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Long.class);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Integer.class);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Short.class);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Character.class);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Byte.class);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Double.TYPE);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Float.TYPE);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Long.TYPE);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Integer.TYPE);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Short.TYPE);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Character.TYPE);
        KubernetesResourceUtil.SIMPLE_FIELD_TYPES.add(Byte.TYPE);
    }

    private static enum Config implements Configs.Key
    {
        name,
        pullPolicy{
            {
                this.d = "IfNotPresent";
            }
        }
        ,
        type{
            {
                this.d = "deployment";
            }
        }
        ,
        replicaCount{
            {
                this.d = "1";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

