/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpec;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSetBuilder;
import io.fabric8.kubernetes.api.model.apps.StatefulSetFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSetSpec;
import io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.handler.DeploymentHandler;
import io.fabric8.maven.core.handler.HandlerHub;
import io.fabric8.maven.core.handler.StatefulSetHandler;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.MavenUtil;
import io.fabric8.maven.core.util.kubernetes.KubernetesResourceUtil;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.MavenEnricherContext;
import java.util.Collections;
import java.util.List;

public class ControllerViaPluginConfigurationEnricher
extends BaseEnricher {
    protected static final String[] POD_CONTROLLER_KINDS = new String[]{"ReplicationController", "ReplicaSet", "Deployment", "DeploymentConfig", "StatefulSet", "DaemonSet", "Job"};
    private final DeploymentHandler deployHandler;
    private final StatefulSetHandler statefulSetHandler;

    public ControllerViaPluginConfigurationEnricher(MavenEnricherContext context) {
        super((EnricherContext)context, "fmp-controller-from-configuration");
        HandlerHub handlers = new HandlerHub(this.getContext().getGav(), this.getContext().getConfiguration().getProperties());
        this.deployHandler = handlers.getDeploymentHandler();
        this.statefulSetHandler = handlers.getStatefulSetHandler();
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        final String name = this.getConfig(Config.name, MavenUtil.createDefaultResourceName((String)this.getContext().getGav().getSanitizedArtifactId(), (String[])new String[0]));
        ResourceConfig config = new ResourceConfig.Builder().controllerName(name).imagePullPolicy(this.getConfig(Config.pullPolicy)).withReplicas(Configs.asInt((String)this.getConfig(Config.replicaCount))).build();
        List images = this.getImages().orElse(Collections.emptyList());
        if (KubernetesResourceUtil.checkForKind((KubernetesListBuilder)builder, (String[])POD_CONTROLLER_KINDS)) {
            if (KubernetesResourceUtil.checkForKind((KubernetesListBuilder)builder, (String[])new String[]{"StatefulSet"})) {
                final StatefulSetSpec spec = this.statefulSetHandler.getStatefulSet(config, images).getSpec();
                if (spec != null) {
                    builder.accept((Visitor)new TypedVisitor<StatefulSetBuilder>(){

                        public void visit(StatefulSetBuilder statefulSetBuilder) {
                            ((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.TemplateNested)statefulSetBuilder.editOrNewSpec().editOrNewTemplate().editOrNewSpec().endSpec()).endTemplate()).endSpec();
                            ControllerViaPluginConfigurationEnricher.this.mergeStatefulSetSpec(statefulSetBuilder, spec);
                        }
                    });
                    if (spec.getTemplate() != null && spec.getTemplate().getSpec() != null) {
                        final PodSpec podSpec = spec.getTemplate().getSpec();
                        builder.accept((Visitor)new TypedVisitor<PodSpecBuilder>(){

                            public void visit(PodSpecBuilder builder) {
                                KubernetesResourceUtil.mergePodSpec((PodSpecBuilder)builder, (PodSpec)podSpec, (String)name);
                            }
                        });
                    }
                }
            } else {
                final DeploymentSpec spec = this.deployHandler.getDeployment(config, images).getSpec();
                if (spec != null) {
                    builder.accept((Visitor)new TypedVisitor<DeploymentBuilder>(){

                        public void visit(DeploymentBuilder deploymentBuilder) {
                            ((DeploymentFluent.SpecNested)((DeploymentSpecFluent.TemplateNested)deploymentBuilder.editOrNewSpec().editOrNewTemplate().editOrNewSpec().endSpec()).endTemplate()).endSpec();
                            ControllerViaPluginConfigurationEnricher.this.mergeDeploymentSpec(deploymentBuilder, spec);
                        }
                    });
                    if (spec.getTemplate() != null && spec.getTemplate().getSpec() != null) {
                        final PodSpec podSpec = spec.getTemplate().getSpec();
                        builder.accept((Visitor)new TypedVisitor<PodSpecBuilder>(){

                            public void visit(PodSpecBuilder builder) {
                                KubernetesResourceUtil.mergePodSpec((PodSpecBuilder)builder, (PodSpec)podSpec, (String)name);
                            }
                        });
                    }
                }
            }
        }
    }

    private void mergeDeploymentSpec(DeploymentBuilder builder, DeploymentSpec spec) {
        DeploymentFluent.SpecNested specBuilder = builder.editSpec();
        KubernetesResourceUtil.mergeSimpleFields((Object)specBuilder, (Object)spec);
        specBuilder.endSpec();
    }

    private void mergeStatefulSetSpec(StatefulSetBuilder builder, StatefulSetSpec spec) {
        StatefulSetFluent.SpecNested specBuilder = builder.editSpec();
        KubernetesResourceUtil.mergeSimpleFields((Object)specBuilder, (Object)spec);
        specBuilder.endSpec();
    }

    private static enum Config implements Configs.Key
    {
        name,
        pullPolicy{
            {
                this.d = "IfNotPresent";
            }
        }
        ,
        type{
            {
                this.d = "deployment";
            }
        }
        ,
        replicaCount{
            {
                this.d = "1";
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

