/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.extensions.DeploymentFluent;
import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;

public class RevisionHistoryEnricher
extends BaseEnricher {
    public static final String DEFAULT_NAME = "fmp-revision-history";
    private static final String DEFAULT_NUMBER_OF_REVISIONS = "2";

    public RevisionHistoryEnricher(EnricherContext buildContext) {
        super(buildContext, DEFAULT_NAME);
    }

    public void addMissingResources(KubernetesListBuilder builder) {
        final Integer maxRevisionHistories = Configs.asInt((String)this.getConfig(Config.limit));
        this.log.info("Adding revision history limit to %s", new Object[]{maxRevisionHistories});
        builder.accept((Visitor)new TypedVisitor<DeploymentBuilder>(){

            public void visit(DeploymentBuilder item) {
                ((DeploymentFluent.SpecNested)item.editOrNewSpec().withRevisionHistoryLimit(maxRevisionHistories)).endSpec();
            }
        });
    }

    static enum Config implements Configs.Key
    {
        limit{
            {
                this.d = RevisionHistoryEnricher.DEFAULT_NUMBER_OF_REVISIONS;
            }
        };

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

