/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.standard;

import io.fabric8.maven.core.util.DockerServerUtil;
import io.fabric8.maven.core.util.SecretConstants;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.standard.SecretEnricher;
import io.fabric8.utils.Strings;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.settings.Settings;

public class DockerRegistrySecretEnricher
extends SecretEnricher {
    private static final String ANNOTATION_KEY = "maven.fabric8.io/dockerServerId";
    private static final String ENRICHER_NAME = "fmp-docker-registry-secret";

    public DockerRegistrySecretEnricher(EnricherContext buildContext) {
        super(buildContext, ENRICHER_NAME);
    }

    @Override
    protected String getAnnotationKey() {
        return ANNOTATION_KEY;
    }

    @Override
    protected Map<String, String> generateData(String dockerId) {
        String dockerSecret = DockerServerUtil.getDockerJsonConfigString((Settings)this.getContext().getSettings(), (String)dockerId);
        if (Strings.isNullOrBlank((String)dockerSecret)) {
            return null;
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(SecretConstants.DOCKER_DATA_KEY, this.encode(dockerSecret));
        return data;
    }
}

