/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.enricher.fabric8;

import io.fabric8.maven.core.util.Configs;
import io.fabric8.maven.core.util.MapUtil;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.enricher.api.BaseEnricher;
import io.fabric8.maven.enricher.api.EnricherContext;
import io.fabric8.maven.enricher.api.Kind;
import io.fabric8.utils.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PrometheusEnricher
extends BaseEnricher {
    static final String ENRICHER_NAME = "f8-prometheus";
    static final String PROMETHEUS_PORT = "9779";

    public PrometheusEnricher(EnricherContext buildContext) {
        super(buildContext, ENRICHER_NAME);
    }

    public Map<String, String> getAnnotations(Kind kind) {
        String prometheusPort;
        if (kind == Kind.SERVICE && Strings.isNotBlank((String)(prometheusPort = this.findPrometheusPort()))) {
            this.log.verbose("Add prometheus.io annotations: %s=%s, %s=%S", new Object[]{"prometheus.io/scrape", "true", "prometheus.io/port", prometheusPort});
            HashMap<String, String> annotations = new HashMap<String, String>();
            MapUtil.putIfAbsent(annotations, (String)"prometheus.io/port", (String)prometheusPort);
            MapUtil.putIfAbsent(annotations, (String)"prometheus.io/scrape", (String)"true");
            return annotations;
        }
        return super.getAnnotations(kind);
    }

    private String findPrometheusPort() {
        String prometheusPort = this.getConfig(Config.prometheusPort);
        if (Strings.isNullOrBlank((String)prometheusPort)) {
            for (ImageConfiguration configuration : this.getImages()) {
                List ports;
                BuildImageConfiguration buildImageConfiguration = configuration.getBuildConfiguration();
                if (buildImageConfiguration == null || (ports = buildImageConfiguration.getPorts()) == null || !ports.contains(PROMETHEUS_PORT)) continue;
                prometheusPort = PROMETHEUS_PORT;
                break;
            }
        }
        return prometheusPort;
    }

    private static enum Config implements Configs.Key
    {
        prometheusPort;

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

