/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.handler;

import io.fabric8.maven.core.handler.ContainerHandler;
import io.fabric8.maven.core.handler.DaemonSetHandler;
import io.fabric8.maven.core.handler.DeploymentConfigHandler;
import io.fabric8.maven.core.handler.DeploymentHandler;
import io.fabric8.maven.core.handler.JobHandler;
import io.fabric8.maven.core.handler.PodTemplateHandler;
import io.fabric8.maven.core.handler.ProbeHandler;
import io.fabric8.maven.core.handler.ReplicaSetHandler;
import io.fabric8.maven.core.handler.ReplicationControllerHandler;
import io.fabric8.maven.core.handler.ServiceHandler;
import io.fabric8.maven.core.handler.StatefulSetHandler;
import io.fabric8.maven.core.model.GroupArtifactVersion;
import java.util.Properties;

public class HandlerHub {
    private final ServiceHandler serviceHandler;
    private final ReplicaSetHandler replicaSetHandler;
    private final ReplicationControllerHandler replicationControllerHandler;
    private final DeploymentHandler deploymentHandler;
    private final DeploymentConfigHandler deploymentConfigHandler;
    private final StatefulSetHandler statefulSetHandler;
    private final DaemonSetHandler daemonSetHandler;
    private final JobHandler jobHandler;

    public HandlerHub(GroupArtifactVersion groupArtifactVersion, Properties configuration) {
        ProbeHandler probeHandler = new ProbeHandler();
        ContainerHandler containerHandler = new ContainerHandler(configuration, groupArtifactVersion, probeHandler);
        PodTemplateHandler podTemplateHandler = new PodTemplateHandler(containerHandler);
        this.deploymentHandler = new DeploymentHandler(podTemplateHandler);
        this.deploymentConfigHandler = new DeploymentConfigHandler(podTemplateHandler);
        this.replicaSetHandler = new ReplicaSetHandler(podTemplateHandler);
        this.replicationControllerHandler = new ReplicationControllerHandler(podTemplateHandler);
        this.serviceHandler = new ServiceHandler();
        this.statefulSetHandler = new StatefulSetHandler(podTemplateHandler);
        this.daemonSetHandler = new DaemonSetHandler(podTemplateHandler);
        this.jobHandler = new JobHandler(podTemplateHandler);
    }

    public ServiceHandler getServiceHandler() {
        return this.serviceHandler;
    }

    public DeploymentHandler getDeploymentHandler() {
        return this.deploymentHandler;
    }

    public DeploymentConfigHandler getDeploymentConfigHandler() {
        return this.deploymentConfigHandler;
    }

    public ReplicaSetHandler getReplicaSetHandler() {
        return this.replicaSetHandler;
    }

    public ReplicationControllerHandler getReplicationControllerHandler() {
        return this.replicationControllerHandler;
    }

    public StatefulSetHandler getStatefulSetHandler() {
        return this.statefulSetHandler;
    }

    public DaemonSetHandler getDaemonSetHandler() {
        return this.daemonSetHandler;
    }

    public JobHandler getJobHandler() {
        return this.jobHandler;
    }
}

