/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.maven.core.util.KindAndName;
import io.fabric8.maven.core.util.KubernetesResourceUtil;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.openshift.api.model.Parameter;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.utils.Lists;
import io.fabric8.utils.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OpenShiftDependencyResources {
    private final Map<KindAndName, HasMetadata> openshiftDependencyResources = new HashMap<KindAndName, HasMetadata>();
    private final Map<String, Parameter> templateParameters = new HashMap<String, Parameter>();
    private final Logger log;

    public OpenShiftDependencyResources(Logger log) {
        this.log = log;
    }

    public void addOpenShiftResources(List<HasMetadata> items, boolean isAppCatalog) {
        for (HasMetadata item : items) {
            Template template;
            if (item instanceof Template && !KubernetesResourceUtil.isAppCatalogResource((HasMetadata)(template = (Template)item)) && !isAppCatalog) {
                List objects = Lists.notNullList((List)template.getObjects());
                String sourceUrl = KubernetesResourceUtil.getSourceUrlAnnotation((HasMetadata)template);
                if (Strings.isNotBlank((String)sourceUrl)) {
                    for (HasMetadata object : objects) {
                        KubernetesResourceUtil.setSourceUrlAnnotationIfNotSet(object, sourceUrl);
                    }
                }
                this.addOpenShiftResources(objects, isAppCatalog);
                this.mergeParametersIntoMap(this.templateParameters, Lists.notNullList((List)template.getParameters()));
                continue;
            }
            KindAndName key = new KindAndName(item);
            HasMetadata old = this.openshiftDependencyResources.get(key);
            if (old != null && !isAppCatalog) {
                this.log.warn("Duplicate OpenShift resources for %s at %s and %s", new Object[]{key, KubernetesResourceUtil.getSourceUrlAnnotation(old), KubernetesResourceUtil.getSourceUrlAnnotation(item)});
            }
            this.openshiftDependencyResources.put(key, item);
        }
    }

    private void mergeParametersIntoMap(Map<String, Parameter> targetMap, Iterable<Parameter> parameters) {
        for (Parameter parameter : parameters) {
            String name = parameter.getName();
            if (!Strings.isNotBlank((String)name)) continue;
            Parameter old = targetMap.get(name);
            if (old != null) {
                this.mergeParameters(old, parameter);
                continue;
            }
            targetMap.put(name, parameter);
        }
    }

    private void mergeParameters(Parameter current, Parameter other) {
        String from;
        String generate;
        String value = other.getValue();
        if (Strings.isNotBlank((String)value) && Strings.isNullOrBlank((String)current.getValue())) {
            current.setValue(value);
        }
        if (Strings.isNotBlank((String)(generate = other.getGenerate())) && Strings.isNullOrBlank((String)current.getGenerate())) {
            current.setGenerate(generate);
        }
        if (Strings.isNotBlank((String)(from = other.getFrom())) && Strings.isNullOrBlank((String)current.getFrom())) {
            current.setFrom(from);
        }
    }

    public HasMetadata convertKubernetesItemToOpenShift(HasMetadata item) {
        KindAndName key = new KindAndName(item);
        HasMetadata answer = this.openshiftDependencyResources.get(key);
        if (answer == null && item instanceof Deployment) {
            key = new KindAndName("DeploymentConfig", KubernetesHelper.getName((HasMetadata)item));
            answer = this.openshiftDependencyResources.get(key);
        }
        return answer;
    }

    public void addMissingParameters(Template template) {
        ArrayList<Parameter> parameters = template.getParameters();
        if (parameters == null) {
            parameters = new ArrayList<Parameter>();
        }
        HashMap<String, Parameter> map = new HashMap<String, Parameter>();
        for (Parameter parameter : parameters) {
            map.put(parameter.getName(), parameter);
        }
        this.mergeParametersIntoMap(map, parameters);
        for (Parameter parameter : map.values()) {
            if (parameters.contains(parameter)) continue;
            parameters.add(parameter);
        }
        template.setParameters(parameters);
    }

    public void addMissingResources(List<HasMetadata> objects) {
        HashMap<KindAndName, HasMetadata> itemMap = new HashMap<KindAndName, HasMetadata>();
        for (HasMetadata hasMetadata : objects) {
            itemMap.put(new KindAndName(hasMetadata), hasMetadata);
        }
        for (Map.Entry entry : this.openshiftDependencyResources.entrySet()) {
            KindAndName key = (KindAndName)entry.getKey();
            HasMetadata dependency = (HasMetadata)entry.getValue();
            if (itemMap.containsKey(key)) continue;
            objects.add(dependency);
        }
    }
}

