/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.maven.core.config.ProcessorConfig;
import java.util.concurrent.atomic.AtomicInteger;

public class Profile
implements Comparable<Profile> {
    private static final AtomicInteger idCreator = new AtomicInteger(0);
    private final int id = idCreator.getAndIncrement();
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="enricher")
    private ProcessorConfig enricherConfig;
    @JsonProperty(value="generator")
    private ProcessorConfig generatorConfig;
    @JsonProperty(value="watcher")
    private ProcessorConfig watcherConfig;
    @JsonProperty(value="order")
    private int order;

    public Profile() {
    }

    public Profile(Profile profile) {
        this();
        this.name = profile.name;
        this.order = profile.order;
        this.enricherConfig = ProcessorConfig.cloneProcessorConfig(profile.enricherConfig);
        this.generatorConfig = ProcessorConfig.cloneProcessorConfig(profile.generatorConfig);
        this.watcherConfig = ProcessorConfig.cloneProcessorConfig(profile.watcherConfig);
    }

    public Profile(Profile profileA, Profile profileB) {
        this();
        this.name = profileA.name;
        if (!profileB.name.equals(profileA.getName())) {
            throw new IllegalArgumentException(String.format("Cannot merge to profiles with different names (%s vs. %s)", profileA.getName(), profileB.getName()));
        }
        if (profileA.order >= profileB.order) {
            this.order = profileA.order;
            this.enricherConfig = ProcessorConfig.mergeProcessorConfigs(profileA.enricherConfig, profileB.enricherConfig);
            this.generatorConfig = ProcessorConfig.mergeProcessorConfigs(profileA.generatorConfig, profileB.generatorConfig);
            this.watcherConfig = ProcessorConfig.mergeProcessorConfigs(profileA.watcherConfig, profileB.watcherConfig);
        } else {
            this.order = profileB.order;
            this.enricherConfig = ProcessorConfig.mergeProcessorConfigs(profileB.enricherConfig, profileA.enricherConfig);
            this.generatorConfig = ProcessorConfig.mergeProcessorConfigs(profileB.generatorConfig, profileA.generatorConfig);
            this.watcherConfig = ProcessorConfig.mergeProcessorConfigs(profileB.watcherConfig, profileA.watcherConfig);
        }
    }

    public String getName() {
        return this.name;
    }

    public ProcessorConfig getEnricherConfig() {
        return this.enricherConfig;
    }

    public ProcessorConfig getGeneratorConfig() {
        return this.generatorConfig;
    }

    public ProcessorConfig getWatcherConfig() {
        return this.watcherConfig;
    }

    public int getOrder() {
        return this.order;
    }

    @Override
    public int compareTo(Profile o) {
        int orderDiff = this.order - o.order;
        if (orderDiff != 0) {
            return orderDiff;
        }
        return this.id - o.id;
    }
}

