/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NamePatternUtil {
    public static String convertImageNamePattern(String pattern) {
        String REGEX_PREFIX = "%regex[";
        String ANT_PREFIX = "%ant[";
        String PATTERN_SUFFIX = "]";
        if (pattern.startsWith("%regex[") && pattern.endsWith("]")) {
            return pattern.substring("%regex[".length(), pattern.length() - "]".length());
        }
        if (pattern.startsWith("%ant[") && pattern.endsWith("]")) {
            pattern = pattern.substring("%ant[".length(), pattern.length() - "]".length());
        }
        String[] parts = pattern.split("((?=[/:?*])|(?<=[/:?*]))");
        Matcher matcher = Pattern.compile("[A-Za-z0-9-]+").matcher("");
        StringBuilder builder = new StringBuilder("^");
        for (int i = 0; i < parts.length; ++i) {
            if ("?".equals(parts[i])) {
                builder.append("[^/:]");
                continue;
            }
            if ("*".equals(parts[i])) {
                if (i + 1 < parts.length && "*".equals(parts[i + 1])) {
                    builder.append("([^:]|:(?=.*:))*");
                    if (++i + 1 >= parts.length || !"/".equals(parts[i + 1])) continue;
                    builder.append("(?<![^/])");
                    ++i;
                    continue;
                }
                builder.append("([^/:]|:(?=.*:))*");
                continue;
            }
            if ("/".equals(parts[i]) || ":".equals(parts[i]) || matcher.reset(parts[i]).matches()) {
                builder.append(parts[i]);
                continue;
            }
            if (parts[i].length() <= 0) continue;
            builder.append(Pattern.quote(parts[i]));
        }
        builder.append("$");
        return builder.toString();
    }
}

