/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.echain.workflow.engine;

import com.ecc.echain.db.DbControl;
import com.ecc.echain.ext.AppExtFactory;
import com.ecc.echain.log.WfLog;
import com.ecc.echain.message.MsgFactory;
import com.ecc.echain.org.OrgFactory;
import com.ecc.echain.org.OrgIF;
import com.ecc.echain.org.model.OrgModel;
import com.ecc.echain.util.DatetimeUtils;
import com.ecc.echain.util.Field;
import com.ecc.echain.util.StringUtils;
import com.ecc.echain.util.UNIDProducer;
import com.ecc.echain.util.WfPropertyManager;
import com.ecc.echain.workflow.cache.WFCache;
import com.ecc.echain.workflow.engine.EVO;
import com.ecc.echain.workflow.engine.OrgClass;
import com.ecc.echain.workflow.engine.Permit;
import com.ecc.echain.workflow.engine.Urgent;
import com.ecc.echain.workflow.engine.WfEngine;
import com.ecc.echain.workflow.engine.WfGatherEngine;
import com.ecc.echain.workflow.engine.WfManager;
import com.ecc.echain.workflow.engine.WfTrack;
import com.ecc.echain.workflow.model.CommentExtVO;
import com.ecc.echain.workflow.model.CommentVO;
import com.ecc.echain.workflow.model.GatherActionVO;
import com.ecc.echain.workflow.model.GatherVO;
import com.ecc.echain.workflow.model.VO_wf_node_field_property;
import com.ecc.echain.workflow.model.VO_wf_node_property;
import com.ecc.echain.workflow.model.VO_wf_whole_property;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class WorkFlowClient {
    private static WorkFlowClient _instance = new WorkFlowClient();

    public static WorkFlowClient getInstance() {
        return _instance;
    }

    public Vector getWFNameList(EVO vo) {
        Vector<EVO> WFList;
        long dst;
        block32: {
            dst = System.currentTimeMillis();
            String AppID = vo.getAppID();
            String CurrentUserID = vo.getCurrentUserID();
            String sysid = vo.getSysid();
            String orgid = vo.getOrgid();
            String WFAdmin = vo.getWFAdmin();
            String formid = vo.getFormid();
            String wfsign = vo.getWFSign();
            WfLog.log(0, "\u83b7\u53d6\u53ef\u7528\u6d41\u7a0b\u5217\u8868getWFNameList(),AppID:" + AppID + ";CurrentUserID:" + CurrentUserID + "; orgid:" + orgid + "; sysid:" + sysid);
            String NodeUserList = "";
            WFList = new Vector<EVO>();
            if (WFAdmin == null || WFAdmin.equals("") || WFAdmin.equals("null")) {
                WFAdmin = null;
            }
            if (CurrentUserID == null || CurrentUserID.equals("") || CurrentUserID.equals("null")) {
                WfLog.paramException(this, "getWFNameList", vo);
                return WFList;
            }
            if (formid != null && !formid.equals("null") && !formid.equals("")) {
                return this.getWFNameListByFormID(vo);
            }
            if (wfsign != null && !wfsign.equals("null") && !wfsign.equals("")) {
                return this.getWFNameListByWFSign(vo);
            }
            DbControl db = DbControl.getInstance();
            Connection cn = null;
            boolean bClose = true;
            OrgClass orgclass = OrgClass.getInstance();
            try {
                try {
                    EVO obj;
                    if (vo.getConnection() != null) {
                        cn = vo.getConnection();
                        bClose = false;
                    } else {
                        cn = db.getConnection();
                        vo.setConnection(cn);
                    }
                    String wfid = "";
                    String wfadmintmp = "";
                    String WFInitiators = "";
                    String WFCondition = "";
                    String WFFirstNodeDocID = "";
                    Map wfMapList = WFCache.getInstance().getWFList();
                    Iterator it = wfMapList.keySet().iterator();
                    boolean bOK = false;
                    while (it.hasNext()) {
                        bOK = false;
                        String wfname = (String)it.next();
                        HashMap wfMap = (HashMap)wfMapList.get(wfname);
                        if (sysid != null ? wfMap == null || wfMap.get("sysid") == null || !((String)wfMap.get("sysid")).equals(sysid) : AppID != null && !((String)wfMap.get("wfappid")).equals(AppID)) continue;
                        wfid = (String)wfMap.get("wfid");
                        wfadmintmp = (String)wfMap.get("wfadmin");
                        WFInitiators = (String)wfMap.get("wfinitiators");
                        WFCondition = (String)wfMap.get("wfcondition");
                        if (WFInitiators != null && WFInitiators.equals("0")) {
                            if (WFAdmin == null || StringUtils.isPartOf(wfadmintmp, "U." + WFAdmin, ";")) {
                                bOK = true;
                            }
                        } else if (WFInitiators != null && WFInitiators.equals("1")) {
                            if (WFAdmin == null || StringUtils.isPartOf(wfadmintmp, "U." + WFAdmin, ";")) {
                                WFFirstNodeDocID = WfEngine.getFirstDocUNID(wfid);
                                VO_wf_node_property wnp = WFCache.getInstance().getNodeProperty(WFFirstNodeDocID);
                                NodeUserList = wnp.NodeUsersList;
                                if ((NodeUserList = orgclass.convertPersonsList_str(orgid, NodeUserList, cn)) == null || NodeUserList.equals("")) {
                                    bOK = true;
                                } else if (StringUtils.isPartOf(NodeUserList, CurrentUserID, ";")) {
                                    bOK = true;
                                }
                            }
                        } else if (WFInitiators != null && WFInitiators.equals("2") && WFCondition != null && !WFCondition.equals("") && WfEngine.ISMatchCondition(WFCondition, vo)) {
                            bOK = true;
                        }
                        if (!bOK) continue;
                        obj = new EVO();
                        obj.setWFID(wfid);
                        obj.setWFName(wfname);
                        obj.setWFSign((String)wfMap.get("wfsign"));
                        obj.setTip((String)wfMap.get("wfver"));
                        obj.setAppID((String)wfMap.get("wfappid"));
                        obj.setAppName((String)wfMap.get("wfappname"));
                        obj.setWFMainForm((String)wfMap.get("wfmainformid"));
                        obj.setWFAdmin(orgclass.convertPersonsList_str(orgid, wfadmintmp, cn));
                        obj.setWFReaders(orgclass.convertPersonsList_str(orgid, (String)wfMap.get("wfreaders"), cn));
                        obj.setAuthor((String)wfMap.get("author"));
                        WFList.addElement(obj);
                    }
                    if (AppID != null && !AppID.equals("null") && !AppID.equals("")) {
                        obj = new EVO();
                        obj.setWFID("wffreerouter");
                        obj.setWFName("\u3010\u81ea\u7531\u6d41\u7a0b\u3011");
                        obj.setTip("V0001");
                        obj.setAppID(AppID);
                        obj.setAppName(AppID);
                        obj.setWFMainForm("-");
                        obj.setWFAdmin("-");
                        obj.setWFReaders(CurrentUserID);
                        obj.setAuthor("-");
                        WFList.addElement(obj);
                    }
                }
                catch (Exception e) {
                    WFList = new Vector();
                    WfLog.runtimeException(this, "getWFNameList", e);
                    if (cn != null && bClose) {
                        try {
                            db.freeConnection(cn);
                        }
                        catch (Exception e2) {
                            WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                            e2.printStackTrace();
                        }
                    }
                    break block32;
                }
            }
            catch (Throwable throwable) {
                if (cn != null && bClose) {
                    try {
                        db.freeConnection(cn);
                    }
                    catch (Exception e) {
                        WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u83b7\u53d6\u53ef\u7528\u6d41\u7a0b\u5217\u8868getWFNameList(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return WFList;
    }

    private Vector getWFNameListByFormID(EVO vo) {
        Vector<EVO> WFList;
        long dst;
        block18: {
            dst = System.currentTimeMillis();
            String orgid = vo.getOrgid();
            String formid = vo.getFormid();
            WFList = new Vector<EVO>();
            DbControl db = DbControl.getInstance();
            Connection cn = null;
            boolean bClose = true;
            OrgClass orgclass = OrgClass.getInstance();
            try {
                try {
                    EVO obj;
                    if (vo.getConnection() != null) {
                        cn = vo.getConnection();
                        bClose = false;
                    } else {
                        cn = db.getConnection();
                    }
                    Map wfMapList = WFCache.getInstance().getWFList();
                    for (String wfname : wfMapList.keySet()) {
                        HashMap wfMap = (HashMap)wfMapList.get(wfname);
                        if (!((String)wfMap.get("sysid")).equals(vo.getSysid()) || !((String)wfMap.get("wfmainformid")).equals(formid)) continue;
                        obj = new EVO();
                        obj.setWFID((String)wfMap.get("wfid"));
                        obj.setWFName(wfname);
                        obj.setWFSign((String)wfMap.get("wfsign"));
                        obj.setTip((String)wfMap.get("wfver"));
                        obj.setAppID((String)wfMap.get("wfappid"));
                        obj.setAppName((String)wfMap.get("wfappname"));
                        obj.setWFMainForm((String)wfMap.get("wfmainformid"));
                        obj.setWFAdmin(orgclass.convertPersonsList_str(orgid, (String)wfMap.get("wfadmin"), cn));
                        obj.setWFReaders(orgclass.convertPersonsList_str(orgid, (String)wfMap.get("wfreaders"), cn));
                        obj.setAuthor((String)wfMap.get("author"));
                        WFList.addElement(obj);
                    }
                    String AppID = vo.getAppID();
                    if (AppID != null && !AppID.equals("null") && !AppID.equals("")) {
                        obj = new EVO();
                        obj.setWFID("wffreerouter");
                        obj.setWFName("\u3010\u81ea\u7531\u6d41\u7a0b\u3011");
                        obj.setAppID(AppID);
                        obj.setAppName(AppID);
                        obj.setWFMainForm("-");
                        obj.setWFAdmin("-");
                        obj.setWFReaders("-");
                        obj.setAuthor("-");
                        WFList.addElement(obj);
                    }
                }
                catch (Exception e) {
                    WFList = new Vector();
                    WfLog.runtimeException(this, "getWFNameListByFormID", e);
                    if (cn != null && bClose) {
                        try {
                            db.freeConnection(cn);
                        }
                        catch (Exception e2) {
                            WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                            e2.printStackTrace();
                        }
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (cn != null && bClose) {
                    try {
                        db.freeConnection(cn);
                    }
                    catch (Exception e) {
                        WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u83b7\u53d6\u53ef\u7528\u6d41\u7a0b\u5217\u8868\uff08\u6839\u636e\u8868\u5355ID\uff09getWFNameListByFormID(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return WFList;
    }

    private Vector getWFNameListByWFSign(EVO vo) {
        Vector<EVO> WFList;
        long dst;
        block18: {
            dst = System.currentTimeMillis();
            String AppID = vo.getAppID();
            String orgid = vo.getOrgid();
            String wfsign = vo.getWFSign();
            WFList = new Vector<EVO>();
            DbControl db = DbControl.getInstance();
            Connection cn = null;
            boolean bClose = true;
            OrgClass orgclass = OrgClass.getInstance();
            try {
                try {
                    EVO obj;
                    if (vo.getConnection() != null) {
                        cn = vo.getConnection();
                        bClose = false;
                    } else {
                        cn = db.getConnection();
                    }
                    Map wfMapList = WFCache.getInstance().getWFList();
                    for (String wfname : wfMapList.keySet()) {
                        HashMap wfMap = (HashMap)wfMapList.get(wfname);
                        if (!((String)wfMap.get("sysid")).equals(vo.getSysid()) || AppID != null && !((String)wfMap.get("wfappid")).equals(AppID) || !((String)wfMap.get("wfsign")).equals(wfsign)) continue;
                        obj = new EVO();
                        obj.setWFID((String)wfMap.get("wfid"));
                        obj.setWFName(wfname);
                        obj.setWFSign((String)wfMap.get("wfsign"));
                        obj.setTip((String)wfMap.get("wfver"));
                        obj.setAppID((String)wfMap.get("wfappid"));
                        obj.setAppName((String)wfMap.get("wfappname"));
                        obj.setWFMainForm((String)wfMap.get("wfmainformid"));
                        obj.setWFAdmin(orgclass.convertPersonsList_str(orgid, (String)wfMap.get("wfadmin"), cn));
                        obj.setWFReaders(orgclass.convertPersonsList_str(orgid, (String)wfMap.get("wfreaders"), cn));
                        obj.setAuthor((String)wfMap.get("author"));
                        WFList.addElement(obj);
                    }
                    if (AppID != null && !AppID.equals("null") && !AppID.equals("")) {
                        obj = new EVO();
                        obj.setWFID("wffreerouter");
                        obj.setWFName("\u3010\u81ea\u7531\u6d41\u7a0b\u3011");
                        obj.setAppID(AppID);
                        obj.setAppName(AppID);
                        obj.setWFMainForm("-");
                        obj.setWFAdmin("-");
                        obj.setWFReaders("-");
                        obj.setAuthor("-");
                        WFList.addElement(obj);
                    }
                }
                catch (Exception e) {
                    WFList = new Vector();
                    WfLog.runtimeException(this, "getWFNameListByWFSign", e);
                    if (cn != null && bClose) {
                        try {
                            db.freeConnection(cn);
                        }
                        catch (Exception e2) {
                            WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                            e2.printStackTrace();
                        }
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (cn != null && bClose) {
                    try {
                        db.freeConnection(cn);
                    }
                    catch (Exception e) {
                        WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u83b7\u53d6\u53ef\u7528\u6d41\u7a0b\u5217\u8868\uff08\u6839\u636e\u6d41\u7a0b\u6807\u8bc6\uff09getWFNameListByWFSign(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return WFList;
    }

    /*
     * Unable to fully structure code
     */
    public Vector getInstanceList(EVO vo) {
        block20: {
            block21: {
                dst = System.currentTimeMillis();
                WFID = vo.getWFID();
                WFStatus = vo.getWFStatus();
                CurrentUserID = vo.getCurrentUserID();
                WfLog.log(0, "\u6839\u636e\u6d41\u7a0bid\u83b7\u53d6\u6240\u6709\u7684\u6d41\u7a0b\u5b9e\u4f8bgetInstanceList(),WFID:" + WFID);
                SqlStr = "";
                WFList = new Vector<EVO>();
                if (WFID == null || WFID.equals("") || WFID.equals("null") || CurrentUserID == null || CurrentUserID.equals("") || CurrentUserID.equals("null")) {
                    WfLog.paramException(this, "getInstanceList", vo);
                    WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u6839\u636e\u6d41\u7a0bid\u83b7\u53d6\u6240\u6709\u7684\u6d41\u7a0b\u5b9e\u4f8bgetInstanceList(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
                    return WFList;
                }
                db = DbControl.getInstance();
                cn = null;
                bClose = true;
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                }
                if (WFID.equals("wffreerouter") || StringUtils.isPartOf(WFAdmin = WFCache.getInstance().getCacheWFObj((String)WFID).WFAdmin, "U." + CurrentUserID, ";")) break block20;
                WfLog.log(4, "\u5f53\u524d\u7528\u6237\u4e0d\u662f\u6d41\u7a0b\u53f7\u4e3a\uff1a" + WFID + "\u7684\u7ba1\u7406\u5458\uff01");
                WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u6839\u636e\u6d41\u7a0bid\u83b7\u53d6\u6240\u6709\u7684\u6d41\u7a0b\u5b9e\u4f8bgetInstanceList(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
                var19_14 = WFList;
                if (cn == null || !bClose) break block21;
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
            return var19_14;
        }
        try {
            try {
                SqlStr = WFStatus == null || WFStatus.equals("") != false || WFStatus.equals("null") != false ? "select InstanceID,WFName,WFID,WFAppID,WFAppName,WFJobName,AppSign,SPStatus,depid,orgid,NodeName,NodeID,WFStatus,NodeStatus,WFNodeFormID,WFNodeFormFlow,CurrentNodeUser,originalusers,author,PreProcessorList,NodeStartTime,NodePlanEndTime,AllProcessor,AllReadersList,AnnounceUser,bDraft,IsProcessed from wf_worklist where WFID='" + WFID + "' order by NodeStartTime DESC" : "select InstanceID,WFName,WFID,WFAppID,WFAppName,WFJobName,AppSign,SPStatus,depid,orgid,NodeName,NodeID,WFStatus,NodeStatus,WFNodeFormID,WFNodeFormFlow,CurrentNodeUser,originalusers,author,PreProcessorList,NodeStartTime,NodePlanEndTime,AllProcessor,AllReadersList,AnnounceUser,bDraft,IsProcessed from wf_worklist where WFStatus='" + WFStatus + "' and WFID='" + WFID + "' order by NodeStartTime DESC";
                vecData = db.performQuery(SqlStr, cn);
                i = 0;
                while (i < vecData.size()) {
                    vecRow = (Vector)vecData.elementAt(i);
                    bDraft = (String)vecRow.elementAt(25);
                    IsProcessed = (String)vecRow.elementAt(26);
                    if (bDraft.equals("0") || IsProcessed.equals("1")) {
                        obj = new EVO();
                        obj.setInstanceID((String)vecRow.elementAt(0));
                        obj.setWFName((String)vecRow.elementAt(1) == null ? "-" : (String)vecRow.elementAt(1));
                        obj.setWFID((String)vecRow.elementAt(2));
                        obj.setAppID((String)vecRow.elementAt(3));
                        obj.setAppName((String)vecRow.elementAt(4) == null ? "-" : (String)vecRow.elementAt(4));
                        obj.setJobName((String)vecRow.elementAt(5) == null ? "-" : (String)vecRow.elementAt(5));
                        obj.setAppSign((String)vecRow.elementAt(6));
                        obj.setSPStatus((String)vecRow.elementAt(7));
                        obj.setDepid((String)vecRow.elementAt(8));
                        obj.setOrgid((String)vecRow.elementAt(9));
                        obj.setNodeName((String)vecRow.elementAt(10) == null ? "-" : (String)vecRow.elementAt(10));
                        obj.setNodeID((String)vecRow.elementAt(11));
                        obj.setWFStatus((String)vecRow.elementAt(12));
                        obj.setNodeStatus((String)vecRow.elementAt(13));
                        obj.setFormid((String)vecRow.elementAt(14));
                        obj.setFormflow((String)vecRow.elementAt(15));
                        obj.setCurrentNodeUser(vecRow.elementAt(16) == null ? "" : ((String)vecRow.elementAt(16)).trim());
                        obj.setOriginalUser(vecRow.elementAt(17) == null ? "" : ((String)vecRow.elementAt(17)).trim());
                        obj.setAuthor((String)vecRow.elementAt(18));
                        obj.setPreUser((String)vecRow.elementAt(19));
                        obj.setNodeStartTime((String)vecRow.elementAt(20) == null ? "-" : (String)vecRow.elementAt(20));
                        obj.setNodePlanEndTime((String)vecRow.elementAt(21) == null ? "-" : (String)vecRow.elementAt(21));
                        obj.setAllProcessor((String)vecRow.elementAt(22) == null ? "-" : ((String)vecRow.elementAt(22)).trim());
                        obj.setTip((String)vecRow.elementAt(23) == null ? "-" : ((String)vecRow.elementAt(23)).trim());
                        obj.setUserID((String)vecRow.elementAt(24) == null ? "-" : ((String)vecRow.elementAt(24)).trim());
                        obj.setIsDraft(bDraft);
                        obj.setIsProcessed(IsProcessed);
                        WFList.addElement(obj);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                WFList = new Vector<E>();
                WfLog.runtimeException(this, "getInstanceList", e);
                if (cn == null || !bClose) ** GOTO lbl109
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable var18_24) {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
            throw var18_24;
        }
        if (cn != null && bClose) {
            try {
                db.freeConnection(cn);
            }
            catch (Exception e) {
                WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                e.printStackTrace();
            }
        }
lbl109:
        // 7 sources

        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u6839\u636e\u6d41\u7a0bid\u83b7\u53d6\u6240\u6709\u7684\u6d41\u7a0b\u5b9e\u4f8bgetInstanceList(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return WFList;
    }

    public EVO wfCompleteJob(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        String InstanceID = vo.getInstanceID();
        String CurrentUserID = vo.getCurrentUserID();
        String NodeID = vo.getNodeID();
        String orgid = vo.getOrgid();
        WfLog.log(0, "\u5b8c\u6210\u5f53\u524d\u8282\u70b9\u529e\u7406\uff0c\u63d0\u4ea4\u5de5\u4f5c\u4efb\u52a1wfCompleteJob(),orgid:" + orgid + ";InstanceID:" + InstanceID + ";CurrentUserID:" + CurrentUserID + "; NodeID:" + NodeID + "; NextNodeID:" + vo.getNextNodeID() + "; NextNodeUser:" + vo.getNextNodeUser());
        if (InstanceID == null || CurrentUserID == null || InstanceID.equals("") || CurrentUserID.equals("") || NodeID == null || NodeID.equals("") || orgid == null || orgid.equals("")) {
            WfLog.paramException(this, "wfCompleteJob", vo);
            vo.setSign(1);
            vo.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u5b8c\u6210\u5f53\u524d\u8282\u70b9\u529e\u7406\uff0c\u63d0\u4ea4\u5de5\u4f5c\u4efb\u52a1wfCompleteJob(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return vo;
        }
        DbControl db = DbControl.getInstance();
        WfEngine we = WfEngine.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                    vo.setConnection(cn);
                }
                vo = we.wfCompleteJob(vo, cn);
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                WfLog.runtimeException(this, "wfCompleteJob", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u5b8c\u6210\u5f53\u524d\u8282\u70b9\u529e\u7406\uff0c\u63d0\u4ea4\u5de5\u4f5c\u4efb\u52a1wfCompleteJob(),\u63d0\u4ea4\u529e\u7406\u4eba\uff1a" + vo.getNextNodeUser() + ";\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return vo;
    }

    public List wfBatchCompleteJob(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        ArrayList<EVO> al = new ArrayList<EVO>();
        WfLog.log(0, "\u6279\u91cf\u63d0\u4ea4\u5de5\u4f5c\u4efb\u52a1wfBatchCompleteJob()");
        DbControl db = DbControl.getInstance();
        WfEngine we = WfEngine.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                }
                for (String InstanceID : vo.paramMap.keySet()) {
                    EVO obj = (EVO)vo.paramMap.get(InstanceID);
                    if (obj == null) continue;
                    InstanceID = obj.getInstanceID();
                    String CurrentUserID = obj.getCurrentUserID();
                    String NodeID = obj.getNodeID();
                    WfLog.log(0, "\u5904\u7406\u6279\u91cf\u63d0\u4ea4\u4efb\u52a1\uff0c\u5b9e\u4f8b\u53f7\uff1a" + InstanceID + ";\u8282\u70b9\u53f7\uff1a" + NodeID);
                    if (InstanceID == null || CurrentUserID == null || InstanceID.equals("") || CurrentUserID.equals("") || NodeID == null || NodeID.equals("")) {
                        obj.setSign(1);
                        obj.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
                    } else {
                        obj = we.wfCompleteJob(obj, cn);
                    }
                    al.add(obj);
                }
                if (vo.getUserObject() != null && vo.getUserObject() instanceof Vector) {
                    db.performBathSql((Vector)vo.getUserObject(), cn);
                }
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                WfLog.runtimeException(this, "wfBatchCompleteJob", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u6279\u91cf\u63d0\u4ea4\u5de5\u4f5c\u4efb\u52a1wfBatchCompleteJob(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return al;
    }

    public EVO wfCancelVirEnd(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        EVO obj = new EVO();
        String InstanceID = vo.getInstanceID();
        String CurrentUserID = vo.getCurrentUserID();
        WfLog.log(0, "\u53d6\u6d88\u529e\u7ed3wfCancelVirEnd(),InstanceID:" + InstanceID + ";CurrentUserID:" + CurrentUserID);
        if (InstanceID == null || CurrentUserID == null || InstanceID.equals("") || CurrentUserID.equals("")) {
            WfLog.paramException(this, "wfCancelVirEnd", vo);
            obj.setSign(1);
            obj.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u53d6\u6d88\u529e\u7ed3wfCancelVirEnd(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return obj;
        }
        DbControl db = DbControl.getInstance();
        WfTrack wt = WfTrack.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            if (vo.getConnection() != null) {
                cn = vo.getConnection();
                bClose = false;
            } else {
                cn = db.getConnection();
                vo.setConnection(cn);
            }
            String ifok = Permit.getInstance().ifCanCancelVirEnd(vo, cn);
            if (!ifok.equals("ok")) {
                obj.setSign(1);
                obj.setTip(ifok);
                WfLog.log(4, "\u6267\u884c\u53d6\u6d88\u529e\u7ed3\uff1a" + ifok);
                EVO eVO = obj;
                return eVO;
            }
            try {
                Vector vecData = new Vector();
                String SqlStr = "select a.IsWFSet,a.WFID,a.WFSign,a.WFName,a.WFAppID,a.FlowTrace,a.WFMainFormID,a.orgid,a.formdata,b.PreNodeName,b.PreNodeID,b.NodeID,b.NodeName,b.AllProcessor,b.IsLastUser,b.CurrentNodeUsers,b.CurrentNodeUser,b.CurrentNodeProcessors,b.NodeAcceptTime from wf_instance_whole_property a,wf_instance_node_property b where a.InstanceID=b.InstanceID and a.InstanceID='" + InstanceID + "'";
                vecData = db.performQuery(SqlStr, cn);
                Vector vecRow = (Vector)vecData.elementAt(0);
                String IsWFSet = (String)vecRow.elementAt(0);
                String wfid = (String)vecRow.elementAt(1);
                vo.setWFID(wfid);
                String WFSign = (String)vecRow.elementAt(2);
                vo.setWFName((String)vecRow.elementAt(3));
                String WFAppID = (String)vecRow.elementAt(4);
                String FlowTrace = ((String)vecRow.elementAt(5)).trim();
                String WFMainFormID = (String)vecRow.elementAt(6);
                String orgid = (String)vecRow.elementAt(7);
                vo.setOrgid(orgid);
                String formdata = (String)vecRow.elementAt(8);
                if (vo.paramMap == null || vo.paramMap.size() == 0) {
                    vo.paramMap = StringUtils.convertStrToHashMap(formdata);
                } else {
                    vo.paramMap.putAll(StringUtils.convertStrToHashMap(formdata));
                }
                String PreNodeID = null;
                PreNodeID = vo.getIsDraft() != null && vo.getIsDraft().equals("1") ? WfEngine.getFirstDocUNID(wfid) : (String)vecRow.elementAt(10);
                VO_wf_node_property wnp2 = WFCache.getInstance().getNodeProperty(PreNodeID);
                vo.setNextNodeID(PreNodeID);
                String NodeID = (String)vecRow.elementAt(11);
                vo.setNodeID(NodeID);
                VO_wf_node_property wnp = WFCache.getInstance().getNodeProperty(NodeID);
                vo.setNodeSign(wnp.NodeSign);
                String NodeName = (String)vecRow.elementAt(12);
                vo.setNodeName(NodeName);
                FlowTrace = String.valueOf(FlowTrace) + ";" + PreNodeID;
                obj.setNextNodeID(PreNodeID);
                obj.setNextNodeName(wnp2.NodeName);
                String AllProcessor = vecRow.elementAt(13) == null ? CurrentUserID : String.valueOf(((String)vecRow.elementAt(13)).trim()) + ";" + CurrentUserID;
                String CurrentNodeUsers = vecRow.elementAt(15) == null ? "" : ((String)vecRow.elementAt(15)).trim();
                String CurrentNodeUser = vecRow.elementAt(16) == null ? "" : ((String)vecRow.elementAt(16)).trim();
                String CurrentNodeProcessors = vecRow.elementAt(17) == null ? "" : ((String)vecRow.elementAt(17)).trim();
                String NodeAcceptTime = (String)vecRow.elementAt(18);
                Vector<Field> vecFields = new Vector<Field>();
                vecFields.addElement(new Field("FlowTrace", FlowTrace));
                vecFields.addElement(new Field("WFStatus", "0"));
                db.doUpdate("wf_instance_whole_property", vecFields, "InstanceID='" + InstanceID + "'", cn);
                SqlStr = "select NodeStartTime,CurrentNodeUsers,CurrentNodeUser,originalusers,NodeMulteit,NodeUserModifyType from wf_node_record where InstanceID='" + InstanceID + "' and NodeID='" + PreNodeID + "' order by NodeStartTime";
                vecData = db.performQuery(SqlStr, cn);
                vecRow = (Vector)vecData.lastElement();
                CurrentNodeUser = (String)vecRow.elementAt(2);
                if (CurrentNodeUser != null && CurrentNodeUser.endsWith(";")) {
                    CurrentNodeUser = CurrentNodeUser.substring(0, CurrentNodeUser.length() - 1);
                }
                obj.setNextNodeUser(CurrentNodeUser == null ? "" : CurrentNodeUser.trim());
                vo.setNextNodeUser(CurrentNodeUser == null ? "" : CurrentNodeUser.trim());
                if (vo.getNodeorgid() == null || vo.getNodeorgid().equals("")) {
                    if (CurrentNodeUser != null && CurrentNodeUser.split(";").length > 1) {
                        String[] tmpUsers = CurrentNodeUser.split(";");
                        vo.setNodeorgid(OrgFactory.getInstance().getOrgClass().getOrgIdByUser(tmpUsers[tmpUsers.length - 1].trim(), cn));
                    } else {
                        vo.setNodeorgid(OrgFactory.getInstance().getOrgClass().getOrgIdByUser(CurrentNodeUser.trim(), cn));
                    }
                }
                if (IsWFSet.equals("2") || IsWFSet.equals("5")) {
                    EVO votmp = new EVO();
                    votmp.setInstanceID(InstanceID);
                    votmp.setNodeID(NodeID);
                    votmp.setNodeName(NodeName);
                    votmp.setCurrentUserID(CurrentUserID);
                    votmp.setNextNodeUser(vecRow.elementAt(3) == null ? "" : ((String)vecRow.elementAt(3)).trim());
                    votmp.setNextNodeID(PreNodeID);
                    votmp.setNextNodeName(wnp2.NodeName);
                    votmp.setTip("\u6267\u884c\u53d6\u6d88\u529e\u7ed3\u64cd\u4f5c\uff01");
                    votmp.setNextNodeUser("-");
                    votmp.setOrgid(orgid);
                    votmp.setNodeAcceptTime(NodeAcceptTime);
                    wt.wfTrackNodeRecordEnd(votmp, true, cn);
                }
                vecFields = new Vector();
                vecFields.addElement(new Field("NodeID", PreNodeID));
                vecFields.addElement(new Field("NodeName", wnp2.NodeName));
                vecFields.addElement(new Field("NodeSign", wnp2.NodeSign));
                vecFields.addElement(new Field("PreNodeID", NodeID));
                vecFields.addElement(new Field("PreNodeName", NodeName));
                vecFields.addElement(new Field("AllProcessor", String.valueOf(StringUtils.delSameElement(AllProcessor, ";")) + ";"));
                vecFields.addElement(new Field("CurrentNodeUsers", vecRow.elementAt(1) == null ? "" : String.valueOf(((String)vecRow.elementAt(1)).trim()) + ";"));
                vecFields.addElement(new Field("CurrentNodeUser", CurrentNodeUser == null ? "" : String.valueOf(CurrentNodeUser.trim()) + ";"));
                vecFields.addElement(new Field("CurrentNodeProcessors", "-"));
                vecFields.addElement(new Field("originalusers", StringUtils.NullToEmpty((String)vecRow.elementAt(3))));
                vecFields.addElement(new Field("PreProcessorList", CurrentUserID));
                vecFields.addElement(new Field("NodeStatus", "9"));
                if (vecRow.elementAt(4).toString().equals("0")) {
                    vecFields.addElement(new Field("IsLastUser", "1"));
                }
                db.doUpdate("wf_instance_node_property", vecFields, "InstanceID='" + InstanceID + "'", cn);
                AppExtFactory.getInstance().getAppExtClass(wfid).afterCancelVirEnd(vo, null);
                obj.setTip("\u53d6\u6d88\u529e\u7ed3\u6210\u529f");
                obj.setSign(0);
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                obj.setSign(1);
                obj.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u63a7\u5236\u53f0\u5f02\u5e38\u4fe1\u606f\u5e76\u4e0e\u6d41\u7a0b\u7ba1\u7406\u5458\u53d6\u5f97\u8054\u7cfb\uff01");
                WfLog.runtimeException(this, "wfReturnBack", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u9000\u56dewfReturnBack(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return obj;
    }

    public EVO wfReturnBack(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        EVO obj = new EVO();
        String InstanceID = vo.getInstanceID();
        String CurrentUserID = vo.getCurrentUserID();
        WfLog.log(0, "\u9000\u56dewfReturnBack(),InstanceID:" + InstanceID + ";CurrentUserID:" + CurrentUserID);
        if (InstanceID == null || CurrentUserID == null || InstanceID.equals("") || CurrentUserID.equals("")) {
            WfLog.paramException(this, "wfReturnBack", vo);
            obj.setSign(1);
            obj.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u9000\u56dewfReturnBack(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return obj;
        }
        DbControl db = DbControl.getInstance();
        WfTrack wt = WfTrack.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                    vo.setConnection(cn);
                }
                String ifok = Permit.getInstance().ifCanReturnBack(vo, cn);
                if (!ifok.equals("ok")) {
                    obj.setSign(1);
                    obj.setTip(ifok);
                    WfLog.log(4, "\u6267\u884c\u9000\u56de\u5f02\u5e38\uff1a" + ifok);
                } else {
                    EVO votmp;
                    if (vo.getCommentVO() != null && vo.getCommentVO().getCommentContent() != null) {
                        WfEngine.getInstance().setComment(vo.getCommentVO(), cn);
                    }
                    Vector vecData = new Vector();
                    String SqlStr = "select a.IsWFSet,a.WFID,a.WFSign,a.WFName,a.WFAppID,a.FlowTrace,a.WFMainFormID,a.orgid,a.formdata,b.PreNodeName,b.PreNodeID,b.NodeID,b.NodeName,b.AllProcessor,b.IsLastUser,b.CurrentNodeUsers,b.CurrentNodeUser,b.CurrentNodeProcessors,b.NodeAcceptTime,b.PreProcessorList from wf_instance_whole_property a,wf_instance_node_property b where a.InstanceID=b.InstanceID and a.InstanceID='" + InstanceID + "'";
                    vecData = db.performQuery(SqlStr, cn);
                    Vector vecRow = (Vector)vecData.elementAt(0);
                    String IsWFSet = (String)vecRow.elementAt(0);
                    String wfid = (String)vecRow.elementAt(1);
                    vo.setWFID(wfid);
                    String WFSign = (String)vecRow.elementAt(2);
                    vo.setWFName((String)vecRow.elementAt(3));
                    String WFAppID = (String)vecRow.elementAt(4);
                    String FlowTrace = ((String)vecRow.elementAt(5)).trim();
                    String WFMainFormID = (String)vecRow.elementAt(6);
                    String orgid = (String)vecRow.elementAt(7);
                    vo.setOrgid(orgid);
                    String formdata = (String)vecRow.elementAt(8);
                    if (vo.paramMap == null || vo.paramMap.size() == 0) {
                        vo.paramMap = StringUtils.convertStrToHashMap(formdata);
                    } else {
                        vo.paramMap.putAll(StringUtils.convertStrToHashMap(formdata));
                    }
                    String PreNodeID = null;
                    String PreNodeName = null;
                    if (vo.getIsDraft() != null && vo.getIsDraft().equals("1")) {
                        PreNodeID = WfEngine.getFirstDocUNID(wfid);
                    } else {
                        PreNodeName = (String)vecRow.elementAt(9);
                        PreNodeID = (String)vecRow.elementAt(10);
                    }
                    VO_wf_node_property wnp2 = WFCache.getInstance().getNodeProperty(PreNodeID);
                    vo.setNextNodeID(PreNodeID);
                    String NodeID = (String)vecRow.elementAt(11);
                    vo.setNodeID(NodeID);
                    VO_wf_node_property wnp = WFCache.getInstance().getNodeProperty(NodeID);
                    vo.setNodeSign(wnp.NodeSign);
                    String NodeName = (String)vecRow.elementAt(12);
                    vo.setNodeName(NodeName);
                    if (PreNodeName == null) {
                        vo.setNextNodeName(wnp2.NodeName);
                    } else {
                        vo.setNextNodeName(PreNodeName);
                    }
                    FlowTrace = String.valueOf(FlowTrace) + ";" + PreNodeID;
                    obj.setNextNodeID(PreNodeID);
                    obj.setNextNodeName(wnp2.NodeName);
                    String AllProcessor = vecRow.elementAt(13) == null ? CurrentUserID : String.valueOf(((String)vecRow.elementAt(13)).trim()) + ";" + CurrentUserID;
                    String CurrentNodeUsers = vecRow.elementAt(15) == null ? "" : ((String)vecRow.elementAt(15)).trim();
                    String CurrentNodeUser = vecRow.elementAt(16) == null ? "" : ((String)vecRow.elementAt(16)).trim();
                    String CurrentNodeProcessors = vecRow.elementAt(17) == null ? "" : ((String)vecRow.elementAt(17)).trim();
                    String NodeAcceptTime = (String)vecRow.elementAt(18);
                    String PreProcessorList = (String)vecRow.elementAt(19);
                    if (vecRow.elementAt(14).toString().equals("1")) {
                        Vector<Field> vecFields = new Vector<Field>();
                        vecFields.addElement(new Field("FlowTrace", FlowTrace));
                        db.doUpdate("wf_instance_whole_property", vecFields, "InstanceID='" + InstanceID + "'", cn);
                        SqlStr = "select NodeStartTime,CurrentNodeUsers,CurrentNodeUser,originalusers,NodeMulteit,NodeUserModifyType,roleid from wf_node_record where InstanceID='" + InstanceID + "' and NodeID='" + PreNodeID + "' order by NodeStartTime";
                        vecData = db.performQuery(SqlStr, cn);
                        vecRow = (Vector)vecData.lastElement();
                        if (PreNodeID.equals(NodeID)) {
                            CurrentNodeUsers = CurrentNodeUser = String.valueOf(PreProcessorList) + ";";
                        } else {
                            CurrentNodeUser = (String)vecRow.elementAt(1);
                            String string = CurrentNodeUsers = vecRow.elementAt(1) == null ? "" : String.valueOf(((String)vecRow.elementAt(1)).trim()) + ";";
                        }
                        if (CurrentNodeUser != null && CurrentNodeUser.endsWith(";")) {
                            CurrentNodeUser = CurrentNodeUser.substring(0, CurrentNodeUser.length() - 1);
                        }
                        obj.setNextNodeUser(CurrentNodeUser == null ? "" : CurrentNodeUser.trim());
                        vo.setNextNodeUser(CurrentNodeUser == null ? "" : CurrentNodeUser.trim());
                        if (vo.getNodeorgid() == null || vo.getNodeorgid().equals("")) {
                            if (CurrentNodeUser != null && CurrentNodeUser.split(";").length > 1) {
                                String[] tmpUsers = CurrentNodeUser.split(";");
                                vo.setNodeorgid(OrgFactory.getInstance().getOrgClass().getOrgIdByUser(tmpUsers[tmpUsers.length - 1].trim(), cn));
                            } else {
                                vo.setNodeorgid(OrgFactory.getInstance().getOrgClass().getOrgIdByUser(CurrentNodeUser.trim(), cn));
                            }
                        }
                        if (IsWFSet.equals("2") || IsWFSet.equals("5")) {
                            votmp = new EVO();
                            votmp.setInstanceID(InstanceID);
                            votmp.setNodeID(NodeID);
                            votmp.setNodeName(NodeName);
                            votmp.setCurrentUserID(CurrentUserID);
                            votmp.setNextNodeUser(CurrentNodeUser);
                            votmp.setNextNodeID(PreNodeID);
                            votmp.setRoleid(vecRow.elementAt(6) == null ? "" : ((String)vecRow.elementAt(6)).trim());
                            votmp.setNextNodeName(wnp2.NodeName);
                            votmp.setTip("\u6267\u884c\u9000\u56de\u64cd\u4f5c\uff01");
                            votmp.setOrgid(orgid);
                            votmp.setNodeAcceptTime(NodeAcceptTime);
                            wt.wfTrackNodeRecordEnd(votmp, true, cn);
                        }
                        vecFields = new Vector();
                        vecFields.addElement(new Field("NodeID", PreNodeID));
                        vecFields.addElement(new Field("NodeName", wnp2.NodeName));
                        vecFields.addElement(new Field("NodeSign", wnp2.NodeSign));
                        vecFields.addElement(new Field("PreNodeID", NodeID));
                        vecFields.addElement(new Field("PreNodeName", NodeName));
                        vecFields.addElement(new Field("AllProcessor", String.valueOf(StringUtils.delSameElement(AllProcessor, ";")) + ";"));
                        vecFields.addElement(new Field("CurrentNodeUsers", CurrentNodeUsers == null ? "" : String.valueOf(CurrentNodeUsers.trim()) + ";"));
                        vecFields.addElement(new Field("CurrentNodeUser", CurrentNodeUser == null ? "" : String.valueOf(CurrentNodeUser.trim()) + ";"));
                        vecFields.addElement(new Field("CurrentNodeProcessors", "-"));
                        vecFields.addElement(new Field("originalusers", StringUtils.NullToEmpty((String)vecRow.elementAt(3))));
                        vecFields.addElement(new Field("PreProcessorList", CurrentUserID));
                        if (vecRow.elementAt(4).toString().equals("0")) {
                            vecFields.addElement(new Field("IsLastUser", "1"));
                        } else {
                            vecFields.addElement(new Field("IsLastUser", "0"));
                        }
                        vecFields.addElement(new Field("IsProcessed", "1"));
                        String NodeActionList = "";
                        Iterator it = wnp2.hmNodeFieldProperty.keySet().iterator();
                        String key = "";
                        while (it.hasNext()) {
                            key = (String)it.next();
                            VO_wf_node_field_property wnfp = (VO_wf_node_field_property)wnp2.hmNodeFieldProperty.get(key);
                            if (!wnfp.FieldControlType.equals("A")) continue;
                            NodeActionList = String.valueOf(NodeActionList) + ";" + wnfp.FieldCode;
                        }
                        if (NodeActionList.length() > 0) {
                            NodeActionList = NodeActionList.substring(1, NodeActionList.length());
                        }
                        String NodeUserModifyType = wnp2.NodeEditControl;
                        vecFields.addElement(new Field("NodeStatus", "5"));
                        vecFields.addElement(new Field("NodeActionList", NodeActionList));
                        vecFields.addElement(new Field("NodeRequest", "0"));
                        vecFields.addElement(new Field("NodeUserModifyType", NodeUserModifyType));
                        vecFields.addElement(new Field("errtxt", "\u5f53\u524d\u8282\u70b9\u88ab\u9000\u56de\u91cd\u65b0\u529e\u7406"));
                        vecFields.addElement(new Field("NodeChangeSet", "0"));
                        vecFields.addElement(new Field("NodeRecallSet", "0"));
                        vecFields.addElement(new Field("NodeReturnBackSet", "0"));
                        vecFields.addElement(new Field("NodeUrgeSet", "0"));
                        String NodePlanEndTime = "";
                        String nowtime = DatetimeUtils.getNowDateTimeString();
                        if (wnp2.NodeTimelimitNotification != null && wnp2.NodeTimelimitNotification.equals("1")) {
                            String NodeDurationTime = "";
                            NodeDurationTime = wnp2.NodeDurationTime == null || wnp2.NodeDurationTime.equals("") ? "D3" : wnp2.NodeDurationTime;
                            NodePlanEndTime = DatetimeUtils.convertDateTimeString(nowtime, NodeDurationTime, "after");
                        } else {
                            NodePlanEndTime = DatetimeUtils.convertDateTimeString(nowtime, "D3", "after");
                        }
                        vecFields.addElement(new Field("NodePlanEndTime", NodePlanEndTime));
                        vecFields.addElement(new Field("NodeStartTime", nowtime));
                        vecFields.addElement(new Field("NodeAcceptTime", "-"));
                        String NodeFormID = wnp2.NodeFormID;
                        if (NodeFormID == null || NodeFormID.equals("")) {
                            NodeFormID = WFMainFormID;
                        }
                        vecFields.addElement(new Field("WFNodeFormID", NodeFormID));
                        if (IsWFSet.equals("2") || IsWFSet.equals("5")) {
                            HashMap<String, String> hmParam = new HashMap<String, String>();
                            hmParam.put("NodeName", wnp2.NodeName);
                            hmParam.put("NodeID", PreNodeID);
                            hmParam.put("errtxt", "\u5f53\u524d\u8282\u70b9\u88ab\u9000\u56de\u91cd\u65b0\u529e\u7406");
                            hmParam.put("NodeStatus", "5");
                            hmParam.put("PreNodeName", wnp2.NodeName);
                            hmParam.put("NodeUserModifyType", NodeUserModifyType);
                            hmParam.put("NodePlanEndTime", DatetimeUtils.getNowDateTimeString());
                            hmParam.put("CurrentNodeUsers", obj.getNextNodeUser());
                            hmParam.put("CurrentNodeUser", obj.getNextNodeUser());
                            hmParam.put("originalusers", obj.getOriginalUser());
                            hmParam.put("PreProcessorList", vo.getCurrentUserID());
                            hmParam.put("IsLastUser", "1");
                            hmParam.put("WFID", vo.getWFID());
                            hmParam.put("WFName", vo.getWFName());
                            hmParam.put("FlowTrace", FlowTrace);
                            hmParam.put("nodeorgid", vo.getNodeorgid());
                            HashMap hm = wt.wfTrackNextNodeRecordInitialize(InstanceID, PreNodeID, hmParam, cn);
                            String NodeNumber = (String)hm.get("NodeNumber");
                            vecFields.addElement(new Field("NodeNumber", NodeNumber));
                        }
                        if (vo.getNodeorgid() != null && vo.getNodeorgid().length() > 0) {
                            vecFields.addElement(new Field("nodeorgid", vo.getNodeorgid()));
                        }
                        db.doUpdate("wf_instance_node_property", vecFields, "InstanceID='" + InstanceID + "'", cn);
                    } else {
                        CurrentNodeProcessors = CurrentNodeProcessors == null || CurrentNodeProcessors.equals("") ? CurrentUserID : String.valueOf(CurrentNodeProcessors) + ";" + CurrentUserID;
                        CurrentNodeUsers = StringUtils.delSubStr(CurrentNodeUsers, CurrentUserID, ";");
                        Vector<Field> vecFields = new Vector<Field>();
                        CurrentNodeUser = wnp.NodeTransactType.equals("2") || wnp.NodeTransactType.equals("5") ? StringUtils.getFirstElement(CurrentNodeUsers, ";") : StringUtils.delSubStr(CurrentNodeUser, CurrentUserID, ";");
                        obj.setNextNodeUser(CurrentNodeUser);
                        vo.setNextNodeUser(CurrentNodeUser);
                        AllProcessor = String.valueOf(StringUtils.delSameElement(AllProcessor, ";")) + ";";
                        vecFields.addElement(new Field("AllProcessor", AllProcessor));
                        vecFields.addElement(new Field("CurrentNodeUsers", CurrentNodeUsers));
                        vecFields.addElement(new Field("CurrentNodeUser", String.valueOf(CurrentNodeUser) + ";"));
                        vecFields.addElement(new Field("CurrentNodeProcessors", CurrentNodeProcessors));
                        vecFields.addElement(new Field("IsProcessed", "1"));
                        if (StringUtils.getElementsNUM(CurrentNodeUsers, ";") > 1) {
                            vecFields.addElement(new Field("IsLastUser", "0"));
                        } else {
                            vecFields.addElement(new Field("IsLastUser", "1"));
                        }
                        db.doUpdate("wf_instance_node_property", vecFields, "InstanceID='" + InstanceID + "'", cn);
                        if (IsWFSet.equals("2") || IsWFSet.equals("5")) {
                            votmp = new EVO();
                            votmp.setInstanceID(InstanceID);
                            votmp.setNodeID(NodeID);
                            votmp.setNodeName(NodeName);
                            votmp.setCurrentUserID(CurrentUserID);
                            votmp.setNextNodeUser(CurrentNodeUser);
                            votmp.setTip("\u6267\u884c\u9000\u56de\u64cd\u4f5c\uff01");
                            votmp.setOrgid(orgid);
                            String roleList = "";
                            String roleNameList = "";
                            Map roleMap = this.getRoleByUserNode(InstanceID, PreNodeID, CurrentNodeUser, cn);
                            for (String roleID : roleMap.keySet()) {
                                String roleName = (String)roleMap.get(roleID);
                                roleList = String.valueOf(roleList) + roleID + ";";
                                roleNameList = String.valueOf(roleNameList) + roleName + ";";
                            }
                            votmp.setRoleid(roleList);
                            votmp.setRoleName(roleNameList);
                            wt.wfTrackUpdateNodeReord(votmp, cn);
                        }
                    }
                    OrgClass orgclass = OrgClass.getInstance();
                    obj.setNextNodeUser(orgclass.getUserNameByUserID(obj.getNextNodeUser(), cn));
                    WfEngine.getInstance().executeFlowAppExt("txtExtreturnback", vo, cn);
                    HashMap<String, String> hmExt = new HashMap<String, String>();
                    hmExt.put("CurrentNodeUser", String.valueOf(CurrentNodeUser) + ";");
                    hmExt.put("AllProcessor", AllProcessor);
                    AppExtFactory.getInstance().getAppExtClass(wfid).afterReturnBack(vo, hmExt);
                    obj.setSign(0);
                    obj.setTip("\u9000\u56de\u5904\u7406\u6210\u529f\uff0c\u6587\u6863\u5df2\u7ecf\u9000\u56de\u5230\u4e0a\u4e00\u73af\u8282\u91cd\u65b0\u529e\u7406\uff01");
                    obj.setWFSign(WFSign);
                    WfLog.log(2, "\u6267\u884c\u9000\u56de\u64cd\u4f5c,\u8c03\u7528\u65b9\u6cd5wfReturnBack(),\u5f53\u524d\u7528\u6237\uff1a" + CurrentUserID + ",\u5b9e\u4f8b\u53f7\uff1a" + InstanceID + ",\u6240\u5c5e\u5e94\u7528\uff1a" + WFAppID);
                }
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                obj.setSign(1);
                obj.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u63a7\u5236\u53f0\u5f02\u5e38\u4fe1\u606f\u5e76\u4e0e\u6d41\u7a0b\u7ba1\u7406\u5458\u53d6\u5f97\u8054\u7cfb\uff01");
                WfLog.runtimeException(this, "wfReturnBack", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u9000\u56dewfReturnBack(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return obj;
    }

    public EVO wfCallBack(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        EVO obj = new EVO();
        String InstanceID = vo.getInstanceID();
        String CurrentUserID = vo.getCurrentUserID();
        String NodeID = vo.getNodeID();
        String NextNodeID = vo.getNextNodeID();
        String NextNodeUser = vo.getNextNodeUser();
        String orgid = vo.getOrgid();
        WfLog.log(0, "\u6253\u56dewfCallBack(),InstanceID:" + InstanceID + ";NodeID:" + NodeID + ";CurrentUserID:" + CurrentUserID + ";NextNodeID:" + NextNodeID + ";NextNodeUser:" + NextNodeUser);
        if (InstanceID == null || CurrentUserID == null || InstanceID.equals("") || CurrentUserID.equals("") || NodeID == null || NodeID.equals("") || NextNodeID == null || NextNodeID.equals("") || NextNodeUser == null || NextNodeUser.equals("")) {
            WfLog.paramException(this, "wfCallBack", vo);
            obj.setSign(1);
            obj.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u6253\u56dewfCallBack(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return obj;
        }
        if (NextNodeUser.startsWith("U.")) {
            NextNodeUser = NextNodeUser.substring(2);
        }
        DbControl db = DbControl.getInstance();
        WfTrack wt = WfTrack.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                    vo.setConnection(cn);
                }
                String ifok = Permit.getInstance().ifCanCallBack(vo, cn);
                if (!ifok.equals("ok")) {
                    obj.setSign(1);
                    obj.setTip(ifok);
                    WfLog.log(4, "\u6267\u884c\u6253\u56de\u5f02\u5e38\uff1a" + ifok);
                } else {
                    WfLog.log(0, "\u6253\u56de\u6a21\u5f0f\uff1a" + vo.getCallBackModel());
                    if (vo.getCommentVO() != null && vo.getCommentVO().getCommentContent() != null) {
                        WfEngine.getInstance().setComment(vo.getCommentVO(), cn);
                    }
                    String SqlStr = "select a.WFID,a.FlowTrace,a.WFMainFormID,a.orgid,a.formdata,b.AllProcessor,b.NodeAcceptTime from wf_instance_whole_property a,wf_instance_node_property b where a.InstanceID=b.InstanceID and a.InstanceID='" + InstanceID + "'";
                    Vector vecData = db.performQuery(SqlStr, cn);
                    Vector vecRow = (Vector)vecData.elementAt(0);
                    String wfid = (String)vecRow.elementAt(0);
                    String FlowTrace = ((String)vecRow.elementAt(1)).trim();
                    String WFMainFormID = (String)vecRow.elementAt(2);
                    orgid = (String)vecRow.elementAt(3);
                    vo.setOrgid(orgid);
                    String formdata = (String)vecRow.elementAt(4);
                    if (vo.paramMap == null || vo.paramMap.size() == 0) {
                        vo.paramMap = StringUtils.convertStrToHashMap(formdata);
                    } else {
                        vo.paramMap.putAll(StringUtils.convertStrToHashMap(formdata));
                    }
                    FlowTrace = String.valueOf(FlowTrace) + ";" + NextNodeID;
                    VO_wf_node_property wnp = WFCache.getInstance().getNodeProperty(NodeID);
                    VO_wf_node_property wnp2 = WFCache.getInstance().getNodeProperty(NextNodeID);
                    vo.setNodeSign(wnp.NodeSign);
                    vo.setNextNodeName(wnp2.NodeName);
                    if (vo.getNodeorgid() == null || vo.getNodeorgid().equals("")) {
                        if (NextNodeUser != null && NextNodeUser.split(";").length > 1) {
                            String[] tmpUsers = NextNodeUser.split(";");
                            vo.setNodeorgid(OrgFactory.getInstance().getOrgClass().getOrgIdByUser(tmpUsers[tmpUsers.length - 1].trim(), cn));
                        } else {
                            vo.setNodeorgid(OrgFactory.getInstance().getOrgClass().getOrgIdByUser(NextNodeUser.trim(), cn));
                        }
                    }
                    EVO votmp = new EVO();
                    votmp.setInstanceID(InstanceID);
                    votmp.setNodeID(NodeID);
                    votmp.setNodeName(wnp.NodeName);
                    votmp.setCurrentUserID(CurrentUserID);
                    votmp.setNextNodeUser(NextNodeUser);
                    votmp.setNextNodeID(NextNodeID);
                    votmp.setNextNodeName(wnp2.NodeName);
                    votmp.setTip("\u6267\u884c\u9000\u56de\u4efb\u4e00\u7ea7\u64cd\u4f5c\uff01");
                    votmp.setOrgid(orgid);
                    votmp.setNodeAcceptTime((String)vecRow.elementAt(6));
                    String roleList = "";
                    String roleNameList = "";
                    Map roleMap = this.getRoleByUserNode(InstanceID, NextNodeID, NextNodeUser, cn);
                    for (String roleID : roleMap.keySet()) {
                        String roleName = (String)roleMap.get(roleID);
                        roleList = String.valueOf(roleList) + roleID + ";";
                        roleNameList = String.valueOf(roleNameList) + roleName + ";";
                    }
                    votmp.setRoleid(roleList);
                    votmp.setRoleName(roleNameList);
                    wt.wfTrackNodeRecordEnd(votmp, true, cn);
                    String AllProcessor = vecRow.elementAt(5) == null ? CurrentUserID : String.valueOf(((String)vecRow.elementAt(5)).trim()) + ";" + CurrentUserID;
                    Vector<Field> vecFields = new Vector<Field>();
                    vecFields.addElement(new Field("PreNodeID", NodeID));
                    vecFields.addElement(new Field("PreNodeName", wnp.NodeName));
                    vecFields.addElement(new Field("NodeID", NextNodeID));
                    vecFields.addElement(new Field("NodeName", wnp2.NodeName));
                    vecFields.addElement(new Field("NodeSign", wnp2.NodeSign));
                    AllProcessor = String.valueOf(StringUtils.delSameElement(AllProcessor, ";")) + ";";
                    vecFields.addElement(new Field("AllProcessor", AllProcessor));
                    vecFields.addElement(new Field("CurrentNodeUsers", String.valueOf(NextNodeUser) + ";"));
                    vecFields.addElement(new Field("CurrentNodeUser", String.valueOf(NextNodeUser) + ";"));
                    vecFields.addElement(new Field("CurrentNodeProcessors", "-"));
                    vecFields.addElement(new Field("PreProcessorList", CurrentUserID));
                    vecFields.addElement(new Field("IsLastUser", "1"));
                    vecFields.addElement(new Field("IsProcessed", "1"));
                    String callBackModel = vo.getCallBackModel();
                    if (callBackModel != null && callBackModel.equals("0")) {
                        vecFields.addElement(new Field("NextNodeID", NodeID));
                        vecFields.addElement(new Field("NextNodeName", wnp.NodeName));
                        vecFields.addElement(new Field("NextNodeUser", CurrentUserID));
                    }
                    String NodeActionList = "";
                    Iterator it = wnp2.hmNodeFieldProperty.keySet().iterator();
                    String key = "";
                    while (it.hasNext()) {
                        key = (String)it.next();
                        VO_wf_node_field_property wnfp = (VO_wf_node_field_property)wnp2.hmNodeFieldProperty.get(key);
                        if (!wnfp.FieldControlType.equals("A")) continue;
                        NodeActionList = String.valueOf(NodeActionList) + ";" + wnfp.FieldCode;
                    }
                    if (NodeActionList.length() > 0) {
                        NodeActionList = NodeActionList.substring(1, NodeActionList.length());
                    }
                    String NodeUserModifyType = wnp2.NodeEditControl;
                    vecFields.addElement(new Field("NodeStatus", "7"));
                    vecFields.addElement(new Field("NodeActionList", NodeActionList));
                    vecFields.addElement(new Field("NodeRequest", "0"));
                    vecFields.addElement(new Field("NodeUserModifyType", NodeUserModifyType));
                    vecFields.addElement(new Field("errtxt", "\u5f53\u524d\u8282\u70b9\u88ab\u9000\u56de\u4efb\u4e00\u7ea7\u91cd\u65b0\u529e\u7406"));
                    if (callBackModel != null && callBackModel.equals("0")) {
                        vecFields.addElement(new Field("NodeRecallSet", "0"));
                        vecFields.addElement(new Field("NodeReturnBackSet", "0"));
                    }
                    vecFields.addElement(new Field("NodeChangeSet", "0"));
                    vecFields.addElement(new Field("NodeUrgeSet", "0"));
                    String NodePlanEndTime = "";
                    String nowtime = DatetimeUtils.getNowDateTimeString();
                    if (wnp2.NodeTimelimitNotification != null && wnp2.NodeTimelimitNotification.equals("1")) {
                        String NodeDurationTime = "";
                        NodeDurationTime = wnp2.NodeDurationTime == null || wnp2.NodeDurationTime.equals("") ? "D3" : wnp2.NodeDurationTime;
                        NodePlanEndTime = DatetimeUtils.convertDateTimeString(nowtime, NodeDurationTime, "after");
                    } else {
                        NodePlanEndTime = DatetimeUtils.convertDateTimeString(nowtime, "D3", "after");
                    }
                    vecFields.addElement(new Field("NodePlanEndTime", NodePlanEndTime));
                    vecFields.addElement(new Field("NodeStartTime", nowtime));
                    vecFields.addElement(new Field("NodeAcceptTime", "-"));
                    String NodeFormID = wnp2.NodeFormID;
                    if (NodeFormID == null || NodeFormID.equals("")) {
                        NodeFormID = WFMainFormID;
                    }
                    vecFields.addElement(new Field("WFNodeFormID", NodeFormID));
                    HashMap<String, String> hmParam = new HashMap<String, String>();
                    hmParam.put("NodeName", wnp2.NodeName);
                    hmParam.put("NodeID", NextNodeID);
                    hmParam.put("errtxt", "\u5f53\u524d\u8282\u70b9\u88ab\u9000\u56de\u4efb\u4e00\u7ea7\u91cd\u65b0\u529e\u7406");
                    hmParam.put("NodeStatus", "7");
                    hmParam.put("PreNodeID", NodeID);
                    hmParam.put("PreNodeName", wnp.NodeName);
                    hmParam.put("NodeUserModifyType", NodeUserModifyType);
                    hmParam.put("NodePlanEndTime", DatetimeUtils.getNowDateTimeString());
                    hmParam.put("CurrentNodeUsers", NextNodeUser);
                    hmParam.put("CurrentNodeUser", NextNodeUser);
                    hmParam.put("originalusers", NextNodeUser);
                    hmParam.put("PreProcessorList", CurrentUserID);
                    hmParam.put("IsLastUser", "1");
                    hmParam.put("WFID", wnp.WFID);
                    hmParam.put("WFName", wnp.WFName);
                    hmParam.put("FlowTrace", FlowTrace);
                    hmParam.put("nodeorgid", vo.getNodeorgid());
                    HashMap hm = wt.wfTrackNextNodeRecordInitialize(InstanceID, NextNodeID, hmParam, cn);
                    String NodeNumber = (String)hm.get("NodeNumber");
                    vecFields.addElement(new Field("NodeNumber", NodeNumber));
                    if (vo.getNodeorgid() != null && vo.getNodeorgid().length() > 0) {
                        vecFields.addElement(new Field("nodeorgid", vo.getNodeorgid()));
                    }
                    db.doUpdate("wf_instance_node_property", vecFields, "InstanceID='" + InstanceID + "' and NodeID='" + NodeID + "'", cn);
                    obj.setNextNodeID(NextNodeID);
                    obj.setNextNodeName(wnp2.NodeName);
                    obj.setNextNodeUser(NextNodeUser);
                    WfEngine.getInstance().executeFlowAppExt("txtExtcallback", vo, cn);
                    HashMap<String, String> hmExt = new HashMap<String, String>();
                    hmExt.put("CurrentNodeUser", String.valueOf(NextNodeUser) + ";");
                    hmExt.put("AllProcessor", AllProcessor);
                    AppExtFactory.getInstance().getAppExtClass(wfid).afterCallBack(vo, hmExt);
                    obj.setSign(0);
                    obj.setTip("\u6267\u884c\u6d41\u7a0b\u6253\u56de\u64cd\u4f5c\u6210\u529f!");
                    WfLog.log(2, "\u6267\u884c\u6253\u56de\u64cd\u4f5c,\u8c03\u7528\u65b9\u6cd5wfCallBack(),\u5f53\u524d\u7528\u6237\uff1a" + CurrentUserID + ",\u5b9e\u4f8b\u53f7\uff1a" + InstanceID);
                }
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                obj.setSign(1);
                obj.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u63a7\u5236\u53f0\u5f02\u5e38\u4fe1\u606f\u5e76\u4e0e\u6d41\u7a0b\u7ba1\u7406\u5458\u53d6\u5f97\u8054\u7cfb\uff01");
                WfLog.runtimeException(this, "wfCallBack", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u6253\u56dewfCallBack(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return obj;
    }

    public EVO wfAssist(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        EVO obj = new EVO();
        String InstanceID = vo.getInstanceID();
        String CurrentUserID = vo.getCurrentUserID();
        String NodeID = vo.getNodeID();
        String NextNodeUser = vo.getNextNodeUser();
        String orgid = vo.getOrgid();
        WfLog.log(0, "\u534f\u52a9\u529e\u7406wfAssist(),InstanceID:" + InstanceID + ";NodeID:" + NodeID + ";CurrentUserID:" + CurrentUserID + ";NextNodeUser:" + NextNodeUser);
        if (InstanceID == null || CurrentUserID == null || InstanceID.equals("") || CurrentUserID.equals("") || NodeID == null || NodeID.equals("") || NextNodeUser == null || NextNodeUser.equals("")) {
            WfLog.paramException(this, "wfCallBack", vo);
            obj.setSign(1);
            obj.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u534f\u52a9\u529e\u7406wfAssist(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return obj;
        }
        if (NextNodeUser.startsWith("U.")) {
            NextNodeUser = NextNodeUser.substring(2);
        }
        DbControl db = DbControl.getInstance();
        WfTrack wt = WfTrack.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                    vo.setConnection(cn);
                }
                String ifok = Permit.getInstance().ifCanAssist(vo, cn);
                if (!ifok.equals("ok")) {
                    obj.setSign(1);
                    obj.setTip(ifok);
                    WfLog.log(4, "\u6267\u884c\u534f\u52a9\u529e\u7406wfAssist\u5f02\u5e38\uff1a" + ifok);
                } else {
                    String SqlStr = "select prenodeid, nodeid from  wf_instance_node_property where instanceid='" + InstanceID + "' ";
                    Vector vect = db.performQuery(SqlStr, vo.getConnection());
                    String preNodeId = "";
                    if (vect != null && vect.size() > 0) {
                        preNodeId = (String)((Vector)vect.get(0)).get(0);
                    }
                    if (vo.getCommentVO() != null && vo.getCommentVO().getCommentContent() != null) {
                        WfEngine.getInstance().setComment(vo.getCommentVO(), cn);
                    }
                    VO_wf_node_property wnp = WFCache.getInstance().getNodeProperty(NodeID);
                    vo.setNodeSign(wnp.NodeSign);
                    VO_wf_node_property preWnp = WFCache.getInstance().getNodeProperty(preNodeId);
                    EVO votmp = new EVO();
                    votmp.setInstanceID(InstanceID);
                    votmp.setNodeID(NodeID);
                    votmp.setNodeName(wnp.NodeName);
                    votmp.setCurrentUserID(CurrentUserID);
                    votmp.setNextNodeUser(NextNodeUser);
                    votmp.setNextNodeID(NodeID);
                    votmp.setNextNodeName("[\u534f\u52a9\u529e\u7406]");
                    votmp.setTip("\u6267\u884c\u534f\u52a9\u529e\u7406\u64cd\u4f5c\uff01");
                    votmp.setOrgid(orgid);
                    wt.wfTrackNodeRecordEnd(votmp, true, cn);
                    String strSql = "select AllProcessor from  wf_worklist where instanceid='" + vo.getInstanceID() + "'";
                    vect = db.performQuery(strSql, vo.getConnection());
                    String AllProcessor = "";
                    if (vect != null && vect.size() > 0) {
                        AllProcessor = (String)((Vector)vect.get(0)).get(0);
                    }
                    Vector<Field> vecFields = new Vector<Field>();
                    vecFields.addElement(new Field("PreNodeID", NodeID));
                    vecFields.addElement(new Field("PreNodeName", wnp.NodeName));
                    vecFields.addElement(new Field("NodeID", NodeID));
                    vecFields.addElement(new Field("NodeName", "[\u534f\u52a9\u529e\u7406]"));
                    vecFields.addElement(new Field("NodeSign", wnp.NodeSign));
                    vecFields.addElement(new Field("CurrentNodeUsers", String.valueOf(NextNodeUser) + ";"));
                    vecFields.addElement(new Field("CurrentNodeUser", String.valueOf(NextNodeUser) + ";"));
                    vecFields.addElement(new Field("CurrentNodeProcessors", "-"));
                    vecFields.addElement(new Field("PreProcessorList", CurrentUserID));
                    vecFields.addElement(new Field("AllProcessor", String.valueOf(AllProcessor) + ";" + CurrentUserID));
                    vecFields.addElement(new Field("IsLastUser", "1"));
                    vecFields.addElement(new Field("IsProcessed", "1"));
                    vecFields.addElement(new Field("NextNodeID", NodeID));
                    vecFields.addElement(new Field("NodeStatus", "8"));
                    vecFields.addElement(new Field("NextNodeName", wnp.NodeName));
                    vecFields.addElement(new Field("NextNodeUser", CurrentUserID));
                    vecFields.addElement(new Field("NodeRequest", "0"));
                    vecFields.addElement(new Field("errtxt", "\u5f53\u524d\u8282\u70b9\u63d0\u4ea4\u8bf7\u6c42\u534f\u52a9\u529e\u7406"));
                    vecFields.addElement(new Field("NodeRecallSet", "0"));
                    vecFields.addElement(new Field("NodeChangeSet", "0"));
                    vecFields.addElement(new Field("NodeReturnBackSet", "0"));
                    vecFields.addElement(new Field("NodeUrgeSet", "0"));
                    vecFields.addElement(new Field("NodeUseSubWF", "0"));
                    String nowtime = DatetimeUtils.getNowDateTimeString();
                    vecFields.addElement(new Field("NodeStartTime", nowtime));
                    vecFields.addElement(new Field("NodeAcceptTime", "-"));
                    HashMap<String, String> hmParam = new HashMap<String, String>();
                    hmParam.put("NodeName", wnp.NodeName);
                    hmParam.put("NodeID", NodeID);
                    hmParam.put("errtxt", "\u5f53\u524d\u8282\u70b9\u63d0\u4ea4\u8bf7\u6c42\u534f\u52a9\u529e\u7406");
                    hmParam.put("NodeStatus", "8");
                    hmParam.put("PreNodeID", NodeID);
                    hmParam.put("PreNodeName", wnp.NodeName);
                    hmParam.put("NodeUserModifyType", wnp.NodeEditControl);
                    hmParam.put("NodePlanEndTime", DatetimeUtils.getNowDateTimeString());
                    hmParam.put("CurrentNodeUsers", NextNodeUser);
                    hmParam.put("CurrentNodeUser", NextNodeUser);
                    hmParam.put("originalusers", NextNodeUser);
                    hmParam.put("PreProcessorList", CurrentUserID);
                    hmParam.put("IsLastUser", "1");
                    hmParam.put("WFID", wnp.WFID);
                    hmParam.put("WFName", wnp.WFName);
                    hmParam.put("FlowTrace", String.valueOf(NodeID) + ";" + NodeID);
                    HashMap hm = wt.wfTrackNextNodeRecordInitialize(InstanceID, NodeID, hmParam, cn);
                    String NodeNumber = (String)hm.get("NodeNumber");
                    vecFields.addElement(new Field("NodeNumber", NodeNumber));
                    db.doUpdate("wf_instance_node_property", vecFields, "InstanceID='" + InstanceID + "' and NodeID='" + NodeID + "'", cn);
                    obj.setNextNodeID(NodeID);
                    obj.setNextNodeName(wnp.NodeName);
                    obj.setNextNodeUser(NextNodeUser);
                    obj.setSign(0);
                    obj.setTip("\u6267\u884c\u6d41\u7a0b\u534f\u52a9\u529e\u7406\u64cd\u4f5c\u6210\u529f");
                    WfLog.log(2, "\u6267\u884c\u534f\u52a9\u529e\u7406\u64cd\u4f5c,\u8c03\u7528\u65b9\u6cd5wfAssist(),\u5f53\u524d\u7528\u6237\uff1a" + CurrentUserID + ",\u5b9e\u4f8b\u53f7\uff1a" + InstanceID);
                }
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                obj.setSign(1);
                obj.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u63a7\u5236\u53f0\u5f02\u5e38\u4fe1\u606f\u5e76\u4e0e\u6d41\u7a0b\u7ba1\u7406\u5458\u53d6\u5f97\u8054\u7cfb\uff01");
                WfLog.runtimeException(this, "wfAssist", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u534f\u52a9\u529e\u7406wfAssist(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return obj;
    }

    public EVO wfTakeBack(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        EVO obj = new EVO();
        String InstanceID = vo.getInstanceID();
        String CurrentUserID = vo.getCurrentUserID();
        obj.setNextNodeUser(CurrentUserID);
        vo.setNextNodeUser(CurrentUserID);
        WfLog.log(0, "\u91cd\u529ewfTakeBack(),InstanceID:" + InstanceID + ";CurrentUserID:" + CurrentUserID);
        if (InstanceID == null || CurrentUserID == null || InstanceID.equals("") || CurrentUserID.equals("")) {
            WfLog.paramException(this, "wfTakeBack", vo);
            obj.setSign(1);
            obj.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u91cd\u529ewfTakeBack(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return obj;
        }
        DbControl db = DbControl.getInstance();
        WfTrack wt = WfTrack.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                    vo.setConnection(cn);
                }
                String ifok = Permit.getInstance().ifCanRequestWFAgain(vo, cn);
                if (!ifok.equals("ok")) {
                    obj.setSign(1);
                    obj.setTip(ifok);
                    WfLog.log(4, "\u6267\u884c\u91cd\u529e\u5f02\u5e38\uff1a" + ifok);
                } else {
                    String AllProcessor;
                    if (vo.getCommentVO() != null && vo.getCommentVO().getCommentContent() != null) {
                        WfEngine.getInstance().setComment(vo.getCommentVO(), cn);
                    }
                    if (vo.getNodeorgid() == null || vo.getNodeorgid().equals("")) {
                        vo.setNodeorgid(OrgFactory.getInstance().getOrgClass().getOrgIdByUser(CurrentUserID, cn));
                    }
                    Vector vecData = new Vector();
                    String SqlStr = "select a.IsWFSet,a.WFID,a.WFName,a.WFSign,a.WFAppID,a.FlowTrace,a.WFMainFormID,a.orgid,a.formdata,b.PreNodeName,b.PreNodeID,b.NodeID,b.NodeName,b.AllProcessor,b.NodeAcceptTime from wf_instance_whole_property a,wf_instance_node_property b where a.InstanceID=b.InstanceID and a.InstanceID='" + InstanceID + "'";
                    vecData = db.performQuery(SqlStr, cn);
                    Vector vecRow = (Vector)vecData.elementAt(0);
                    String IsWFSet = (String)vecRow.elementAt(0);
                    String wfid = (String)vecRow.elementAt(1);
                    vo.setWFID(wfid);
                    vo.setWFName((String)vecRow.elementAt(2));
                    String WFSign = (String)vecRow.elementAt(3);
                    String WFAppID = (String)vecRow.elementAt(4);
                    String FlowTrace = ((String)vecRow.elementAt(5)).trim();
                    String WFMainFormID = (String)vecRow.elementAt(6);
                    String orgid = (String)vecRow.elementAt(7);
                    vo.setOrgid(orgid);
                    String formdata = (String)vecRow.elementAt(8);
                    if (vo.paramMap == null || vo.paramMap.size() == 0) {
                        vo.paramMap = StringUtils.convertStrToHashMap(formdata);
                    } else {
                        vo.paramMap.putAll(StringUtils.convertStrToHashMap(formdata));
                    }
                    String PreNodeID = (String)vecRow.elementAt(10);
                    VO_wf_node_property wnp = WFCache.getInstance().getNodeProperty(PreNodeID);
                    vo.setNodeSign(wnp.NodeSign);
                    String NodeID = (String)vecRow.elementAt(11);
                    String NodeName = (String)vecRow.elementAt(12);
                    vo.setNodeID(NodeID);
                    vo.setNodeName(NodeName);
                    vo.setNextNodeID(PreNodeID);
                    String string = AllProcessor = vecRow.elementAt(13) == null ? CurrentUserID : String.valueOf(((String)vecRow.elementAt(13)).trim()) + ";" + CurrentUserID;
                    if (IsWFSet.equals("2")) {
                        String strsql = "select roleid from wf_node_record where instanceid='" + InstanceID + "' and nodeid='" + PreNodeID + "'";
                        Vector vecro = db.performQuery(strsql, cn);
                        Vector vectRowRole = null;
                        if (vecro != null && vecro.size() > 0) {
                            vectRowRole = (Vector)vecro.get(0);
                        }
                        EVO votmp = new EVO();
                        votmp.setInstanceID(InstanceID);
                        votmp.setNodeID(NodeID);
                        votmp.setNodeName(NodeName);
                        votmp.setCurrentUserID(CurrentUserID);
                        votmp.setNextNodeID(PreNodeID);
                        votmp.setNextNodeName(wnp.NodeName);
                        if (vectRowRole != null && vectRowRole.size() > 0) {
                            votmp.setRoleid((String)vectRowRole.get(0));
                        }
                        votmp.setNextNodeUser(CurrentUserID);
                        votmp.setTip("\u6267\u884c\u91cd\u529e\u64cd\u4f5c\uff0c\u8be5\u6587\u6863\u88ab\u62ff\u56de\u91cd\u65b0\u529e\u7406\uff01");
                        votmp.setOrgid(orgid);
                        votmp.setNodeAcceptTime((String)vecRow.elementAt(14));
                        wt.wfTrackNodeRecordEnd(votmp, true, cn);
                    }
                    obj.setNextNodeID(PreNodeID);
                    obj.setNextNodeName(wnp.NodeName);
                    FlowTrace = String.valueOf(FlowTrace) + ";" + PreNodeID;
                    Vector<Field> vecFields = new Vector<Field>();
                    vecFields.addElement(new Field("FlowTrace", FlowTrace));
                    db.doUpdate("wf_instance_whole_property", vecFields, "InstanceID='" + InstanceID + "'", cn);
                    vecFields = new Vector();
                    vecFields.addElement(new Field("NodeID", PreNodeID));
                    vecFields.addElement(new Field("NodeName", wnp.NodeName));
                    vecFields.addElement(new Field("NodeSign", wnp.NodeSign));
                    AllProcessor = String.valueOf(StringUtils.delSameElement(AllProcessor, ";")) + ";";
                    String CurrentNodeUser = String.valueOf(CurrentUserID) + ";";
                    vecFields.addElement(new Field("AllProcessor", AllProcessor));
                    vecFields.addElement(new Field("CurrentNodeUsers", CurrentNodeUser));
                    vecFields.addElement(new Field("CurrentNodeUser", CurrentNodeUser));
                    vecFields.addElement(new Field("IsLastUser", "1"));
                    vecFields.addElement(new Field("IsProcessed", "1"));
                    String NodeActionList = "";
                    Iterator it = wnp.hmNodeFieldProperty.keySet().iterator();
                    String key = "";
                    while (it.hasNext()) {
                        key = (String)it.next();
                        VO_wf_node_field_property wnfp = (VO_wf_node_field_property)wnp.hmNodeFieldProperty.get(key);
                        if (!wnfp.FieldControlType.equals("A")) continue;
                        NodeActionList = String.valueOf(NodeActionList) + ";" + wnfp.FieldCode;
                    }
                    if (NodeActionList.length() > 0) {
                        NodeActionList = NodeActionList.substring(1, NodeActionList.length());
                    }
                    String NodeUserModifyType = wnp.NodeEditControl;
                    vecFields.addElement(new Field("NodeStatus", "4"));
                    vecFields.addElement(new Field("NodeActionList", NodeActionList));
                    vecFields.addElement(new Field("NodeRequest", "2"));
                    vecFields.addElement(new Field("NodeUserModifyType", NodeUserModifyType));
                    vecFields.addElement(new Field("errtxt", "\u5f53\u524d\u8282\u70b9\u6b63\u5904\u4e8e\u91cd\u529e\u72b6\u6001"));
                    vecFields.addElement(new Field("NodeRecallSet", "0"));
                    vecFields.addElement(new Field("NodeChangeSet", "0"));
                    vecFields.addElement(new Field("NodeReturnBackSet", "0"));
                    vecFields.addElement(new Field("NodeUrgeSet", "0"));
                    String NodePlanEndTime = "";
                    String nowtime = DatetimeUtils.getNowDateTimeString();
                    if (wnp.NodeTimelimitNotification != null && wnp.NodeTimelimitNotification.equals("1")) {
                        String NodeDurationTime = "";
                        NodeDurationTime = wnp.NodeDurationTime == null || wnp.NodeDurationTime.equals("") ? "D3" : wnp.NodeDurationTime;
                        NodePlanEndTime = DatetimeUtils.convertDateTimeString(nowtime, NodeDurationTime, "after");
                    } else {
                        NodePlanEndTime = DatetimeUtils.convertDateTimeString(nowtime, "D3", "after");
                    }
                    vecFields.addElement(new Field("NodePlanEndTime", NodePlanEndTime));
                    vecFields.addElement(new Field("NodeStartTime", nowtime));
                    vecFields.addElement(new Field("NodeAcceptTime", nowtime));
                    String NodeFormID = wnp.NodeFormID;
                    if (NodeFormID == null || NodeFormID.equals("")) {
                        NodeFormID = WFMainFormID;
                    }
                    vecFields.addElement(new Field("WFNodeFormID", NodeFormID));
                    if (IsWFSet.equals("2")) {
                        HashMap<String, String> hmParam = new HashMap<String, String>();
                        hmParam.put("NodeName", wnp.NodeName);
                        hmParam.put("NodeID", PreNodeID);
                        hmParam.put("errtxt", "\u5f53\u524d\u8282\u70b9\u6b63\u5904\u4e8e\u91cd\u529e\u72b6\u6001");
                        hmParam.put("NodeStatus", "4");
                        hmParam.put("PreNodeName", wnp.NodeName);
                        hmParam.put("NodeUserModifyType", NodeUserModifyType);
                        hmParam.put("NodePlanEndTime", DatetimeUtils.getNowDateTimeString());
                        hmParam.put("CurrentNodeUsers", vo.getCurrentUserID());
                        hmParam.put("CurrentNodeUser", vo.getCurrentUserID());
                        hmParam.put("originalusers", vo.getCurrentUserID());
                        hmParam.put("PreProcessorList", vo.getCurrentUserID());
                        hmParam.put("IsLastUser", "1");
                        hmParam.put("WFID", vo.getWFID());
                        hmParam.put("WFName", vo.getWFName());
                        hmParam.put("FlowTrace", FlowTrace);
                        hmParam.put("nodeorgid", vo.getNodeorgid());
                        HashMap hm = wt.wfTrackNextNodeRecordInitialize(InstanceID, PreNodeID, hmParam, cn);
                        String NodeNumber = (String)hm.get("NodeNumber");
                        vecFields.addElement(new Field("NodeNumber", NodeNumber));
                    }
                    if (vo.getNodeorgid() != null && vo.getNodeorgid().length() > 0) {
                        vecFields.addElement(new Field("nodeorgid", vo.getNodeorgid()));
                    }
                    db.doUpdate("wf_instance_node_property", vecFields, "InstanceID='" + InstanceID + "'", cn);
                    WfEngine.getInstance().executeFlowAppExt("txtExtrequestback", vo, cn);
                    HashMap<String, String> hmExt = new HashMap<String, String>();
                    hmExt.put("CurrentNodeUser", CurrentNodeUser);
                    hmExt.put("AllProcessor", AllProcessor);
                    AppExtFactory.getInstance().getAppExtClass(wfid).afterTakeBack(vo, hmExt);
                    OrgClass orgclass = OrgClass.getInstance();
                    obj.setNextNodeUser(orgclass.getUserNameByUserID(obj.getNextNodeUser(), cn));
                    obj.setSign(0);
                    obj.setTip("\u91cd\u529e\u5904\u7406\u6210\u529f\uff0c\u6587\u6863\u5df2\u7ecf\u62ff\u56de\u5230\u4e0a\u4e00\u73af\u8282\u91cd\u65b0\u529e\u7406\uff01");
                    obj.setWFSign(WFSign);
                    WfLog.log(2, "\u6267\u884c\u91cd\u529e\u64cd\u4f5c,\u8c03\u7528\u65b9\u6cd5wfTakeBack(),\u5f53\u524d\u7528\u6237\uff1a" + CurrentUserID + ",\u5b9e\u4f8b\u53f7\uff1a" + InstanceID + ",\u6240\u5c5e\u5e94\u7528\uff1a" + WFAppID);
                }
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                obj.setSign(1);
                obj.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u63a7\u5236\u53f0\u5f02\u5e38\u4fe1\u606f\u5e76\u4e0e\u6d41\u7a0b\u7ba1\u7406\u5458\u53d6\u5f97\u8054\u7cfb\uff01");
                WfLog.runtimeException(this, "wfTakeBack", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u91cd\u529ewfTakeBack(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return obj;
    }

    public EVO getChangeUser(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        String InstanceID = vo.getInstanceID();
        String CurrentUserID = vo.getCurrentUserID();
        String NodeID = vo.getNodeID();
        EVO obj = new EVO();
        obj.setMulteitFlag("1");
        WfLog.log(0, "\u8f6c\u529egetChangeUser(),InstanceID:" + InstanceID + ";CurrentUserID:" + CurrentUserID);
        if (InstanceID == null || CurrentUserID == null || InstanceID.equals("") || CurrentUserID.equals("")) {
            WfLog.paramException(this, "getChangeUser", vo);
            obj.setSign(1);
            obj.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u8f6c\u529egetChangeUser(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return obj;
        }
        DbControl db = DbControl.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            if (vo.getConnection() != null) {
                cn = vo.getConnection();
                bClose = false;
            } else {
                cn = db.getConnection();
            }
            String ifok = Permit.getInstance().ifCanChangeWF(vo, cn);
            if (!ifok.equals("ok")) {
                obj.setSign(1);
                obj.setTip(ifok);
                WfLog.log(4, "\u6267\u884c\u8f6c\u529e\u5f02\u5e38\uff1a" + ifok);
                WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u8f6c\u529egetChangeUser(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
                EVO eVO = obj;
                return eVO;
            }
            if (NodeID == null || NodeID.equals("") || NodeID.equals("null")) {
                NodeID = vo.getNodeID();
            }
            String orgid = vo.getOrgid();
            OrgClass orgclass = OrgClass.getInstance();
            VO_wf_node_property wnp = WFCache.getInstance().getNodeProperty(NodeID);
            String NodeUsersList = wnp.NodeUsersList;
            String NodeUsersCompute = wnp.NodeUsersCompute;
            if (NodeUsersList != null && NodeUsersList.equals("${alluser}")) {
                obj.setExb(true);
                EVO eVO = obj;
                return eVO;
            }
            try {
                String userlist = orgclass.convertPersonsList_str(vo, NodeUsersList, NodeUsersCompute, cn);
                StringTokenizer st = new StringTokenizer(userlist, ";");
                String strTemp = "";
                while (st.hasMoreElements()) {
                    strTemp = (String)st.nextElement();
                    obj.paramMap.put(strTemp, orgclass.getNameByID(orgid, strTemp, cn));
                }
            }
            catch (Exception e) {
                obj.setSign(1);
                obj.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u63a7\u5236\u53f0\u5f02\u5e38\u4fe1\u606f\u5e76\u4e0e\u6d41\u7a0b\u7ba1\u7406\u5458\u53d6\u5f97\u8054\u7cfb\uff01");
                WfLog.runtimeException(this, "getChangeUser", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u8f6c\u529egetChangeUser(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return obj;
    }

    public EVO wfChange(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        EVO obj = new EVO();
        DbControl db = DbControl.getInstance();
        WfTrack wt = WfTrack.getInstance();
        String NextNodeUser = vo.getNextNodeUser();
        String CurrentUserID = vo.getCurrentUserID();
        String NodeID = vo.getNodeID();
        String nextNodeRole = vo.getRoleid();
        String InstanceID = vo.getInstanceID();
        String NextNodeID = vo.getNextNodeID() == null ? vo.getNodeID() : vo.getNextNodeID();
        WfLog.log(0, "\u8f6c\u529e\u63d0\u4ea4\uff0c\u5728\u8f6c\u529e\u4eba\u5458\u9009\u62e9\u540e\u6267\u884cwfChange(),InstanceID:" + InstanceID + ";CurrentUserID:" + CurrentUserID + ";NextNodeID:" + NextNodeID + ";NextNodeUser:" + NextNodeUser);
        if (InstanceID == null || NextNodeID == null || InstanceID.equals("") || NextNodeID.equals("") || NextNodeUser == null || NextNodeUser.equals("") || CurrentUserID == null || CurrentUserID.equals("")) {
            WfLog.paramException(this, "wfChange", vo);
            obj.setSign(1);
            obj.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u8f6c\u529e\u63d0\u4ea4\uff0c\u5728\u8f6c\u529e\u4eba\u5458\u9009\u62e9\u540e\u6267\u884cwfChange(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return obj;
        }
        Connection cn = null;
        boolean bClose = true;
        OrgClass orgclass = OrgClass.getInstance();
        try {
            try {
                Vector<Field> vecFields;
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                    vo.setConnection(cn);
                }
                if (vo.getCommentVO() != null && vo.getCommentVO().getCommentContent() != null) {
                    WfEngine.getInstance().setComment(vo.getCommentVO(), cn);
                }
                String SqlStr = "select a.IsWFSet,a.WFID,a.WFName,a.WFAppID,a.orgid,b.NodeName,b.AllProcessor,b.AllReadersList,b.CurrentNodeUsers,b.CurrentNodeUser from wf_instance_whole_property a,wf_instance_node_property b where a.InstanceID=b.InstanceID and a.InstanceID='" + InstanceID + "' and b.NodeID='" + NextNodeID + "'";
                Vector vecData = db.performQuery(SqlStr, cn);
                Vector vecRow = (Vector)vecData.elementAt(0);
                String IsWFSet = (String)vecRow.elementAt(0);
                String wfid = (String)vecRow.elementAt(1);
                vo.setWFID(wfid);
                String WFName = (String)vecRow.elementAt(2);
                String WFAppID = (String)vecRow.elementAt(3);
                String orgid = (String)vecRow.elementAt(4);
                String NodeName = (String)vecRow.elementAt(5);
                obj.setNextNodeName(NodeName);
                Vector vTmp = orgclass.getPersonsList(orgid, NextNodeUser, InstanceID, CurrentUserID, vo.paramMap, cn);
                NextNodeUser = (String)vTmp.elementAt(1);
                obj.setNextNodeID(NextNodeID);
                obj.setNextNodeUser(NextNodeUser);
                vo.setOrgid(orgid);
                VO_wf_node_property wnp = WFCache.getInstance().getNodeProperty(NodeID);
                vo.setNodeSign(wnp.NodeSign);
                if (IsWFSet.equals("2")) {
                    EVO votmp = new EVO();
                    votmp.setInstanceID(InstanceID);
                    votmp.setNodeID(NodeID);
                    votmp.setNodeName(NodeName);
                    votmp.setNextNodeID(NodeID);
                    votmp.setNextNodeName(NodeName);
                    votmp.setRoleid(nextNodeRole);
                    votmp.setCurrentUserID(CurrentUserID);
                    votmp.setNextNodeUser(NextNodeUser);
                    votmp.setTip("\u6267\u884c\u8f6c\u529e\u64cd\u4f5c\uff0c\u6587\u6863\u8f6c\u4ea4 " + orgclass.getUserNameByUserID(NextNodeUser, cn) + " \u529e\u7406");
                    votmp.setOrgid(orgid);
                    wt.wfTrackUpdateNodeReord(votmp, cn);
                }
                String AllProcessor = vecRow.elementAt(6) == null ? "" : ((String)vecRow.elementAt(6)).trim();
                AllProcessor = String.valueOf(AllProcessor) + ";" + CurrentUserID;
                String AllReadersList = vecRow.elementAt(7) == null ? NextNodeUser : String.valueOf(((String)vecRow.elementAt(7)).trim()) + ";" + NextNodeUser;
                String CurrentNodeUsers = StringUtils.replace((String)vecRow.elementAt(8), CurrentUserID, NextNodeUser);
                String CurrentNodeUser = StringUtils.replace((String)vecRow.elementAt(9), CurrentUserID, NextNodeUser);
                CurrentNodeUsers = StringUtils.delSameElement(CurrentNodeUsers, ";");
                CurrentNodeUser = StringUtils.delSameElement(CurrentNodeUser, ";");
                if (IsWFSet.equals("2")) {
                    vecData = db.performQuery("select CurrentNodeUsers,CurrentNodeUser from wf_node_record where InstanceID='" + InstanceID + "' and NodeID='" + NextNodeID + "'", cn);
                    vecRow = (Vector)vecData.elementAt(0);
                    String cnus = vecRow.elementAt(0) == null ? "" : (String)vecRow.elementAt(0);
                    String cnu = vecRow.elementAt(1) == null ? "" : (String)vecRow.elementAt(1);
                    cnus = StringUtils.replace(cnus, CurrentUserID, NextNodeUser);
                    cnu = StringUtils.replace(cnu, CurrentUserID, NextNodeUser);
                    cnus = StringUtils.delSameElement(cnus, ";");
                    cnu = StringUtils.delSameElement(cnu, ";");
                    vecFields = new Vector();
                    vecFields.addElement(new Field("CurrentNodeUsers", String.valueOf(cnus) + ";"));
                    vecFields.addElement(new Field("CurrentNodeUser", cnu));
                    db.doUpdate("wf_node_record", vecFields, "InstanceID='" + InstanceID + "' and NodeID='" + NextNodeID + "'", cn);
                }
                vecFields = new Vector<Field>();
                vecFields.addElement(new Field("AllProcessor", String.valueOf(StringUtils.delSameElement(AllProcessor, ";")) + ";"));
                vecFields.addElement(new Field("AllReadersList", String.valueOf(AllReadersList) + ";"));
                vecFields.addElement(new Field("CurrentNodeUsers", String.valueOf(CurrentNodeUsers) + ";"));
                vecFields.addElement(new Field("CurrentNodeUser", String.valueOf(CurrentNodeUser) + ";"));
                vecFields.addElement(new Field("IsProcessed", "1"));
                db.doUpdate("wf_instance_node_property", vecFields, "InstanceID='" + InstanceID + "'", cn);
                vecData = db.performQuery("select formdata from wf_instance_whole_property where InstanceID='" + InstanceID + "'", cn);
                vecRow = (Vector)vecData.elementAt(0);
                String formdata = (String)vecRow.elementAt(0);
                if (vo.paramMap != null && vo.paramMap.size() > 0) {
                    vo.paramMap.putAll(StringUtils.convertStrToHashMap(formdata));
                    formdata = StringUtils.convertHashMapToStr(vo.paramMap);
                    vecFields = new Vector();
                    vecFields.addElement(new Field("formdata", formdata));
                    db.doUpdate("wf_instance_whole_property", vecFields, "InstanceID='" + InstanceID + "'", cn);
                } else {
                    vo.paramMap = StringUtils.convertStrToHashMap(formdata);
                }
                String SendSMSSign = vo.getSendSMSSign();
                if (SendSMSSign != null && SendSMSSign.equals("1")) {
                    StringTokenizer st = new StringTokenizer(vo.getNextNodeUser(), ";");
                    while (st.hasMoreElements()) {
                        String tmp = (String)st.nextElement();
                        MsgFactory mf = new MsgFactory("3", vo.getCurrentUserID(), tmp, "\u6d41\u7a0b<" + WFName + ">\u5728\u73af\u8282[" + NodeName + "]\u5df2\u7ecf\u529e\u7406\u5b8c\u6bd5\uff0c\u73b0\u8f6c\u4ea4\u7ed9\u60a8\u529e\u7406.", orgid, null);
                        mf.start();
                    }
                }
                WfEngine.getInstance().executeFlowAppExt("txtExtchange", vo, cn);
                AppExtFactory.getInstance().getAppExtClass(wfid).afterChange(vo, null);
                obj.setSign(0);
                obj.setTip("\u6d41\u7a0b\u8f6c\u529e\u6210\u529f");
                WfLog.log(2, "\u6267\u884c\u8f6c\u529e\u64cd\u4f5c,\u8c03\u7528\u65b9\u6cd5wfChange(),\u5f53\u524d\u7528\u6237\uff1a" + CurrentUserID + ",\u5b9e\u4f8b\u53f7\uff1a" + InstanceID + "\u63d0\u4ea4\u529e\u7406\u4eba\uff1a" + NextNodeUser + ",\u6240\u5c5e\u5e94\u7528\uff1a" + WFAppID);
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                obj.setSign(1);
                obj.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u63a7\u5236\u53f0\u5f02\u5e38\u4fe1\u606f\u5e76\u4e0e\u6d41\u7a0b\u7ba1\u7406\u5458\u53d6\u5f97\u8054\u7cfb\uff01");
                WfLog.runtimeException(this, "wfChange", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u8f6c\u529e\u63d0\u4ea4\uff0c\u5728\u8f6c\u529e\u4eba\u5458\u9009\u62e9\u540e\u6267\u884cwfChange(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return obj;
    }

    public EVO wfCancel(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        EVO obj = new EVO();
        String InstanceID = vo.getInstanceID();
        String UserName = vo.getCurrentUserID();
        WfLog.log(0, "\u64a4\u529ewfCancel(),InstanceID:" + InstanceID + ";CurrentUserID:" + UserName);
        if (InstanceID == null || UserName == null || InstanceID.equals("") || UserName.equals("")) {
            WfLog.paramException(this, "wfCancel", vo);
            obj.setSign(1);
            obj.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u64a4\u529ewfCancel(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return obj;
        }
        DbControl db = DbControl.getInstance();
        WfTrack wt = WfTrack.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                    vo.setConnection(cn);
                }
                String ifok = Permit.getInstance().ifCanCancelWF(InstanceID, UserName, cn);
                if (!ifok.equals("ok")) {
                    obj.setSign(1);
                    obj.setTip(ifok);
                    WfLog.log(4, "\u6267\u884c\u64a4\u529e\u5f02\u5e38\uff1a" + ifok);
                } else {
                    if (vo.getCommentVO() != null && vo.getCommentVO().getCommentContent() != null) {
                        WfEngine.getInstance().setComment(vo.getCommentVO(), cn);
                    }
                    Vector vecData = new Vector();
                    String SqlStr = "select a.WFID,a.WFName,a.WFAppID,a.orgid,a.formdata,b.NodeID,b.NodeName,b.NodeAcceptTime from wf_instance_whole_property a,wf_instance_node_property b where a.InstanceID=b.InstanceID and a.InstanceID='" + InstanceID + "'";
                    vecData = db.performQuery(SqlStr, cn);
                    Vector vecRow = (Vector)vecData.elementAt(0);
                    String wfid = (String)vecRow.elementAt(0);
                    vo.setWFID(wfid);
                    vo.setWFName((String)vecRow.elementAt(1));
                    String WFAppID = (String)vecRow.elementAt(2);
                    String orgid = (String)vecRow.elementAt(3);
                    vo.setOrgid(orgid);
                    String formdata = (String)vecRow.elementAt(4);
                    if (vo.paramMap == null || vo.paramMap.size() == 0) {
                        vo.paramMap = StringUtils.convertStrToHashMap(formdata);
                    } else {
                        vo.paramMap.putAll(StringUtils.convertStrToHashMap(formdata));
                    }
                    String NodeID = (String)vecRow.elementAt(5);
                    String NodeName = (String)vecRow.elementAt(6);
                    VO_wf_node_property wnp = WFCache.getInstance().getNodeProperty(NodeID);
                    vo.setNodeSign(wnp.NodeSign);
                    EVO votmp = new EVO();
                    votmp.setInstanceID(InstanceID);
                    votmp.setNodeID(NodeID);
                    votmp.setNextNodeID("WFEND");
                    votmp.setNodeName(NodeName);
                    votmp.setCurrentUserID(UserName);
                    votmp.setNextNodeUser("-");
                    votmp.setTip("\u6267\u884c\u64a4\u529e\u64cd\u4f5c\uff0c\u8be5\u6587\u6863\u88ab\u64a4\u9500\u529e\u7406\uff01");
                    votmp.setOrgid(orgid);
                    votmp.setNodeAcceptTime((String)vecRow.elementAt(7));
                    wt.wfTrackNodeRecordEnd(votmp, true, cn);
                    Vector<Field> vecFields = new Vector<Field>();
                    vecFields.addElement(new Field("WFStatus", "3"));
                    db.doUpdate("wf_instance_whole_property", vecFields, "InstanceID='" + InstanceID + "'", cn);
                    vo.setNextNodeID("WFEND");
                    wt.wfTrackWholeRecordEnd(vo, cn);
                    WfEngine.getInstance().executeFlowAppExt("txtExtcancel", vo, cn);
                    AppExtFactory.getInstance().getAppExtClass(wfid).afterCancel(vo, null);
                    obj.setSign(0);
                    obj.setTip("\u64a4\u529e\u5904\u7406\u6210\u529f\uff0c\u6587\u6863\u5df2\u7ecf\u88ab\u64a4\u9500\u529e\u7406\uff01");
                    WfLog.log(2, "\u6267\u884c\u64a4\u529e\u64cd\u4f5c,\u8c03\u7528\u65b9\u6cd5wfCancel(),\u5f53\u524d\u7528\u6237\uff1a" + UserName + ",\u5b9e\u4f8b\u53f7\uff1a" + InstanceID + ",\u6240\u5c5e\u5e94\u7528\uff1a" + WFAppID);
                }
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                obj.setSign(1);
                obj.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u63a7\u5236\u53f0\u5f02\u5e38\u4fe1\u606f\u5e76\u4e0e\u6d41\u7a0b\u7ba1\u7406\u5458\u53d6\u5f97\u8054\u7cfb\uff01");
                WfLog.runtimeException(this, "wfCancel", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u64a4\u529ewfCancel(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return obj;
    }

    public EVO wfUrge(EVO vo) throws Exception {
        Urgent urgent = new Urgent();
        return urgent.webUrgeWF(vo);
    }

    public EVO wfHang(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        EVO obj = new EVO();
        String InstanceID = vo.getInstanceID();
        String CurrentUserID = vo.getCurrentUserID();
        WfLog.log(0, "\u6d41\u7a0b\u6302\u8d77wfHang(),InstanceID:" + InstanceID + ";CurrentUserID:" + CurrentUserID);
        if (InstanceID == null || CurrentUserID == null || InstanceID.equals("") || CurrentUserID.equals("")) {
            WfLog.paramException(this, "wfHang", vo);
            obj.setSign(1);
            obj.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u6d41\u7a0b\u6302\u8d77wfHang(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return obj;
        }
        DbControl db = DbControl.getInstance();
        WfTrack wt = WfTrack.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            if (vo.getConnection() != null) {
                cn = vo.getConnection();
                bClose = false;
            } else {
                cn = db.getConnection();
                vo.setConnection(cn);
            }
            String ifok = Permit.getInstance().ifCanHangWF(InstanceID, CurrentUserID, cn);
            if (!ifok.equals("ok")) {
                obj.setSign(1);
                obj.setTip(ifok);
                WfLog.log(4, "\u6267\u884c\u6302\u8d77\u5f02\u5e38\uff1a" + ifok);
                WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u6d41\u7a0b\u6302\u8d77wfHang(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
                EVO eVO = obj;
                return eVO;
            }
            try {
                if (vo.getCommentVO() != null && vo.getCommentVO().getCommentContent() != null) {
                    WfEngine.getInstance().setComment(vo.getCommentVO(), cn);
                }
                Vector vecData = new Vector();
                String SqlStr = "select a.WFID,a.WFAppID,a.orgid,a.formdata,b.NodeID,b.NodeName from wf_instance_whole_property a,wf_instance_node_property b where a.InstanceID=b.InstanceID and a.InstanceID='" + InstanceID + "'";
                vecData = db.performQuery(SqlStr, cn);
                Vector vecRow = (Vector)vecData.elementAt(0);
                String wfid = (String)vecRow.elementAt(0);
                vo.setWFID(wfid);
                String WFAppID = (String)vecRow.elementAt(1);
                String orgid = (String)vecRow.elementAt(2);
                vo.setOrgid(orgid);
                String formdata = (String)vecRow.elementAt(3);
                if (vo.paramMap == null || vo.paramMap.size() == 0) {
                    vo.paramMap = StringUtils.convertStrToHashMap(formdata);
                } else {
                    vo.paramMap.putAll(StringUtils.convertStrToHashMap(formdata));
                }
                String NodeID = (String)vecRow.elementAt(4);
                VO_wf_node_property wnp = WFCache.getInstance().getNodeProperty(NodeID);
                vo.setNodeSign(wnp.NodeSign);
                EVO votmp = new EVO();
                votmp.setInstanceID(InstanceID);
                votmp.setNodeID(NodeID);
                votmp.setNodeName((String)vecRow.elementAt(5));
                votmp.setCurrentUserID(CurrentUserID);
                votmp.setNextNodeUser("-");
                votmp.setTip("\u6267\u884c\u6d41\u7a0b\u6302\u8d77\u64cd\u4f5c\uff0c\u5f53\u524d\u6587\u6863\u88ab\u6302\u8d77\uff01");
                votmp.setOrgid(orgid);
                wt.wfTrackNodeRecordEnd(votmp, false, cn);
                Vector<Field> vecFields = new Vector<Field>();
                vecFields.addElement(new Field("WFStatus", "2"));
                db.doUpdate("wf_instance_whole_property", vecFields, "InstanceID='" + InstanceID + "'", cn);
                WfEngine.getInstance().executeFlowAppExt("txtExthang", vo, cn);
                AppExtFactory.getInstance().getAppExtClass(wfid).afterHang(vo, null);
                obj.setSign(0);
                obj.setTip("\u6d41\u7a0b\u6302\u8d77\u6210\u529f\uff0c\u5f53\u524d\u6587\u6863\u5df2\u7ecf\u88ab\u6682\u505c\u5904\u7406\uff01");
                WfLog.log(2, "\u6267\u884c\u6d41\u7a0b\u6302\u8d77\u64cd\u4f5c,\u8c03\u7528\u65b9\u6cd5wfHang(),\u5f53\u524d\u7528\u6237\uff1a" + CurrentUserID + ",\u5b9e\u4f8b\u53f7\uff1a" + InstanceID + ",\u6240\u5c5e\u5e94\u7528\uff1a" + WFAppID);
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            cn.rollback();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                obj.setSign(1);
                obj.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u63a7\u5236\u53f0\u5f02\u5e38\u4fe1\u606f\u5e76\u4e0e\u6d41\u7a0b\u7ba1\u7406\u5458\u53d6\u5f97\u8054\u7cfb\uff01");
                WfLog.runtimeException(this, "wfHang", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u6d41\u7a0b\u6302\u8d77wfHang(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return obj;
    }

    public EVO wfWake(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        EVO obj = new EVO();
        String InstanceID = vo.getInstanceID();
        String UserName = vo.getCurrentUserID();
        WfLog.log(0, "\u6d41\u7a0b\u5524\u9192wfWake(),InstanceID:" + InstanceID + ";CurrentUserID:" + UserName);
        if (InstanceID == null || UserName == null || InstanceID.equals("") || UserName.equals("")) {
            WfLog.paramException(this, "wfWake", vo);
            obj.setSign(1);
            obj.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u6d41\u7a0b\u5524\u9192wfWake(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return obj;
        }
        DbControl db = DbControl.getInstance();
        WfTrack wt = WfTrack.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                    vo.setConnection(cn);
                }
                String ifok = Permit.getInstance().ifCanWakeWF(InstanceID, UserName, cn);
                if (!ifok.equals("ok")) {
                    obj.setSign(1);
                    obj.setTip(ifok);
                    WfLog.log(4, "\u6267\u884c\u5524\u9192\u5f02\u5e38\uff1a" + ifok);
                } else {
                    if (vo.getCommentVO() != null && vo.getCommentVO().getCommentContent() != null) {
                        WfEngine.getInstance().setComment(vo.getCommentVO(), cn);
                    }
                    Vector vecData = new Vector();
                    String SqlStr = "select a.WFID,a.WFAppID,a.orgid,a.formdata,b.NodeID,b.NodeName,b.CurrentNodeUser from wf_instance_whole_property a,wf_instance_node_property b where a.InstanceID=b.InstanceID and a.InstanceID='" + InstanceID + "'";
                    vecData = db.performQuery(SqlStr, cn);
                    Vector vecRow = (Vector)vecData.elementAt(0);
                    String wfid = (String)vecRow.elementAt(0);
                    vo.setWFID(wfid);
                    String WFAppID = (String)vecRow.elementAt(1);
                    String orgid = (String)vecRow.elementAt(2);
                    vo.setOrgid(orgid);
                    String formdata = (String)vecRow.elementAt(3);
                    if (vo.paramMap == null || vo.paramMap.size() == 0) {
                        vo.paramMap = StringUtils.convertStrToHashMap(formdata);
                    } else {
                        vo.paramMap.putAll(StringUtils.convertStrToHashMap(formdata));
                    }
                    String NodeID = (String)vecRow.elementAt(4);
                    VO_wf_node_property wnp = WFCache.getInstance().getNodeProperty(NodeID);
                    vo.setNodeSign(wnp.NodeSign);
                    String NodeName = (String)vecRow.elementAt(5);
                    obj.setNextNodeID(NodeID);
                    obj.setNextNodeName(NodeName);
                    obj.setNextNodeUser(vecRow.elementAt(6) == null ? "" : ((String)vecRow.elementAt(6)).trim());
                    EVO votmp = new EVO();
                    votmp.setInstanceID(InstanceID);
                    votmp.setNodeID(NodeID);
                    votmp.setNodeName(NodeName);
                    votmp.setCurrentUserID(UserName);
                    votmp.setNextNodeUser("-");
                    votmp.setTip("\u6267\u884c\u6d41\u7a0b\u5524\u9192\u64cd\u4f5c\uff0c\u5f53\u524d\u6587\u6863\u88ab\u5524\u9192\u91cd\u65b0\u8fdb\u884c\u529e\u7406\uff01");
                    votmp.setOrgid(orgid);
                    wt.wfTrackUpdateNodeReord(votmp, cn);
                    Vector<Field> vecFields = new Vector<Field>();
                    vecFields.addElement(new Field("NodeStatus", "0"));
                    db.doUpdate("wf_node_record", vecFields, "InstanceID='" + InstanceID + "' and NodeID='" + NodeID + "'", cn);
                    vecFields = new Vector();
                    vecFields.addElement(new Field("WFStatus", "0"));
                    db.doUpdate("wf_instance_whole_property", vecFields, "InstanceID='" + InstanceID + "'", cn);
                    WfEngine.getInstance().executeFlowAppExt("txtExtwake", vo, cn);
                    AppExtFactory.getInstance().getAppExtClass(wfid).afterWake(vo, null);
                    obj.setSign(0);
                    obj.setTip("\u6d41\u7a0b\u5524\u9192\u6210\u529f\uff0c\u5f53\u524d\u6587\u6863\u5df2\u7ecf\u88ab\u5524\u9192\u91cd\u65b0\u529e\u7406\uff01");
                    WfLog.log(2, "\u6267\u884c\u6d41\u7a0b\u5524\u9192\u64cd\u4f5c,\u8c03\u7528\u65b9\u6cd5wfWake(),\u5f53\u524d\u7528\u6237\uff1a" + UserName + ",\u5b9e\u4f8b\u53f7\uff1a" + InstanceID + ",\u6240\u5c5e\u5e94\u7528\uff1a" + WFAppID);
                }
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                obj.setSign(1);
                obj.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u63a7\u5236\u53f0\u5f02\u5e38\u4fe1\u606f\u5e76\u4e0e\u6d41\u7a0b\u7ba1\u7406\u5458\u53d6\u5f97\u8054\u7cfb\uff01");
                WfLog.runtimeException(this, "wfWake", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u6d41\u7a0b\u5524\u9192wfWake(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return obj;
    }

    public EVO wfEnd(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        EVO obj = new EVO();
        String InstanceID = vo.getInstanceID();
        String CurrentUserID = vo.getCurrentUserID();
        String NodeID = vo.getNodeID();
        WfLog.log(0, "\u6d41\u7a0b\u7ed3\u675fwfEnd(),InstanceID:" + InstanceID + ";CurrentUserID:" + CurrentUserID + ";NodeID:" + NodeID);
        if (InstanceID == null || CurrentUserID == null || NodeID == null || InstanceID.equals("") || CurrentUserID.equals("") || NodeID.equals("")) {
            WfLog.paramException(this, "wfEnd", vo);
            obj.setSign(1);
            obj.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u6d41\u7a0b\u7ed3\u675fwfEnd(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return obj;
        }
        DbControl db = DbControl.getInstance();
        WfEngine we = WfEngine.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            if (vo.getConnection() != null) {
                cn = vo.getConnection();
                bClose = false;
            } else {
                cn = db.getConnection();
            }
            String ifok = Permit.getInstance().ifCanEndWF(InstanceID, CurrentUserID, cn);
            if (!ifok.equals("ok")) {
                obj.setSign(1);
                obj.setTip(ifok);
                WfLog.log(4, "\u6267\u884c\u6d41\u7a0b\u7ed3\u675f\u5f02\u5e38\uff1a" + ifok);
                WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u6d41\u7a0b\u7ed3\u675fwfEnd(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
                EVO eVO = obj;
                return eVO;
            }
            try {
                vo = we.wfEndWFWholeDocSubmit(vo, cn);
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
                obj.setSign(0);
                obj.setTip("\u6267\u884c\u64cd\u4f5c\uff1a\u6d41\u7a0b\u7ed3\u675f\u6210\u529f");
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            cn.rollback();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                obj.setSign(1);
                obj.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u63a7\u5236\u53f0\u5f02\u5e38\u4fe1\u606f\u5e76\u4e0e\u6d41\u7a0b\u7ba1\u7406\u5458\u53d6\u5f97\u8054\u7cfb\uff01");
                WfLog.runtimeException(this, "wfEnd", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u6d41\u7a0b\u7ed3\u675fwfEnd(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return obj;
    }

    public EVO wfJump(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        String InstanceID = vo.getInstanceID();
        String CurrentUserID = vo.getCurrentUserID();
        String NodeID = vo.getNodeID();
        String NextNodeID = vo.getNextNodeID();
        String NextNodeUser = vo.getNextNodeUser();
        WfLog.log(0, "\u6d41\u7a0b\u8df3\u8f6cwfJump(),InstanceID:" + InstanceID + ";CurrentUserID:" + CurrentUserID + ";NodeID:" + NodeID + ";NextNodeID:" + NextNodeID + ";NextNodeUser:" + NextNodeUser);
        if (InstanceID == null || InstanceID.equals("") || CurrentUserID == null || CurrentUserID.equals("") || NodeID == null || NodeID.equals("") || NextNodeID == null || NextNodeID.equals("")) {
            WfLog.paramException(this, "wfJump", vo);
            vo.setSign(1);
            vo.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u6d41\u7a0b\u8df3\u8f6cwfJump(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return vo;
        }
        DbControl db = DbControl.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                    vo.setConnection(cn);
                }
                String ifok = Permit.getInstance().ifCanJumpWF(InstanceID, CurrentUserID, cn);
                if (!ifok.equals("ok")) {
                    vo.setSign(1);
                    vo.setTip(ifok);
                    WfLog.log(4, "\u6267\u884c\u8df3\u8f6c\u5f02\u5e38\uff1a" + ifok);
                } else {
                    WfEngine we = WfEngine.getInstance();
                    vo = we.JumpWF(vo, cn);
                    WfLog.log(2, "\u6267\u884c\u6d41\u7a0b\u8df3\u8f6c\u64cd\u4f5c,\u8c03\u7528\u65b9\u6cd5wfJump(),\u5f53\u524d\u7528\u6237\uff1a" + CurrentUserID + ",\u5b9e\u4f8b\u53f7\uff1a" + InstanceID + ",\u5f53\u524d\u8282\u70b9\uff1a" + NodeID + ",\u8df3\u8f6c\u8282\u70b9\uff1a" + NextNodeID + ",\u53d1\u9001\u529e\u7406\u4eba\uff1a" + NextNodeUser);
                }
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                vo.setSign(1);
                vo.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u63a7\u5236\u53f0\u5f02\u5e38\u4fe1\u606f\u5e76\u4e0e\u6d41\u7a0b\u7ba1\u7406\u5458\u53d6\u5f97\u8054\u7cfb\uff01");
                WfLog.runtimeException(this, "wfJump", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u6d41\u7a0b\u8df3\u8f6cwfJump(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return vo;
    }

    public EVO wfJump2First(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        String InstanceID = vo.getInstanceID();
        String CurrentUserID = vo.getCurrentUserID();
        String NodeID = vo.getNodeID();
        WfLog.log(0, "\u6d41\u7a0b\u8df3\u8f6cwfJump2First(),InstanceID:" + InstanceID + ";CurrentUserID:" + CurrentUserID + ";NodeID:" + NodeID);
        if (InstanceID == null || InstanceID.equals("") || CurrentUserID == null || CurrentUserID.equals("") || NodeID == null || NodeID.equals("")) {
            WfLog.paramException(this, "wfJump2First", vo);
            vo.setSign(1);
            vo.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u6d41\u7a0b\u8df3\u8f6cwfJump2First(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return vo;
        }
        DbControl db = DbControl.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                }
                String ifok = "ok";
                String wfid = "";
                String author = "";
                String SqlStr = "select WFID,author from wf_instance_whole_property where InstanceID='" + InstanceID + "'";
                Vector vecData = db.performQuery(SqlStr, cn);
                if (vecData == null || vecData.isEmpty()) {
                    ifok = "\u65e0\u6cd5\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u6570\u636e\uff0c\u53ef\u80fd\u5f53\u524d\u5b9e\u4f8b\u5df2\u7ecf\u529e\u7ed3";
                } else {
                    Vector vecRow = (Vector)vecData.elementAt(0);
                    wfid = (String)vecRow.elementAt(0);
                    author = (String)vecRow.elementAt(1);
                    if (!CurrentUserID.equalsIgnoreCase(author)) {
                        ifok = "\u5f53\u524d\u7528\u6237[" + CurrentUserID + "]\u4e0d\u662f\u6d41\u7a0b\u53d1\u8d77\u4eba\uff0c\u65e0\u6743\u6267\u884c\u8be5\u64cd\u4f5c";
                    }
                }
                if (!ifok.equals("ok")) {
                    vo.setSign(1);
                    vo.setTip(ifok);
                    WfLog.log(4, "\u6267\u884c\u8df3\u8f6c\u5f02\u5e38\uff1a" + ifok);
                } else {
                    WfEngine we = WfEngine.getInstance();
                    String FirstNodeID = WfEngine.getFirstDocUNID(wfid);
                    vo.setNextNodeID(FirstNodeID);
                    vo.setNextNodeUser("U." + author);
                    vo = we.JumpWF(vo, cn);
                    WfLog.log(2, "\u6267\u884c\u6d41\u7a0b\u8df3\u8f6c\u64cd\u4f5c,\u8c03\u7528\u65b9\u6cd5wfJump2First(),\u5f53\u524d\u7528\u6237\uff1a" + CurrentUserID + ",\u5b9e\u4f8b\u53f7\uff1a" + InstanceID + ",\u5f53\u524d\u8282\u70b9\uff1a" + NodeID + ",\u8df3\u8f6c\u8282\u70b9\uff1a" + FirstNodeID + ",\u53d1\u9001\u529e\u7406\u4eba\uff1a" + author);
                }
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                vo.setSign(1);
                vo.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u63a7\u5236\u53f0\u5f02\u5e38\u4fe1\u606f\u5e76\u4e0e\u6d41\u7a0b\u7ba1\u7406\u5458\u53d6\u5f97\u8054\u7cfb\uff01");
                WfLog.runtimeException(this, "wfJump2First", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u6d41\u7a0b\u8df3\u8f6cwfJump2First(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return vo;
    }

    public EVO wfWithdrawUser(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        String InstanceID = vo.getInstanceID();
        String CurrentUserID = vo.getCurrentUserID();
        String NodeID = vo.getNodeID();
        String UserID = vo.getUserID();
        WfLog.log(0, "\u64a4\u9500\u529e\u7406\u4ebawfWithdrawUser(),InstanceID:" + InstanceID + ";NodeID:" + NodeID + ";CurrentUserID:" + CurrentUserID + ";UserID:" + UserID);
        if (InstanceID == null || InstanceID.equals("") || NodeID == null || NodeID.equals("") || CurrentUserID == null || CurrentUserID.equals("") || UserID == null || UserID.equals("")) {
            WfLog.paramException(this, "wfWithdrawUser", vo);
            vo.setSign(1);
            vo.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u64a4\u9500\u529e\u7406\u4ebawfWithdrawUser(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return vo;
        }
        DbControl db = DbControl.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            if (vo.getConnection() != null) {
                cn = vo.getConnection();
                bClose = false;
            } else {
                cn = db.getConnection();
                vo.setConnection(cn);
            }
            String sqlstr = "select CurrentNodeUsers,CurrentNodeUser,IsLastUser from wf_instance_node_property where InstanceID='" + InstanceID + "' and NodeID='" + NodeID + "'";
            Vector vecData = db.performQuery(sqlstr, cn);
            Vector vecRow = (Vector)vecData.elementAt(0);
            String CurrentNodeUsers = (String)vecRow.elementAt(0);
            String CurrentNodeUser = (String)vecRow.elementAt(1);
            String IsLastUser = (String)vecRow.elementAt(2);
            if (CurrentNodeUsers == null || CurrentNodeUsers.equals("") || !StringUtils.isPartOf(CurrentNodeUsers, UserID, ";")) {
                vo.setSign(1);
                vo.setTip("\u64a4\u9500\u4eba\u975e\u5f53\u524d\u8282\u70b9\u529e\u7406\u4eba\u8303\u56f4\uff0c\u65e0\u6cd5\u64a4\u9500!");
                EVO eVO = vo;
                return eVO;
            }
            if (IsLastUser != null && IsLastUser.equals("1")) {
                EVO eVO = WfEngine.getInstance().submitNextNode(vo, cn);
                return eVO;
            }
            try {
                CurrentNodeUsers = StringUtils.delSubStr(CurrentNodeUsers, UserID, ";");
                VO_wf_node_property wnp = WFCache.getInstance().getNodeProperty(NodeID);
                String NodeTransactType = wnp.NodeTransactType;
                if (NodeTransactType.equals("2") || NodeTransactType.equals("5")) {
                    if (CurrentNodeUser.equals(UserID)) {
                        CurrentNodeUser = StringUtils.getFirstElement(CurrentNodeUsers, ";");
                    }
                } else {
                    CurrentNodeUser = StringUtils.delSubStr(CurrentNodeUser, UserID, ";");
                }
                IsLastUser = StringUtils.getElementsNUM(CurrentNodeUsers, ";") == 1 ? "1" : "0";
                Vector<Field> vecFields = new Vector<Field>();
                vecFields.addElement(new Field("CurrentNodeUsers", String.valueOf(CurrentNodeUsers) + ";"));
                vecFields.addElement(new Field("CurrentNodeUser", String.valueOf(CurrentNodeUser) + ";"));
                vecFields.addElement(new Field("IsLastUser", IsLastUser));
                db.doUpdate("wf_instance_node_property", vecFields, "InstanceID='" + InstanceID + "' and NodeID='" + NodeID + "'", cn);
                vo.setSign(0);
                vo.setTip("\u8282\u70b9\u64a4\u9500\u529e\u7406\u4eba\u63d0\u4ea4\u6210\u529f");
                vo.setNextNodeID(NodeID);
                vo.setNextNodeName(wnp.NodeName);
                vo.setNextNodeUser(CurrentNodeUser);
                EVO votmp = new EVO();
                votmp.setInstanceID(InstanceID);
                votmp.setNodeID(NodeID);
                votmp.setNodeName(wnp.NodeName);
                votmp.setNextNodeID(NodeID);
                votmp.setNextNodeName(wnp.NodeName);
                votmp.setCurrentUserID(CurrentUserID);
                votmp.setNextNodeUser(CurrentNodeUser);
                votmp.setTip("\u6267\u884c\u64a4\u9500\u529e\u7406\u4eba\u64cd\u4f5c");
                votmp.setOrgid(vo.getOrgid());
                WfTrack.getInstance().wfTrackUpdateNodeReord(votmp, cn);
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                vo.setSign(1);
                vo.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u63a7\u5236\u53f0\u5f02\u5e38\u4fe1\u606f\u5e76\u4e0e\u6d41\u7a0b\u7ba1\u7406\u5458\u53d6\u5f97\u8054\u7cfb\uff01");
                WfLog.runtimeException(this, "wfWithdrawUser", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u64a4\u9500\u529e\u7406\u4ebawfWithdrawUser(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return vo;
    }

    public EVO wfDelInstance(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        String InstanceID = vo.getInstanceID();
        WfLog.log(0, "\u5220\u9664\u5b9e\u4f8bwfDelSpecialDoc(),InstanceID:" + InstanceID);
        if (InstanceID == null || InstanceID.equals("")) {
            WfLog.paramException(this, "wfDelSpecialDoc", vo);
            vo.setSign(1);
            vo.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u5220\u9664\u5b9e\u4f8bwfDelSpecialDoc(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return vo;
        }
        DbControl db = DbControl.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                    vo.setConnection(cn);
                }
                vo = WfEngine.getInstance().wfDelSpecialDoc(vo, cn);
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                WfLog.runtimeException(this, "wfDelSpecialDoc", e);
                vo.setSign(1);
                vo.setTip("\u5220\u9664\u5b9e\u4f8b\u5931\u8d25");
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u5220\u9664\u5b9e\u4f8bwfDelSpecialDoc(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return vo;
    }

    public HashMap getNodeControlFormField(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        String InstanceID = vo.getInstanceID();
        WfLog.log(0, "\u83b7\u53d6\u8282\u70b9\u8868\u5355\u53ef\u63a7\u5b57\u6bb5\u4fe1\u606fgetNodeControlFormField(),InstanceID:" + InstanceID);
        HashMap hm = new HashMap();
        if (InstanceID == null || InstanceID.equals("")) {
            WfLog.paramException(this, "getNodeControlFormField", vo);
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u83b7\u53d6\u8282\u70b9\u8868\u5355\u53ef\u63a7\u5b57\u6bb5\u4fe1\u606fgetNodeControlFormField(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return hm;
        }
        DbControl db = DbControl.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            if (vo.getConnection() != null) {
                cn = vo.getConnection();
                bClose = false;
            } else {
                cn = db.getConnection();
            }
            WfEngine we = WfEngine.getInstance();
            hm = we.getNodeControlFormField(vo, cn);
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u83b7\u53d6\u8282\u70b9\u8868\u5355\u53ef\u63a7\u5b57\u6bb5\u4fe1\u606fgetNodeControlFormField(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return hm;
    }

    public EVO wfSaveJob(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        String InstanceID = vo.getInstanceID();
        String FormFlow = vo.getFormflow();
        String orgid = vo.getOrgid();
        WfLog.log(0, "\u4fdd\u5b58\u5f53\u524d\u5b9e\u4f8bwfSaveJob(),InstanceID:" + InstanceID + "\uff1bFormFlow:" + FormFlow);
        if (InstanceID == null || InstanceID.equals("") || orgid == null || orgid.equals("")) {
            WfLog.paramException(this, "wfSaveJob", vo);
            vo.setSign(1);
            vo.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u4fdd\u5b58\u5f53\u524d\u5b9e\u4f8bwfSaveJob(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return vo;
        }
        DbControl db = DbControl.getInstance();
        WfEngine we = WfEngine.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                    vo.setConnection(cn);
                }
                vo = we.wfSaveJob(vo, cn);
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                WfLog.runtimeException(this, "wfSaveJob", e);
                vo.setSign(1);
                vo.setTip("\u4fdd\u5b58\u5b9e\u4f8b\u5931\u8d25");
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u4fdd\u5b58\u5f53\u524d\u5b9e\u4f8bwfSaveJob(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return vo;
    }

    public List wfBatchSaveJob(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        ArrayList<EVO> al = new ArrayList<EVO>();
        WfLog.log(0, "\u6279\u91cf\u4fdd\u5b58\u5f53\u524d\u5b9e\u4f8bwfBatchSaveJob()");
        DbControl db = DbControl.getInstance();
        WfEngine we = WfEngine.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                }
                for (String InstanceID : vo.paramMap.keySet()) {
                    EVO obj = (EVO)vo.paramMap.get(InstanceID);
                    if (obj == null) continue;
                    InstanceID = obj.getInstanceID();
                    WfLog.log(0, "\u5904\u7406\u6279\u91cf\u4fdd\u5b58\u4efb\u52a1\uff0c\u5b9e\u4f8b\u53f7\uff1a" + InstanceID);
                    if (InstanceID == null || InstanceID.equals("")) {
                        obj.setSign(1);
                        obj.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
                    } else {
                        obj = we.wfSaveJob(obj, cn);
                    }
                    al.add(obj);
                }
                if (vo.getUserObject() != null && vo.getUserObject() instanceof Vector) {
                    db.performBathSql((Vector)vo.getUserObject(), cn);
                }
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                WfLog.runtimeException(this, "wfBatchSaveJob", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u6279\u91cf\u4fdd\u5b58\u5f53\u524d\u5b9e\u4f8bwfBatchSaveJob(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return al;
    }

    public HashMap getNodeControlFormAction(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        String InstanceID = vo.getInstanceID();
        String UserName = vo.getCurrentUserID();
        String NodeID = vo.getNodeID();
        HashMap hm = new HashMap();
        hm.put("track", "1");
        hm.put("viewcomment", "1");
        WfLog.log(0, "\u83b7\u53d6\u8282\u70b9\u8868\u5355\u5177\u6709\u6743\u9650\u64cd\u4f5c\u4fe1\u606fgetNodeControlFormAction(),InstanceID:" + InstanceID + ";CurrentUserID:" + UserName + "; NodeID:" + NodeID);
        if (InstanceID == null || InstanceID.equals("") || UserName == null || UserName.equals("") || NodeID == null || NodeID.equals("")) {
            WfLog.paramException(this, "getNodeControlFormAction", vo);
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u83b7\u53d6\u8282\u70b9\u8868\u5355\u5177\u6709\u6743\u9650\u64cd\u4f5c\u4fe1\u606fgetNodeControlFormAction(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return hm;
        }
        DbControl db = DbControl.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            if (vo.getConnection() != null) {
                cn = vo.getConnection();
                bClose = false;
            } else {
                cn = db.getConnection();
            }
            WfEngine we = WfEngine.getInstance();
            hm = we.getNodeControlFormAction(vo, cn);
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u83b7\u53d6\u8282\u70b9\u8868\u5355\u5177\u6709\u6743\u9650\u64cd\u4f5c\u4fe1\u606fgetNodeControlFormAction(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return hm;
    }

    public CommentVO getUserComment(EVO evo) throws Exception {
        CommentVO cvo = evo.getCommentVO();
        long dst = System.currentTimeMillis();
        String InstanceID = cvo.getInstanceID();
        String userID = cvo.getUserID();
        WfLog.log(0, "\u83b7\u53d6\u8282\u70b9\u7528\u6237\u8f93\u5165\u7684\u610f\u89c1getUserComment(),InstanceID:" + InstanceID + ";userID:" + userID);
        if (InstanceID == null || InstanceID.equals("") || userID == null || userID.equals("")) {
            WfLog.paramException(this, "getUserComment", cvo);
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u83b7\u53d6\u8282\u70b9\u7528\u6237\u8f93\u5165\u7684\u610f\u89c1getUserComment(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return cvo;
        }
        DbControl db = DbControl.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            if (evo.getConnection() != null) {
                cn = evo.getConnection();
                bClose = false;
            } else {
                cn = db.getConnection();
            }
            WfEngine we = WfEngine.getInstance();
            cvo = we.getUserComment(cvo, cn);
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u83b7\u53d6\u8282\u70b9\u7528\u6237\u8f93\u5165\u7684\u610f\u89c1getUserComment(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return cvo;
    }

    public Vector getAllComments(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        CommentVO cvo = vo.getCommentVO();
        String InstanceID = cvo.getInstanceID();
        String userID = cvo.getUserID();
        WfLog.log(0, "\u83b7\u53d6\u5f53\u524d\u5b9e\u4f8b\u6240\u6709\u7684\u610f\u89c1\u5217\u8868getAllComments(),InstanceID:" + InstanceID + ";userID:" + userID);
        Vector vecResult = new Vector();
        if (InstanceID == null || InstanceID.equals("") || userID == null || userID.equals("")) {
            WfLog.paramException(this, "getAllComments", vo);
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u83b7\u53d6\u5f53\u524d\u5b9e\u4f8b\u6240\u6709\u7684\u610f\u89c1\u5217\u8868getAllComments(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return vecResult;
        }
        DbControl db = DbControl.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            if (vo.getConnection() != null) {
                cn = vo.getConnection();
                bClose = false;
            } else {
                cn = db.getConnection();
            }
            WfEngine we = WfEngine.getInstance();
            vecResult = we.getAllComments(cvo, cn, vo.isExb());
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u83b7\u53d6\u5f53\u524d\u5b9e\u4f8b\u6240\u6709\u7684\u610f\u89c1\u5217\u8868getAllComments(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return vecResult;
    }

    public boolean setComment(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        CommentVO cvo = vo.getCommentVO();
        String InstanceID = cvo.getInstanceID();
        String userID = cvo.getUserID();
        WfLog.log(0, "\u586b\u5199\u610f\u89c1\u63d0\u4ea4setComment(),InstanceID:" + InstanceID + ";userID:" + userID);
        if (InstanceID == null || InstanceID.equals("") || userID == null || userID.equals("") || cvo.getCommentContent() == null || cvo.getCommentContent().equals("")) {
            WfLog.paramException(this, "setComment", vo);
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u586b\u5199\u610f\u89c1\u63d0\u4ea4setComment(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return false;
        }
        boolean result = false;
        DbControl db = DbControl.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                }
                WfEngine we = WfEngine.getInstance();
                result = we.setComment(cvo, cn);
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u586b\u5199\u610f\u89c1\u63d0\u4ea4setComment(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return result;
    }

    public EVO getNextNodeList(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        EVO obj = new EVO();
        String InstanceID = vo.getInstanceID();
        String CurrentUserID = vo.getCurrentUserID();
        String NodeID = vo.getNodeID();
        WfLog.log(0, "\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u5217\u8868getNextNodeList(),InstanceID:" + InstanceID + ";CurrentUserID:" + CurrentUserID + "; NodeID:" + NodeID);
        if (InstanceID == null || CurrentUserID == null || InstanceID.equals("") || CurrentUserID.equals("") || NodeID == null || NodeID.equals("")) {
            WfLog.paramException(this, "getNextNodeList", vo);
            obj.setSign(1);
            obj.setTip("\u65e0\u6548\u7684\u53c2\u6570");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u5217\u8868getNextNodeList(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return obj;
        }
        DbControl db = DbControl.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            if (vo.getConnection() != null) {
                cn = vo.getConnection();
                bClose = false;
            } else {
                cn = db.getConnection();
            }
            WfEngine we = WfEngine.getInstance();
            VO_wf_node_property wnp = WFCache.getInstance().getNodeProperty(NodeID);
            vo.setUserObject(wnp);
            obj = we.getNextNodeList(vo, cn);
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u83b7\u53d6\u4e0b\u4e00\u8282\u70b9\u5217\u8868getNextNodeList(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return obj;
    }

    public EVO getNodeUserList(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        EVO obj = new EVO();
        String InstanceID = vo.getInstanceID();
        String NodeID = vo.getNodeID();
        String CurrentUserID = vo.getCurrentUserID();
        WfLog.log(0, "\u83b7\u53d6\u8282\u70b9\u529e\u7406\u7528\u6237\u5217\u8868getNodeUserList(),InstanceID:" + InstanceID + ";CurrentUserID:" + CurrentUserID + "; NodeID:" + NodeID);
        if (InstanceID == null || InstanceID.equals("") || NodeID == null || NodeID.equals("") || CurrentUserID == null || CurrentUserID.equals("")) {
            WfLog.paramException(this, "getNodeUserList", vo);
            obj.setSign(1);
            obj.setTip("\u65e0\u6548\u7684\u53c2\u6570");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u83b7\u53d6\u8282\u70b9\u529e\u7406\u7528\u6237\u5217\u8868getNodeUserList(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return obj;
        }
        DbControl db = DbControl.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            if (vo.getConnection() != null) {
                cn = vo.getConnection();
                bClose = false;
            } else {
                cn = db.getConnection();
            }
            WfEngine we = WfEngine.getInstance();
            obj = we.getNodeUserList(vo, cn);
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u83b7\u53d6\u8282\u70b9\u529e\u7406\u7528\u6237\u5217\u8868getNodeUserList(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return obj;
    }

    public EVO getInstanceNodeUserList(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        String InstanceID = vo.getInstanceID();
        String NodeID = vo.getNodeID();
        String orgid = vo.getOrgid();
        WfLog.log(0, "\u83b7\u53d6\u5f53\u524d\u5b9e\u4f8b\u5f53\u524d\u8282\u70b9\u529e\u7406\u7528\u6237\u5217\u8868getInstanceNodeUserList(),InstanceID:" + InstanceID + "; NodeID:" + NodeID);
        if (InstanceID == null || InstanceID.equals("") || NodeID == null || NodeID.equals("")) {
            WfLog.paramException(this, "getInstanceNodeUserList", vo);
            vo.setSign(1);
            vo.setTip("\u65e0\u6548\u7684\u53c2\u6570");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u83b7\u53d6\u5f53\u524d\u5b9e\u4f8b\u5f53\u524d\u8282\u70b9\u529e\u7406\u7528\u6237\u5217\u8868getInstanceNodeUserList(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return vo;
        }
        DbControl db = DbControl.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            if (vo.getConnection() != null) {
                cn = vo.getConnection();
                bClose = false;
            } else {
                cn = db.getConnection();
            }
            String sqlstr = "select CurrentNodeUsers from wf_instance_node_property where InstanceID='" + InstanceID + "' and NodeID='" + NodeID + "'";
            Vector vecData = db.performQuery(sqlstr, cn);
            if (vecData != null && vecData.size() > 0) {
                Vector vecRow = (Vector)vecData.elementAt(0);
                String CurrentNodeUsers = (String)vecRow.elementAt(0);
                StringTokenizer st = new StringTokenizer(CurrentNodeUsers, ";");
                OrgClass orgclass = OrgClass.getInstance();
                while (st.hasMoreElements()) {
                    String s = (String)st.nextElement();
                    vo.paramMap.put(s, orgclass.getUserNameByUserID(s, cn));
                }
                vo.setSign(0);
                vo.setTip("\u8bfb\u53d6\u5f53\u524d\u5b9e\u4f8b\u5f53\u524d\u8282\u70b9\u529e\u7406\u7528\u6237\u5217\u8868\u6210\u529f");
            } else {
                vo.setSign(1);
                vo.setTip("\u65e0\u6cd5\u83b7\u53d6\u5b9e\u4f8b\u4fe1\u606f");
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u83b7\u53d6\u5f53\u524d\u5b9e\u4f8b\u5f53\u524d\u8282\u70b9\u529e\u7406\u7528\u6237\u5217\u8868getInstanceNodeUserList(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return vo;
    }

    public EVO getAnnounceUserList(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        EVO obj = new EVO();
        String InstanceID = vo.getInstanceID();
        String NodeID = vo.getNodeID();
        String CurrentUserID = vo.getCurrentUserID();
        WfLog.log(0, "\u83b7\u53d6\u8282\u70b9\u6284\u9001\u7528\u6237\u5217\u8868getAnnounceUserList(),InstanceID:" + InstanceID + ";CurrentUserID:" + CurrentUserID + "; NodeID:" + NodeID);
        if (InstanceID == null || InstanceID.equals("") || NodeID == null || NodeID.equals("") || CurrentUserID == null || CurrentUserID.equals("")) {
            WfLog.paramException(this, "getAnnounceUserList", vo);
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u83b7\u53d6\u8282\u70b9\u6284\u9001\u7528\u6237\u5217\u8868getAnnounceUserList(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            obj.setSign(1);
            obj.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
            return obj;
        }
        String SqlStr = "";
        String strTemp = "";
        DbControl db = DbControl.getInstance();
        Connection cn = null;
        boolean bClose = true;
        OrgClass orgclass = OrgClass.getInstance();
        try {
            if (vo.getConnection() != null) {
                cn = vo.getConnection();
                bClose = false;
            } else {
                cn = db.getConnection();
            }
            if (NodeID.equals("wffreerouter")) {
                obj.setMulteitFlag("1");
                obj.setExb(true);
                WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u83b7\u53d6\u8282\u70b9\u6284\u9001\u7528\u6237\u5217\u8868getAnnounceUserList(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
                EVO eVO = obj;
                return eVO;
            }
            VO_wf_node_property wnp = WFCache.getInstance().getNodeProperty(NodeID);
            obj.setMulteitFlag("n");
            if (wnp.NodeAnnounceSet == null || wnp.NodeAnnounceSet.equals("0")) {
                EVO eVO = obj;
                return eVO;
            }
            try {
                if (wnp.NodeAnnounceSet.equals("1")) {
                    obj.setExb(true);
                } else {
                    String orgid = vo.getOrgid();
                    StringTokenizer st = new StringTokenizer(orgclass.convertPersonsList_str(vo, wnp.NodeAnnounceUser == null ? "" : wnp.NodeAnnounceUser.trim(), "0", cn), ";");
                    while (st.hasMoreElements()) {
                        strTemp = (String)st.nextElement();
                        obj.paramMap.put(strTemp, orgclass.getNameByID(orgid, strTemp, cn));
                    }
                }
            }
            catch (Exception e) {
                WfLog.runtimeException(this, "getAnnounceUserList", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u83b7\u53d6\u8282\u70b9\u6284\u9001\u7528\u6237\u5217\u8868getAnnounceUserList(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return obj;
    }

    public boolean sendAnnounce(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        String InstanceID = vo.getInstanceID();
        String NodeID = vo.getNodeID();
        String CurrentUserID = vo.getCurrentUserID();
        String orgid = vo.getOrgid();
        String AnnounceUser = vo.getAnnounceUser();
        if (AnnounceUser == null || AnnounceUser.equals("")) {
            AnnounceUser = vo.getUserName();
        }
        WfLog.log(0, "\u53d1\u9001\u8282\u70b9\u6284\u9001sendAnnounce(),InstanceID:" + InstanceID + ";CurrentUserID:" + CurrentUserID + "; NodeID:" + NodeID + "; AnnounceUser:" + AnnounceUser);
        boolean bResult = false;
        if (InstanceID == null || InstanceID.equals("") || NodeID == null || NodeID.equals("") || CurrentUserID == null || CurrentUserID.equals("") || AnnounceUser == null || AnnounceUser.equals("")) {
            WfLog.paramException(this, "sendAnnounce", vo);
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u53d1\u9001\u8282\u70b9\u6284\u9001sendAnnounce(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return bResult;
        }
        String SqlStr = "";
        DbControl db = DbControl.getInstance();
        Connection cn = null;
        boolean bClose = true;
        OrgClass orgclass = OrgClass.getInstance();
        try {
            try {
                Vector vecData;
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                }
                if (orgid == null || orgid.equals("")) {
                    SqlStr = "select orgid from wf_instance_whole_property where InstanceID='" + InstanceID + "'";
                    vecData = db.performQuery(SqlStr, cn);
                    orgid = ((Vector)vecData.elementAt(0)).elementAt(0).toString();
                    vo.setOrgid(orgid);
                }
                AnnounceUser = orgclass.convertPersonsList_str_ids(vo, AnnounceUser, vo.paramMap, cn);
                SqlStr = "select WFName,NodeName,AllReadersList,AnnounceUser from wf_worklist where InstanceID='" + InstanceID + "' and NodeID='" + NodeID + "'";
                vecData = db.performQuery(SqlStr, cn);
                Vector vecRow = (Vector)vecData.elementAt(0);
                String AllReadersList = "";
                AllReadersList = vecRow.elementAt(2) == null || vecRow.elementAt(2).toString().equals("") ? AnnounceUser : (vecRow.elementAt(2).toString().endsWith(";") ? String.valueOf(vecRow.elementAt(2).toString()) + AnnounceUser : String.valueOf(vecRow.elementAt(2).toString()) + ";" + AnnounceUser);
                String AnnounceUser2 = "";
                AnnounceUser2 = vecRow.elementAt(3) == null || vecRow.elementAt(3).toString().equals("") ? AnnounceUser : (vecRow.elementAt(3).toString().endsWith(";") ? String.valueOf(vecRow.elementAt(3).toString()) + AnnounceUser : String.valueOf(vecRow.elementAt(3).toString()) + ";" + AnnounceUser);
                Vector<Field> vecFields = new Vector<Field>();
                vecFields.addElement(new Field("AllReadersList", String.valueOf(StringUtils.delSameElement(AllReadersList, ";")) + ";"));
                vecFields.addElement(new Field("AnnounceUser", String.valueOf(StringUtils.delSameElement(AnnounceUser2, ";")) + ";"));
                db.doUpdate("wf_instance_node_property", vecFields, "InstanceID='" + InstanceID + "' and NodeID='" + NodeID + "'", cn);
                MsgFactory mf = new MsgFactory("1", CurrentUserID, AnnounceUser, "\u6d41\u7a0b<" + (String)vecRow.elementAt(0) + ">\u73b0\u6b63\u5728\u529e\u7406[" + (String)vecRow.elementAt(1) + "]\u73af\u8282\uff0c\u7528\u6237\uff1a" + CurrentUserID + "\u6284\u9001\u7ed9\u60a8\u67e5\u770b.", orgid, null);
                mf.start();
                bResult = true;
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                bResult = false;
                WfLog.runtimeException(this, "sendAnnounce", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u53d1\u9001\u8282\u70b9\u6284\u9001sendAnnounce(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return bResult;
    }

    public Vector getSubFlow(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        String InstanceID = vo.getInstanceID();
        String AppID = vo.getAppID();
        String NodeID = vo.getNodeID();
        String orgid = vo.getOrgid();
        WfLog.log(0, "\u8c03\u7528\u5b50\u6d41getSubFlow(),InstanceID:" + InstanceID + ";AppID:" + AppID + "; NodeID:" + NodeID);
        Vector<EVO> vecResult = new Vector<EVO>();
        if (InstanceID == null || InstanceID.equals("") || AppID == null || AppID.equals("") || NodeID == null || NodeID.equals("")) {
            WfLog.paramException(this, "getSubFlow", vo);
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u8c03\u7528\u5b50\u6d41getSubFlow(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return vecResult;
        }
        String SqlStr = "";
        DbControl db = DbControl.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                }
                Map wfMapList = WFCache.getInstance().getWFList();
                for (String wfname : wfMapList.keySet()) {
                    HashMap wfMap = (HashMap)wfMapList.get(wfname);
                    if (!((String)wfMap.get("sysid")).equals(vo.getSysid()) || AppID == null || !((String)wfMap.get("wfappid")).equals(AppID) || !((String)wfMap.get("wfinitiators")).equals("0")) continue;
                    EVO obj = new EVO();
                    obj.setWFID((String)wfMap.get("wfid"));
                    obj.setWFName((String)wfMap.get("wfname"));
                    obj.setAppID(AppID);
                    obj.setAppName((String)wfMap.get("wfappname"));
                    obj.setWFMainForm((String)wfMap.get("wfmainformid"));
                    vecResult.addElement(obj);
                }
            }
            catch (Exception e) {
                WfLog.runtimeException(this, "getSubFlow", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u8c03\u7528\u5b50\u6d41getSubFlow(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return vecResult;
    }

    public EVO synSubFlowSetSubmit(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        EVO obj = new EVO();
        String mainInstanceID = vo.getMainInstanceID();
        String mainNodeID = vo.getMainNodeID();
        String subNextNodeID = vo.getNodeID();
        String subNextNodeUser = vo.getNextNodeUser();
        String subNodeRole = vo.getRoleid();
        String subWfid = vo.getWFID();
        String CurrentUserID = vo.getCurrentUserID();
        String orgid = vo.getOrgid();
        String custID = vo.getCustID();
        String custName = vo.getCustName();
        String sysid = vo.getSysid();
        obj.setNextNodeUser(CurrentUserID);
        WfLog.log(0, "\u7528\u6237\u540c\u6b65\u5b50\u6d41\u8bbe\u7f6e\u521d\u59cb\u5316synSubFlowSetSubmit(),mainInstanceID:" + mainInstanceID + ";subWFID:" + subWfid + "; orgid:" + orgid + "; CurrentUserID:" + CurrentUserID);
        if (mainInstanceID == null || mainInstanceID.equals("") || subWfid == null || subWfid.equals("") || orgid == null || orgid.equals("") || CurrentUserID == null || CurrentUserID.equals("")) {
            WfLog.paramException(this, "SubFlowSetSubmit", vo);
            obj.setSign(1);
            obj.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u7528\u6237\u540c\u6b65\u5b50\u6d41\u8bbe\u7f6e\u521d\u59cb\u5316synSubFlowSetSubmit(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return obj;
        }
        String SqlStr = "";
        DbControl db = DbControl.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                }
                WfLog.log(2, "\u8c03\u7528\u5b50\u6d41,\u8c03\u7528\u65b9\u6cd5asynSubFlowSetSubmit(),\u4e3b\u6d41\u7a0b\u5b9e\u4f8b\u53f7\uff1a" + mainInstanceID + ",\u5f53\u524d\u673a\u6784\uff1a" + orgid + ",\u5f53\u524d\u7528\u6237\uff1a" + CurrentUserID + ",\u5b50\u6d41\u6807\u8bc6\uff1a" + subWfid);
                VO_wf_node_property wnp = WFCache.getInstance().getNodeProperty(mainNodeID);
                String NodeUseSubWF = wnp.NodeUseSubWF;
                if (NodeUseSubWF != null && NodeUseSubWF.equals("1")) {
                    String SubLevel;
                    SqlStr = "select SubLevel from wf_instance_status where InstanceID='" + mainInstanceID + "'";
                    Vector vecData = db.performQuery(SqlStr, cn);
                    if (vecData.size() > 0) {
                        SubLevel = (String)((Vector)vecData.elementAt(0)).elementAt(0);
                        int k = Integer.parseInt(SubLevel) + 1;
                        SubLevel = String.valueOf(k);
                    } else {
                        SubLevel = "1";
                    }
                    Vector<Field> vecFields = new Vector<Field>();
                    vecFields.addElement(new Field("InstanceID", mainInstanceID));
                    vecFields.addElement(new Field("SubLevel", SubLevel));
                    Vector<String> vecRow = new Vector<String>();
                    vecRow.addElement("PreNodeName");
                    vecRow.addElement("PreNodeID");
                    vecRow.addElement("NodeName");
                    vecRow.addElement("NodeID");
                    vecRow.addElement("NodeSign");
                    vecRow.addElement("NodeActionList");
                    vecRow.addElement("NodeRequest");
                    vecRow.addElement("NodeUserModifyType");
                    vecRow.addElement("NodeNumber");
                    vecRow.addElement("WFNodeFormID");
                    vecRow.addElement("WFNodeFormFlow");
                    vecRow.addElement("NodeRecallSet");
                    vecRow.addElement("NodeChangeSet");
                    vecRow.addElement("NodeReturnBackSet");
                    vecRow.addElement("NodeUrgeSet");
                    vecRow.addElement("NodeAnnounceSet");
                    vecRow.addElement("NodeStartTime");
                    vecRow.addElement("NodePlanEndTime");
                    vecRow.addElement("NodeAcceptTime");
                    vecRow.addElement("CurrentNodeUsers");
                    vecRow.addElement("CurrentNodeUser");
                    vecRow.addElement("CurrentNodeProcessors");
                    vecRow.addElement("PreProcessorList");
                    vecRow.addElement("IsLastUser");
                    vecData = db.performQueryHashMap("wf_instance_node_property", vecRow, "InstanceID='" + mainInstanceID + "' and NodeID='" + mainNodeID + "'", cn);
                    HashMap hm = (HashMap)vecData.elementAt(0);
                    vecFields.addElement(new Field("PreNodeName", (String)hm.get("PreNodeName")));
                    vecFields.addElement(new Field("PreNodeID", (String)hm.get("PreNodeID")));
                    vecFields.addElement(new Field("NodeName", (String)hm.get("NodeName")));
                    vecFields.addElement(new Field("NodeID", (String)hm.get("NodeID")));
                    vecFields.addElement(new Field("NodeSign", (String)hm.get("NodeSign")));
                    vecFields.addElement(new Field("NodeActionList", (String)hm.get("NodeActionList")));
                    vecFields.addElement(new Field("NodeRequest", (String)hm.get("NodeRequest")));
                    vecFields.addElement(new Field("NodeUserModifyType", (String)hm.get("NodeUserModifyType")));
                    vecFields.addElement(new Field("NodeNumber", (String)hm.get("NodeNumber")));
                    vecFields.addElement(new Field("WFNodeFormID", (String)hm.get("WFNodeFormID")));
                    vecFields.addElement(new Field("WFNodeFormFlow", (String)hm.get("WFNodeFormFlow")));
                    vecFields.addElement(new Field("NodeRecallSet", (String)hm.get("NodeRecallSet")));
                    vecFields.addElement(new Field("NodeChangeSet", (String)hm.get("NodeChangeSet")));
                    vecFields.addElement(new Field("NodeReturnBackSet", (String)hm.get("NodeReturnBackSet")));
                    vecFields.addElement(new Field("NodeUrgeSet", (String)hm.get("NodeUrgeSet")));
                    vecFields.addElement(new Field("NodeAnnounceSet", (String)hm.get("NodeAnnounceSet")));
                    vecFields.addElement(new Field("NodeStartTime", (String)hm.get("NodeStartTime")));
                    vecFields.addElement(new Field("NodePlanEndTime", (String)hm.get("NodePlanEndTime")));
                    vecFields.addElement(new Field("NodeAcceptTime", (String)hm.get("NodeAcceptTime")));
                    vecFields.addElement(new Field("CurrentNodeUsers", (String)hm.get("CurrentNodeUsers")));
                    vecFields.addElement(new Field("CurrentNodeUser", (String)hm.get("CurrentNodeUser")));
                    vecFields.addElement(new Field("CurrentNodeProcessors", (String)hm.get("CurrentNodeProcessors")));
                    vecFields.addElement(new Field("PreProcessorList", (String)hm.get("PreProcessorList")));
                    vecFields.addElement(new Field("IsLastUser", (String)hm.get("IsLastUser")));
                    db.doInsert("wf_instance_status", vecFields, cn);
                    String FirstDocUNID = WfEngine.getFirstDocUNID(subWfid);
                    VO_wf_node_property wnp2 = WFCache.getInstance().getNodeProperty(FirstDocUNID);
                    obj.setNextNodeID(FirstDocUNID);
                    obj.setNextNodeName(wnp2.NodeName);
                    vecFields = new Vector();
                    vecFields.addElement(new Field("PreNodeName", "WFBEGIN"));
                    vecFields.addElement(new Field("PreNodeID", "WFBEGIN"));
                    vecFields.addElement(new Field("NodeName", wnp2.NodeName));
                    vecFields.addElement(new Field("NodeID", FirstDocUNID));
                    vecFields.addElement(new Field("NodeSign", wnp2.NodeSign));
                    vecFields.addElement(new Field("NodeStatus", "0"));
                    vecFields.addElement(new Field("NodeActionList", ""));
                    vecFields.addElement(new Field("NodeRequest", "0"));
                    vecFields.addElement(new Field("NodeNumber", "1"));
                    vecFields.addElement(new Field("NodeRecallSet", "0"));
                    vecFields.addElement(new Field("NodeChangeSet", "0"));
                    vecFields.addElement(new Field("NodeReturnBackSet", "0"));
                    vecFields.addElement(new Field("NodeUseSubWF", "0"));
                    vecFields.addElement(new Field("NodeUrgeSet", "0"));
                    vecFields.addElement(new Field("CurrentNodeUsers", String.valueOf(subNextNodeUser) + ";"));
                    vecFields.addElement(new Field("CurrentNodeUser", String.valueOf(subNextNodeUser) + ";"));
                    vecFields.addElement(new Field("CurrentNodeProcessors", ""));
                    vecFields.addElement(new Field("PreProcessorList", CurrentUserID));
                    vecFields.addElement(new Field("IsLastUser", "1"));
                    vecFields.addElement(new Field("IsProcessed", "1"));
                    db.doUpdate("wf_instance_node_property", vecFields, "InstanceID='" + mainInstanceID + "' and NodeID='" + mainNodeID + "'", cn);
                    vecFields = new Vector();
                    vecFields.addElement(new Field("IsWFSet", "5"));
                    db.doUpdate("wf_instance_whole_property", vecFields, "InstanceID='" + mainInstanceID + "'", cn);
                    String flowTrace = "";
                    Vector vec = db.performQuery2("select FlowTrace from wf_instance_whole_property where instanceid='" + mainInstanceID + "'", cn);
                    if (vec.size() >= 0) {
                        Map mapRow = (Map)vec.elementAt(0);
                        flowTrace = (String)mapRow.get("FLOWTRACE");
                    }
                    WfTrack wt = WfTrack.getInstance();
                    VO_wf_whole_property subWwp = WFCache.getInstance().getCacheWFObj(subWfid);
                    VO_wf_node_property subNp = WFCache.getInstance().getNodeProperty(subNextNodeID);
                    String nowtime = DatetimeUtils.getNowDateTimeString();
                    String NodePlanEndTime = DatetimeUtils.convertDateTimeString(nowtime, "D3", "after");
                    HashMap<String, String> hmParam = new HashMap<String, String>();
                    hmParam.put("NodeName", wnp2.NodeName);
                    hmParam.put("NodeID", subWwp.WFFirstNodeDocID);
                    hmParam.put("errtxt", "\u65e0");
                    hmParam.put("NodeStatus", "0");
                    hmParam.put("PreNodeName", "WFBEGIN");
                    hmParam.put("NodeUserModifyType", subNp.NodeEditControl);
                    hmParam.put("NodePlanEndTime", NodePlanEndTime);
                    hmParam.put("NextNodePlanEndTime", vo.getNodePlanEndTime());
                    hmParam.put("CurrentNodeUsers", subNextNodeUser);
                    hmParam.put("CurrentNodeUser", subNextNodeUser);
                    hmParam.put("originalusers", vo.getOriginalUser());
                    hmParam.put("PreProcessorList", vo.getCurrentUserID());
                    hmParam.put("IsLastUser", "1");
                    hmParam.put("WFID", subWfid);
                    hmParam.put("WFName", subWwp.WFName);
                    hmParam.put("FlowTrace", String.valueOf(flowTrace) + ";" + FirstDocUNID);
                    hmParam.put("roleid", vo.getRoleid());
                    wt.wfTrackNextNodeRecordInitialize(mainInstanceID, FirstDocUNID, hmParam, cn);
                    String subNextNodeUserName = OrgClass.getInstance().getUserNameByUserID(subNextNodeUser, cn);
                    vo = new EVO();
                    vo.setInstanceID(mainInstanceID);
                    vo.setNodeID(mainNodeID);
                    vo.setNodeName(wnp.NodeName);
                    vo.setNextNodeID(subNextNodeID);
                    vo.setNextNodeName(subNp.NodeName);
                    vo.setNextNodeUser(subNextNodeUser);
                    vo.setCurrentUserID(CurrentUserID);
                    vo.setTip("\u5f00\u59cb\u8c03\u7528\u5b50\u6d41\u7a0b\u5904\u7406\uff0c\u4e3b\u6d41\u7a0b\u88ab\u6302\u8d77");
                    vo.setOrgid(orgid);
                    vo.setRoleid(subNodeRole == null ? "" : subNodeRole);
                    wt.wfTrackUpdateNodeReord(vo, cn);
                    vecFields = new Vector();
                    vecFields.addElement(new Field("FlowTrace", String.valueOf(flowTrace) + ";" + FirstDocUNID));
                    db.doUpdate("wf_instance_whole_property", vecFields, "InstanceID='" + mainInstanceID + "'", cn);
                    obj.setSign(0);
                    obj.setNextNodeName(subNp.NodeName);
                    obj.setNextNodeUser(subNextNodeUserName);
                    obj.setTip("\u7528\u6237\u9009\u62e9\u540c\u6b65\u5b50\u6d41\u7a0b\u63d0\u4ea4\u6210\u529f");
                } else {
                    obj.setSign(1);
                    obj.setTip("\u6d41\u7a0b\u8bbe\u7f6e\u4e0d\u5141\u8bb8\u8c03\u7528\u5b50\u6d41");
                }
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                obj.setSign(1);
                obj.setTip("\u5b50\u6d41\u7a0b\u8bbe\u7f6e\u5931\u8d25");
                WfLog.runtimeException(this, "SubFlowSetSubmit", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u5b50\u6d41\u8bbe\u7f6e\u5b8c\u6bd5SubFlowSetSubmit(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return obj;
    }

    public EVO asynSubFlowSetSubmit(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        EVO obj = new EVO();
        String mainInstanceID = vo.getMainInstanceID();
        String mainNodeID = vo.getMainNodeID();
        String bizSeqNo = vo.getBizseqno();
        String WFID = vo.getWFID();
        String CurrentUserID = vo.getCurrentUserID();
        String orgid = vo.getOrgid();
        String custID = vo.getCustID();
        String custName = vo.getCustName();
        String sysid = vo.getSysid();
        obj.setNextNodeUser(CurrentUserID);
        WfLog.log(0, "\u7528\u6237\u5f02\u6b65\u5b50\u6d41\u8bbe\u7f6e\u521d\u59cb\u5316asynSubFlowSetSubmit(),mainInstanceID:" + mainInstanceID + ";WFID:" + WFID + "; orgid:" + orgid + "; CurrentUserID:" + CurrentUserID);
        if (mainInstanceID == null || mainInstanceID.equals("") || WFID == null || WFID.equals("") || orgid == null || orgid.equals("") || CurrentUserID == null || CurrentUserID.equals("")) {
            WfLog.paramException(this, "SubFlowSetSubmit", vo);
            obj.setSign(1);
            obj.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u7528\u6237\u5f02\u6b65\u5b50\u6d41\u8bbe\u7f6e\u521d\u59cb\u5316asynSubFlowSetSubmit(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return obj;
        }
        String SqlStr = "";
        DbControl db = DbControl.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                }
                WfLog.log(2, "\u8c03\u7528\u5b50\u6d41,\u8c03\u7528\u65b9\u6cd5asynSubFlowSetSubmit(),\u4e3b\u6d41\u7a0b\u5b9e\u4f8b\u53f7\uff1a" + mainInstanceID + ",\u5f53\u524d\u673a\u6784\uff1a" + orgid + ",\u5f53\u524d\u7528\u6237\uff1a" + CurrentUserID + ",\u5b50\u6d41\u6807\u8bc6\uff1a" + WFID);
                VO_wf_node_property wnp = WFCache.getInstance().getNodeProperty(mainNodeID);
                String NodeUseSubWF = wnp.NodeUseSubWF;
                if (NodeUseSubWF != null && NodeUseSubWF.equals("2")) {
                    String nowtime = DatetimeUtils.getNowDateTimeString();
                    String NodePlanEndTime = DatetimeUtils.convertDateTimeString(nowtime, "D3", "after");
                    EVO votmp = new EVO();
                    votmp.setWFID(WFID);
                    votmp.setCurrentUserID(vo.getCurrentUserID());
                    votmp.setOrgid(orgid);
                    votmp.setBizseqno(bizSeqNo);
                    votmp.setCustID(custID);
                    votmp.setCustName(custName);
                    votmp.setMainInstanceID(mainInstanceID);
                    votmp.setMainNodeID(mainNodeID);
                    votmp.setClientSign(vo.getClientSign());
                    votmp.setSysid(vo.getSysid());
                    votmp.setAppID(vo.getAppID());
                    votmp = this.initializeWFWholeDocUNID(votmp);
                    Vector vecFields = new Vector();
                    EVO evo = new EVO();
                    evo.setInstanceID(votmp.getInstanceID());
                    evo.setInstanceID(mainInstanceID);
                    evo.setCurrentUserID(CurrentUserID);
                    evo.setNodeID(mainNodeID);
                    evo.setBizseqno(bizSeqNo);
                    evo.setConnection(cn);
                    AppExtFactory.getInstance().getAppExtClass(WFID).startSubFlowAfter(evo, null);
                    obj = votmp;
                    obj.setSign(0);
                    obj.setTip("\u5b50\u6d41\u7a0b\u8c03\u7528\u6210\u529f");
                    vo.setExs(obj.getInstanceID());
                    this.wfTrackNodeRecord(vo, cn);
                } else if (NodeUseSubWF != null && NodeUseSubWF.equals("1")) {
                    String SubLevel;
                    SqlStr = "select SubLevel from wf_instance_status where InstanceID='" + mainInstanceID + "'";
                    Vector vecData = db.performQuery(SqlStr, cn);
                    if (vecData.size() > 0) {
                        SubLevel = (String)((Vector)vecData.elementAt(0)).elementAt(0);
                        int k = Integer.parseInt(SubLevel) + 1;
                        SubLevel = String.valueOf(k);
                    } else {
                        SubLevel = "1";
                    }
                    Vector<Field> vecFields = new Vector<Field>();
                    vecFields.addElement(new Field("InstanceID", mainInstanceID));
                    vecFields.addElement(new Field("SubLevel", SubLevel));
                    Vector<String> vecRow = new Vector<String>();
                    vecRow.addElement("PreNodeName");
                    vecRow.addElement("PreNodeID");
                    vecRow.addElement("NodeName");
                    vecRow.addElement("NodeID");
                    vecRow.addElement("NodeSign");
                    vecRow.addElement("NodeActionList");
                    vecRow.addElement("NodeRequest");
                    vecRow.addElement("NodeUserModifyType");
                    vecRow.addElement("NodeNumber");
                    vecRow.addElement("WFNodeFormID");
                    vecRow.addElement("WFNodeFormFlow");
                    vecRow.addElement("NodeRecallSet");
                    vecRow.addElement("NodeChangeSet");
                    vecRow.addElement("NodeReturnBackSet");
                    vecRow.addElement("NodeUrgeSet");
                    vecRow.addElement("NodeAnnounceSet");
                    vecRow.addElement("NodeStartTime");
                    vecRow.addElement("NodePlanEndTime");
                    vecRow.addElement("NodeAcceptTime");
                    vecRow.addElement("CurrentNodeUsers");
                    vecRow.addElement("CurrentNodeUser");
                    vecRow.addElement("CurrentNodeProcessors");
                    vecRow.addElement("PreProcessorList");
                    vecRow.addElement("IsLastUser");
                    vecData = db.performQueryHashMap("wf_instance_node_property", vecRow, "InstanceID='" + mainInstanceID + "' and NodeID='" + mainNodeID + "'", cn);
                    HashMap hm = (HashMap)vecData.elementAt(0);
                    vecFields.addElement(new Field("PreNodeName", (String)hm.get("PreNodeName")));
                    vecFields.addElement(new Field("PreNodeID", (String)hm.get("PreNodeID")));
                    vecFields.addElement(new Field("NodeName", (String)hm.get("NodeName")));
                    vecFields.addElement(new Field("NodeID", (String)hm.get("NodeID")));
                    vecFields.addElement(new Field("NodeSign", (String)hm.get("NodeSign")));
                    vecFields.addElement(new Field("NodeActionList", (String)hm.get("NodeActionList")));
                    vecFields.addElement(new Field("NodeRequest", (String)hm.get("NodeRequest")));
                    vecFields.addElement(new Field("NodeUserModifyType", (String)hm.get("NodeUserModifyType")));
                    vecFields.addElement(new Field("NodeNumber", (String)hm.get("NodeNumber")));
                    vecFields.addElement(new Field("WFNodeFormID", (String)hm.get("WFNodeFormID")));
                    vecFields.addElement(new Field("WFNodeFormFlow", (String)hm.get("WFNodeFormFlow")));
                    vecFields.addElement(new Field("NodeRecallSet", (String)hm.get("NodeRecallSet")));
                    vecFields.addElement(new Field("NodeChangeSet", (String)hm.get("NodeChangeSet")));
                    vecFields.addElement(new Field("NodeReturnBackSet", (String)hm.get("NodeReturnBackSet")));
                    vecFields.addElement(new Field("NodeUrgeSet", (String)hm.get("NodeUrgeSet")));
                    vecFields.addElement(new Field("NodeAnnounceSet", (String)hm.get("NodeAnnounceSet")));
                    vecFields.addElement(new Field("NodeStartTime", (String)hm.get("NodeStartTime")));
                    vecFields.addElement(new Field("NodePlanEndTime", (String)hm.get("NodePlanEndTime")));
                    vecFields.addElement(new Field("NodeAcceptTime", (String)hm.get("NodeAcceptTime")));
                    vecFields.addElement(new Field("CurrentNodeUsers", (String)hm.get("CurrentNodeUsers")));
                    vecFields.addElement(new Field("CurrentNodeUser", (String)hm.get("CurrentNodeUser")));
                    vecFields.addElement(new Field("CurrentNodeProcessors", (String)hm.get("CurrentNodeProcessors")));
                    vecFields.addElement(new Field("PreProcessorList", (String)hm.get("PreProcessorList")));
                    vecFields.addElement(new Field("IsLastUser", (String)hm.get("IsLastUser")));
                    db.doInsert("wf_instance_status", vecFields, cn);
                    String FirstDocUNID = WfEngine.getFirstDocUNID(WFID);
                    VO_wf_node_property wnp2 = WFCache.getInstance().getNodeProperty(FirstDocUNID);
                    obj.setNextNodeID(FirstDocUNID);
                    obj.setNextNodeName(wnp2.NodeName);
                    vecFields = new Vector();
                    vecFields.addElement(new Field("PreNodeName", "WFBEGIN"));
                    vecFields.addElement(new Field("PreNodeID", "WFBEGIN"));
                    vecFields.addElement(new Field("NodeName", wnp2.NodeName));
                    vecFields.addElement(new Field("NodeID", FirstDocUNID));
                    vecFields.addElement(new Field("NodeSign", wnp2.NodeSign));
                    vecFields.addElement(new Field("NodeStatus", "0"));
                    vecFields.addElement(new Field("NodeActionList", ""));
                    vecFields.addElement(new Field("NodeRequest", "0"));
                    vecFields.addElement(new Field("NodeNumber", "1"));
                    vecFields.addElement(new Field("NodeRecallSet", "0"));
                    vecFields.addElement(new Field("NodeChangeSet", "0"));
                    vecFields.addElement(new Field("NodeReturnBackSet", "0"));
                    vecFields.addElement(new Field("NodeUseSubWF", "0"));
                    vecFields.addElement(new Field("NodeUrgeSet", "0"));
                    vecFields.addElement(new Field("CurrentNodeUsers", String.valueOf(CurrentUserID) + ";"));
                    vecFields.addElement(new Field("CurrentNodeUser", String.valueOf(CurrentUserID) + ";"));
                    vecFields.addElement(new Field("CurrentNodeProcessors", ""));
                    vecFields.addElement(new Field("PreProcessorList", CurrentUserID));
                    vecFields.addElement(new Field("IsLastUser", "1"));
                    vecFields.addElement(new Field("IsProcessed", "1"));
                    db.doUpdate("wf_instance_node_property", vecFields, "InstanceID='" + mainInstanceID + "' and NodeID='" + mainNodeID + "'", cn);
                    vecFields = new Vector();
                    vecFields.addElement(new Field("IsWFSet", "5"));
                    db.doUpdate("wf_instance_whole_property", vecFields, "InstanceID='" + mainInstanceID + "'", cn);
                    WfTrack wt = WfTrack.getInstance();
                    EVO votmp = new EVO();
                    votmp.setWFID(WFID);
                    votmp.setCurrentUserID(vo.getCurrentUserID());
                    votmp.setOrgid(orgid);
                    votmp.setBizseqno(bizSeqNo);
                    votmp.setCustID(custID);
                    votmp.setCustName(custName);
                    votmp.setMainInstanceID(mainInstanceID);
                    votmp.setMainNodeID(mainNodeID);
                    votmp.setClientSign(vo.getClientSign());
                    votmp.setSysid(vo.getSysid());
                    votmp = this.initializeWFWholeDocUNID(votmp);
                    votmp = new EVO();
                    votmp.setInstanceID(mainInstanceID);
                    votmp.setNodeID(mainNodeID);
                    votmp.setNodeName(wnp.NodeName);
                    votmp.setCurrentUserID(CurrentUserID);
                    votmp.setNextNodeUser("-");
                    votmp.setTip("\u5f00\u59cb\u8c03\u7528\u5b50\u6d41\u7a0b\u5904\u7406\uff0c\u4e3b\u6d41\u7a0b\u88ab\u6302\u8d77.");
                    votmp.setOrgid(orgid);
                    wt.wfTrackUpdateNodeReord(votmp, cn);
                    obj.setSign(0);
                    obj.setTip("\u5b50\u6d41\u7a0b\u8bbe\u7f6e\u6210\u529f");
                } else {
                    obj.setSign(1);
                    obj.setTip("\u6d41\u7a0b\u8bbe\u7f6e\u4e0d\u5141\u8bb8\u8c03\u7528\u5b50\u6d41");
                }
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                obj.setSign(1);
                obj.setTip("\u5b50\u6d41\u7a0b\u8bbe\u7f6e\u5931\u8d25");
                WfLog.runtimeException(this, "SubFlowSetSubmit", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u5b50\u6d41\u8bbe\u7f6e\u5b8c\u6bd5SubFlowSetSubmit(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return obj;
    }

    public EVO setSPStatus(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        EVO obj = new EVO();
        WfLog.log(0, "\u8bbe\u7f6e\u6d41\u7a0b\u5ba1\u6279\u72b6\u6001setSPStatus(),InstanceID:" + vo.getInstanceID() + ";SPStatus:" + vo.getSPStatus());
        if (vo.getInstanceID() == null || vo.getInstanceID().equals("") || vo.getSPStatus() == null || vo.getSPStatus().equals("")) {
            WfLog.paramException(this, "setSPStatus", vo);
            obj.setSign(1);
            obj.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u8bbe\u7f6e\u6d41\u7a0b\u5ba1\u6279\u72b6\u6001setSPStatus(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return obj;
        }
        DbControl db = DbControl.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                }
                WfLog.log(2, "\u8bbe\u7f6e\u6d41\u7a0b\u5ba1\u6279\u72b6\u6001,\u8c03\u7528\u65b9\u6cd5setSPStatus()\uff0c\u5b9e\u4f8b\u53f7\uff1a" + vo.getInstanceID());
                Vector<Field> vecFields = new Vector<Field>();
                vecFields.addElement(new Field("SPStatus", vo.getSPStatus()));
                db.doUpdate("wf_instance_whole_property", vecFields, "InstanceID='" + vo.getInstanceID() + "'", cn);
                obj.setSign(0);
                obj.setTip("\u8bbe\u7f6e\u6d41\u7a0b\u5ba1\u6279\u72b6\u6001\u6210\u529f");
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                obj.setSign(1);
                obj.setTip("\u8bbe\u7f6e\u6d41\u7a0b\u5ba1\u6279\u72b6\u6001\u5931\u8d25");
                WfLog.runtimeException(this, "setSPStatus", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u8bbe\u7f6e\u6d41\u7a0b\u5ba1\u6279\u72b6\u6001setSPStatus(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return obj;
    }

    public EVO setAppSign(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        EVO obj = new EVO();
        WfLog.log(0, "\u8bbe\u7f6e\u5e94\u7528\u6570\u636e\u6807\u8bc6setAppSign(),InstanceID:" + vo.getInstanceID() + ";AppSign:" + vo.getAppSign());
        if (vo.getInstanceID() == null || vo.getInstanceID().equals("") || vo.getAppSign() == null || vo.getAppSign().equals("")) {
            WfLog.paramException(this, "setAppSign", vo);
            obj.setSign(1);
            obj.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u8bbe\u7f6e\u5e94\u7528\u6570\u636e\u6807\u8bc6setAppSign(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return obj;
        }
        DbControl db = DbControl.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                }
                Vector<Field> vecFields = new Vector<Field>();
                vecFields.addElement(new Field("AppSign", vo.getAppSign()));
                db.doUpdate("wf_instance_whole_property", vecFields, "InstanceID='" + vo.getInstanceID() + "'", cn);
                obj.setSign(0);
                obj.setTip("\u8bbe\u7f6e\u5e94\u7528\u6570\u636e\u6807\u8bc6\u6210\u529f");
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                obj.setSign(1);
                obj.setTip("\u8bbe\u7f6e\u5e94\u7528\u6570\u636e\u6807\u8bc6\u5931\u8d25");
                WfLog.runtimeException(this, "setAppSign", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u8bbe\u7f6e\u5e94\u7528\u6570\u636e\u6807\u8bc6setAppSign(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return obj;
    }

    public String getWorkFlowVersion() {
        return "echain workflow v3.0";
    }

    public boolean ClearAllWF() {
        return WfManager.getInstance().ClearAllWF();
    }

    public boolean DelWF(String wfid) {
        return WfManager.getInstance().DelWF(wfid);
    }

    public boolean ClearAllWFInstance() {
        return WfManager.getInstance().ClearAllWFInstance();
    }

    public boolean DelInstance(String wfid) {
        return WfManager.getInstance().DelInstance(wfid);
    }

    public boolean backupWF(String orgid, String depid, String userid, String docpath) {
        return WfManager.getInstance().backupWF(orgid, depid, userid, docpath);
    }

    public boolean restoreWF(String orgid, String depid, String userid, String docpath) {
        return WfManager.getInstance().restoreWF(orgid, depid, userid, docpath);
    }

    public boolean setUserObject(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        boolean b = false;
        String InstanceID = vo.getInstanceID();
        Object uo = vo.getUserObject();
        WfLog.log(0, "setUserObject(),InstanceID:" + InstanceID);
        if (InstanceID == null || InstanceID.equals("") || InstanceID.equals("null") || uo == null) {
            WfLog.paramException(this, "setUserObject", vo);
            return b;
        }
        try {
            DbControl db = DbControl.getInstance();
            b = db.WriteBlob(InstanceID, uo);
        }
        catch (Exception e) {
            WfLog.log(4, "\u5b58\u50a8UserObject\u65f6\u53d1\u751f\u5f02\u5e38");
            e.printStackTrace();
            throw e;
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1asetUserObject(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return b;
    }

    public boolean setUserObject22(EVO vo) {
        boolean b = false;
        String InstanceID = vo.getInstanceID();
        Object uo = vo.getUserObject();
        String content = "";
        WfLog.log(0, "setUserObject(),InstanceID:" + InstanceID);
        if (InstanceID == null || InstanceID.equals("") || InstanceID.equals("null") || uo == null) {
            WfLog.paramException(this, "setUserObject", vo);
            return b;
        }
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            ObjectOutputStream oOut = new ObjectOutputStream(byteOut);
            oOut.writeObject(uo);
            oOut.flush();
            byte[] outs = byteOut.toByteArray();
            content = new BASE64Encoder().encode(outs);
            DbControl db = DbControl.getInstance();
            b = db.WriteClob(InstanceID, content);
        }
        catch (Exception e) {
            WfLog.log(4, "\u5b58\u50a8UserObject\u65f6\u53d1\u751f\u5f02\u5e38");
            e.printStackTrace();
        }
        return b;
    }

    public EVO getUserObject(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        EVO obj = new EVO();
        Object uo = null;
        String InstanceID = vo.getInstanceID();
        obj.setInstanceID(InstanceID);
        WfLog.log(0, "getUserObject(),InstanceID:" + InstanceID);
        if (InstanceID == null || InstanceID.equals("") || InstanceID.equals("null")) {
            WfLog.paramException(this, "getUserObject", vo);
            return obj;
        }
        DbControl db = DbControl.getInstance();
        try {
            uo = db.ReadBlob(InstanceID);
        }
        catch (Exception e) {
            WfLog.log(4, "\u8f6c\u6362UserObject\u683c\u5f0f\u65f6\u53d1\u751f\u5f02\u5e38");
            e.printStackTrace();
            uo = null;
            throw e;
        }
        obj.setUserObject(uo);
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1agetUserObject(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return obj;
    }

    public EVO getUserObject22(EVO vo) {
        EVO obj = new EVO();
        Object uo = null;
        String InstanceID = vo.getInstanceID();
        obj.setInstanceID(InstanceID);
        WfLog.log(0, "getUserObject(),InstanceID:" + InstanceID);
        if (InstanceID == null || InstanceID.equals("") || InstanceID.equals("null")) {
            WfLog.paramException(this, "getUserObject", vo);
            return obj;
        }
        DbControl db = DbControl.getInstance();
        try {
            String content = db.ReadClob(InstanceID);
            if (content != null && !content.equals("")) {
                ByteArrayInputStream byteIn = new ByteArrayInputStream(new BASE64Decoder().decodeBuffer(content));
                ObjectInputStream oIn = new ObjectInputStream(byteIn);
                uo = oIn.readObject();
                byteIn.close();
                oIn.close();
            }
        }
        catch (Exception e) {
            WfLog.log(4, "\u8f6c\u6362UserObject\u683c\u5f0f\u65f6\u53d1\u751f\u5f02\u5e38");
            e.printStackTrace();
            uo = null;
        }
        obj.setUserObject(uo);
        return obj;
    }

    public HashMap getWFNodeList(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        HashMap<String, String> hm = new HashMap<String, String>();
        String InstanceID = vo.getInstanceID();
        String WFID = vo.getWFID();
        WfLog.log(0, "\u83b7\u53d6\u6d41\u7a0b\u8282\u70b9\u5217\u8868getWFNodeList(),InstanceID:" + InstanceID + ";WFID:" + WFID);
        if ((InstanceID == null || InstanceID.equals("")) && (WFID == null || WFID.equals(""))) {
            WfLog.paramException(this, "getWFNodeList", vo);
            hm.put("WFEND", "\u6d41\u7a0b\u7ed3\u675f");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u83b7\u53d6\u6d41\u7a0b\u8282\u70b9\u5217\u8868getWFNodeList(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return hm;
        }
        DbControl db = DbControl.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                }
                if (WFID == null || WFID.equals("")) {
                    String SqlStr = "select WFID from wf_instance_whole_property where InstanceID='" + InstanceID + "'";
                    Vector vecData = db.performQuery(SqlStr, cn);
                    Vector vecRow = (Vector)vecData.elementAt(0);
                    WFID = (String)vecRow.elementAt(0);
                }
                VO_wf_whole_property wwp = WFCache.getInstance().getCacheWFObj(WFID);
                String NodeType = "";
                int i = 0;
                while (i < wwp.nodeList.size()) {
                    VO_wf_node_property wnp = WFCache.getInstance().getNodeProperty((String)wwp.nodeList.get(i));
                    NodeType = wnp.NodeType;
                    if (NodeType != null && NodeType.equals("A") && !"VIRTUAL_NODE".equals(wnp.NodeSign)) {
                        hm.put(wnp.NodeID, wnp.NodeName);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                WfLog.runtimeException(this, "getWFNodeList", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u83b7\u53d6\u6d41\u7a0b\u8282\u70b9\u5217\u8868getWFNodeList(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return hm;
    }

    public List getWFTreatedNodeList(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        ArrayList al = new ArrayList();
        String InstanceID = vo.getInstanceID();
        String NodeID = vo.getNodeID();
        String orgid = vo.getOrgid();
        WfLog.log(0, "\u83b7\u53d6\u6d41\u7a0b\u5df2\u529e\u7406\u8282\u70b9\u5217\u8868getWFTreatedNodeList(),InstanceID:" + InstanceID + ";NodeID:" + NodeID);
        if (InstanceID == null || InstanceID.equals("")) {
            WfLog.paramException(this, "getWFTreatedNodeList", vo);
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u83b7\u53d6\u6d41\u7a0b\u5df2\u529e\u7406\u8282\u70b9\u5217\u8868getWFTreatedNodeList(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return al;
        }
        DbControl db = DbControl.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                Vector vecRow;
                Vector vecData;
                String SqlStr;
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                }
                if (NodeID == null || NodeID.equals("")) {
                    SqlStr = "select NodeID from wf_instance_node_property where InstanceID='" + InstanceID + "'";
                    vecData = db.performQuery(SqlStr, cn);
                    vecRow = (Vector)vecData.elementAt(0);
                    NodeID = (String)vecRow.elementAt(0);
                }
                String currentnodeuserslist = WFCache.getInstance().getNodeProperty((String)NodeID).NodeUsersList;
                OrgClass orgclass = OrgClass.getInstance();
                HashMap<String, String> hmtmp = new HashMap<String, String>();
                SqlStr = "select NodeID,NodeName,NodeNumber,CurrentNodeUser from wf_node_record where InstanceID='" + InstanceID + "' order by nodestarttime";
                vecData = db.performQuery(SqlStr, cn);
                int i = 0;
                while (i < vecData.size()) {
                    block22: {
                        HashMap<String, String> hm;
                        String nodeid;
                        block24: {
                            String username;
                            String userid;
                            block23: {
                                vecRow = (Vector)vecData.elementAt(i);
                                nodeid = (String)vecRow.elementAt(0);
                                if (hmtmp.get(nodeid) != null) break block22;
                                hm = new HashMap<String, String>();
                                hm.put("nodeid", nodeid);
                                hm.put("nodename", (String)vecRow.elementAt(1));
                                hm.put("currentnodeuserslist", currentnodeuserslist);
                                hm.put("nodeuserslist", WFCache.getInstance().getNodeProperty((String)nodeid).NodeUsersList);
                                String NodeNumber = (String)vecRow.elementAt(2);
                                if (NodeNumber != null && !NodeNumber.equals("1")) break block23;
                                userid = (String)vecRow.elementAt(3);
                                hm.put("userid", userid);
                                if (userid == null || userid.length() <= 0) break block24;
                                if (userid.startsWith("T.")) break block22;
                                if (userid.indexOf(";") != -1) {
                                    username = "";
                                    StringTokenizer st = new StringTokenizer(userid, ";");
                                    while (st.hasMoreElements()) {
                                        username = String.valueOf(username) + ";" + orgclass.getNameByID(orgid, "U." + st.nextElement(), cn);
                                    }
                                    username = username.substring(1);
                                    hm.put("username", username);
                                } else {
                                    hm.put("username", orgclass.getNameByID(orgid, "U." + userid, cn));
                                }
                                break block24;
                            }
                            userid = "";
                            username = "";
                            Vector v = db.performQuery("select distinct TransActor,ActionName from wf_node_action_record where InstanceID='" + InstanceID + "' and NodeID='" + nodeid + "'", cn);
                            int j = 0;
                            while (j < v.size()) {
                                Vector vr = (Vector)v.elementAt(j);
                                String s = (String)vr.elementAt(0);
                                String ActionName = (String)vr.elementAt(1);
                                if (ActionName == null || ActionName.indexOf("\u91cd\u7f6e\u5f53\u524d\u8282\u70b9\u529e\u7406\u4eba") == -1) {
                                    userid = String.valueOf(userid) + ";" + s;
                                    username = String.valueOf(username) + ";" + orgclass.getNameByID(orgid, "U." + s, cn);
                                }
                                ++j;
                            }
                            if (userid.length() > 0) {
                                userid = userid.substring(1);
                                username = username.substring(1);
                            }
                            userid = StringUtils.delSameElement(userid, ";");
                            username = StringUtils.delSameElement(username, ";");
                            hm.put("userid", userid);
                            hm.put("username", username);
                        }
                        hmtmp.put(nodeid, "1");
                        al.add(hm);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                WfLog.runtimeException(this, "getWFTreatedNodeList", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u83b7\u53d6\u6d41\u7a0b\u5df2\u529e\u7406\u8282\u70b9\u5217\u8868getWFTreatedNodeList(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return al;
    }

    public boolean acceptAndAutoSign(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        String InstanceID = vo.getInstanceID();
        String CurrentUserID = vo.getCurrentUserID();
        String NodeID = vo.getNodeID();
        WfLog.log(0, "\u66f4\u65b0\u53d7\u7406\u65f6\u95f4\u548c\u81ea\u52a8\u7b7e\u6536\u64cd\u4f5cacceptAndAutoSign() InstanceID:" + InstanceID + " CurrentUserID:" + CurrentUserID);
        if (InstanceID == null || InstanceID.equals("")) {
            WfLog.log(4, "\u66f4\u65b0\u53d7\u7406\u65f6\u95f4\u548c\u81ea\u52a8\u7b7e\u6536\u64cd\u4f5cacceptAndAutoSign()\u51fa\u9519\uff0c\u6d41\u7a0b\u5b9e\u4f8b\u53f7\u4e3a\u7a7a!~");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u66f4\u65b0\u53d7\u7406\u65f6\u95f4\u548c\u81ea\u52a8\u7b7e\u6536\u64cd\u4f5cacceptAndAutoSign(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return false;
        }
        DbControl db = DbControl.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                    vo.setConnection(cn);
                }
                WfEngine we = WfEngine.getInstance();
                String SqlStr = "select NodeID,NodeStatus,CurrentNodeUsers,CurrentNodeUser,NodeAcceptTime from wf_worklist where InstanceID='" + InstanceID + "'";
                if (!(NodeID == null || NodeID.equals("") || NodeID.equals("-") || NodeID.equals("null"))) {
                    SqlStr = String.valueOf(SqlStr) + " and NodeID='" + NodeID + "'";
                }
                Vector vecData = db.performQuery(SqlStr, cn);
                String nodestatus = null;
                String currentnodeusers = null;
                String currentnodeuser = null;
                String NodeAcceptTime = null;
                if (vecData != null && vecData.size() > 0) {
                    Vector vecRow = (Vector)vecData.elementAt(0);
                    NodeID = (String)vecRow.elementAt(0);
                    nodestatus = (String)vecRow.elementAt(1);
                    currentnodeusers = (String)vecRow.elementAt(2);
                    currentnodeuser = (String)vecRow.elementAt(3);
                    NodeAcceptTime = ((String)vecRow.elementAt(4)).trim();
                }
                if (nodestatus != null && nodestatus.equals("3")) {
                    if (WfPropertyManager.getInstance().autoSignIn && currentnodeusers != null && StringUtils.isPartOf(currentnodeusers, CurrentUserID, ";")) {
                        we.instanceSignIn(vo, cn);
                    }
                } else if (nodestatus != null && nodestatus.equals("0")) {
                    if (WfPropertyManager.getInstance().autoSignIn && currentnodeuser != null && StringUtils.isPartOf(currentnodeuser, CurrentUserID, ";")) {
                        db.performSql("update wf_instance_node_property set CurrentNodeUser='" + CurrentUserID + ";' where InstanceID='" + InstanceID + "' and NodeID='" + NodeID + "' and NodeTransactType='1' and IsLastUser='1'", cn);
                    }
                    if ((NodeAcceptTime == null || NodeAcceptTime.equals("-")) && currentnodeuser != null && StringUtils.isPartOf(currentnodeuser, CurrentUserID, ";")) {
                        NodeAcceptTime = DatetimeUtils.getNowDateTimeString();
                        db.performSql("update wf_instance_node_property set NodeAcceptTime='" + NodeAcceptTime + "' where InstanceID='" + InstanceID + "' and NodeID='" + NodeID + "'", cn);
                    }
                }
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                WfLog.runtimeException(this, "getInstanceInfo", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u53d6\u5f97\u5b9e\u4f8b\u76f8\u5173\u5c5e\u6027getInstanceInfo(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return true;
    }

    public EVO getInstanceInfo(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        String InstanceID = vo.getInstanceID();
        String CurrentUserID = vo.getCurrentUserID();
        String wfid = null;
        String NodeID = vo.getNodeID();
        String formid = vo.getFormid();
        String WFSign = vo.getWFSign();
        String orgid = vo.getOrgid();
        WfLog.log(0, "\u53d6\u5f97\u5b9e\u4f8b\u76f8\u5173\u5c5e\u6027getInstanceInfo(),InstanceID:" + InstanceID + ";CurrentUserID:" + CurrentUserID + "; NodeID:" + NodeID);
        if (InstanceID == null || InstanceID.equals("")) {
            WfLog.paramException(this, "getInstanceInfo", vo);
            vo.setSign(1);
            vo.setTip("\u65e0\u6548\u7684\u53c2\u6570");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u53d6\u5f97\u5b9e\u4f8b\u76f8\u5173\u5c5e\u6027getInstanceInfo(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return vo;
        }
        DbControl db = DbControl.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                String getinstanceinfoif;
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                    vo.setConnection(cn);
                }
                WfEngine we = WfEngine.getInstance();
                String SqlStr = "select WFID,WFName,WFSign,WFAppID,WFAppName,WFJobName,WFStartTime,AppSign,SPStatus,formdata,PreNodeID,PreNodeName,NodeID,NodeName,WFStatus,NodeStatus,WFNodeFormID,WFNodeFormFlow,CurrentNodeUsers,CurrentNodeUser,Author,PreProcessorList,NodeStartTime,NodeAcceptTime,NodePlanEndTime,bDraft,IsProcessed,Orgid,BizSeqno,Sysid,CustId,CustName,isNextNodeModi,MainInstanceId,MainNodeId,NodeOrgid,AllProcessor,WFPlanEndTime from wf_worklist where InstanceID='" + InstanceID + "'";
                if (!(NodeID == null || NodeID.equals("") || NodeID.equals("-") || NodeID.equals("null"))) {
                    SqlStr = String.valueOf(SqlStr) + " and NodeID='" + NodeID + "'";
                }
                Vector vecData = db.performQuery(SqlStr, cn);
                String formdata = "";
                String nodestatus = null;
                String wfstatus = null;
                String currentnodeusers = null;
                String currentnodeuser = null;
                String NodeAcceptTime = null;
                if (vecData == null || vecData.isEmpty()) {
                    vecData = db.performQuery("select WFID,WFName,WFSign,WFJobName,WFStartTime,WFAppID,FormID,FormFlow,Orgid,FormData,BizSeqno,Sysid,CustId,CustName,spStatus,MainInstanceId,MainNodeId,WFEndTime,WFPlanEndTime  from wf_instance_end where InstanceID='" + InstanceID + "'", cn);
                    if (vecData != null && vecData.size() > 0) {
                        Vector vecRow = (Vector)vecData.elementAt(0);
                        wfid = (String)vecRow.elementAt(0);
                        vo.setWFID(wfid);
                        vo.setWFName((String)vecRow.elementAt(1));
                        WFSign = (String)vecRow.elementAt(2);
                        vo.setWFSign(WFSign);
                        vo.setJobName((String)vecRow.elementAt(3) == null ? "-" : (String)vecRow.elementAt(3));
                        vo.setWFStartTime((String)vecRow.elementAt(4));
                        vo.setAppID((String)vecRow.elementAt(5));
                        vo.setFormid((String)vecRow.elementAt(6));
                        vo.setFormflow((String)vecRow.elementAt(7));
                        if (orgid == null || orgid.equals("")) {
                            orgid = (String)vecRow.elementAt(8);
                            vo.setOrgid(orgid);
                        }
                        formdata = vecRow.elementAt(9) == null ? "" : ((String)vecRow.elementAt(9)).trim();
                        vo.setBizseqno((String)vecRow.get(10));
                        vo.setSysid((String)vecRow.get(11));
                        vo.setCustID((String)vecRow.get(12));
                        vo.setCustName((String)vecRow.get(13));
                        vo.setSPStatus(vecRow.elementAt(14) == null ? "" : (String)vecRow.elementAt(14));
                        vo.setMainInstanceID(vecRow.elementAt(15) == null ? "" : (String)vecRow.elementAt(15));
                        vo.setMainNodeID(vecRow.elementAt(16) == null ? "" : (String)vecRow.elementAt(16));
                        vo.setWFEndTime(vecRow.elementAt(17) == null ? "" : (String)vecRow.elementAt(17));
                        vo.setWFPlanEndTime(vecRow.elementAt(18) == null ? "" : (String)vecRow.elementAt(18));
                        wfstatus = "1";
                        vo.setWFStatus("1");
                        vo.setNodeName("\u7ed3\u675f");
                        vo.setNodeStatus("2");
                    }
                } else if (vecData != null && vecData.size() > 0) {
                    Vector vecRow = (Vector)vecData.elementAt(0);
                    wfid = (String)vecRow.elementAt(0);
                    vo.setWFID(wfid);
                    vo.setWFName((String)vecRow.elementAt(1) == null ? "-" : (String)vecRow.elementAt(1));
                    WFSign = (String)vecRow.elementAt(2);
                    vo.setWFSign(WFSign);
                    vo.setAppID((String)vecRow.elementAt(3));
                    vo.setAppName((String)vecRow.elementAt(4) == null ? "-" : (String)vecRow.elementAt(4));
                    vo.setJobName((String)vecRow.elementAt(5) == null ? "-" : (String)vecRow.elementAt(5));
                    vo.setWFStartTime((String)vecRow.elementAt(6));
                    vo.setAppSign((String)vecRow.elementAt(7));
                    vo.setSPStatus((String)vecRow.elementAt(8));
                    formdata = vecRow.elementAt(9) == null ? "" : ((String)vecRow.elementAt(9)).trim();
                    vo.setPreNodeID((String)vecRow.elementAt(10));
                    vo.setPreNodeName((String)vecRow.elementAt(11) == null ? "-" : (String)vecRow.elementAt(11));
                    NodeID = (String)vecRow.elementAt(12);
                    vo.setNodeID(NodeID);
                    vo.setNodeName((String)vecRow.elementAt(13) == null ? "-" : (String)vecRow.elementAt(13));
                    wfstatus = (String)vecRow.elementAt(14);
                    vo.setWFStatus(wfstatus);
                    nodestatus = (String)vecRow.elementAt(15);
                    vo.setNodeStatus(nodestatus);
                    formid = (String)vecRow.elementAt(16);
                    vo.setFormid(formid);
                    vo.setFormflow((String)vecRow.elementAt(17));
                    currentnodeusers = (String)vecRow.elementAt(18);
                    currentnodeuser = (String)vecRow.elementAt(19);
                    vo.setCurrentNodeUser(currentnodeuser);
                    vo.setAuthor((String)vecRow.elementAt(20));
                    vo.setPreUser((String)vecRow.elementAt(21));
                    vo.setNodeStartTime((String)vecRow.elementAt(22) == null ? "-" : (String)vecRow.elementAt(22));
                    NodeAcceptTime = ((String)vecRow.elementAt(23)).trim();
                    vo.setNodePlanEndTime((String)vecRow.elementAt(24) == null ? "-" : (String)vecRow.elementAt(24));
                    vo.setIsDraft((String)vecRow.elementAt(25));
                    vo.setIsProcessed((String)vecRow.elementAt(26));
                    if (orgid == null || orgid.equals("")) {
                        orgid = (String)vecRow.elementAt(27);
                        vo.setOrgid(orgid);
                    }
                    vo.setBizseqno((String)vecRow.get(28));
                    vo.setSysid((String)vecRow.get(29));
                    vo.setCustID((String)vecRow.get(30));
                    vo.setCustName((String)vecRow.get(31));
                    vo.setIsNextNodeModi((String)vecRow.get(32));
                    vo.setMainInstanceID((String)vecRow.get(33));
                    vo.setMainNodeID((String)vecRow.get(34));
                    vo.setNodeorgid((String)vecRow.get(35));
                    vo.setAllProcessor((String)vecRow.get(36));
                    vo.setWFPlanEndTime((String)vecRow.get(37));
                    vo.paramMap.put("getWFNodeExtProperties", this.getWFNodeExtProperties(NodeID));
                }
                if ((getinstanceinfoif = WfPropertyManager.getInstance().getinstanceinfoif).indexOf("getNodeFormData") != -1) {
                    HashMap paramMap = StringUtils.convertStrToHashMap(formdata);
                    vo.paramMap.put("getNodeFormData", paramMap);
                }
                if (wfstatus != null && !wfstatus.equals("1")) {
                    if (getinstanceinfoif.indexOf("getNextNodeList") != -1) {
                        try {
                            vo.paramMap.put("getNextNodeList", we.getNextNodeList(vo, cn));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (getinstanceinfoif.indexOf("getNodeControlFormField") != -1) {
                        vo.paramMap.put("getNodeControlFormField", we.getNodeControlFormField(vo, cn));
                    }
                } else {
                    if (getinstanceinfoif.indexOf("getNextNodeList") != -1) {
                        vo.paramMap.put("getNextNodeList", new EVO());
                    }
                    if (getinstanceinfoif.indexOf("getNodeControlFormField") != -1) {
                        vo.paramMap.put("getNodeControlFormField", new HashMap());
                    }
                }
                if (getinstanceinfoif.indexOf("getNodeControlFormAction") != -1) {
                    vo.paramMap.put("getNodeControlFormAction", we.getNodeControlFormAction(vo, cn));
                }
                vo.paramMap.put("getWFExtProperties", this.getWFExtProperties(wfid));
                vo.setSign(0);
                vo.setTip("\u83b7\u53d6\u5b9e\u4f8b\u76f8\u5173\u5c5e\u6027\u6210\u529f");
                AppExtFactory.getInstance().getAppExtClass(wfid).getInstanceInfo(vo, null);
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                WfLog.runtimeException(this, "getInstanceInfo", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u53d6\u5f97\u5b9e\u4f8b\u76f8\u5173\u5c5e\u6027getInstanceInfo(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return vo;
    }

    public EVO initializeWFWholeDocUNID(EVO vo) throws Exception {
        WfEngine we = WfEngine.getInstance();
        return we.initializeWFWholeDocUNID(vo);
    }

    public Vector getWorkFlowHistory(EVO vo) throws Exception {
        WfTrack wt = WfTrack.getInstance();
        return wt.getWorkFlowHistory(vo);
    }

    public void sendMail(String sender, String sendto, String content, String orgid, Map paramMap) {
        MsgFactory mf = new MsgFactory("2", sender, sendto, content, orgid, paramMap);
        mf.start();
    }

    public void sendSMS(String sender, String sendto, String content, String orgid, Map paramMap) {
        MsgFactory mf = new MsgFactory("3", sender, sendto, content, orgid, paramMap);
        mf.start();
    }

    public EVO resetUrgentTreat(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        String InstanceID = vo.getInstanceID();
        String WFPlanEndTime = vo.getWFPlanEndTime();
        if (InstanceID == null || InstanceID.equals("") || WFPlanEndTime == null || WFPlanEndTime.equals("") || WFPlanEndTime.length() > 19) {
            vo.setSign(1);
            vo.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u91cd\u7f6e\u6d41\u7a0b\u8fc7\u671f\u5904\u7406resetUrgentTreat(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return vo;
        }
        DbControl db = DbControl.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                }
                if (WFPlanEndTime.length() < 5) {
                    String nowtime = DatetimeUtils.getNowDateTimeString();
                    WFPlanEndTime = DatetimeUtils.convertDateTimeString(nowtime, WFPlanEndTime, "after");
                }
                Vector<Field> vecFields = new Vector<Field>();
                vecFields.addElement(new Field("WFNotificationTime", WFPlanEndTime));
                db.doUpdate("wf_main_record", vecFields, "InstanceID='" + InstanceID + "'", cn);
                vo.setSign(0);
                vo.setTip("\u91cd\u7f6e\u6d41\u7a0b\u8fc7\u671f\u5904\u7406\u6210\u529f!");
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                vo.setSign(1);
                vo.setTip("\u91cd\u7f6e\u6d41\u7a0b\u8fc7\u671f\u5904\u7406\u5931\u8d25!" + e.toString());
                WfLog.runtimeException(this, "resetUrgentTreat", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u91cd\u7f6e\u6d41\u7a0b\u8fc7\u671f\u5904\u7406resetUrgentTreat(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return vo;
    }

    public EVO instanceSignIn(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        String CurrentUserID = vo.getCurrentUserID();
        WfLog.log(0, "\u5b9e\u4f8b\u7b7e\u6536instanceSignIn(),InstanceID:" + vo.getInstanceID() + ";CurrentUserID:" + CurrentUserID);
        if (CurrentUserID == null || CurrentUserID.equals("")) {
            vo.setSign(1);
            vo.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u5b9e\u4f8b\u7b7e\u6536instanceSignIn(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return vo;
        }
        DbControl db = DbControl.getInstance();
        WfEngine we = WfEngine.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                    vo.setConnection(cn);
                }
                vo = we.instanceSignIn(vo, cn);
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                WfLog.runtimeException(this, "instanceSignIn", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u5b9e\u4f8b\u7b7e\u6536instanceSignIn(),InstanceID:" + vo.getInstanceID() + ";\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return vo;
    }

    public List batchInstanceSignIn(List list) throws Exception {
        long dst = System.currentTimeMillis();
        ArrayList<EVO> al = new ArrayList<EVO>();
        WfLog.log(0, "\u6279\u91cf\u5b9e\u4f8b\u7b7e\u6536batchInstanceSignIn()");
        DbControl db = DbControl.getInstance();
        WfEngine we = WfEngine.getInstance();
        Connection cn = null;
        try {
            try {
                cn = db.getConnection();
                int i = 0;
                while (i < list.size()) {
                    EVO vo = (EVO)list.get(i);
                    if (vo != null) {
                        String InstanceID = vo.getInstanceID();
                        String CurrentUserID = vo.getCurrentUserID();
                        WfLog.log(0, "\u5904\u7406\u6279\u91cf\u5b9e\u4f8b\u7b7e\u6536\uff0c\u5f53\u524d\u7528\u6237\uff1a" + CurrentUserID + ";\u5b9e\u4f8b\u53f7\uff1a" + InstanceID);
                        if (InstanceID == null || CurrentUserID == null || InstanceID.equals("") || CurrentUserID.equals("")) {
                            vo.setSign(1);
                            vo.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
                        } else {
                            vo = we.instanceSignIn(vo, cn);
                        }
                        al.add(vo);
                    }
                    ++i;
                }
                if (!WfPropertyManager.getInstance().autocommit) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                WfLog.runtimeException(this, "batchInstanceSignIn", e);
                throw e;
            }
        }
        finally {
            if (cn != null) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u6279\u91cf\u5b9e\u4f8b\u7b7e\u6536batchInstanceSignIn(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return al;
    }

    public EVO instanceSignOff(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        String InstanceID = vo.getInstanceID();
        String CurrentUserID = vo.getCurrentUserID();
        WfLog.log(0, "\u5b9e\u4f8b\u64a4\u9500\u7b7e\u6536instanceSignOff(),InstanceID:" + InstanceID + ";CurrentUserID:" + CurrentUserID);
        if (InstanceID == null || InstanceID.equals("") || CurrentUserID == null || CurrentUserID.equals("")) {
            vo.setSign(1);
            vo.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u5b9e\u4f8b\u64a4\u9500\u7b7e\u6536instanceSignOff(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return vo;
        }
        DbControl db = DbControl.getInstance();
        WfEngine we = WfEngine.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                    vo.setConnection(cn);
                }
                vo = we.instanceSignOff(vo, cn);
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                WfLog.runtimeException(this, "instanceSignOff", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u5b9e\u4f8b\u64a4\u9500\u7b7e\u6536instanceSignOff(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return vo;
    }

    public EVO taskSignIn(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        String CurrentUserID = vo.getCurrentUserID();
        WfLog.log(0, "\u4efb\u52a1\u8ba4\u9886taskSignIn(),InstanceID:" + vo.getInstanceID() + ";CurrentUserID:" + CurrentUserID);
        if (CurrentUserID == null || CurrentUserID.equals("")) {
            vo.setSign(1);
            vo.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u4efb\u52a1\u8ba4\u9886taskSignIn()\u5931\u8d25,\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return vo;
        }
        DbControl db = DbControl.getInstance();
        WfEngine we = WfEngine.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                }
                vo = we.taskSignIn(vo, cn);
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                WfLog.runtimeException(this, "taskSignIn", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u4efb\u52a1\u8ba4\u9886taskSignIn(),InstanceID:" + vo.getInstanceID() + ";\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return vo;
    }

    public EVO taskSignOff(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        String InstanceID = vo.getInstanceID();
        String CurrentUserID = vo.getCurrentUserID();
        WfLog.log(0, "\u64a4\u9500\u4efb\u52a1\u8ba4\u9886taskSignOff(),InstanceID:" + InstanceID + ";CurrentUserID:" + CurrentUserID);
        if (InstanceID == null || InstanceID.equals("") || CurrentUserID == null || CurrentUserID.equals("")) {
            vo.setSign(1);
            vo.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u64a4\u9500\u4efb\u52a1\u8ba4\u9886taskSignOff()\u5931\u8d25,\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return vo;
        }
        DbControl db = DbControl.getInstance();
        WfEngine we = WfEngine.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                }
                vo = we.taskSignOff(vo, cn);
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                WfLog.runtimeException(this, "taskSignOff", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u64a4\u9500\u4efb\u52a1\u8ba4\u9886taskSignOff(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return vo;
    }

    public String createEasyWF(EVO vo) throws Exception {
        return WfManager.getInstance().createEasyWF(vo);
    }

    public boolean hangupEasyWF(EVO vo) throws Exception {
        return WfManager.getInstance().hangupEasyWF(vo);
    }

    public Map getWFExtProperties(String wfid) throws Exception {
        if (wfid == null || wfid.equals("")) {
            return new HashMap();
        }
        return WFCache.getInstance().getCacheWFObj((String)wfid).hmAppExtProperty;
    }

    public Map getWFNodeExtProperties(String nodeid) throws Exception {
        if (nodeid == null || nodeid.equals("") || nodeid.equals("-")) {
            return new HashMap();
        }
        return WFCache.getInstance().getNodeProperty((String)nodeid).hmAppExtProperty;
    }

    public EVO resetCurrentNodeUser(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        EVO obj = new EVO();
        DbControl db = DbControl.getInstance();
        WfTrack wt = WfTrack.getInstance();
        String InstanceID = vo.getInstanceID();
        String NodeID = vo.getNodeID();
        String CurrentUserID = vo.getCurrentUserID();
        String CurrentNodeUser = vo.getCurrentNodeUser();
        WfLog.log(0, "\u91cd\u7f6e\u5f53\u524d\u8282\u70b9\u529e\u7406\u4eba,InstanceID:" + InstanceID + ";CurrentUserID:" + CurrentUserID + ";NodeID:" + NodeID + ";CurrentNodeUser:" + CurrentNodeUser);
        if (InstanceID == null || NodeID == null || InstanceID.equals("") || NodeID.equals("") || CurrentNodeUser == null || CurrentNodeUser.equals("") || CurrentUserID == null || CurrentUserID.equals("")) {
            WfLog.paramException(this, "resetCurrentNodeUser", vo);
            obj.setSign(1);
            obj.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u91cd\u7f6e\u5f53\u524d\u8282\u70b9\u529e\u7406\u4ebaresetCurrentNodeUser()\u5931\u8d25,\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return obj;
        }
        Connection cn = null;
        boolean bClose = true;
        OrgClass orgclass = OrgClass.getInstance();
        try {
            try {
                Vector<Field> vecFields;
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                    vo.setConnection(cn);
                }
                if (vo.getCommentVO() != null && vo.getCommentVO().getCommentContent() != null) {
                    WfEngine.getInstance().setComment(vo.getCommentVO(), cn);
                }
                String SqlStr = "select a.IsWFSet,a.WFID,a.WFName,a.WFAppID,a.orgid,b.NodeName,b.AllProcessor,b.AllReadersList,b.CurrentNodeUsers,b.CurrentNodeUser from wf_instance_whole_property a,wf_instance_node_property b where a.InstanceID=b.InstanceID and a.InstanceID='" + InstanceID + "' and b.NodeID='" + NodeID + "'";
                Vector vecData = db.performQuery(SqlStr, cn);
                Vector vecRow = (Vector)vecData.elementAt(0);
                String IsWFSet = (String)vecRow.elementAt(0);
                String wfid = (String)vecRow.elementAt(1);
                vo.setWFID(wfid);
                String WFName = (String)vecRow.elementAt(2);
                String WFAppID = (String)vecRow.elementAt(3);
                String orgid = (String)vecRow.elementAt(4);
                String NodeName = (String)vecRow.elementAt(5);
                obj.setNextNodeName(NodeName);
                vo.setOrgid(orgid);
                if (IsWFSet.equals("2")) {
                    EVO votmp = new EVO();
                    votmp.setInstanceID(InstanceID);
                    votmp.setNodeID(NodeID);
                    votmp.setNodeName(NodeName);
                    votmp.setNextNodeID(NodeID);
                    votmp.setNextNodeName(NodeName);
                    votmp.setCurrentUserID(CurrentUserID);
                    votmp.setNextNodeUser(CurrentNodeUser);
                    votmp.setTip("\u91cd\u7f6e\u5f53\u524d\u8282\u70b9\u529e\u7406\u4eba\uff0c\u6587\u6863\u8f6c\u4ea4 " + orgclass.getUserNameByUserID(CurrentNodeUser, cn) + " \u529e\u7406");
                    votmp.setOrgid(orgid);
                    wt.wfTrackUpdateNodeReord(votmp, cn);
                    vecFields = new Vector();
                    vecFields.addElement(new Field("CurrentNodeUsers", String.valueOf(CurrentNodeUser) + ";"));
                    vecFields.addElement(new Field("CurrentNodeUser", CurrentNodeUser));
                    db.doUpdate("wf_node_record", vecFields, "InstanceID='" + InstanceID + "' and NodeID='" + NodeID + "'", cn);
                }
                String AllProcessor = vecRow.elementAt(6) == null ? "" : ((String)vecRow.elementAt(6)).trim();
                AllProcessor = String.valueOf(AllProcessor) + ";" + CurrentUserID;
                String AllReadersList = vecRow.elementAt(7) == null ? CurrentNodeUser : String.valueOf(((String)vecRow.elementAt(7)).trim()) + ";" + CurrentNodeUser;
                vecFields = new Vector<Field>();
                vecFields.addElement(new Field("AllProcessor", String.valueOf(StringUtils.delSameElement(AllProcessor, ";")) + ";"));
                vecFields.addElement(new Field("AllReadersList", String.valueOf(AllReadersList) + ";"));
                vecFields.addElement(new Field("CurrentNodeUsers", String.valueOf(CurrentNodeUser) + ";"));
                vecFields.addElement(new Field("CurrentNodeUser", String.valueOf(CurrentNodeUser) + ";"));
                vecFields.addElement(new Field("IsProcessed", "1"));
                vecFields.addElement(new Field("IsLastUser", "1"));
                db.doUpdate("wf_instance_node_property", vecFields, "InstanceID='" + InstanceID + "' and NodeID='" + NodeID + "'", cn);
                obj.setSign(0);
                obj.setTip("\u6267\u884c\u91cd\u7f6e\u5f53\u524d\u8282\u70b9\u529e\u7406\u4ebaresetCurrentNodeUser()\u64cd\u4f5c\u6210\u529f\uff0c\u5f53\u524d\u7528\u6237\uff1a" + CurrentUserID + ",\u5b9e\u4f8b\u53f7\uff1a" + InstanceID + "\u63d0\u4ea4\u529e\u7406\u4eba\uff1a" + CurrentNodeUser + ",\u6240\u5c5e\u5e94\u7528\uff1a" + WFAppID);
                WfLog.log(2, "\u91cd\u7f6e\u5f53\u524d\u8282\u70b9\u529e\u7406\u4eba,\u8c03\u7528\u65b9\u6cd5resetCurrentNodeUser(),\u5f53\u524d\u7528\u6237\uff1a" + CurrentUserID + ",\u5b9e\u4f8b\u53f7\uff1a" + InstanceID + ",\u63d0\u4ea4\u529e\u7406\u4eba\uff1a" + CurrentNodeUser + ",\u6240\u5c5e\u5e94\u7528\uff1a" + WFAppID);
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                obj.setSign(1);
                obj.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u63a7\u5236\u53f0\u5f02\u5e38\u4fe1\u606f\u5e76\u4e0e\u6d41\u7a0b\u7ba1\u7406\u5458\u53d6\u5f97\u8054\u7cfb\uff01");
                WfLog.runtimeException(this, "resetCurrentNodeUser", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u91cd\u7f6e\u5f53\u524d\u8282\u70b9\u529e\u7406\u4ebaresetCurrentNodeUser()\u6210\u529f,\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return obj;
    }

    public EVO getPreNodeUser(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        DbControl db = DbControl.getInstance();
        String InstanceID = vo.getInstanceID();
        String NodeID = vo.getNodeID();
        WfLog.log(0, "\u83b7\u53d6\u4e0a\u4e00\u8282\u70b9\u529e\u7406\u4eba,InstanceID:" + InstanceID + ";NodeID:" + NodeID);
        if (InstanceID == null || NodeID == null || InstanceID.equals("") || NodeID.equals("")) {
            WfLog.paramException(this, "getPreNodeUser", vo);
            vo.setSign(1);
            vo.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u83b7\u53d6\u4e0a\u4e00\u8282\u70b9\u529e\u7406\u4ebagetPreNodeUser()\u5931\u8d25,\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return vo;
        }
        Connection cn = null;
        boolean bClose = true;
        OrgClass orgclass = OrgClass.getInstance();
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                }
                Vector vecData = db.performQuery("select PreProcessorList from wf_node_record where InstanceID='" + InstanceID + "' and NodeID='" + NodeID + "'", cn);
                if (vecData != null && vecData.size() > 0) {
                    Vector vecRow = (Vector)vecData.elementAt(0);
                    vo.setUserID((String)vecRow.elementAt(0));
                }
                vo.setSign(0);
                vo.setTip("\u83b7\u53d6\u4e0a\u4e00\u8282\u70b9\u529e\u7406\u4ebagetPreNodeUser()\u64cd\u4f5c\u6210\u529f");
            }
            catch (Exception e) {
                vo.setSign(1);
                vo.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u63a7\u5236\u53f0\u5f02\u5e38\u4fe1\u606f\u5e76\u4e0e\u6d41\u7a0b\u7ba1\u7406\u5458\u53d6\u5f97\u8054\u7cfb\uff01");
                WfLog.runtimeException(this, "getPreNodeUser", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u83b7\u53d6\u4e0a\u4e00\u8282\u70b9\u529e\u7406\u4ebagetPreNodeUser()\u6210\u529f,\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return vo;
    }

    public EVO resetBizseqno(EVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        EVO obj = new EVO();
        DbControl db = DbControl.getInstance();
        String InstanceID = vo.getInstanceID();
        String CurrentUserID = vo.getCurrentUserID();
        String bizseqno = vo.getBizseqno();
        WfLog.log(0, "\u91cd\u7f6e\u4e1a\u52a1\u6d41\u6c34\u53f7,InstanceID:" + InstanceID + ";CurrentUserID=" + CurrentUserID + ";bizseqno:" + bizseqno);
        if (InstanceID == null || InstanceID.equals("") || bizseqno == null || bizseqno.equals("") || CurrentUserID == null || CurrentUserID.equals("")) {
            WfLog.paramException(this, "resetBizseqno", vo);
            obj.setSign(1);
            obj.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u91cd\u7f6e\u4e1a\u52a1\u6d41\u6c34\u53f7resetBizseqno()\u5931\u8d25,\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return obj;
        }
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                }
                String sql = "update wf_instance_whole_property set bizseqno='" + bizseqno + "'";
                if (vo.getCustID() != null && vo.getCustID().length() > 0) {
                    sql = String.valueOf(sql) + ",custID='" + vo.getCustID() + "'";
                }
                if (vo.getCustName() != null && vo.getCustName().length() > 0) {
                    sql = String.valueOf(sql) + ",custName='" + vo.getCustName() + "'";
                }
                sql = String.valueOf(sql) + " where InstanceID='" + InstanceID + "'";
                db.performSql(sql, cn);
                obj.setSign(0);
                obj.setTip("\u6267\u884c\u91cd\u7f6e\u4e1a\u52a1\u6d41\u6c34\u53f7resetBizseqno()\u64cd\u4f5c\u6210\u529f\uff0c\u5f53\u524d\u7528\u6237\uff1a" + CurrentUserID + ",\u5b9e\u4f8b\u53f7\uff1a" + InstanceID + "\u4e1a\u52a1\u6d41\u6c34\u53f7\uff1a" + bizseqno);
                WfLog.log(2, "\u91cd\u7f6e\u4e1a\u52a1\u6d41\u6c34\u53f7,\u8c03\u7528\u65b9\u6cd5resetBizseqno(),\u5f53\u524d\u7528\u6237\uff1a" + CurrentUserID + ",\u5b9e\u4f8b\u53f7\uff1a" + InstanceID + ",\u4e1a\u52a1\u6d41\u6c34\u53f7\uff1a" + bizseqno);
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                obj.setSign(1);
                obj.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u63a7\u5236\u53f0\u5f02\u5e38\u4fe1\u606f\u5e76\u4e0e\u6d41\u7a0b\u7ba1\u7406\u5458\u53d6\u5f97\u8054\u7cfb\uff01");
                WfLog.runtimeException(this, "resetBizseqno", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u91cd\u7f6e\u4e1a\u52a1\u6d41\u6c34\u53f7resetBizseqno()\u6210\u529f,\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return obj;
    }

    public EVO getWFSignByAppID(EVO evo) throws Exception {
        long dst = System.currentTimeMillis();
        DbControl db = DbControl.getInstance();
        String orgid = evo.getOrgid();
        String appid = evo.getAppID();
        String suporgid = null;
        WfLog.log(0, "\u7531\u673a\u6784\u53f7\u3001\u6d41\u7a0b\u7c7b\u578b\u548c\u6d41\u7a0b\u5b50\u7c7b\u578b\u83b7\u53d6\u5bf9\u5e94\u7684\u6d41\u7a0b\u6807\u8bc6,orgid:" + orgid + ";appid=" + appid + ";exv19=" + evo.getExv19());
        if (orgid == null || orgid.equals("") || appid == null || appid.equals("")) {
            WfLog.paramException(this, "getWFSignByAppID", evo);
            evo.setSign(1);
            evo.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
            WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u7531\u673a\u6784\u53f7\u3001\u6d41\u7a0b\u7c7b\u578b\u548c\u6d41\u7a0b\u5b50\u7c7b\u578b\u83b7\u53d6\u5bf9\u5e94\u7684\u6d41\u7a0b\u6807\u8bc6getWFSignByAppID()\u5931\u8d25,\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
            return evo;
        }
        Connection cn = null;
        boolean bClose = true;
        try {
            if (evo.getConnection() != null) {
                cn = evo.getConnection();
                bClose = false;
            } else {
                cn = db.getConnection();
            }
            Vector vecData = db.performQuery("select * from wf_orgWFLink where appid='" + appid + "'", cn);
            if (vecData == null || vecData.size() == 0) {
                WfLog.log(0, "\u7531\u673a\u6784\u53f7\u3001\u6d41\u7a0b\u7c7b\u578b\u548c\u6d41\u7a0b\u5b50\u7c7b\u578b\u83b7\u53d6\u5bf9\u5e94\u7684\u6d41\u7a0b\u6807\u8bc6\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u8be5\u6d41\u7a0b\u6807\u8bc6\u5bf9\u5e94\u7684\u8bb0\u5f55");
                evo.setSign(1);
                evo.setTip("\u7531\u673a\u6784\u53f7\u3001\u6d41\u7a0b\u7c7b\u578b\u548c\u6d41\u7a0b\u5b50\u7c7b\u578b\u83b7\u53d6\u5bf9\u5e94\u7684\u6d41\u7a0b\u6807\u8bc6\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u8be5\u6d41\u7a0b\u6807\u8bc6\u5bf9\u5e94\u7684\u8bb0\u5f55");
                EVO eVO = evo;
                return eVO;
            }
            try {
                String subtype = "";
                if (evo.getExv10() != null && evo.getExv10().length() > 0) {
                    subtype = String.valueOf(subtype) + " and subtype1='" + evo.getExv10() + "'";
                }
                if (evo.getExv19() != null && evo.getExv19().length() > 0) {
                    subtype = String.valueOf(subtype) + " and subtype2='" + evo.getExv19() + "'";
                }
                if (evo.getExv32() != null && evo.getExv32().length() > 0) {
                    subtype = String.valueOf(subtype) + " and subtype3='" + evo.getExv32() + "'";
                }
                if ((vecData = db.performQuery("select wfsign,wfname from wf_orgWFLink where orgid='" + orgid + "' and appid='" + appid + "'" + subtype, cn)) == null || vecData.size() == 0) {
                    vecData = db.performQuery("select wfsign,wfname from wf_orgWFLink where orgid='" + orgid + "' and appid='" + appid + "' and subtype1 is null and subtype2 is null and subtype3 is null", cn);
                }
                if (vecData != null && vecData.size() > 0) {
                    Vector vecRow = (Vector)vecData.elementAt(0);
                    evo.setWFSign((String)vecRow.elementAt(0));
                    evo.setWFName((String)vecRow.elementAt(1));
                } else {
                    OrgModel om = OrgFactory.getInstance().getOrgClass().getParentOrg(orgid, cn);
                    if (om != null) {
                        suporgid = om.getOrgid();
                    }
                    while (suporgid != null) {
                        vecData = db.performQuery("select wfsign,wfname from wf_orgWFLink where orgid='" + suporgid + "' and appid='" + appid + "'" + subtype, cn);
                        if (vecData == null || vecData.size() == 0) {
                            vecData = db.performQuery("select wfsign,wfname from wf_orgWFLink where orgid='" + suporgid + "' and appid='" + appid + "' and subtype1 is null and subtype2 is null and subtype3 is null", cn);
                        }
                        if (vecData != null && vecData.size() > 0) {
                            Vector vecRow = (Vector)vecData.elementAt(0);
                            evo.setWFSign((String)vecRow.elementAt(0));
                            evo.setWFName((String)vecRow.elementAt(1));
                            break;
                        }
                        om = OrgFactory.getInstance().getOrgClass().getParentOrg(suporgid, cn);
                        suporgid = om != null ? om.getOrgid() : null;
                    }
                }
                if (evo.getWFSign() == null || evo.getWFSign().length() == 0) {
                    evo.setSign(1);
                    evo.setTip("\u6267\u884c\u7531\u673a\u6784\u53f7\u3001\u4e1a\u52a1\u54c1\u79cd\u83b7\u53d6\u5bf9\u5e94\u7684\u6d41\u7a0b\u6807\u8bc6getWFSignByAppID()\u64cd\u4f5c\u5931\u8d25\uff0c\u8be5\u6d41\u7a0b\u7c7b\u578b\u6ca1\u6709\u914d\u7f6e\u7f3a\u7701\u7684\u673a\u6784\u6d41\u7a0b\u5173\u8054\u8bb0\u5f55");
                    WfLog.log(2, "\u6267\u884c\u7531\u673a\u6784\u53f7\u3001\u4e1a\u52a1\u54c1\u79cd\u83b7\u53d6\u5bf9\u5e94\u7684\u6d41\u7a0b\u6807\u8bc6getWFSignByAppID()\u64cd\u4f5c\u5931\u8d25\uff0c\u8be5\u6d41\u7a0b\u7c7b\u578b\u6ca1\u6709\u914d\u7f6e\u7f3a\u7701\u7684\u673a\u6784\u6d41\u7a0b\u5173\u8054\u8bb0\u5f55");
                } else {
                    evo.setSign(0);
                    evo.setTip("\u6267\u884c\u7531\u673a\u6784\u53f7\u3001\u4e1a\u52a1\u54c1\u79cd\u83b7\u53d6\u5bf9\u5e94\u7684\u6d41\u7a0b\u6807\u8bc6getWFSignByAppID()\u64cd\u4f5c\u6210\u529f\uff0c\u5b9e\u9645orgid\uff1a" + suporgid == null ? orgid : String.valueOf(suporgid) + ",\u6d41\u7a0b\u6807\u8bc6\uff1a" + evo.getWFSign());
                    WfLog.log(2, "\u6267\u884c\u7531\u673a\u6784\u53f7\u3001\u4e1a\u52a1\u54c1\u79cd\u83b7\u53d6\u5bf9\u5e94\u7684\u6d41\u7a0b\u6807\u8bc6getWFSignByAppID()\u64cd\u4f5c\u6210\u529f\uff0c\u5b9e\u9645orgid\uff1a" + suporgid == null ? orgid : String.valueOf(suporgid) + ",\u6d41\u7a0b\u6807\u8bc6\uff1a" + evo.getWFSign());
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                evo.setSign(1);
                evo.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u63a7\u5236\u53f0\u5f02\u5e38\u4fe1\u606f\u5e76\u4e0e\u6d41\u7a0b\u7ba1\u7406\u5458\u53d6\u5f97\u8054\u7cfb\uff01");
                WfLog.runtimeException(this, "getWFSignByAppID", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u7531\u673a\u6784\u53f7\u3001\u4e1a\u52a1\u54c1\u79cd\u83b7\u53d6\u5bf9\u5e94\u7684\u6d41\u7a0b\u6807\u8bc6getWFSignByAppID()\u6210\u529f,\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return evo;
    }

    public GatherVO initializeGather(GatherVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        DbControl db = DbControl.getInstance();
        WfGatherEngine we = WfGatherEngine.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                    vo.setConnection(cn);
                }
                vo = we.initializeGather(vo, cn);
                if (vo.getSign() == 0) {
                    this.wfTrackNodeRecord(vo, cn);
                }
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                WfLog.runtimeException(this, "initializeGather", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u53d1\u8d77\u65b0\u4f1a\u529e\uff0c\u63d0\u4ea4\u5de5\u4f5c\u4efb\u52a1initializeGather(),\u4f1a\u529e\u53d1\u8d77\u4eba\uff1a" + vo.getGatherStartUserID() + ";" + "\u4f1a\u529e\u53c2\u4e0e\u4eba\uff1a" + vo.getAllProcessorName() + ",\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return vo;
    }

    public GatherVO wfCompleteGather(GatherVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        DbControl db = DbControl.getInstance();
        WfGatherEngine we = WfGatherEngine.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                    vo.setConnection(cn);
                }
                vo = we.wfCompleteGather(vo, cn);
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                WfLog.runtimeException(this, "wfCompleteGather", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u63d0\u4ea4\u4f1a\u529e\u7ed9\u6c47\u603b\u4ebawfCompleteGather(),\u4f1a\u529e\u6c47\u603b\u4eba\uff1a" + vo.getGatherEndUserID() + ";" + "\u4f1a\u529e\u53c2\u4e0e\u4eba\uff1a" + vo.getCurrentGatherProcessors() + "\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return vo;
    }

    public GatherVO wfFinishGatherJob(GatherVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        DbControl db = DbControl.getInstance();
        WfGatherEngine we = WfGatherEngine.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                    vo.setConnection(cn);
                }
                vo = we.wfFinishGather(vo, cn);
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                WfLog.runtimeException(this, "wfFinishGatherJob", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u7ed3\u675f\u4f1a\u529ewfFinishGatherJob()\u5b8c\u6210\uff0c\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return vo;
    }

    public GatherVO getGatherInstanceInfo(GatherVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        DbControl db = DbControl.getInstance();
        WfGatherEngine we = WfGatherEngine.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                    vo.setConnection(cn);
                }
                vo = we.getGatherInstanceInfo(vo, cn);
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                WfLog.runtimeException(this, "getGatherInstanceInfo", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u83b7\u53d6\u4f1a\u529e\u5b9e\u4f8bgetGatherInstanceInfo()\u5b8c\u6210\uff0c\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return vo;
    }

    public Vector<GatherActionVO> getGatherActions(GatherVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        DbControl db = DbControl.getInstance();
        WfGatherEngine we = WfGatherEngine.getInstance();
        Connection cn = null;
        boolean bClose = true;
        Vector<GatherActionVO> retVec = null;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                    vo.setConnection(cn);
                }
                retVec = we.getGatherActions(vo, cn);
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                WfLog.runtimeException(this, "getGatherActions", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u83b7\u53d6\u4f1a\u529e\u75d5\u8ff9getGatherActions()\u5b8c\u6210\uff0c\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return retVec;
    }

    public GatherVO wfCheckIsFinishGather(GatherVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        DbControl db = DbControl.getInstance();
        WfGatherEngine we = WfGatherEngine.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                    vo.setConnection(cn);
                }
                vo = we.wfCheckIsFinishGather(vo, cn);
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                WfLog.runtimeException(this, "wfCheckIsFinishGather", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u5224\u65ad\u662f\u5426\u53ef\u4ee5\u7ed3\u675f\u4f1a\u529ewfCheckIsFinishGather()\u5b8c\u6210\uff0c\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return vo;
    }

    public GatherVO wfResetProcessor(GatherVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        DbControl db = DbControl.getInstance();
        WfGatherEngine we = WfGatherEngine.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                    vo.setConnection(cn);
                }
                vo = we.wfResetProcessor(vo, cn);
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                WfLog.runtimeException(this, "wfResetProcessor", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u91cd\u7f6e\u4f1a\u529e\u53c2\u4e0e\u4ebawfResetProcessor()\u5b8c\u6210\uff0c\u91cd\u7f6e\u540e\u4f1a\u529e\u53c2\u4e0e\u4eba\uff1a" + vo.getAllProcessor() + "\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return vo;
    }

    public GatherVO wfChangeGather(GatherVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        DbControl db = DbControl.getInstance();
        WfGatherEngine we = WfGatherEngine.getInstance();
        Connection cn = null;
        boolean bClose = true;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                    vo.setConnection(cn);
                }
                vo = we.wfChangeGather(vo, cn);
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                WfLog.runtimeException(this, "wfChangeGather", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        return vo;
    }

    private boolean wfTrackNodeRecord(Object obj, Connection cn) throws Exception {
        DbControl db = DbControl.getInstance();
        Vector<Field> vecFields = new Vector<Field>();
        OrgClass orgClass = OrgClass.getInstance();
        OrgIF oif = OrgFactory.getInstance().getOrgClass();
        if (obj instanceof GatherVO) {
            GatherVO vo = (GatherVO)obj;
            String actionName = String.valueOf(orgClass.getUserNameByUserID(vo.getGatherStartUserID(), cn)) + " \u4e8e " + DatetimeUtils.getNowDateTimeString() + " \u53d1\u8d77\u4f1a\u529e\uff0c\u4f1a\u529e\u53c2\u4e0e\u4eba:" + vo.getAllProcessorName();
            if (actionName.length() > 300) {
                actionName = String.valueOf(actionName.substring(0, 295)) + "...";
            }
            String strSql = "select roleid from wf_node_record where instanceid='" + vo.getMainInstanceID() + "' and nodeid='" + vo.getMainNodeID() + "' ";
            Vector vec = db.performQuery(strSql, cn);
            Vector rowVec = (Vector)vec.elementAt(0);
            String roleid = (String)rowVec.elementAt(0);
            vecFields.addElement(new Field("NodeActionID", new UNIDProducer().getUNID()));
            vecFields.addElement(new Field("InstanceID", vo.getMainInstanceID()));
            vecFields.addElement(new Field("NodeID", vo.getMainNodeID()));
            vecFields.addElement(new Field("NodeName", vo.getMainNodeName()));
            vecFields.addElement(new Field("TransActor", vo.getGatherStartUserID()));
            vecFields.addElement(new Field("TransActorName", orgClass.getUserNameByUserID(vo.getGatherStartUserID(), cn)));
            vecFields.addElement(new Field("ActTime", DatetimeUtils.getNowDateTimeString()));
            vecFields.addElement(new Field("ActionName", actionName));
            vecFields.addElement(new Field("NextNodeID", "hb_gather"));
            vecFields.addElement(new Field("NextNodeName", "\u53d1\u8d77\u4f1a\u529e-" + vo.getInstanceID()));
            vecFields.addElement(new Field("SendTo", vo.getAllProcessor()));
            vecFields.addElement(new Field("orgid", oif.getOrgIdByUser(vo.getGatherStartUserID(), cn)));
            String SendToName = orgClass.getUserNameByUserID(vo.getAllProcessor(), cn);
            vecFields.addElement(new Field("SendToName", SendToName.length() > 200 ? String.valueOf(SendToName.substring(0, 290)) + "..." : SendToName));
            vecFields.addElement(new Field("roleid", roleid));
            vecFields.addElement(new Field("rolename", roleid == null || roleid.length() == 0 ? "" : (roleid.substring(0, 2).equals("T.") ? "\u9879\u76ee\u6c60" : oif.getRoleModel(null, roleid, cn).getRolename())));
            db.doInsert("wf_node_action_record", vecFields, cn);
        } else if (obj instanceof EVO) {
            EVO vo = (EVO)obj;
            String wfid = vo.getWFID();
            VO_wf_whole_property wp = WFCache.getInstance().getCacheWFObj(wfid);
            VO_wf_node_property np = WFCache.getInstance().getNodeProperty(vo.getNodeID());
            String actionName = String.valueOf(orgClass.getUserNameByUserID(vo.getCurrentUserID(), cn)) + " \u4e8e " + DatetimeUtils.getNowDateTimeString() + " \u53d1\u8d77\u5b50\u6d41\u7a0b:" + wp.WFName + "\uff0c\u6d41\u7a0bID\uff1a" + wfid;
            if (actionName.length() > 300) {
                actionName = String.valueOf(actionName.substring(0, 295)) + "...";
            }
            String strSql = "select roleid from wf_node_record where instanceid='" + vo.getInstanceID() + "' and nodeid='" + vo.getNodeID() + "' ";
            Vector vec = db.performQuery(strSql, cn);
            Vector rowVec = (Vector)vec.elementAt(0);
            String roleid = (String)rowVec.elementAt(0);
            vecFields.addElement(new Field("NodeActionID", new UNIDProducer().getUNID()));
            vecFields.addElement(new Field("InstanceID", vo.getInstanceID()));
            vecFields.addElement(new Field("NodeID", vo.getNodeID()));
            vecFields.addElement(new Field("NodeName", np.NodeName));
            vecFields.addElement(new Field("TransActor", vo.getCurrentUserID()));
            vecFields.addElement(new Field("TransActorName", orgClass.getUserNameByUserID(vo.getCurrentUserID(), cn)));
            vecFields.addElement(new Field("ActTime", DatetimeUtils.getNowDateTimeString()));
            vecFields.addElement(new Field("ActionName", actionName));
            vecFields.addElement(new Field("NextNodeID", "sub_wfFlow"));
            vecFields.addElement(new Field("NextNodeName", "\u53d1\u8d77\u5b50\u6d41\u7a0b-" + vo.getExs()));
            vecFields.addElement(new Field("SendTo", ""));
            vecFields.addElement(new Field("orgid", vo.getOrgid()));
            vecFields.addElement(new Field("roleid", roleid));
            vecFields.addElement(new Field("rolename", roleid == null || roleid.length() == 0 ? "" : (roleid.substring(0, 2).equals("T.") ? "\u9879\u76ee\u6c60" : oif.getRoleModel(null, roleid, cn).getRolename())));
            db.doInsert("wf_node_action_record", vecFields, cn);
        }
        return true;
    }

    public String getGatherStatus(GatherVO vo) throws Exception {
        long dst = System.currentTimeMillis();
        DbControl db = DbControl.getInstance();
        WfGatherEngine we = WfGatherEngine.getInstance();
        Connection cn = null;
        boolean bClose = true;
        String retStr = null;
        try {
            try {
                if (vo.getConnection() != null) {
                    cn = vo.getConnection();
                    bClose = false;
                } else {
                    cn = db.getConnection();
                    vo.setConnection(cn);
                }
                retStr = we.getGatherStatus(vo, cn);
                if (!WfPropertyManager.getInstance().autocommit && bClose) {
                    cn.commit();
                }
            }
            catch (Exception e) {
                if (cn != null && bClose) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                }
                WfLog.runtimeException(this, "getGatherStatus", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        return retStr;
    }

    private Map getRoleByUserNode(String instanceid, String nodeid, String userList, Connection cn) throws Exception {
        DbControl db = DbControl.getInstance();
        boolean isClosed = false;
        LinkedHashMap<String, String> retMap = new LinkedHashMap<String, String>();
        Vector vecData = new Vector();
        try {
            if (cn == null) {
                cn = db.getConnection();
                isClosed = true;
            }
            if (instanceid == null || instanceid.length() <= 0 || nodeid == null || nodeid.length() <= 0) {
                WfLog.log(4, "\u6839\u636e\u7528\u6237ID\u5230\u8282\u70b9\u64cd\u4f5c\u75d5\u8ff9\u8868\u4e2d\u67e5\u627e\u89d2\u8272\u65f6\u51fa\u9519\uff0c\u6d41\u7a0b\u5b9e\u4f8b\u53f7\u3001\u8282\u70b9\u53f7\u4e3a\u7a7a");
                LinkedHashMap<String, String> linkedHashMap = retMap;
                return linkedHashMap;
            }
            if (userList == null || userList.length() <= 0) {
                LinkedHashMap<String, String> linkedHashMap = retMap;
                return linkedHashMap;
            }
            try {
                String[] ids = userList.split(";");
                String strSql = "select TransActor,RoleID,RoleName from wf_node_action_record where instanceid='" + instanceid + "' and nodeid='" + nodeid + "'";
                vecData = db.performQuery2(strSql, cn);
                int i = 0;
                while (i < vecData.size()) {
                    Map mapRow = (Map)vecData.elementAt(i);
                    String userid = (String)mapRow.get("TRANSACTOR");
                    int j = 0;
                    while (j < ids.length) {
                        if (ids[j] != null && ids[j].equals(userid)) {
                            String roleID = (String)mapRow.get("ROLEID");
                            String roleName = (String)mapRow.get("ROLENAME");
                            if (roleID != null && roleID.length() != 0) {
                                retMap.put(roleID, roleName);
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                WfLog.log(4, "\u6839\u636e\u7528\u6237ID\u5230\u8282\u70b9\u64cd\u4f5c\u75d5\u8ff9\u8868\u4e2d\u67e5\u627e\u89d2\u8272\u65f6\u51fa\u9519", e);
                throw e;
            }
        }
        finally {
            if (cn != null && isClosed) {
                cn.close();
            }
        }
        return retMap;
    }

    public boolean checkExistSubFlow(EVO evo) throws Exception {
        boolean result = false;
        String mainInstanceid = evo.getMainInstanceID();
        String subwfsign = evo.getWFSign();
        if (mainInstanceid == null || mainInstanceid.equals("null") || mainInstanceid.equals("") || subwfsign == null || subwfsign.equals("null") || subwfsign.equals("")) {
            WfLog.log(4, "\u6839\u636e\u4e3b\u6d41\u7a0b\u5b9e\u4f8b\u53f7\u53ca\u5b50\u6d41\u7a0b\u6807\u8bc6\u68c0\u67e5\u5b50\u6d41\u7a0b\u4fe1\u606f\u51fa\u9519\uff0c\u4e3b\u6d41\u7a0b\u5b9e\u4f8b\u53f7\u6216\u5b50\u6d41\u7a0b\u6807\u8bc6\u4e3a\u7a7a\uff01");
            return result;
        }
        Connection connection = null;
        DbControl db = DbControl.getInstance();
        boolean isClosed = false;
        try {
            try {
                String sqlStr;
                Vector vecData;
                connection = evo.getConnection();
                if (connection == null) {
                    connection = db.getConnection();
                    isClosed = true;
                }
                if ((vecData = db.performQuery(sqlStr = "SELECT instanceid FROM wf_instance_whole_property WHERE MainInstanceID = '" + mainInstanceid + "' and bDraft='0' and (wfstatus='0' or wfstatus='5') and wfsign='" + subwfsign + "'", db.getConnection())) != null && vecData.size() > 0) {
                    result = true;
                }
            }
            catch (Exception e) {
                WfLog.log(4, "\u6839\u636e\u4e3b\u6d41\u7a0b\u5b9e\u4f8b\u53f7\u53ca\u5b50\u6d41\u7a0b\u6807\u8bc6\u68c0\u67e5\u5b50\u6d41\u7a0b\u4fe1\u606f\u51fa\u9519\uff01", e);
                throw e;
            }
        }
        finally {
            if (connection != null && isClosed) {
                connection.close();
            }
        }
        return result;
    }

    public Vector<CommentExtVO> getCommentExts(CommentExtVO cvo, Connection cn) throws Exception {
        String InstanceID = cvo.getInstanceID();
        String userID = cvo.getUserID();
        String bizSeqno = cvo.getBizseqno();
        String superCommid = cvo.getSuperCommid();
        String SqlStr = "";
        Vector<CommentExtVO> vecResult = new Vector<CommentExtVO>();
        DbControl db = DbControl.getInstance();
        boolean bClose = false;
        try {
            try {
                WfLog.log(2, "\u67e5\u8be2\u610f\u89c1,\u8c03\u7528\u65b9\u6cd5getCommentExts()\uff0c\u5b9e\u4f8b\u53f7\uff1a" + InstanceID + "\u5f53\u524d\u7528\u6237\uff1a" + userID);
                if (cn == null) {
                    cn = db.getConnection();
                    bClose = true;
                }
                String endSign = "";
                SqlStr = "select bizseqno from wf_instance_whole_property where InstanceID='" + InstanceID + "'";
                Vector vecData = db.performQuery(SqlStr, cn);
                if (vecData.size() == 0) {
                    endSign = "END";
                }
                if (WfPropertyManager.getInstance().mapWFAdmin.get(userID) != null || WfPropertyManager.getInstance().mapWFAdmin.get("${ALL}") != null) {
                    SqlStr = "select * from wf_comment_ext" + endSign + " where InstanceID='" + InstanceID + "'";
                } else {
                    int commentLevel = this.getUserCommentLevel(InstanceID, userID, cn);
                    SqlStr = "select * from wf_comment_ext" + endSign + " where InstanceID='" + InstanceID + "' and commentLevel<=" + commentLevel;
                }
                if (bizSeqno != null && bizSeqno.length() > 0) {
                    SqlStr = String.valueOf(SqlStr) + " and bizseqno='" + bizSeqno + "'";
                }
                if (superCommid != null && superCommid.length() > 0) {
                    SqlStr = String.valueOf(SqlStr) + " and superCommid='" + superCommid + "'";
                    SqlStr = String.valueOf(SqlStr) + " order by commentTime asc";
                } else {
                    SqlStr = String.valueOf(SqlStr) + " order by commentTime desc";
                }
                vecData = db.performQuery2(SqlStr, cn);
                boolean isReaders = false;
                String commentType = "";
                int i = 0;
                while (i < vecData.size()) {
                    block26: {
                        Map mapRow;
                        block25: {
                            mapRow = (Map)vecData.elementAt(i);
                            String string = commentType = mapRow.get("COMMENTTYPE") == null ? "" : (String)mapRow.get("COMMENTTYPE");
                            if (!commentType.equals("2")) break block25;
                            isReaders = false;
                            if (((String)mapRow.get("USERID")).equals(userID)) {
                                isReaders = true;
                            } else {
                                String cr = (String)mapRow.get("COMMENTREADERS");
                                if (cr != null && StringUtils.isPartOf(cr, userID, ";")) {
                                    isReaders = true;
                                }
                            }
                            if (!isReaders) break block26;
                        }
                        CommentExtVO obj = new CommentExtVO();
                        obj.setCommentID((String)mapRow.get("COMMENTID"));
                        obj.setNodeID((String)mapRow.get("NODEID"));
                        obj.setNodeName((String)mapRow.get("NODENAME"));
                        obj.setUserID((String)mapRow.get("USERID"));
                        obj.setUserName((String)mapRow.get("USERNAME"));
                        obj.setAppendRole((String)mapRow.get("APPENDROLE"));
                        obj.setCommentTime((String)mapRow.get("COMMENTTIME"));
                        obj.setCommentLevel(Integer.parseInt((String)mapRow.get("COMMENTLEVEL")));
                        obj.setOrgID((String)mapRow.get("ORGID"));
                        obj.setBizseqno((String)mapRow.get("BIZSEQNO"));
                        obj.setSuperCommid((String)mapRow.get("SUPERCOMMID"));
                        obj.setCommentSign((String)mapRow.get("COMMENTSIGN"));
                        obj.setCommentContent((String)mapRow.get("COMMENTCONTENT"));
                        obj.setCommentType((String)mapRow.get("COMMENTTYPE"));
                        obj.setCommentReaders((String)mapRow.get("COMMENTREADERS"));
                        obj.setVa((String)mapRow.get("VA"));
                        obj.setVb((String)mapRow.get("VB"));
                        obj.setVc((String)mapRow.get("VC"));
                        obj.setVd((String)mapRow.get("VD"));
                        obj.setVe((String)mapRow.get("VE"));
                        obj.setVf((String)mapRow.get("VF"));
                        obj.setVg((String)mapRow.get("VG"));
                        obj.setVh((String)mapRow.get("VH"));
                        obj.setVi((String)mapRow.get("VI"));
                        obj.setVj((String)mapRow.get("VJ"));
                        obj.setVk((String)mapRow.get("VK"));
                        obj.setVl((String)mapRow.get("VL"));
                        obj.setVm((String)mapRow.get("VM"));
                        obj.setVn((String)mapRow.get("VN"));
                        obj.setVo((String)mapRow.get("VO"));
                        obj.setVp((String)mapRow.get("VP"));
                        obj.setVq((String)mapRow.get("VQ"));
                        obj.setVr((String)mapRow.get("VR"));
                        obj.setVs((String)mapRow.get("VS"));
                        obj.setVt((String)mapRow.get("VT"));
                        obj.setVu((String)mapRow.get("VU"));
                        obj.setVv((String)mapRow.get("VV"));
                        obj.setVw((String)mapRow.get("VW"));
                        obj.setVx((String)mapRow.get("VX"));
                        obj.setVy((String)mapRow.get("VY"));
                        obj.setVz((String)mapRow.get("VZ"));
                        vecResult.addElement(obj);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                WfLog.runtimeException(this, "getCommentExts", e);
                throw e;
            }
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
        return vecResult;
    }

    public String setCommentExts(CommentExtVO cvo, Connection cn, boolean isCommit) throws Exception {
        String InstanceID = cvo.getInstanceID();
        String userID = cvo.getUserID();
        String NodeID = cvo.getNodeID();
        String orgid = cvo.getOrgID();
        String bizseqno = cvo.getBizseqno();
        String superCommid = cvo.getSuperCommid();
        String commentID = cvo.getCommentID();
        boolean bClose = false;
        DbControl db = DbControl.getInstance();
        try {
            String commentTime;
            String userName;
            WfLog.log(2, "\u586b\u5199\u610f\u89c1\u63d0\u4ea4,\u8c03\u7528\u65b9\u6cd5setCommentExts()\uff0c\u5b9e\u4f8b\u53f7\uff1a" + InstanceID + "\u5f53\u524d\u7528\u6237\uff1a" + userID);
            if (cn == null) {
                cn = db.getConnection();
                bClose = true;
            }
            VO_wf_node_property wnp = WFCache.getInstance().getNodeProperty(NodeID);
            int sl = cvo.getCommentLevel();
            if (sl < 0) {
                sl = wnp.NodeLevel;
            }
            if ((userName = cvo.getUserName()) == null || userName.equals("")) {
                userName = OrgClass.getInstance().getUserNameByUserID(userID, cn);
            }
            if ((commentTime = cvo.getCommentTime()) == null || commentTime.equals("")) {
                commentTime = DatetimeUtils.getNowDateTimeString();
            }
            if (commentID == null || commentID.length() == 0) {
                commentID = new UNIDProducer().getUNID();
            }
            Vector<Field> vecFields = new Vector<Field>();
            vecFields.addElement(new Field("commentID", commentID));
            vecFields.addElement(new Field("InstanceID", InstanceID));
            vecFields.addElement(new Field("NodeID", NodeID));
            vecFields.addElement(new Field("NodeName", wnp.NodeName));
            vecFields.addElement(new Field("userID", userID));
            vecFields.addElement(new Field("userName", userName));
            vecFields.addElement(new Field("commentTime", commentTime));
            vecFields.addElement(new Field("commentLevel", String.valueOf(sl)));
            vecFields.addElement(new Field("orgid", orgid));
            vecFields.addElement(new Field("bizseqno", bizseqno == null ? "" : bizseqno));
            vecFields.addElement(new Field("superCommid", superCommid == null ? "" : superCommid));
            vecFields.addElement(new Field("commentSign", cvo.getCommentSign() == null ? "" : cvo.getCommentSign()));
            vecFields.addElement(new Field("commentContent", cvo.getCommentContent() == null ? "" : cvo.getCommentContent()));
            vecFields.addElement(new Field("commentType", cvo.getCommentType() == null ? "" : cvo.getCommentType()));
            vecFields.addElement(new Field("commentReaders", cvo.getCommentReaders() == null ? "" : cvo.getCommentReaders()));
            String strSql = "select roleid from wf_node_record where instanceid='" + cvo.getInstanceID() + "' and nodeid='" + cvo.getNodeID() + "' ";
            Vector vec = db.performQuery(strSql, cn);
            if (vec.size() >= 0) {
                Vector rowVec = (Vector)vec.elementAt(0);
                String roleid = (String)rowVec.elementAt(0);
                vecFields.addElement(new Field("appendRole", roleid == null || roleid.length() <= 0 ? "" : roleid));
            }
            this.createCommentExtVAZ(cvo, vecFields);
            db.doInsert("wf_comment_ext", vecFields, cn);
            if (!WfPropertyManager.getInstance().autocommit && isCommit) {
                cn.commit();
            }
            String string = commentID;
            return string;
        }
        catch (Exception e) {
            if (cn != null && bClose) {
                try {
                    if (!WfPropertyManager.getInstance().autocommit) {
                        WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                        cn.rollback();
                    }
                }
                catch (Exception ee) {
                    WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                    ee.printStackTrace();
                }
            }
            WfLog.runtimeException(this, "setCommentExts", e);
            throw e;
        }
        finally {
            if (cn != null && bClose) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
            }
        }
    }

    private int getUserCommentLevel(String instanceID, String userID, Connection cn) throws Exception {
        if (instanceID == null || instanceID.equals("") || userID == null || userID.equals("")) {
            return 0;
        }
        String SqlStr = "";
        DbControl db = DbControl.getInstance();
        try {
            String endSign = "";
            SqlStr = "select bizseqno from wf_instance_whole_property where InstanceID='" + instanceID + "'";
            Vector vecData = db.performQuery(SqlStr, cn);
            if (vecData.size() == 0) {
                endSign = "END";
            }
            int commentLevel = 0;
            SqlStr = "select NodeID from wf_node_record" + endSign + " where InstanceID='" + instanceID + "' and (CurrentNodeUser='" + userID + "' or CurrentNodeUsers like '%" + userID + ";%') order by NodeStartTime desc";
            vecData = db.performQuery2(SqlStr, cn);
            if (vecData.size() == 0) {
                SqlStr = "select NodeID from wf_instance_node_property where InstanceID='" + instanceID + "' and (CurrentNodeUser like '%" + userID + ";%' or CurrentNodeUsers like '%" + userID + ";%') order by NodeStartTime desc";
                vecData = db.performQuery2(SqlStr, cn);
            }
            int i = 0;
            while (i < vecData.size()) {
                Map mapRow = (Map)vecData.elementAt(i);
                String NodeID = (String)mapRow.get("NODEID");
                VO_wf_node_property wnp = WFCache.getInstance().getNodeProperty(NodeID);
                if (wnp != null) {
                    commentLevel = commentLevel < wnp.NodeLevel ? wnp.NodeLevel : commentLevel;
                }
                ++i;
            }
            return commentLevel;
        }
        catch (Exception e) {
            WfLog.log(4, "getUserCommentLevel,\u53d6" + userID + "\u7684\u610f\u89c1\u7ea7\u522b\u51fa\u9519:", e);
            throw e;
        }
    }

    private Vector<Field> createCommentExtVAZ(CommentExtVO vo, Vector<Field> vecFields) throws Exception {
        try {
            if (vo.getVa() != null && vo.getVa().length() > 0) {
                vecFields.add(new Field("va", vo.getVa()));
            }
            if (vo.getVb() != null && vo.getVb().length() > 0) {
                vecFields.add(new Field("vb", vo.getVb()));
            }
            if (vo.getVc() != null && vo.getVc().length() > 0) {
                vecFields.add(new Field("vc", vo.getVc()));
            }
            if (vo.getVd() != null && vo.getVd().length() > 0) {
                vecFields.add(new Field("vd", vo.getVd()));
            }
            if (vo.getVe() != null && vo.getVe().length() > 0) {
                vecFields.add(new Field("ve", vo.getVe()));
            }
            if (vo.getVf() != null && vo.getVf().length() > 0) {
                vecFields.add(new Field("vf", vo.getVf()));
            }
            if (vo.getVg() != null && vo.getVg().length() > 0) {
                vecFields.add(new Field("vg", vo.getVg()));
            }
            if (vo.getVh() != null && vo.getVh().length() > 0) {
                vecFields.add(new Field("vh", vo.getVh()));
            }
            if (vo.getVi() != null && vo.getVi().length() > 0) {
                vecFields.add(new Field("vi", vo.getVi()));
            }
            if (vo.getVj() != null && vo.getVj().length() > 0) {
                vecFields.add(new Field("vj", vo.getVj()));
            }
            if (vo.getVk() != null && vo.getVk().length() > 0) {
                vecFields.add(new Field("vk", vo.getVk()));
            }
            if (vo.getVl() != null && vo.getVl().length() > 0) {
                vecFields.add(new Field("vl", vo.getVl()));
            }
            if (vo.getVm() != null && vo.getVm().length() > 0) {
                vecFields.add(new Field("vm", vo.getVm()));
            }
            if (vo.getVn() != null && vo.getVn().length() > 0) {
                vecFields.add(new Field("vn", vo.getVn()));
            }
            if (vo.getVo() != null && vo.getVo().length() > 0) {
                vecFields.add(new Field("vo", vo.getVo()));
            }
            if (vo.getVp() != null && vo.getVp().length() > 0) {
                vecFields.add(new Field("vp", vo.getVp()));
            }
            if (vo.getVq() != null && vo.getVq().length() > 0) {
                vecFields.add(new Field("vq", vo.getVq()));
            }
            if (vo.getVr() != null && vo.getVr().length() > 0) {
                vecFields.add(new Field("vr", vo.getVr()));
            }
            if (vo.getVs() != null && vo.getVs().length() > 0) {
                vecFields.add(new Field("vs", vo.getVs()));
            }
            if (vo.getVt() != null && vo.getVt().length() > 0) {
                vecFields.add(new Field("vt", vo.getVt()));
            }
            if (vo.getVu() != null && vo.getVu().length() > 0) {
                vecFields.add(new Field("vu", vo.getVu()));
            }
            if (vo.getVv() != null && vo.getVv().length() > 0) {
                vecFields.add(new Field("vv", vo.getVv()));
            }
            if (vo.getVw() != null && vo.getVw().length() > 0) {
                vecFields.add(new Field("vw", vo.getVw()));
            }
            if (vo.getVx() != null && vo.getVx().length() > 0) {
                vecFields.add(new Field("vx", vo.getVx()));
            }
            if (vo.getVy() != null && vo.getVy().length() > 0) {
                vecFields.add(new Field("vy", vo.getVy()));
            }
            if (vo.getVz() != null && vo.getVz().length() > 0) {
                vecFields.add(new Field("vz", vo.getVz()));
            }
        }
        catch (Exception e) {
            WfLog.runtimeException(this, "setComment", e);
            throw e;
        }
        return vecFields;
    }
}

