/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.echain.workflow.engine;

import com.ecc.echain.db.DbControl;
import com.ecc.echain.log.WfLog;
import com.ecc.echain.org.OrgFactory;
import com.ecc.echain.org.OrgIF;
import com.ecc.echain.util.DatetimeUtils;
import com.ecc.echain.util.Field;
import com.ecc.echain.util.StringUtils;
import com.ecc.echain.util.UNIDProducer;
import com.ecc.echain.util.WfPropertyManager;
import com.ecc.echain.workflow.cache.WFCache;
import com.ecc.echain.workflow.engine.EVO;
import com.ecc.echain.workflow.engine.OrgClass;
import com.ecc.echain.workflow.engine.WfEngine;
import com.ecc.echain.workflow.model.VO_wf_node_property;
import com.ecc.echain.workflow.model.VO_wf_whole_property;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class WfTrack {
    private static WfTrack _instance = new WfTrack();

    private WfTrack() {
    }

    public static WfTrack getInstance() {
        return _instance;
    }

    public String wfTrackInitializeUNID(EVO vo, VO_wf_whole_property wwp, Connection cn) throws Exception {
        String InstanceID = vo.getInstanceID();
        String orgid = vo.getOrgid();
        String WFPlanEndTime = "";
        DbControl db = DbControl.getInstance();
        try {
            String nowtime = DatetimeUtils.getNowDateTimeString();
            OrgClass orgclass = OrgClass.getInstance();
            Vector<Field> vecFields = new Vector<Field>();
            vecFields.addElement(new Field("InstanceID", InstanceID));
            vecFields.addElement(new Field("bizseqno", vo.getBizseqno()));
            if (vo.getCustID() != null && vo.getCustID().length() > 0) {
                vecFields.addElement(new Field("custID", vo.getCustID()));
            }
            if (vo.getCustName() != null && vo.getCustName().length() > 0) {
                vecFields.addElement(new Field("custName", vo.getCustName()));
            }
            if (vo.getMainInstanceID() != null && vo.getMainInstanceID().length() > 0) {
                vecFields.addElement(new Field("MainInstanceID", vo.getMainInstanceID()));
            }
            if (vo.getMainNodeID() != null && vo.getMainNodeID().length() > 0) {
                vecFields.addElement(new Field("MainNodeID", vo.getMainNodeID()));
            }
            vecFields.addElement(new Field("WFStartTime", nowtime));
            vecFields.addElement(new Field("WFStatus", "0"));
            vecFields.addElement(new Field("WFType", "0"));
            vecFields.addElement(new Field("WFID", wwp.WFID));
            vecFields.addElement(new Field("WFName", StringUtils.gb2iso(wwp.WFName)));
            vecFields.addElement(new Field("WFSign", wwp.WFSign));
            vecFields.addElement(new Field("AppName", StringUtils.gb2iso(wwp.WFAppName)));
            vecFields.addElement(new Field("AppID", wwp.WFAppID));
            vecFields.addElement(new Field("WFAdmin", orgclass.convertPersonsList_str(orgid, wwp.WFAdmin, cn)));
            vecFields.addElement(new Field("WFReaders", orgclass.convertPersonsList_str(orgid, wwp.WFReaders, cn)));
            vecFields.addElement(new Field("WFAgent", wwp.WFAgent));
            vecFields.addElement(new Field("WFChange", wwp.WFChange));
            vecFields.addElement(new Field("WFAgain", wwp.WFAgain));
            vecFields.addElement(new Field("WFRecall", wwp.WFRecall));
            vecFields.addElement(new Field("WFReturnBack", wwp.WFReturnBack));
            vecFields.addElement(new Field("WFHangup", wwp.WFHangup));
            vecFields.addElement(new Field("WFWake", wwp.WFWake));
            vecFields.addElement(new Field("WFJump", wwp.WFJump));
            if (vo.getWFPlanEndTime() != null && vo.getWFPlanEndTime().length() > 1) {
                WFPlanEndTime = vo.getWFPlanEndTime().length() == 19 ? vo.getWFPlanEndTime() : DatetimeUtils.convertDateTimeString(nowtime, vo.getWFPlanEndTime(), "after");
            } else if (wwp.WFTimelimitNotification != null && wwp.WFTimelimitNotification.equals("1")) {
                String WFDurationTime = "";
                WFDurationTime = wwp.WFDurationTime == null || wwp.WFDurationTime.equals("") ? "D10" : wwp.WFDurationTime;
                WFPlanEndTime = DatetimeUtils.convertDateTimeString(nowtime, WFDurationTime, "after");
            }
            vecFields.addElement(new Field("WFNotificationTime", WFPlanEndTime));
            vecFields.addElement(new Field("WFPlanEndTime", WFPlanEndTime));
            vecFields.addElement(new Field("WFTimelimitRepeat", wwp.WFTimelimitRepeat));
            vecFields.addElement(new Field("WFTimelimitRepeatTimes", "0"));
            vecFields.addElement(new Field("overduetreat", wwp.overduetreat));
            vecFields.addElement(new Field("orgid", orgid));
            vecFields.addElement(new Field("CostTimes", "0"));
            vecFields.addElement(new Field("sysid", vo.getSysid()));
            db.doInsert("wf_main_record", vecFields, cn);
        }
        catch (Exception e) {
            WfLog.runtimeException(this, "wfTrackInitializeUNID", e);
            throw e;
        }
        return WFPlanEndTime;
    }

    public void updateWFTrackWholeRecord(String InstanceID, VO_wf_whole_property wwp, Connection cn) throws Exception {
        DbControl db = DbControl.getInstance();
        String orgid = wwp.orgid;
        try {
            OrgClass orgclass = OrgClass.getInstance();
            Vector<Field> vecData = new Vector<Field>();
            vecData.addElement(new Field("WFName", wwp.WFName));
            vecData.addElement(new Field("WFID", wwp.WFID));
            vecData.addElement(new Field("AppName", wwp.WFAppName));
            vecData.addElement(new Field("AppID", wwp.WFAppID));
            vecData.addElement(new Field("WFAdmin", orgclass.convertPersonsList_str(orgid, wwp.WFAdmin, cn)));
            vecData.addElement(new Field("WFReaders", orgclass.convertPersonsList_str(orgid, wwp.WFReaders, cn)));
            vecData.addElement(new Field("WFAgent", wwp.WFAgent));
            vecData.addElement(new Field("WFChange", wwp.WFChange));
            vecData.addElement(new Field("WFAgain", wwp.WFAgain));
            vecData.addElement(new Field("WFRecall", wwp.WFRecall));
            vecData.addElement(new Field("WFReturnBack", wwp.WFReturnBack));
            vecData.addElement(new Field("WFHangup", wwp.WFHangup));
            vecData.addElement(new Field("WFWake", wwp.WFWake));
            if (wwp.WFTimelimitNotification != null && wwp.WFTimelimitNotification.equals("1")) {
                String WFDurationTime = "";
                WFDurationTime = wwp.WFDurationTime == null || wwp.WFDurationTime.equals("") ? "D10" : wwp.WFDurationTime;
                String nowtime = DatetimeUtils.getNowDateTimeString();
                String WFNotificationTime = DatetimeUtils.convertDateTimeString(nowtime, WFDurationTime, "after");
                vecData.addElement(new Field("WFNotificationTime", WFNotificationTime));
                vecData.addElement(new Field("WFTimelimitRepeat", wwp.WFTimelimitRepeat));
            }
            vecData.addElement(new Field("orgid", orgid));
            db.doUpdate("wf_main_record", vecData, "InstanceID='" + InstanceID + "'", cn);
        }
        catch (Exception e) {
            WfLog.runtimeException(this, "updateWFTrackWholeRecord", e);
            throw e;
        }
    }

    public void wfTrackInitializeUNIDForFreeRouter(EVO vo, Connection cn) throws Exception {
        String InstanceID = vo.getInstanceID();
        String AppID = vo.getAppID();
        String CurrentUserID = vo.getCurrentUserID();
        DbControl db = DbControl.getInstance();
        try {
            Vector<Field> vecData = new Vector<Field>();
            vecData.addElement(new Field("InstanceID", InstanceID));
            vecData.addElement(new Field("WFStartTime", DatetimeUtils.getNowDateTimeString()));
            vecData.addElement(new Field("WFStatus", "0"));
            vecData.addElement(new Field("WFType", "1"));
            vecData.addElement(new Field("WFID", "wffreerouter"));
            vecData.addElement(new Field("WFName", "\u81ea\u7531\u6d41\u7a0b"));
            vecData.addElement(new Field("AppName", AppID));
            vecData.addElement(new Field("AppID", AppID));
            vecData.addElement(new Field("WFAdmin", CurrentUserID));
            vecData.addElement(new Field("WFReaders", CurrentUserID));
            vecData.addElement(new Field("WFAgent", "0"));
            vecData.addElement(new Field("WFChange", "0"));
            vecData.addElement(new Field("WFAgain", "0"));
            vecData.addElement(new Field("WFRecall", "0"));
            vecData.addElement(new Field("WFReturnBack", "0"));
            vecData.addElement(new Field("WFHangup", "0"));
            vecData.addElement(new Field("WFJump", "0"));
            vecData.addElement(new Field("WFWake", "0"));
            db.doInsert("wf_main_record", vecData, cn);
        }
        catch (Exception e) {
            WfLog.runtimeException(this, "wfTrackInitializeUNIDForFreeRouter", e);
            throw e;
        }
    }

    public void wfTrackInitializeFirstUNID(EVO vo, VO_wf_whole_property wwp, VO_wf_node_property wnp, Connection cn) throws Exception {
        String CurrentUserID = vo.getCurrentUserID();
        DbControl db = DbControl.getInstance();
        try {
            String nowtime = DatetimeUtils.getNowDateTimeString();
            Vector<Field> vecFields = new Vector<Field>();
            vecFields.addElement(new Field("InstanceID", vo.getInstanceID()));
            vecFields.addElement(new Field("WFID", wwp.WFID));
            vecFields.addElement(new Field("WFName", StringUtils.gb2iso(wwp.WFName)));
            vecFields.addElement(new Field("NodeID", wnp.NodeID));
            vecFields.addElement(new Field("NodeSign", wnp.NodeSign));
            vecFields.addElement(new Field("NodeName", StringUtils.gb2iso(wnp.NodeName)));
            vecFields.addElement(new Field("NodeNumber", "1"));
            vecFields.addElement(new Field("NodeStartTime", nowtime));
            vecFields.addElement(new Field("CountTime", nowtime));
            vecFields.addElement(new Field("NodeAcceptTime", nowtime));
            vecFields.addElement(new Field("NodeStatus", "0"));
            vecFields.addElement(new Field("PrevNodeName", "WFBEGIN"));
            vecFields.addElement(new Field("CurrentNodeUsers", String.valueOf(CurrentUserID) + ";"));
            vecFields.addElement(new Field("CurrentNodeUser", CurrentUserID));
            vecFields.addElement(new Field("CurrentNodeProcessors", ""));
            vecFields.addElement(new Field("originalusers", ""));
            vecFields.addElement(new Field("PreProcessorList", ""));
            vecFields.addElement(new Field("NodeUserModifyType", "1"));
            vecFields.addElement(new Field("NodeMulteit", "0"));
            vecFields.addElement(new Field("NodeWeigh", String.valueOf(wnp.NodeWeigh)));
            db.doInsert("wf_node_record", vecFields, cn);
        }
        catch (Exception e) {
            WfLog.runtimeException(this, "wfTrackInitializeFirstUNID", e);
            throw e;
        }
    }

    public String updateWFTrackFirstNodeRecord(String InstanceID, VO_wf_whole_property wwp, Connection cn) throws Exception {
        String WFFirstNodeDocID = "";
        DbControl db = DbControl.getInstance();
        try {
            Vector<Field> vecFields = new Vector<Field>();
            vecFields.addElement(new Field("WFName", wwp.WFName));
            vecFields.addElement(new Field("WFID", wwp.WFID));
            WFFirstNodeDocID = WfEngine.getFirstDocUNID(wwp.WFID);
            vecFields.addElement(new Field("NodeName", "\u5df2\u8bbe\u5b9a\u6d41\u7a0b"));
            vecFields.addElement(new Field("NodeID", WFFirstNodeDocID));
            vecFields.addElement(new Field("NodeNumber", "0"));
            vecFields.addElement(new Field("NodeUserModifyType", "1"));
            vecFields.addElement(new Field("NodeMulteit", "0"));
            db.doUpdate("wf_node_record", vecFields, "InstanceID='" + InstanceID + "' and NodeID='NullWF'", cn);
        }
        catch (Exception e) {
            WfLog.runtimeException(this, "updateWFTrackNodeRecord", e);
            throw e;
        }
        return WFFirstNodeDocID;
    }

    public HashMap wfTrackNextNodeRecordInitialize(String InstanceID, String NodeID, HashMap hmParam, Connection cn) throws Exception {
        String SqlStr = "";
        HashMap<String, String> hm = new HashMap<String, String>();
        String NodeNumber = "1";
        String NodePlanEndTime = (String)hmParam.get("NodePlanEndTime");
        DbControl db = DbControl.getInstance();
        try {
            String NextNodePlanEndTime;
            String NodeNotificationTime;
            String NodeTimelimitEfficient;
            String NodeTimelimitRepeat;
            Vector vecData;
            Vector<Field> vecFields = new Vector<Field>();
            String WFID = (String)hmParam.get("WFID");
            String WFName = (String)hmParam.get("WFName");
            String FlowTrace = (String)hmParam.get("FlowTrace");
            String roleid = (String)hmParam.get("roleid");
            roleid = roleid == null ? null : (roleid.startsWith("R.") ? roleid.substring(2) : roleid);
            String nowtime = DatetimeUtils.getNowDateTimeString();
            VO_wf_node_property wnp = WFCache.getInstance().getNodeProperty(NodeID);
            boolean isTreat = false;
            if (StringUtils.getElementsNUM(FlowTrace, NodeID, ";") > 1 && (vecData = db.performQuery(SqlStr = "select NodeNumber from wf_node_record where InstanceID='" + InstanceID + "' and NodeID='" + NodeID + "'", cn)) != null && vecData.size() > 0) {
                Vector vecRow = (Vector)vecData.elementAt(0);
                NodeNumber = (String)vecRow.elementAt(0);
                int kk = Integer.parseInt(NodeNumber) + 1;
                NodeNumber = String.valueOf(kk);
                vecFields.addElement(new Field("NodeNumber", NodeNumber));
                vecFields.addElement(new Field("NodeEndTime", ""));
                vecFields.addElement(new Field("CountTime", nowtime));
                vecFields.addElement(new Field("NodeStatus", "0"));
                vecFields.addElement(new Field("CurrentNodeUsers", String.valueOf((String)hmParam.get("CurrentNodeUsers")) + ";"));
                vecFields.addElement(new Field("CurrentNodeUser", (String)hmParam.get("CurrentNodeUser")));
                vecFields.addElement(new Field("originalusers", (String)hmParam.get("originalusers")));
                vecFields.addElement(new Field("PreProcessorList", (String)hmParam.get("PreProcessorList")));
                NodeTimelimitRepeat = "";
                NodeTimelimitRepeat = wnp.NodeTimelimitRepeat == null || wnp.NodeTimelimitRepeat.equals("") ? "D1" : wnp.NodeTimelimitRepeat;
                NodeTimelimitEfficient = "";
                NodeNotificationTime = "";
                NodeTimelimitEfficient = wnp.NodeTimelimitEfficient == null || wnp.NodeTimelimitEfficient.equals("") ? "D1" : wnp.NodeTimelimitEfficient;
                NextNodePlanEndTime = (String)hmParam.get("NextNodePlanEndTime");
                NodeNotificationTime = NextNodePlanEndTime != null && !NextNodePlanEndTime.equals("") ? (NextNodePlanEndTime.length() == 19 ? NextNodePlanEndTime : DatetimeUtils.convertDateTimeString(nowtime, NextNodePlanEndTime, "after")) : DatetimeUtils.convertDateTimeString(NodePlanEndTime, NodeTimelimitEfficient, "before");
                vecFields.addElement(new Field("NodeTimelimitNotification", wnp.NodeTimelimitNotification));
                vecFields.addElement(new Field("NodePlanEndTime", NodePlanEndTime));
                vecFields.addElement(new Field("NodeNotificationTime", NodeNotificationTime));
                vecFields.addElement(new Field("NodeDurationRepeatTimes", "0"));
                vecFields.addElement(new Field("NodeTimelimitRepeat", NodeTimelimitRepeat));
                vecFields.addElement(new Field("NodeNextNotificationTime", NodeNotificationTime));
                if (roleid != null && roleid.trim().length() != 0) {
                    vecFields.addElement(new Field("roleid", roleid == null ? "" : roleid));
                }
                db.doUpdate("wf_node_record", vecFields, "InstanceID='" + InstanceID + "' and NodeID='" + NodeID + "'", cn);
                isTreat = true;
            }
            if (!isTreat) {
                vecFields.addElement(new Field("InstanceID", InstanceID));
                vecFields.addElement(new Field("WFID", WFID));
                vecFields.addElement(new Field("WFName", WFName));
                vecFields.addElement(new Field("NodeID", NodeID));
                vecFields.addElement(new Field("NodeName", StringUtils.gb2iso((String)hmParam.get("NodeName"))));
                vecFields.addElement(new Field("NodeSign", wnp.NodeSign));
                vecFields.addElement(new Field("NodeNumber", "1"));
                vecFields.addElement(new Field("NodeStartTime", nowtime));
                vecFields.addElement(new Field("CountTime", nowtime));
                vecFields.addElement(new Field("NodeStatus", (String)hmParam.get("NodeStatus")));
                vecFields.addElement(new Field("PrevNodeName", (String)hmParam.get("PreNodeName")));
                vecFields.addElement(new Field("NodeUserModifyType", (String)hmParam.get("NodeUserModifyType")));
                vecFields.addElement(new Field("CurrentNodeUsers", String.valueOf((String)hmParam.get("CurrentNodeUsers")) + ";"));
                if (hmParam.get("CurrentNodeUser").toString().indexOf(";") == -1) {
                    vecFields.addElement(new Field("CurrentNodeUser", (String)hmParam.get("CurrentNodeUser")));
                }
                vecFields.addElement(new Field("CurrentNodeProcessors", ""));
                vecFields.addElement(new Field("originalusers", (String)hmParam.get("originalusers")));
                vecFields.addElement(new Field("PreProcessorList", (String)hmParam.get("PreProcessorList")));
                String IsLastUser = (String)hmParam.get("IsLastUser");
                if (IsLastUser != null && IsLastUser.equals("1")) {
                    vecFields.addElement(new Field("NodeMulteit", "0"));
                } else {
                    vecFields.addElement(new Field("NodeMulteit", "1"));
                }
                NodeTimelimitRepeat = "";
                NodeTimelimitRepeat = wnp.NodeTimelimitRepeat == null || wnp.NodeTimelimitRepeat.equals("") ? "D1" : wnp.NodeTimelimitRepeat;
                NodeTimelimitEfficient = "";
                NodeNotificationTime = "";
                NodeTimelimitEfficient = wnp.NodeTimelimitEfficient == null || wnp.NodeTimelimitEfficient.equals("") ? "D1" : wnp.NodeTimelimitEfficient;
                NextNodePlanEndTime = (String)hmParam.get("NextNodePlanEndTime");
                NodeNotificationTime = NextNodePlanEndTime != null && !NextNodePlanEndTime.equals("") ? (NextNodePlanEndTime.length() == 19 ? NextNodePlanEndTime : DatetimeUtils.convertDateTimeString(nowtime, NextNodePlanEndTime, "after")) : DatetimeUtils.convertDateTimeString(NodePlanEndTime, NodeTimelimitEfficient, "before");
                vecFields.addElement(new Field("NodeTimelimitNotification", wnp.NodeTimelimitNotification));
                vecFields.addElement(new Field("NodePlanEndTime", NodePlanEndTime));
                vecFields.addElement(new Field("NodeNotificationTime", NodeNotificationTime));
                vecFields.addElement(new Field("NodeDurationRepeatTimes", "0"));
                vecFields.addElement(new Field("NodeTimelimitRepeat", NodeTimelimitRepeat));
                vecFields.addElement(new Field("NodeNextNotificationTime", NodeNotificationTime));
                vecFields.addElement(new Field("NodeWeigh", String.valueOf(wnp.NodeWeigh)));
                if (hmParam.get("nodeorgid") != null && hmParam.get("nodeorgid").toString().length() > 0) {
                    vecFields.addElement(new Field("orgid", hmParam.get("nodeorgid").toString()));
                }
                roleid = roleid == null ? "" : (roleid.startsWith("R.") ? roleid.substring(2) : roleid);
                vecFields.addElement(new Field("roleid", roleid));
                db.doInsert("wf_node_record", vecFields, cn);
            }
        }
        catch (Exception e) {
            WfLog.runtimeException(this, "wfTrackNextNodeRecordINitialize", e);
            throw e;
        }
        hm.put("NodeNumber", NodeNumber);
        return hm;
    }

    public void wfTrackNextNodeRecordInitializeForFreeRouter(EVO vo, Connection cn) throws Exception {
        String NextNodeUserID = vo.getNextNodeUser() == null || vo.getNextNodeUser().equals("") ? vo.getCurrentUserID() : vo.getNextNodeUser();
        DbControl db = DbControl.getInstance();
        try {
            String nowtime = DatetimeUtils.getNowDateTimeString();
            Vector<Field> vecFields = new Vector<Field>();
            vecFields.addElement(new Field("InstanceID", vo.getInstanceID()));
            vecFields.addElement(new Field("WFName", "\u81ea\u7531\u6d41\u7a0b"));
            vecFields.addElement(new Field("WFID", "wffreerouter"));
            vecFields.addElement(new Field("NodeName", "\u81ea\u7531\u6d41\u7a0b"));
            vecFields.addElement(new Field("NodeID", vo.getNodeID()));
            vecFields.addElement(new Field("NodeNumber", "1"));
            vecFields.addElement(new Field("NodeStartTime", nowtime));
            vecFields.addElement(new Field("CountTime", nowtime));
            vecFields.addElement(new Field("NodeStatus", "0"));
            vecFields.addElement(new Field("PrevNodeName", "\u81ea\u7531\u6d41\u7a0b"));
            vecFields.addElement(new Field("NodeUserModifyType", "1"));
            vecFields.addElement(new Field("CurrentNodeUsers", String.valueOf(NextNodeUserID) + ";"));
            vecFields.addElement(new Field("CurrentNodeUser", NextNodeUserID));
            vecFields.addElement(new Field("CurrentNodeProcessors", ""));
            vecFields.addElement(new Field("originalusers", NextNodeUserID));
            vecFields.addElement(new Field("PreProcessorList", "wffreerouter"));
            vecFields.addElement(new Field("NodeMulteit", "0"));
            db.doInsert("wf_node_record", vecFields, cn);
        }
        catch (Exception e) {
            WfLog.runtimeException(this, "wfTrackNextNodeRecordInitializeForFreeRouter", e);
            throw e;
        }
    }

    public void wfTrackControlNodeRecord(String InstanceID, String NodeID, Connection cn, String orgid) throws Exception {
        DbControl db = DbControl.getInstance();
        try {
            VO_wf_node_property wnp = WFCache.getInstance().getNodeProperty(NodeID);
            String WFID = wnp.WFID;
            String NodeName = wnp.NodeName;
            Vector<Field> vecFields = new Vector<Field>();
            vecFields.addElement(new Field("InstanceID", InstanceID));
            vecFields.addElement(new Field("WFID", WFID));
            vecFields.addElement(new Field("NodeName", NodeName));
            vecFields.addElement(new Field("NodeID", NodeID));
            vecFields.addElement(new Field("NodeSign", wnp.NodeSign));
            vecFields.addElement(new Field("NodeNumber", "1"));
            String nowtime = DatetimeUtils.getNowDateTimeString();
            vecFields.addElement(new Field("NodeStartTime", nowtime));
            vecFields.addElement(new Field("NodeEndTime", nowtime));
            vecFields.addElement(new Field("CountTime", nowtime));
            vecFields.addElement(new Field("NodeAcceptTime", nowtime));
            vecFields.addElement(new Field("NodeStatus", "1"));
            vecFields.addElement(new Field("NodeMulteit", "0"));
            vecFields.addElement(new Field("NodeUserModifyType", "0"));
            vecFields.addElement(new Field("NodeWeigh", String.valueOf(wnp.NodeWeigh)));
            db.doInsert("wf_node_record", vecFields, cn);
            EVO vo = new EVO();
            vo.setInstanceID(InstanceID);
            vo.setNodeID(NodeID);
            vo.setNodeName(NodeName);
            vo.setCurrentUserID("admin");
            vo.setNextNodeUser("admin");
            vo.setTip("\u81ea\u52a8\u63d0\u4ea4\u5f53\u524d\u8282\u70b9\u529e\u7406");
            vo.setOrgid(orgid);
            this.wfTrackUpdateNodeReord(vo, cn);
        }
        catch (Exception e) {
            WfLog.runtimeException(this, "wfTrackControlNodeRecord", e);
            throw e;
        }
    }

    public boolean wfTrackUpdateNodeReord(EVO vo, Connection cn) throws Exception {
        boolean result = false;
        String PersonName = vo.getCurrentUserID();
        String SendTo = vo.getNextNodeUser();
        String ActionDetail = vo.getTip();
        String orgid = vo.getOrgid();
        String originaler = vo.getOriginalUser();
        DbControl db = DbControl.getInstance();
        UNIDProducer unid = new UNIDProducer();
        OrgClass orgclass = OrgClass.getInstance();
        OrgIF oif = OrgFactory.getInstance().getOrgClass();
        try {
            String NodeName;
            String ActionName = "";
            String ActTime = DatetimeUtils.getNowDateTimeString();
            ActionName = ActionDetail;
            if (originaler != null && !originaler.equals("")) {
                ActionName = String.valueOf(ActionName) + ";\u539f\u529e\u7406\u4eba:" + orgclass.getUserNameByUserID(originaler, cn) + "\u4ee3\u529e\u4eba\uff1a" + orgclass.getUserNameByUserID(SendTo, cn) + ";";
            }
            if (ActionName.length() > 300) {
                ActionName = String.valueOf(ActionName.substring(0, 295)) + "...";
            }
            if ((NodeName = vo.getNodeName()) == null || NodeName.equals("")) {
                VO_wf_node_property wnp = WFCache.getInstance().getNodeProperty(vo.getNodeID());
                NodeName = wnp.NodeName;
            }
            String strSql = "select roleid from wf_node_record where instanceid='" + vo.getInstanceID() + "' and nodeid='" + vo.getNodeID() + "' ";
            Vector vec = db.performQuery(strSql, cn);
            Vector rowVec = (Vector)vec.elementAt(0);
            String roleid = (String)rowVec.elementAt(0);
            String actionRecord = unid.getUNID();
            Vector<Field> vecFields = new Vector<Field>();
            vecFields.addElement(new Field("NodeActionID", actionRecord));
            vecFields.addElement(new Field("InstanceID", vo.getInstanceID()));
            vecFields.addElement(new Field("NodeID", vo.getNodeID()));
            vecFields.addElement(new Field("NodeName", NodeName));
            vecFields.addElement(new Field("TransActor", PersonName));
            vecFields.addElement(new Field("TransActorName", orgclass.getUserNameByUserID(PersonName, cn)));
            vecFields.addElement(new Field("ActTime", ActTime));
            vecFields.addElement(new Field("ActionName", StringUtils.gb2iso(ActionName)));
            vecFields.addElement(new Field("SendTo", SendTo));
            String SendToName = SendTo == null || SendTo.equals("-") || SendTo.equals("") ? "-" : (SendTo.substring(0, 2).equals("T.") ? "\u9879\u76ee\u6c60" : orgclass.getUserNameByUserID(SendTo, cn));
            vecFields.addElement(new Field("SendToName", SendToName));
            String sendToRoleId = vo.getRoleid();
            String SendToRoleName = vo.getRoleName();
            String string = sendToRoleId == null ? "" : (sendToRoleId = sendToRoleId.startsWith("R.") ? sendToRoleId.substring(2) : sendToRoleId);
            if (SendToRoleName == null || SendToRoleName.length() == 0) {
                SendToRoleName = sendToRoleId.equals("eChainOtherRole") ? "\u4efb\u610f\u89d2\u8272" : (sendToRoleId != null && sendToRoleId.length() > 0 && sendToRoleId.startsWith("T.") ? "\u9879\u76ee\u6c60" : (sendToRoleId == null || sendToRoleId.length() == 0 ? "" : oif.getRoleModel(null, sendToRoleId, null).getRolename()));
            }
            vecFields.addElement(new Field("SendToRoleID", sendToRoleId));
            vecFields.addElement(new Field("SendToRoleName", SendToRoleName));
            vecFields.addElement(new Field("RouteID", vo.getFieldID()));
            vecFields.addElement(new Field("RouteName", StringUtils.gb2iso(vo.getFieldName())));
            vecFields.addElement(new Field("NextNodeID", vo.getNextNodeID()));
            vecFields.addElement(new Field("NextNodeName", StringUtils.gb2iso(vo.getNextNodeName())));
            vecFields.addElement(new Field("orgid", orgid));
            roleid = roleid == null ? "" : (roleid.startsWith("R.") ? roleid.substring(2) : roleid);
            String roleName = "";
            roleName = roleid.equals("eChainOtherRole") ? "\u4efb\u610f\u89d2\u8272" : (roleid != null && roleid.length() > 0 && roleid.startsWith("T.") ? "\u9879\u76ee\u6c60" : (roleid == null || roleid.length() == 0 ? "" : oif.getRoleModel(null, roleid, null).getRolename()));
            vecFields.addElement(new Field("roleid", roleid));
            vecFields.addElement(new Field("rolename", roleName));
            db.doInsert("wf_node_action_record", vecFields, cn);
            this.updateActionIDToComment(vo, actionRecord, cn);
            result = true;
        }
        catch (Exception e) {
            result = false;
            WfLog.runtimeException(this, "wfTrackUpdateNodeReord", e);
            throw e;
        }
        return result;
    }

    public boolean updateActionIDToComment(EVO vo, String actionRecord, Connection cn) throws Exception {
        boolean result = false;
        String userId = vo.getCurrentUserID();
        String orgid = vo.getOrgid();
        String insatnceid = vo.getInstanceID();
        String nodeid = vo.getNodeID();
        String commentidBiz = null;
        String commentidWf = null;
        Vector<Field> vecFields = new Vector<Field>();
        DbControl db = DbControl.getInstance();
        try {
            String strSqlWf;
            Vector vectWf;
            String strSqlBiz = "select COMMENTID from wf_comment_ext where instanceid='" + insatnceid + "' and nodeid='" + nodeid + "' and userid='" + userId + "' and NodeActionID is null and SuperCommID is null";
            Vector vectBiz = db.performQuery(strSqlBiz, cn);
            if (vectBiz != null && vectBiz.size() > 0) {
                commentidBiz = (String)((Vector)vectBiz.get(0)).get(0);
            }
            if ((vectWf = db.performQuery(strSqlWf = "select commentID from wf_comment where instanceid='" + insatnceid + "' and nodeid='" + nodeid + "' and userid='" + userId + "' and NodeActionID is null", cn)) != null && vectWf.size() > 0) {
                commentidWf = (String)((Vector)vectWf.get(0)).get(0);
            }
            vecFields.addElement(new Field("NodeActionID", actionRecord));
            if (commentidBiz != null && commentidBiz.length() > 0) {
                db.doUpdate("wf_comment_ext", vecFields, " COMMENTID='" + commentidBiz + "' or SuperCommID='" + commentidBiz + "'", cn);
            }
            if (commentidWf != null && commentidWf.length() > 0) {
                vecFields.add(new Field("commentTime", DatetimeUtils.getNowDateTimeString()));
                db.doUpdate("wf_comment", vecFields, " COMMENTID='" + commentidWf + "'", cn);
            }
            result = true;
        }
        catch (Exception e) {
            result = false;
            WfLog.runtimeException(this, "updateActionIDToComment", e);
            throw e;
        }
        return result;
    }

    public boolean wfTrackNodeRecordEnd(EVO vo, boolean IsEnd, Connection cn) throws Exception {
        boolean result = false;
        String InstanceID = vo.getInstanceID();
        String NodeID = vo.getNodeID();
        DbControl db = DbControl.getInstance();
        try {
            if (IsEnd) {
                String CountTime;
                String NodeAcceptTime;
                String nowtime = DatetimeUtils.getNowDateTimeString();
                String string = NodeAcceptTime = vo.getNodeAcceptTime() == null ? nowtime : vo.getNodeAcceptTime().trim();
                if (NodeAcceptTime == null || NodeAcceptTime.equals("-") || NodeAcceptTime.length() != 19) {
                    NodeAcceptTime = nowtime;
                }
                Vector vecData = db.performQuery("select NodeStartTime,CountTime,CostTimes from wf_node_record where InstanceID='" + InstanceID + "' and NodeID='" + NodeID + "'", cn);
                Vector vecRow = (Vector)vecData.elementAt(0);
                int CostTimes = 0;
                if (vecRow.elementAt(2) != null && vecRow.elementAt(2).toString().length() > 0) {
                    CostTimes = Integer.parseInt((String)vecRow.elementAt(2));
                }
                if ((CountTime = (String)vecRow.elementAt(1)) == null || CountTime.length() != 19) {
                    CountTime = (String)vecRow.elementAt(0);
                }
                if (CountTime != null && CountTime.length() == 19) {
                    CostTimes += DatetimeUtils.countTimeByInt(CountTime, nowtime);
                }
                Vector<Field> vecFields = new Vector<Field>();
                vecFields.addElement(new Field("NodeEndTime", nowtime));
                vecFields.addElement(new Field("NodeAcceptTime", NodeAcceptTime));
                vecFields.addElement(new Field("CostTimes", String.valueOf(CostTimes)));
                vecFields.addElement(new Field("NodeStatus", "1"));
                vecFields.addElement(new Field("CurrentNodeUser", vo.getCurrentUserID()));
                vecFields.addElement(new Field("orgid", vo.getOrgid()));
                db.doUpdate("wf_node_record", vecFields, "InstanceID='" + InstanceID + "' and NodeID='" + NodeID + "'", cn);
                this.wfTrackUpdateNodeReord(vo, cn);
            } else {
                vo.setNextNodeUser("-");
                Vector<Field> vecFields = new Vector<Field>();
                vecFields.addElement(new Field("NodeStatus", "2"));
                vecFields.addElement(new Field("CurrentNodeUser", vo.getCurrentUserID()));
                vecFields.addElement(new Field("orgid", vo.getOrgid()));
                db.doUpdate("wf_node_record", vecFields, "InstanceID='" + InstanceID + "' and NodeID='" + NodeID + "'", cn);
                this.wfTrackUpdateNodeReord(vo, cn);
            }
            result = true;
        }
        catch (Exception e) {
            result = false;
            WfLog.runtimeException(this, "wfTrackNodeRecordEnd", e);
            throw e;
        }
        return result;
    }

    public boolean wfTrackWholeRecordEnd(EVO vo, Connection cn) throws Exception {
        DbControl db = DbControl.getInstance();
        Vector<Field> vecFields = new Vector<Field>();
        boolean Result = false;
        try {
            String nowtime = DatetimeUtils.getNowDateTimeString();
            vecFields.addElement(new Field("InstanceID", vo.getInstanceID()));
            vecFields.addElement(new Field("WFID", vo.getWFID()));
            vecFields.addElement(new Field("WFName", vo.getWFName()));
            vecFields.addElement(new Field("NodeID", vo.getNextNodeID()));
            vecFields.addElement(new Field("NodeName", "\u7ed3\u675f"));
            vecFields.addElement(new Field("NodeNumber", "1"));
            vecFields.addElement(new Field("NodeStartTime", nowtime));
            vecFields.addElement(new Field("NodeEndTime", nowtime));
            vecFields.addElement(new Field("CountTime", nowtime));
            vecFields.addElement(new Field("NodeAcceptTime", nowtime));
            vecFields.addElement(new Field("CostTimes", "0"));
            vecFields.addElement(new Field("NodeStatus", "1"));
            vecFields.addElement(new Field("NodeUserModifyType", "0"));
            vecFields.addElement(new Field("CurrentNodeUsers", String.valueOf(vo.getCurrentUserID()) + ";"));
            vecFields.addElement(new Field("CurrentNodeUser", vo.getCurrentUserID()));
            vecFields.addElement(new Field("CurrentNodeProcessors", ""));
            vecFields.addElement(new Field("NodeMulteit", "0"));
            vecFields.addElement(new Field("orgid", vo.getOrgid()));
            db.doInsert("wf_node_record", vecFields, cn);
            vecFields = new Vector();
            vecFields.addElement(new Field("WFStatus", "1"));
            vecFields.addElement(new Field("WFEndTime", nowtime));
            Vector vecData = db.performQuery("select WFStartTime from wf_main_record where InstanceID='" + vo.getInstanceID() + "'", cn);
            Vector vecRow = (Vector)vecData.elementAt(0);
            int CostTimes = 0;
            String WFStartTime = (String)vecRow.elementAt(0);
            if (WFStartTime != null && WFStartTime.length() == 19) {
                CostTimes = DatetimeUtils.countTimeByInt(WFStartTime, nowtime);
            }
            vecFields.addElement(new Field("CostTimes", String.valueOf(CostTimes)));
            db.doUpdate("wf_main_record", vecFields, "InstanceID='" + vo.getInstanceID() + "'", cn);
            String strSql = "insert into wf_main_recordEND(InstanceID,bizseqno,custID,custName,MainInstanceID,MainNodeID,WFStartTime,WFEndTime,WFPlanEndTime,WFStatus,WFType,WFID,WFName,WFSign,AppID,AppName,WFAdmin,WFReaders,WFAgent,WFChange,WFAgain,WFRecall,WFReturnBack,WFHangup,WFWake,WFJump,orgid,depid,CostTimes,sysid) select InstanceID,bizseqno,custID,custName,MainInstanceID,MainNodeID,WFStartTime,WFEndTime,WFPlanEndTime,WFStatus,WFType,WFID,WFName,WFSign,AppID,AppName,WFAdmin,WFReaders,WFAgent,WFChange,WFAgain,WFRecall,WFReturnBack,WFHangup,WFWake,WFJump,orgid,depid,CostTimes,sysid from wf_main_record where InstanceID='" + vo.getInstanceID() + "'";
            db.performSql(strSql, cn);
            strSql = "insert into wf_node_recordEND(InstanceID,WFID,WFName,NodeID,NodeName,NodeNumber,NodeStartTime,NodeEndTime,NodeAcceptTime,NodeStatus,NodePlanEndTime,CostTimes,CurrentNodeUsers,CurrentNodeUser,CurrentNodeProcessors,originalusers,NodeMulteit,NodeUserModifyType,NodeWeigh,orgid,roleid,nodesign) select InstanceID,WFID,WFName,NodeID,NodeName,NodeNumber,NodeStartTime,NodeEndTime,NodeAcceptTime,NodeStatus,NodePlanEndTime,CostTimes,CurrentNodeUsers,CurrentNodeUser,CurrentNodeProcessors,originalusers,NodeMulteit,NodeUserModifyType,NodeWeigh,orgid,roleid,nodesign from wf_node_record where InstanceID='" + vo.getInstanceID() + "'";
            db.performSql(strSql, cn);
            strSql = "insert into wf_node_action_recordEND select * from wf_node_action_record where InstanceID='" + vo.getInstanceID() + "'";
            db.performSql(strSql, cn);
            strSql = "insert into wf_commentEND(commentID,NODEACTIONID,InstanceID,NodeID,NodeName,userID,userName,appendRole,commentTime,commentType,commentLevel,commentSign,commentContent,orgid) select commentID,NODEACTIONID,InstanceID,NodeID,NodeName,userID,userName,appendRole,commentTime,commentType,commentLevel,commentSign,commentContent,orgid from wf_comment where InstanceID='" + vo.getInstanceID() + "'";
            db.performSql(strSql, cn);
            strSql = "insert into wf_comment_extEND select * from wf_comment_ext where InstanceID = '" + vo.getInstanceID() + "'";
            db.performSql(strSql, cn);
            strSql = "delete from wf_comment where InstanceID='" + vo.getInstanceID() + "'";
            db.performSql(strSql, cn);
            strSql = "delete from wf_node_action_record where InstanceID='" + vo.getInstanceID() + "'";
            db.performSql(strSql, cn);
            strSql = "delete from wf_node_record where InstanceID='" + vo.getInstanceID() + "'";
            db.performSql(strSql, cn);
            strSql = "delete from wf_main_record where InstanceID='" + vo.getInstanceID() + "'";
            db.performSql(strSql, cn);
            strSql = "delete from wf_comment_ext where InstanceID = '" + vo.getInstanceID() + "'";
            db.performSql(strSql, cn);
            Result = true;
        }
        catch (Exception e) {
            WfLog.runtimeException(this, "wfTrackWholeRecordEnd", e);
            throw e;
        }
        return Result;
    }

    public Vector getWorkFlowHistory(EVO vo) {
        Vector<EVO> resultVec;
        long dst;
        block25: {
            dst = System.currentTimeMillis();
            String InstanceID = vo.getInstanceID();
            String CurrentUserID = vo.getCurrentUserID();
            boolean canRead = false;
            resultVec = new Vector<EVO>();
            if (InstanceID == null || InstanceID.equals("") || InstanceID.equals("null")) {
                WfLog.paramException(this, "getWorkFlowHistory", vo);
                vo.setSign(1);
                vo.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
                WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u83b7\u53d6\u7b80\u5355\u6d41\u7a0b\u8ddf\u8e2a\u4fe1\u606fgetWorkFlowHistory,\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
                return resultVec;
            }
            DbControl db = DbControl.getInstance();
            Connection cn = null;
            OrgClass orgclass = OrgClass.getInstance();
            try {
                try {
                    String appid;
                    Vector vecRow;
                    cn = db.getConnection();
                    if (CurrentUserID == null || CurrentUserID.equals("")) {
                        canRead = true;
                    }
                    if (WfPropertyManager.getInstance().mapWFAdmin.get(CurrentUserID) != null || WfPropertyManager.getInstance().mapWFAdmin.get("${ALL}") != null) {
                        canRead = true;
                    }
                    String authWFType = WfPropertyManager.getInstance().authWFType;
                    String nodename = "\u7ed3\u675f";
                    String SqlStr = "select appid from wf_main_record where InstanceID='" + InstanceID + "'";
                    Vector vecData = db.performQuery(SqlStr, cn);
                    if (vecData == null || vecData.size() == 0) {
                        if (!canRead) {
                            SqlStr = "select appid from wf_main_recordEND where InstanceID='" + InstanceID + "'";
                            vecData = db.performQuery(SqlStr, cn);
                            vecRow = (Vector)vecData.elementAt(0);
                            appid = (String)vecRow.elementAt(0);
                            if (authWFType == null || !authWFType.contains(appid)) {
                                canRead = true;
                            }
                        }
                        SqlStr = "select NodeName,TransActor,ActTime,ActionName,SendTo,RouteID,RouteName,NextNodeID,NextNodeName,TransActorName,rolename,SendToName,SendToRoleName,orgid,NodeActionId,NodeId from wf_node_action_recordEND where InstanceID='" + InstanceID + "' order by ActTime desc";
                        vecData = db.performQuery(SqlStr, cn);
                    } else {
                        if (!canRead) {
                            SqlStr = "select appid from wf_main_record where InstanceID='" + InstanceID + "'";
                            vecData = db.performQuery(SqlStr, cn);
                            vecRow = (Vector)vecData.elementAt(0);
                            appid = (String)vecRow.elementAt(0);
                            if (authWFType == null || !authWFType.contains(appid)) {
                                canRead = true;
                            }
                            if (!canRead && (vecData = db.performQuery(SqlStr = "select CurrentNodeUsers,CurrentNodeUser from wf_instance_node_property where InstanceID='" + InstanceID + "'", cn)).size() > 0) {
                                vecRow = (Vector)vecData.elementAt(0);
                                String currentNodeUsers = (String)vecRow.elementAt(0);
                                String currentNodeUser = (String)vecRow.elementAt(1);
                                if (currentNodeUsers != null && currentNodeUsers.contains(CurrentUserID) || currentNodeUser != null && currentNodeUser.contains(CurrentUserID)) {
                                    canRead = true;
                                }
                            }
                        }
                        SqlStr = "select NodeName,TransActor,ActTime,ActionName,SendTo,RouteID,RouteName,NextNodeID,NextNodeName,TransActorName,rolename,SendToName,SendToRoleName,orgid,NodeActionId,NodeId from wf_node_action_record where InstanceID='" + InstanceID + "' order by ActTime desc";
                        vecData = db.performQuery(SqlStr, cn);
                    }
                    int i = 0;
                    while (i < vecData.size()) {
                        vecRow = (Vector)vecData.elementAt(i);
                        String transActor = (String)vecRow.elementAt(1);
                        String sendTo = (String)vecRow.elementAt(4);
                        if (transActor != null && transActor.equals(CurrentUserID) || sendTo != null && sendTo.equals(CurrentUserID)) {
                            canRead = true;
                        }
                        if (canRead) {
                            EVO obj = new EVO();
                            obj.setInstanceID(InstanceID);
                            obj.setNodeName(StringUtils.iso2gb((String)vecRow.elementAt(0)));
                            obj.setNodeStartTime((String)vecRow.elementAt(2));
                            obj.setMethods(StringUtils.iso2gb((String)vecRow.elementAt(3)));
                            obj.setFieldID((String)vecRow.elementAt(5));
                            obj.setFieldName(StringUtils.iso2gb((String)vecRow.elementAt(6)));
                            obj.setNextNodeID((String)vecRow.elementAt(7));
                            obj.setNextNodeName(StringUtils.iso2gb((String)vecRow.elementAt(8)));
                            obj.setUserID(transActor);
                            obj.setUserName(StringUtils.iso2gb((String)vecRow.elementAt(9)));
                            obj.setRoleName(StringUtils.iso2gb((String)vecRow.elementAt(10)));
                            obj.setNextNodeUser((String)vecRow.elementAt(4) == null ? null : StringUtils.iso2gb((String)vecRow.elementAt(11)));
                            obj.setExv10((String)vecRow.elementAt(12));
                            obj.setOrgname((String)vecRow.elementAt(13));
                            obj.setNodeActionId((String)vecRow.elementAt(14));
                            obj.setNodeID((String)vecRow.elementAt(15));
                            resultVec.addElement(obj);
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    WfLog.runtimeException(this, "getWorkFlowHistory", e);
                    try {
                        db.freeConnection(cn);
                    }
                    catch (Exception e2) {
                        WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                        e2.printStackTrace();
                    }
                    break block25;
                }
            }
            catch (Throwable throwable) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                db.freeConnection(cn);
            }
            catch (Exception e) {
                WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                e.printStackTrace();
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u83b7\u53d6\u7b80\u5355\u6d41\u7a0b\u8ddf\u8e2a\u4fe1\u606fgetWorkFlowHistory(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return resultVec;
    }

    public Vector getWorkFlowHistory_bak(EVO vo) {
        Vector<EVO> resultVec;
        long dst;
        block15: {
            dst = System.currentTimeMillis();
            String InstanceID = vo.getInstanceID();
            resultVec = new Vector<EVO>();
            if (InstanceID == null || InstanceID.equals("") || InstanceID.equals("null")) {
                WfLog.paramException(this, "getWorkFlowHistory", vo);
                vo.setSign(1);
                vo.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
                WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u83b7\u53d6\u7b80\u5355\u6d41\u7a0b\u8ddf\u8e2a\u4fe1\u606fgetWorkFlowHistory,\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
                return resultVec;
            }
            DbControl db = DbControl.getInstance();
            Connection cn = null;
            OrgClass orgclass = OrgClass.getInstance();
            try {
                try {
                    Vector vecRow;
                    cn = db.getConnection();
                    String nodename = "\u7ed3\u675f";
                    String SqlStr = "select bizseqno from wf_main_record where InstanceID='" + InstanceID + "'";
                    Vector vecData = db.performQuery(SqlStr, cn);
                    if (vecData == null || vecData.size() == 0) {
                        SqlStr = "select NodeName,TransActor,ActTime,ActionName,SendTo,RouteID,RouteName,NextNodeID,NextNodeName,TransActorName,rolename,SendToName,SendToRoleName,getorgname(orgid) as orgname  from wf_node_action_recordEND where InstanceID='" + InstanceID + "' order by ActTime desc";
                        vecData = db.performQuery(SqlStr, cn);
                    } else {
                        SqlStr = "select NodeName from wf_instance_node_property where InstanceID='" + InstanceID + "'";
                        vecData = db.performQuery(SqlStr, cn);
                        vecRow = (Vector)vecData.elementAt(0);
                        nodename = (String)vecRow.elementAt(0);
                        SqlStr = "select NodeName,TransActor,ActTime,ActionName,SendTo,RouteID,RouteName,NextNodeID,NextNodeName,TransActorName,rolename,SendToName,SendToRoleName,getorgname(orgid) as orgname from wf_node_action_record where InstanceID='" + InstanceID + "' order by ActTime desc";
                        vecData = db.performQuery(SqlStr, cn);
                    }
                    EVO obj = new EVO();
                    obj.setInstanceID(InstanceID);
                    obj.setNodeName(nodename);
                    obj.setUserName("-");
                    obj.setNodeStartTime("-");
                    obj.setMethods("-");
                    obj.setNextNodeUser("-");
                    obj.setFieldID("-");
                    obj.setFieldName("-");
                    obj.setNextNodeID("-");
                    obj.setNextNodeName("-");
                    obj.setExv10("-");
                    obj.setRoleName("-");
                    obj.setOrgname("-");
                    resultVec.addElement(obj);
                    int i = 0;
                    while (i < vecData.size()) {
                        vecRow = (Vector)vecData.elementAt(i);
                        obj = new EVO();
                        obj.setInstanceID(InstanceID);
                        obj.setNodeName(StringUtils.iso2gb((String)vecRow.elementAt(0)));
                        obj.setNodeStartTime((String)vecRow.elementAt(2));
                        obj.setMethods(StringUtils.iso2gb((String)vecRow.elementAt(3)));
                        obj.setFieldID((String)vecRow.elementAt(5));
                        obj.setFieldName(StringUtils.iso2gb((String)vecRow.elementAt(6)));
                        obj.setNextNodeID((String)vecRow.elementAt(7));
                        obj.setNextNodeName(StringUtils.iso2gb((String)vecRow.elementAt(8)));
                        obj.setUserName(StringUtils.iso2gb((String)vecRow.elementAt(9)));
                        obj.setRoleName(StringUtils.iso2gb((String)vecRow.elementAt(10)));
                        obj.setNextNodeUser((String)vecRow.elementAt(4) == null ? null : StringUtils.iso2gb((String)vecRow.elementAt(11)));
                        obj.setExv10((String)vecRow.elementAt(12));
                        obj.setOrgname((String)vecRow.elementAt(13));
                        resultVec.addElement(obj);
                        ++i;
                    }
                }
                catch (Exception e) {
                    WfLog.runtimeException(this, "getWorkFlowHistory", e);
                    try {
                        db.freeConnection(cn);
                    }
                    catch (Exception e2) {
                        WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                        e2.printStackTrace();
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                db.freeConnection(cn);
            }
            catch (Exception e) {
                WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                e.printStackTrace();
            }
        }
        WfLog.log(0, "\u6267\u884c\u64cd\u4f5c\uff1a\u83b7\u53d6\u7b80\u5355\u6d41\u7a0b\u8ddf\u8e2a\u4fe1\u606fgetWorkFlowHistory(),\u7528\u65f6:" + (System.currentTimeMillis() - dst) + "\u6beb\u79d2");
        return resultVec;
    }

    public HashMap getWFMainRecord(String InstanceID) {
        HashMap<String, String> hm = new HashMap<String, String>();
        DbControl db = DbControl.getInstance();
        Connection cn = null;
        try {
            try {
                cn = db.getConnection();
                Vector<String> vecFields = new Vector<String>();
                vecFields.addElement("wfstarttime");
                vecFields.addElement("wfendtime");
                vecFields.addElement("wfplanendtime");
                vecFields.addElement("wfstatus");
                vecFields.addElement("wfid");
                vecFields.addElement("wfname");
                vecFields.addElement("appid");
                vecFields.addElement("appname");
                vecFields.addElement("wfadmin");
                vecFields.addElement("wfreaders");
                vecFields.addElement("wfagent");
                vecFields.addElement("wfchange");
                vecFields.addElement("wfagain");
                vecFields.addElement("wfrecall");
                vecFields.addElement("wfreturnback");
                vecFields.addElement("wfhangup");
                vecFields.addElement("wfwake");
                vecFields.addElement("costtimes");
                Vector vecData = db.performQueryHashMap("wf_main_record", vecFields, "InstanceID='" + InstanceID + "'", cn);
                if (vecData == null || vecData.size() == 0) {
                    vecData = db.performQueryHashMap("wf_main_recordEND", vecFields, "InstanceID='" + InstanceID + "'", cn);
                }
                if (vecData.size() > 0) {
                    HashMap hmData = (HashMap)vecData.elementAt(0);
                    hm.put("wfstarttime", (String)hmData.get("wfstarttime"));
                    hm.put("wfendtime", (String)hmData.get("wfendtime"));
                    hm.put("wfplanendtime", (String)hmData.get("wfplanendtime"));
                    hm.put("wfstatus", (String)hmData.get("wfstatus"));
                    hm.put("wfid", (String)hmData.get("wfid"));
                    hm.put("wfname", StringUtils.iso2gb((String)hmData.get("wfname")));
                    hm.put("appid", (String)hmData.get("appid"));
                    hm.put("appname", StringUtils.iso2gb((String)hmData.get("appname")));
                    hm.put("wfadmin", (String)hmData.get("wfadmin"));
                    hm.put("wfreaders", (String)hmData.get("wfreaders"));
                    hm.put("wfagent", (String)hmData.get("wfagent"));
                    hm.put("wfchange", (String)hmData.get("wfchange"));
                    hm.put("wfagain", (String)hmData.get("wfagain"));
                    hm.put("wfrecall", (String)hmData.get("wfrecall"));
                    hm.put("wfreturnback", (String)hmData.get("wfreturnback"));
                    hm.put("wfhangup", (String)hmData.get("wfhangup"));
                    hm.put("wfwake", (String)hmData.get("wfwake"));
                    hm.put("costtimes", (String)hmData.get("costtimes"));
                    hm.put("instanceid", InstanceID);
                }
            }
            catch (Exception e) {
                WfLog.runtimeException(this, "getWFMainRecord", e);
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e2) {
                    WfLog.log(4, "\u65e0\u6cd5\u63d0\u4ea4\u5f53\u524d\u4e8b\u52a1\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                db.freeConnection(cn);
            }
            catch (Exception e) {
                WfLog.log(4, "\u65e0\u6cd5\u63d0\u4ea4\u5f53\u524d\u4e8b\u52a1\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                e.printStackTrace();
            }
        }
        return hm;
    }

    public Vector getWFNodeRecord(String InstanceID) {
        Vector vect = new Vector();
        DbControl db = DbControl.getInstance();
        Connection cn = null;
        try {
            try {
                cn = db.getConnection();
                Vector<String> vecFields = new Vector<String>();
                vecFields.addElement("wfid");
                vecFields.addElement("wfname");
                vecFields.addElement("nodeid");
                vecFields.addElement("nodesign");
                vecFields.addElement("nodename");
                vecFields.addElement("nodenumber");
                vecFields.addElement("nodestarttime");
                vecFields.addElement("nodeplanendtime");
                vecFields.addElement("nodeendtime");
                vecFields.addElement("nodeaccepttime");
                vecFields.addElement("costtimes");
                vecFields.addElement("nodestatus");
                vecFields.addElement("currentnodeusers");
                vecFields.addElement("currentnodeuser");
                vecFields.addElement("currentnodeprocessors");
                vecFields.addElement("nodeusermodifytype");
                vecFields.addElement("nodemulteit");
                vecFields.addElement("nodeweigh");
                Vector vecData = db.performQueryHashMap("wf_node_record", vecFields, "InstanceID='" + InstanceID + "' order by NodeStartTime", cn);
                if (vecData == null || vecData.size() == 0) {
                    vecData = db.performQueryHashMap("wf_node_recordEND", vecFields, "InstanceID='" + InstanceID + "' order by NodeStartTime", cn);
                }
                if (vecData.size() > 0) {
                    int i = 0;
                    while (i < vecData.size()) {
                        HashMap hmData = (HashMap)vecData.elementAt(i);
                        HashMap<String, String> hmNode = new HashMap<String, String>();
                        hmNode.put("InstanceID", InstanceID);
                        hmNode.put("wfid", (String)hmData.get("wfid"));
                        hmNode.put("wfname", StringUtils.iso2gb((String)hmData.get("wfname")));
                        hmNode.put("nodeid", (String)hmData.get("nodeid"));
                        hmNode.put("nodesign", (String)hmData.get("nodesign"));
                        hmNode.put("nodename", StringUtils.iso2gb((String)hmData.get("nodename")));
                        hmNode.put("nodenumber", (String)hmData.get("nodenumber"));
                        hmNode.put("nodestarttime", (String)hmData.get("nodestarttime"));
                        hmNode.put("nodeplanendtime", (String)hmData.get("nodeplanendtime"));
                        hmNode.put("nodeendtime", (String)hmData.get("nodeendtime"));
                        hmNode.put("nodeaccepttime", (String)hmData.get("nodeaccepttime"));
                        hmNode.put("costtimes", (String)hmData.get("costtimes"));
                        hmNode.put("nodestatus", (String)hmData.get("nodestatus"));
                        hmNode.put("currentnodeusers", (String)hmData.get("currentnodeusers"));
                        hmNode.put("currentnodeuser", (String)hmData.get("currentnodeuser"));
                        hmNode.put("currentnodeprocessors", (String)hmData.get("currentnodeprocessors"));
                        hmNode.put("nodeusermodifytype", (String)hmData.get("nodeusermodifytype"));
                        hmNode.put("nodemulteit", (String)hmData.get("nodemulteit"));
                        hmNode.put("nodeweigh", (String)hmData.get("nodeweigh"));
                        vect.add(hmNode);
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                WfLog.runtimeException(this, "getWFNodeRecord", e);
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e2) {
                    WfLog.log(4, "\u65e0\u6cd5\u63d0\u4ea4\u5f53\u524d\u4e8b\u52a1\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                db.freeConnection(cn);
            }
            catch (Exception e) {
                WfLog.log(4, "\u65e0\u6cd5\u63d0\u4ea4\u5f53\u524d\u4e8b\u52a1\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                e.printStackTrace();
            }
        }
        return vect;
    }

    public ArrayList getWFNodeAction(String InstanceID) {
        ArrayList al = new ArrayList();
        String SqlStr = "";
        String orgid = "";
        DbControl db = DbControl.getInstance();
        Connection cn = null;
        try {
            try {
                Vector vecRow;
                cn = db.getConnection();
                SqlStr = "select orgid from wf_main_record where InstanceID='" + InstanceID + "'";
                Vector vecData = db.performQuery(SqlStr, cn);
                if (vecData == null || vecData.size() == 0) {
                    SqlStr = "select orgid from wf_main_recordEND where InstanceID='" + InstanceID + "'";
                    vecData = db.performQuery(SqlStr, cn);
                    vecRow = (Vector)vecData.elementAt(0);
                    orgid = (String)vecRow.elementAt(0);
                    SqlStr = "select NodeActionID,NodeID,transactor,acttime,actionname,sendto from wf_node_action_recordEND where InstanceID='" + InstanceID + "' order by acttime";
                    vecData = db.performQuery(SqlStr, cn);
                } else {
                    vecRow = (Vector)vecData.elementAt(0);
                    orgid = (String)vecRow.elementAt(0);
                    SqlStr = "select NodeActionID,NodeID,transactor,acttime,actionname,sendto from wf_node_action_record where InstanceID='" + InstanceID + "' order by acttime";
                    vecData = db.performQuery(SqlStr, cn);
                }
                if (vecData.size() > 0) {
                    OrgClass orgclass = OrgClass.getInstance();
                    int i = 0;
                    while (i < vecData.size()) {
                        vecRow = (Vector)vecData.elementAt(i);
                        HashMap<String, String> hmNode = new HashMap<String, String>();
                        hmNode.put("NodeActionID", (String)vecRow.elementAt(0));
                        hmNode.put("nodeid", (String)vecRow.elementAt(1));
                        hmNode.put("transactor", orgclass.getUserNameByUserID((String)vecRow.elementAt(2), cn));
                        hmNode.put("acttime", (String)vecRow.elementAt(3));
                        hmNode.put("actionname", StringUtils.iso2gb((String)vecRow.elementAt(4)));
                        hmNode.put("sendto", orgclass.getUserNameByUserID((String)vecRow.elementAt(5), cn));
                        al.add(hmNode);
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                WfLog.runtimeException(this, "getWFNodeAction", e);
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e2) {
                    WfLog.log(4, "\u65e0\u6cd5\u63d0\u4ea4\u5f53\u524d\u4e8b\u52a1\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                db.freeConnection(cn);
            }
            catch (Exception e) {
                WfLog.log(4, "\u65e0\u6cd5\u63d0\u4ea4\u5f53\u524d\u4e8b\u52a1\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                e.printStackTrace();
            }
        }
        return al;
    }
}

