/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.echain.workflow.engine;

import com.ecc.echain.db.DbControl;
import com.ecc.echain.log.WfLog;
import com.ecc.echain.util.DatetimeUtils;
import com.ecc.echain.util.StringUtils;
import com.ecc.echain.util.WfPropertyManager;
import com.ecc.echain.workflow.engine.EVO;
import com.ecc.echain.workflow.engine.OrgClass;
import com.ecc.echain.workflow.engine.WfEngine;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;

public class WfSimulation {
    private List fxList = new ArrayList();
    private long bltime = 0L;
    private long cxtime = 0L;
    private long cost = 0L;
    private Map hm = new HashMap();

    public EVO doWFTest(EVO vo) throws Exception {
        WfLog.log(2, "\u3010\u6d41\u7a0b\u4eff\u771f\u3011============Start=================");
        String wfid = vo.getWFID();
        String userid = vo.getCurrentUserID();
        String orgid = vo.getOrgid();
        if (wfid == null || wfid.length() == 0 || userid == null || userid.length() == 0) {
            vo.setSign(1);
            vo.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u539f\u56e0\u662f\uff1a\u60a8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
            return vo;
        }
        EVO obj = new EVO();
        obj.setWFID(wfid);
        obj.setCurrentUserID(userid);
        obj.setOrgid(orgid);
        obj.setJobName("_eChainTest_");
        WfEngine we = WfEngine.getInstance();
        obj = we.initializeWFWholeDocUNID(obj);
        String InstanceID = obj.getInstanceID();
        if (InstanceID == null || InstanceID.length() < 1) {
            vo.setSign(1);
            vo.setTip("\u65e0\u6cd5\u521b\u5efa\u6d41\u7a0b\u5b9e\u4f8b");
            return vo;
        }
        vo.setInstanceID(InstanceID);
        String NodeID = obj.getNodeID();
        DbControl db = DbControl.getInstance();
        Connection cn = null;
        try {
            cn = db.getConnection();
            this.hm = (Map)vo.getUserObject();
            WfLog.log(2, "\u3010\u6d41\u7a0b\u4eff\u771f\u3011\u521d\u59cb\u5316\u6d41\u7a0b\u53d8\u91cf=" + vo.paramMap);
            WfLog.log(2, "\u3010\u6d41\u7a0b\u4eff\u771f\u3011\u521d\u59cb\u5316\u4eff\u771f\u53c2\u6570=" + this.hm);
            if (vo.paramMap != null && vo.paramMap.size() > 0) {
                obj = new EVO();
                obj.setCurrentUserID(userid);
                obj.setOrgid(orgid);
                obj.setInstanceID(InstanceID);
                obj.paramMap = vo.paramMap;
                obj = we.wfSaveJob(obj, cn);
                if (obj.getSign() == 1) {
                    vo.setSign(1);
                    vo.setTip("\u4fdd\u5b58\u5b9e\u4f8b\u5931\u8d25");
                    EVO eVO = vo;
                    return eVO;
                }
            }
            try {
                obj = new EVO();
                obj.setCurrentUserID(userid);
                obj.setOrgid(orgid);
                obj.setInstanceID(InstanceID);
                obj.setNodeID(NodeID);
                this.fxList.add("\u529e\u7406\u8fc7\u7a0b\u5206\u6790\uff1a");
                obj = this.doRecursionSubmit(obj, cn);
                this.fxList.add("");
                this.fxList.add("\u6d41\u7a0b\u5168\u5c40\u8fc7\u7a0b\u7edf\u8ba1\uff1a");
                this.fxList.add("\u6d41\u7a0b\u529e\u7406\u65f6\u95f4\uff1a" + DatetimeUtils.countTimeToString(this.bltime * 60L));
                this.fxList.add("\u6d41\u7a0b\u6301\u7eed\u65f6\u95f4\uff1a" + DatetimeUtils.countTimeToString(this.cxtime * 60L));
                this.fxList.add("\u6d41\u7a0b\u8017\u8d39\u6210\u672c\uff1a" + this.cost);
                vo.setUserObject(this.fxList);
                vo.setSign(obj.getSign());
                vo.setTip(obj.getTip());
                if (!WfPropertyManager.getInstance().autocommit) {
                    cn.commit();
                }
                WfLog.log(2, "\u3010\u6d41\u7a0b\u4eff\u771f\u3011============End=================");
            }
            catch (Exception e) {
                if (cn != null) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                vo.setSign(1);
                vo.setTip("\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u63a7\u5236\u53f0\u5f02\u5e38\u4fe1\u606f\u5e76\u4e0e\u6d41\u7a0b\u7ba1\u7406\u5458\u53d6\u5f97\u8054\u7cfb\uff01");
                e.printStackTrace();
            }
        }
        finally {
            try {
                db.freeConnection(cn);
            }
            catch (Exception exception) {}
        }
        return vo;
    }

    private EVO doRecursionSubmit(EVO vo, Connection cn) throws Exception {
        WfEngine we = WfEngine.getInstance();
        String InstanceID = vo.getInstanceID();
        String userid = vo.getCurrentUserID();
        String orgid = vo.getOrgid();
        WfLog.log(2, "\u3010\u6d41\u7a0b\u4eff\u771f\u3011\u5f53\u524d\u8282\u70b9=" + vo.getNodeID() + ";\u5f53\u524d\u7528\u6237=" + userid);
        if (this.hm.get(vo.getNodeID()) != null) {
            Vector v = (Vector)this.hm.get(vo.getNodeID());
            int blt = Integer.parseInt((String)v.get(3));
            int zgt = Integer.parseInt((String)v.get(4));
            int c = Integer.parseInt((String)v.get(5)) * blt / 60;
            int cxt = blt;
            if (zgt < 8) {
                cxt = blt * 8 / zgt;
            }
            this.fxList.add("\u8282\u70b9\uff1a" + v.get(1) + ", \u529e\u7406\u4eba\uff1a" + userid + ", \u529e\u7406\u65f6\u95f4\uff1a" + blt + "\u5206\u949f, \u6301\u7eed\u65f6\u95f4\uff1a" + cxt + "\u5206\u949f, \u8282\u70b9\u6210\u672c\uff1a" + c + ";");
            this.bltime += (long)blt;
            this.cxtime += (long)cxt;
            this.cost += (long)c;
        }
        EVO obj = we.getNextNodeList(vo, cn);
        HashMap hm = (HashMap)obj.paramMap.get(this.getMapRandom(obj.paramMap));
        String NextNodeID = (String)hm.get("nodeid");
        String NextNodeType = (String)hm.get("nodetype");
        vo.setNextNodeID(NextNodeID);
        if (NextNodeType != null && NextNodeType.equals("E")) {
            vo = we.wfCompleteJob(vo, cn);
            return vo;
        }
        obj = new EVO();
        obj.setInstanceID(InstanceID);
        obj.setCurrentUserID(userid);
        obj.setNodeID(NextNodeID);
        obj.setOrgid(orgid);
        obj = we.getNodeUserList(obj, cn);
        String NextNodeUser = obj.isExb() ? "U.admin" : (String)this.getMapRandom(obj.paramMap);
        while (!NextNodeUser.startsWith("U.")) {
            NextNodeUser = (String)this.getMapRandom(obj.paramMap);
        }
        WfLog.log(2, "\u3010\u6d41\u7a0b\u4eff\u771f\u3011\u4e0b\u4e00\u8282\u70b9=" + NextNodeID + ";\u4e0b\u4e00\u7528\u6237=" + NextNodeUser);
        vo.setNextNodeUser(NextNodeUser);
        vo = we.wfCompleteJob(vo, cn);
        NextNodeID = vo.getNextNodeID();
        obj = new EVO();
        obj.setInstanceID(InstanceID);
        obj.setOrgid(orgid);
        obj.setNodeID(NextNodeID);
        NextNodeUser = OrgClass.getInstance().convertPersonsList_str(orgid, NextNodeUser, cn);
        NextNodeUser = StringUtils.getFirstElement(NextNodeUser, ";");
        obj.setCurrentUserID(NextNodeUser);
        vo = this.doRecursionSubmit(obj, cn);
        return vo;
    }

    private Object getMapRandom(HashMap hm) {
        if (hm == null || hm.size() == 0) {
            return null;
        }
        Random rd = new Random();
        int n = rd.nextInt(hm.size());
        Iterator it = hm.keySet().iterator();
        int i = 0;
        Object key = null;
        while (it.hasNext()) {
            key = it.next();
            if (n == i) break;
            ++i;
        }
        return key;
    }
}

