/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.echain.workflow.engine;

import com.ecc.echain.db.DbControl;
import com.ecc.echain.ext.AppExtFactory;
import com.ecc.echain.log.WfLog;
import com.ecc.echain.org.OrgFactory;
import com.ecc.echain.org.OrgIF;
import com.ecc.echain.org.model.OrgModel;
import com.ecc.echain.org.model.UserModel;
import com.ecc.echain.util.DatetimeUtils;
import com.ecc.echain.util.Field;
import com.ecc.echain.util.StringUtils;
import com.ecc.echain.util.UNIDProducer;
import com.ecc.echain.workflow.engine.EVO;
import com.ecc.echain.workflow.engine.OrgClass;
import com.ecc.echain.workflow.engine.WorkFlowClient;
import com.ecc.echain.workflow.model.GatherActionVO;
import com.ecc.echain.workflow.model.GatherVO;
import java.sql.Connection;
import java.util.Map;
import java.util.Vector;

public class WfGatherEngine {
    private static WfGatherEngine gatherInstance = new WfGatherEngine();
    private static final String[] virtualDept = new String[]{"0A", "0B", "0C", "0D", "0E", "0F", "0G", "0H", "0I", "0J", "0K", "0L", "0M", "0N"};
    private static final String VIR_DEPT_ALL = "AL";

    private WfGatherEngine() {
    }

    public static WfGatherEngine getInstance() {
        return gatherInstance;
    }

    public GatherVO initializeGather(GatherVO vo, Connection conn) throws Exception {
        if (vo == null || conn == null) {
            GatherVO retObj = new GatherVO();
            vo.setSign(1);
            vo.setTip("\u4f1a\u529e\u53d1\u8d77\u5931\u8d25\uff01GatherVO\u548c\u6570\u636e\u5e93\u8fde\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
            WfLog.log("\u4f1a\u529e", 4, "\u4f1a\u529e\u53d1\u8d77\u5931\u8d25\uff01GatherVO\u548c\u6570\u636e\u5e93\u8fde\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
            return retObj;
        }
        Vector<Field> vecFields = new Vector<Field>();
        String gatherStartUserID = this.removeUserFlag(vo.getGatherStartUserID(), "");
        gatherStartUserID = gatherStartUserID.substring(0, gatherStartUserID.length() - 1);
        String gatherStartUserName = vo.getGatherStartUserName();
        String currentGatherUserList = this.removeUserFlag(vo.getCurrentGatherUserList(), ";");
        String gatherEndUserID = this.removeUserFlag(vo.getGatherEndUserID(), ";");
        gatherEndUserID = gatherEndUserID.substring(0, gatherEndUserID.length() - 1);
        String gatherEndUserName = vo.getGatherEndUserName();
        try {
            if (gatherStartUserID == null || gatherStartUserID.trim().equals("") || currentGatherUserList == null || currentGatherUserList.trim().equals("")) {
                vo.setTip("\u4f1a\u529e\u53d1\u8d77\u4eba\u3001\u4f1a\u529e\u53c2\u4e0e\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                vo.setSign(1);
                WfLog.log("eChain-\u4f1a\u529e", 4, "\u4f1a\u529e\u53d1\u8d77\u4eba\u3001\u4f1a\u529e\u53c2\u4e0e\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                return vo;
            }
            if (currentGatherUserList.split(";").length > virtualDept.length) {
                vo.setTip("\u4f1a\u529e\u53c2\u4e0e\u4eba\u8fc7\u591a\uff01\u4f1a\u529e\u53c2\u4e0e\u4eba\u4e0d\u80fd\u8d85\u8fc7\uff1a" + virtualDept.length);
                vo.setSign(1);
                WfLog.log("eChain-\u4f1a\u529e", 4, "\u4f1a\u529e\u53c2\u4e0e\u4eba\u8fc7\u591a\uff01\u4f1a\u529e\u53c2\u4e0e\u4eba\u4e0d\u80fd\u8d85\u8fc7\uff1a" + virtualDept.length);
                return vo;
            }
            if (gatherStartUserName == null || gatherStartUserName.equals("") || gatherStartUserName.equals("null")) {
                gatherStartUserName = this.userID2Name(gatherStartUserID, ";", conn);
            }
            if (gatherEndUserID == null || gatherEndUserID.trim().equals("")) {
                gatherEndUserID = gatherStartUserID;
            }
            if (gatherEndUserName == null || gatherEndUserName.equals("") || gatherEndUserName.equals("null")) {
                gatherEndUserName = this.userID2Name(gatherEndUserID, ";", conn);
            }
            if (currentGatherUserList.split(";").length >= 1 && !currentGatherUserList.endsWith(";")) {
                currentGatherUserList = String.valueOf(currentGatherUserList) + ";";
            }
            String instanceID = new UNIDProducer().getUNID();
            String allProcessorName = this.userID2Name(currentGatherUserList, ";", conn);
            String newCurrentGatherUserList = "";
            String[] tmp = currentGatherUserList.split(";");
            int i = 0;
            while (i < tmp.length) {
                newCurrentGatherUserList = String.valueOf(newCurrentGatherUserList) + virtualDept[i] + "_" + tmp[i] + ";";
                ++i;
            }
            vecFields.add(new Field("InstanceID", instanceID));
            vecFields.add(new Field("BeforeInstanceID", vo.getBeforeInstanceID()));
            vecFields.add(new Field("MainInstanceID", vo.getMainInstanceID()));
            vecFields.add(new Field("BizSeqNo", vo.getBizSeqNo()));
            vecFields.add(new Field("MainNodeID", vo.getMainNodeID()));
            vecFields.add(new Field("MainNodeName", vo.getMainNodeName()));
            vecFields.add(new Field("MainJobName", vo.getMainJobName()));
            vecFields.add(new Field("GatherStartUserID", vo.getGatherStartUserID()));
            vecFields.add(new Field("GatherStartUserName", gatherStartUserName));
            vecFields.add(new Field("GatherEndUserID", gatherEndUserID));
            vecFields.add(new Field("GatherEndUserName", gatherEndUserName));
            vecFields.add(new Field("GatherTitle", vo.getGatherTitle()));
            vecFields.add(new Field("GatherDesc", vo.getGatherDesc()));
            vecFields.add(new Field("CurrentGatherUserList", newCurrentGatherUserList));
            vecFields.add(new Field("AllProcessor", newCurrentGatherUserList));
            vecFields.add(new Field("AllProcessorName", allProcessorName));
            vecFields.add(new Field("CurrentGatherProcessors", ""));
            vecFields.add(new Field("GatherStartTime", DatetimeUtils.getNowDateTimeString()));
            vecFields.add(new Field("sysid", vo.getSysid()));
            DbControl.getInstance().doInsert("wf_instance_gather_property", vecFields, vo.getConnection());
            vo.setInstanceID(instanceID);
            vo.setAllProcessor(currentGatherUserList);
            vo.setAllProcessorName(allProcessorName);
            this.wfTrackGatherRecord(vo, "new", VIR_DEPT_ALL, conn);
            if (vo.getMainInstanceID() != null || vo.getMainInstanceID().length() > 0) {
                WorkFlowClient.getInstance();
                WorkFlowClient wfc = WorkFlowClient.getInstance();
                EVO evo = new EVO();
                evo.setInstanceID(vo.getMainInstanceID());
                evo.setConnection(vo.getConnection());
                evo = wfc.getInstanceInfo(evo);
                AppExtFactory.getInstance().getAppExtClass(evo.getWFID()).startGather(vo, null);
            }
        }
        catch (Exception e) {
            WfLog.runtimeException(this, "initializeGather", e);
            throw e;
        }
        vo.setSign(0);
        vo.setTip("\u3010" + vo.getGatherStartUserName() + "\u3011\u53d1\u8d77\u4f1a\u529e\u6210\u529f,\u4f1a\u529e\u53c2\u4e0e\u4eba\uff1a" + vo.getAllProcessorName());
        WfLog.log("eChain-\u4f1a\u529e", 0, String.valueOf(vo.getGatherStartUserID()) + "\u53d1\u8d77\u4f1a\u529e\u6210\u529f,\u4f1a\u529e\u53c2\u4e0e\u4eba\uff1a" + vo.getAllProcessorName());
        return vo;
    }

    public GatherVO wfCompleteGather(GatherVO vo, Connection conn) throws Exception {
        if (vo == null || conn == null) {
            GatherVO retObj = new GatherVO();
            vo.setSign(1);
            vo.setTip("\u4f1a\u529e\u53d1\u8d77\u5931\u8d25\uff01GatherVO\u548c\u6570\u636e\u5e93\u8fde\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
            WfLog.log("eChain-\u4f1a\u529e", 4, "\u4f1a\u529e\u53d1\u8d77\u5931\u8d25\uff01GatherVO\u548c\u6570\u636e\u5e93\u8fde\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
            return retObj;
        }
        String currentUserID = vo.getCurrentUserID();
        String instanceID = vo.getInstanceID();
        DbControl db = DbControl.getInstance();
        try {
            if (currentUserID == null || currentUserID.trim().equals("") || currentUserID.equals("null") || instanceID == null || instanceID.trim().equals("")) {
                vo.setTip("\u4f1a\u529e\u63d0\u4ea4\u5931\u8d25\uff01\n\u5f53\u7528\u6237\u7f16\u53f7\uff0c\u6570\u636e\u5e93\u8fde\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
                vo.setSign(1);
                WfLog.log("eChain-\u4f1a\u529e", 4, "\u4f1a\u529e\u63d0\u4ea4\u5931\u8d25\uff01\n\u5f53\u7528\u6237\u7f16\u53f7\uff0c\u6570\u636e\u5e93\u8fde\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
                return vo;
            }
            String virDeptNo = this.getVirtualDept(instanceID, currentUserID, conn);
            String selSql = "select BeforeInstanceID,MainInstanceID,BizSeqNo,MainNodeID,MainNodeName, \tMainJobName,GatherStartUserID,GatherEndUserID,GatherTitle,GatherDesc,\tCurrentGatherUserList,AllProcessor,CurrentGatherProcessors,GatherStartTime from wf_instance_gather_property where InstanceID='" + instanceID + "'";
            Vector vec = db.performQuery(selSql, conn);
            Vector vecElement = (Vector)vec.get(0);
            String currentGatherUserList = (String)vecElement.get(10);
            String currentGatherProcessors = (String)vecElement.get(12);
            if (currentGatherUserList == null || !StringUtils.isPartOf(currentGatherUserList, String.valueOf(virDeptNo) + "_" + currentUserID, ";")) {
                vo.setSign(1);
                vo.setTip("\u5f53\u524d\u7528\u6237" + currentUserID + " \u6ca1\u6709\u6743\u9650\u5904\u7406\u8be5\u4f1a\u529e");
                return vo;
            }
            currentGatherUserList = StringUtils.delSubStr2(currentGatherUserList, String.valueOf(virDeptNo) + "_" + currentUserID, ";");
            currentGatherProcessors = currentGatherProcessors == null || currentGatherProcessors.equals("null") ? String.valueOf(virDeptNo) + "_" + currentUserID + ";" : String.valueOf(currentGatherProcessors) + virDeptNo + "_" + currentUserID + ";";
            Vector<Field> vecFields = new Vector<Field>();
            vecFields.add(new Field("CurrentGatherUserList", currentGatherUserList));
            vecFields.add(new Field("CurrentGatherProcessors", currentGatherProcessors));
            db.doUpdate("wf_instance_gather_property", vecFields, " InstanceID='" + instanceID + "' ", conn);
            vo.setBeforeInstanceID((String)vecElement.get(0));
            vo.setMainInstanceID((String)vecElement.get(1));
            vo.setBizSeqNo((String)vecElement.get(2));
            vo.setMainNodeID((String)vecElement.get(3));
            vo.setMainNodeName((String)vecElement.get(4));
            vo.setMainJobName((String)vecElement.get(5));
            vo.setGatherStartUserID((String)vecElement.get(6));
            vo.setGatherEndUserID((String)vecElement.get(7));
            vo.setGatherTitle((String)vecElement.get(8));
            vo.setGatherDesc((String)vecElement.get(9));
            vo.setCurrentGatherUserList(currentGatherProcessors);
            vo.setAllProcessor((String)vecElement.get(11));
            vo.setCurrentGatherProcessors(currentGatherProcessors);
            vo.setGatherStartTime((String)vecElement.get(13));
            this.wfTrackGatherRecord(vo, "complete", virDeptNo, conn);
            if (vo.getMainInstanceID() != null || vo.getMainInstanceID().length() > 0) {
                WorkFlowClient.getInstance();
                WorkFlowClient wfc = WorkFlowClient.getInstance();
                EVO evo = new EVO();
                evo.setInstanceID(vo.getMainInstanceID());
                evo.setConnection(vo.getConnection());
                evo = wfc.getInstanceInfo(evo);
                AppExtFactory.getInstance().getAppExtClass(evo.getWFID()).submitGather(vo, null);
            }
        }
        catch (Exception e) {
            WfLog.runtimeException(this, "wfCompleteGather", e);
            throw e;
        }
        OrgClass org = OrgClass.getInstance();
        vo.setSign(0);
        vo.setTip("\u3010" + org.getUserNameByUserID(vo.getCurrentUserID(), conn) + "\u3011\u4e8e" + DatetimeUtils.getNowDateTimeString() + "\u63d0\u4ea4\u4f1a\u529e\u7ed9\u6c47\u603b\u4eba\uff1a" + org.getUserNameByUserID(vo.getGatherEndUserID(), conn));
        WfLog.log("eChain-\u4f1a\u529e", 0, String.valueOf(vo.getCurrentUserID()) + " \u63d0\u4ea4\u4f1a\u529e\u610f\u89c1\uff0c\u63d0\u4ea4\u4f1a\u529e\u7ed9\u6c47\u603b\u4eba\uff1a" + vo.getGatherEndUserID());
        return vo;
    }

    public GatherVO wfChangeGather(GatherVO vo, Connection conn) throws Exception {
        if (vo == null || conn == null) {
            GatherVO retObj = new GatherVO();
            retObj.setSign(1);
            retObj.setTip("\u7ed3\u675f\u8f6c\u529e\u5931\u8d25\uff01GatherVO\u548c\u6570\u636e\u5e93\u8fde\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
            WfLog.log("eChain-\u4f1a\u529e", 4, "\u7ed3\u675f\u8f6c\u529e\u5931\u8d25\uff01GatherVO\u548c\u6570\u636e\u5e93\u8fde\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
            return retObj;
        }
        DbControl db = DbControl.getInstance();
        Vector<Field> vecFields = new Vector<Field>();
        String strSql = null;
        String instanceID = null;
        String currentUserID = null;
        String nextUsers = null;
        try {
            instanceID = vo.getInstanceID();
            currentUserID = vo.getCurrentUserID();
            nextUsers = vo.getCurrentGatherUserList();
            if (instanceID == null || instanceID.trim().equals("") || currentUserID == null || currentUserID.trim().equals("") || nextUsers == null || nextUsers.trim().equals("")) {
                GatherVO retObj = new GatherVO();
                vo.setSign(1);
                vo.setTip("\u7ed3\u675f\u8f6c\u529e\u5931\u8d25\uff01\u6d41\u7a0b\u5b9e\u4f8b\u53f7\u3001\u5f53\u524d\u7528\u6237\u3001\u4e0b\u4e00\u529e\u7406\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
                WfLog.log("eChain-\u4f1a\u529e", 4, "\u7ed3\u675f\u8f6c\u529e\u5931\u8d25\uff01\u6d41\u7a0b\u5b9e\u4f8b\u53f7\u3001\u5f53\u524d\u7528\u6237\u3001\u4e0b\u4e00\u529e\u7406\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
                return retObj;
            }
            String virDeptNo = this.getVirtualDept(instanceID, currentUserID, conn);
            strSql = "select MainInstanceID,MainNodeID,MainNodeName, CurrentGatherUserList,CurrentGatherProcessors from wf_instance_gather_property where InstanceID='" + instanceID + "'";
            Vector vec = db.performQuery(strSql, conn);
            Vector vecElement = (Vector)vec.get(0);
            String mainInstanceID = (String)vecElement.get(0);
            String mainNodeID = (String)vecElement.get(1);
            String mainNodeName = (String)vecElement.get(2);
            String currentGatherUserList = (String)vecElement.get(3);
            String currentGatherProcessors = (String)vecElement.get(4);
            if (currentGatherUserList == null || !StringUtils.isPartOf(currentGatherUserList, String.valueOf(virDeptNo) + "_" + currentUserID, ";")) {
                vo.setSign(1);
                vo.setTip("\u5f53\u524d\u7528\u6237" + currentUserID + " \u6ca1\u6709\u6743\u9650\u5904\u7406\u8be5\u4f1a\u529e");
                return vo;
            }
            currentGatherProcessors = currentGatherProcessors == null || currentGatherProcessors.length() <= 0 ? String.valueOf(virDeptNo) + "_" + currentUserID + ";" : String.valueOf(currentGatherProcessors) + virDeptNo + "_" + currentUserID + ";";
            currentGatherUserList = StringUtils.delSubStr2(currentGatherUserList, String.valueOf(virDeptNo) + "_" + currentUserID, ";");
            currentGatherUserList = String.valueOf(currentGatherUserList) + virDeptNo + "_" + this.removeUserFlag(nextUsers, ";");
            vecFields.add(new Field("CurrentGatherUserList", currentGatherUserList));
            vecFields.add(new Field("CurrentGatherProcessors", currentGatherProcessors));
            db.doUpdate("wf_instance_gather_property", vecFields, " InstanceID='" + instanceID + "' ", conn);
            vo.setCurrentGatherUserList(nextUsers);
            vo.setMainInstanceID(mainInstanceID);
            vo.setMainInstanceID(mainInstanceID);
            vo.setMainNodeID(mainNodeID);
            vo.setMainNodeName(mainNodeName);
            this.wfTrackGatherRecord(vo, "change", virDeptNo, conn);
            vo.setCurrentGatherUserList(currentGatherUserList);
        }
        catch (Exception e) {
            WfLog.runtimeException(this, "wfGatherChange", e);
            throw e;
        }
        OrgClass org = OrgClass.getInstance();
        vo.setSign(0);
        vo.setTip("\u3010" + org.getUserNameByUserID(currentUserID, conn) + "\u3011\u4e8e" + DatetimeUtils.getNowDateTimeString() + "\u5c06\u4efb\u52a1\u63d0\u4ea4\u7ed9\uff1a" + org.getUserNameByUserID(nextUsers, conn));
        WfLog.log("eChain-\u4f1a\u529e", 0, "\u3010" + currentUserID + "\u3011\u4e8e" + DatetimeUtils.getNowDateTimeString() + "\u5c06\u4efb\u52a1\u63d0\u4ea4\u7ed9\uff1a" + nextUsers);
        return vo;
    }

    public GatherVO wfFinishGather(GatherVO vo, Connection conn) throws Exception {
        if (vo == null || conn == null) {
            GatherVO retObj = new GatherVO();
            vo.setSign(1);
            vo.setTip("\u7ed3\u675f\u4f1a\u529e\u5931\u8d25\uff01GatherVO\u548c\u6570\u636e\u5e93\u8fde\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
            WfLog.log("eChain-\u4f1a\u529e", 4, "\u7ed3\u675f\u4f1a\u529e\u5931\u8d25\uff01GatherVO\u548c\u6570\u636e\u5e93\u8fde\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
            return retObj;
        }
        String currentUserID = vo.getCurrentUserID();
        String instanceID = vo.getInstanceID();
        DbControl db = DbControl.getInstance();
        try {
            if (currentUserID == null || currentUserID.trim().equals("") || instanceID == null || instanceID.trim().equals("")) {
                vo.setTip("\u7ed3\u675f\u5931\u8d25\uff01\n\u5f53\u7528\u6237\u7f16\u53f7\uff0c\u6570\u636e\u5e93\u8fde\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
                vo.setSign(1);
                WfLog.log("eChain-\u4f1a\u529e", 4, "\u7ed3\u675f\u5931\u8d25\uff01\n\u5f53\u7528\u6237\u7f16\u53f7\uff0c\u6570\u636e\u5e93\u8fde\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
                return vo;
            }
            String selSql = "select BeforeInstanceID,MainInstanceID,BizSeqNo,MainNodeID,MainNodeName, \tMainJobName,GatherStartUserID,GatherEndUserID,GatherTitle,GatherDesc, \tCurrentGatherUserList,AllProcessor,CurrentGatherProcessors,GatherStartTime,GatherStartUserName, \tGatherEndUserName,AllProcessorName from wf_instance_gather_property where InstanceID='" + instanceID + "' ";
            Vector vec = db.performQuery(selSql, conn);
            if (vec == null || vec.size() <= 0) {
                GatherVO retObj = new GatherVO();
                vo.setSign(1);
                vo.setTip("\u4e0d\u5b58\u5728\u8be5\u4f1a\u529e\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u4f20\u5165\u7684\u4f1a\u529e\u7684\u5b9e\u4f8b\u53f7[" + vo.getInstanceID() + "]\u662f\u5426\u6b63\u786e");
                WfLog.log("eChain-\u4f1a\u529e", 4, "\u4e0d\u5b58\u5728\u8be5\u4f1a\u529e\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u4f20\u5165\u7684\u4f1a\u529e\u7684\u5b9e\u4f8b\u53f7[" + vo.getInstanceID() + "]\u662f\u5426\u6b63\u786e");
                return retObj;
            }
            Vector vecElement = (Vector)vec.get(0);
            String gatherEndUserID = (String)vecElement.get(7);
            if (gatherEndUserID == null || !gatherEndUserID.equalsIgnoreCase(currentUserID)) {
                vo.setTip(String.valueOf(currentUserID) + "\u6ca1\u6709\u6743\u9650\u7ed3\u675f\u8be5\u4f1a\u529e");
                vo.setSign(1);
                return vo;
            }
            vo.setBeforeInstanceID((String)vecElement.get(0));
            vo.setMainInstanceID((String)vecElement.get(1));
            vo.setBizSeqNo((String)vecElement.get(2));
            vo.setMainNodeID((String)vecElement.get(3));
            vo.setMainNodeName((String)vecElement.get(4));
            vo.setMainJobName((String)vecElement.get(5));
            vo.setGatherStartUserID((String)vecElement.get(6));
            vo.setGatherEndUserID((String)vecElement.get(7));
            vo.setGatherTitle((String)vecElement.get(8));
            vo.setGatherDesc((String)vecElement.get(9));
            vo.setCurrentGatherUserList((String)vecElement.get(10));
            vo.setAllProcessor((String)vecElement.get(11));
            vo.setCurrentGatherProcessors((String)vecElement.get(12));
            vo.setGatherStartTime((String)vecElement.get(13));
            vo.setGatherStartUserName((String)vecElement.get(14));
            vo.setGatherEndUserName((String)vecElement.get(15));
            vo.setAllProcessorName((String)vecElement.get(16));
            db.doDelete("wf_instance_gather_property", " InstanceID='" + instanceID + "'", conn);
            this.wfTrackGatherRecord(vo, "finish", VIR_DEPT_ALL, conn);
            this.wfBackUpGather(vo, conn);
            if (vo.getMainInstanceID() != null || vo.getMainInstanceID().length() > 0) {
                WorkFlowClient.getInstance();
                WorkFlowClient wfc = WorkFlowClient.getInstance();
                EVO evo = new EVO();
                evo.setInstanceID(vo.getMainInstanceID());
                evo.setConnection(vo.getConnection());
                evo = wfc.getInstanceInfo(evo);
                AppExtFactory.getInstance().getAppExtClass(evo.getWFID()).endGather(vo, null);
            }
        }
        catch (Exception e) {
            WfLog.runtimeException(this, "wfFinishGather", e);
            throw e;
        }
        OrgClass org = OrgClass.getInstance();
        vo.setSign(0);
        vo.setTip("\u3010" + org.getUserNameByUserID(vo.getCurrentUserID(), conn) + "\u3011\u4e8e " + DatetimeUtils.getNowDateTimeString() + "\u529e\u7ed3\u4f1a\u529e\u6210\u529f");
        WfLog.log("eChain-\u4f1a\u529e", 0, String.valueOf(currentUserID) + "\u529e\u7ed3\u4f1a\u529e\u6210\u529f");
        return vo;
    }

    protected GatherVO wfTrackGatherRecord(GatherVO vo, String operation, String virtualDeptNo, Connection conn) throws Exception {
        if (vo == null || conn == null) {
            GatherVO retObj = new GatherVO();
            vo.setSign(1);
            vo.setTip("\u4f1a\u529e\u64cd\u4f5c\u75d5\u8ff9\u4fdd\u7559\u5931\u8d25\uff01GatherVO\u548c\u6570\u636e\u5e93\u8fde\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
            return retObj;
        }
        GatherActionVO actionVO = vo.getGatherActionVO();
        if (actionVO == null) {
            actionVO = new GatherActionVO();
        }
        String currentUserID = vo.getCurrentUserID();
        if (virtualDeptNo == null || virtualDeptNo.trim().equals("")) {
            virtualDeptNo = this.getVirtualDept(vo.getInstanceID(), currentUserID, conn);
        }
        String action = null;
        String nextUserID = null;
        String currentUserName = this.userID2Name(vo.getCurrentUserID(), ";", conn);
        try {
            if (operation != null && operation.equalsIgnoreCase("new")) {
                action = "\u3010" + currentUserName + "\u3011\u4e8e" + DatetimeUtils.getNowDateTimeString() + "\u53d1\u8d77\u65b0\u4f1a\u529e\uff0c\u4f1a\u529e\u529e\u7406\u4eba\u5458\uff1a" + this.userID2NameStrong(vo.getAllProcessor(), ";", conn);
                nextUserID = vo.getCurrentGatherUserList();
            } else if (operation != null && operation.equalsIgnoreCase("finish")) {
                action = "\u3010" + currentUserName + "\u3011\u4e8e" + DatetimeUtils.getNowDateTimeString() + "\u529e\u7ed3\u4f1a\u529e\uff0c\u5e76\u5c06\u4f1a\u529e\u63d0\u4ea4\u7ed9" + "\u6c47\u603b\u4eba\uff1a" + this.userID2NameStrong(vo.getGatherEndUserID(), ";", conn);
                nextUserID = vo.getGatherEndUserID();
            } else if (operation != null && operation.equalsIgnoreCase("reset")) {
                action = "\u3010" + currentUserName + "\u3011\u4e8e" + DatetimeUtils.getNowDateTimeString() + "\u91cd\u7f6e\u4f1a\u529e\u529e\u7406\u4eba\uff1a" + vo.getAllProcessorName();
                nextUserID = vo.getGatherStartUserID();
            } else if (operation != null && operation.equalsIgnoreCase("change")) {
                nextUserID = vo.getCurrentGatherUserList();
                action = "\u3010" + currentUserName + "\u3011\u4e8e" + DatetimeUtils.getNowDateTimeString() + "\u5c06\u4efb\u52a1\u4ea4\u529e\u7ed9\uff1a" + this.userID2NameStrong(nextUserID, ";", conn);
            } else {
                action = "\u3010" + currentUserName + "\u3011\u4e8e" + DatetimeUtils.getNowDateTimeString() + "\u5b8c\u6210\u5f53\u524d\u8282\u70b9\uff0c\u5c06\u4f1a\u529e\u63d0\u4ea4\u7ed9" + "\u6c47\u603b\u4eba\uff1a" + this.userID2NameStrong(vo.getGatherEndUserID(), ";", conn);
                nextUserID = vo.getGatherEndUserID();
            }
            Vector<Field> vecFields = new Vector<Field>();
            vecFields.add(new Field("ActionID", new UNIDProducer().getUNID()));
            vecFields.add(new Field("InstanceID", vo.getInstanceID()));
            vecFields.add(new Field("MainInstanceID", vo.getMainInstanceID()));
            vecFields.add(new Field("MainNodeID", vo.getMainNodeID()));
            vecFields.add(new Field("MainNodeName", vo.getMainNodeName()));
            vecFields.add(new Field("TransActor", vo.getCurrentUserID()));
            vecFields.add(new Field("TransActorName", currentUserName));
            vecFields.add(new Field("ActTime", DatetimeUtils.getNowDateTimeString()));
            vecFields.add(new Field("ActionName", action));
            vecFields.add(new Field("Suggest", actionVO.getSuggest() == null ? "-" : actionVO.getSuggest()));
            vecFields.add(new Field("CommentType", actionVO.getCommentType() == null ? "-" : actionVO.getCommentType()));
            vecFields.add(new Field("CommentLevel", actionVO.getCommentLevel() == null ? "-" : actionVO.getCommentLevel()));
            vecFields.add(new Field("VirtualDeptNo", virtualDeptNo == null ? "" : virtualDeptNo));
            vecFields.add(new Field("NextActorID", this.removeUserFlag(nextUserID, ";")));
            vecFields.add(new Field("sysid", vo.getSysid()));
            DbControl db = DbControl.getInstance();
            db.doInsert("wf_gather_action_record", vecFields, conn);
        }
        catch (Exception e) {
            WfLog.runtimeException(this, "wfTrackGatherRecord", e);
            throw e;
        }
        vo.setSign(0);
        vo.setTip("\u8bb0\u5f55\u4f1a\u529e\u64cd\u4f5c\u75d5\u8ff9\u6210\u529f");
        return vo;
    }

    private GatherVO wfBackUpGather(GatherVO vo, Connection conn) throws Exception {
        try {
            DbControl db = DbControl.getInstance();
            Vector<Field> vecFields = new Vector<Field>();
            vecFields.add(new Field("InstanceID", vo.getInstanceID()));
            vecFields.add(new Field("BeforeInstanceID", vo.getBeforeInstanceID()));
            vecFields.add(new Field("MainInstanceID", vo.getMainInstanceID()));
            vecFields.add(new Field("BizSeqNo", vo.getBizSeqNo()));
            vecFields.add(new Field("MainNodeID", vo.getMainNodeID()));
            vecFields.add(new Field("MainNodeName", vo.getMainNodeName()));
            vecFields.add(new Field("MainJobName", vo.getMainJobName()));
            vecFields.add(new Field("GatherStartUserID", vo.getGatherStartUserID()));
            vecFields.add(new Field("GatherStartUserName", vo.getGatherStartUserName()));
            vecFields.add(new Field("GatherEndUserID", vo.getGatherEndUserID()));
            vecFields.add(new Field("GatherEndUserName", vo.getGatherEndUserName()));
            vecFields.add(new Field("GatherTitle", vo.getGatherTitle()));
            vecFields.add(new Field("GatherDesc", vo.getGatherDesc()));
            vecFields.add(new Field("AllProcessor", vo.getAllProcessor()));
            vecFields.add(new Field("AllProcessorName", vo.getAllProcessorName()));
            vecFields.add(new Field("CurrentGatherProcessors", vo.getCurrentGatherProcessors()));
            vecFields.add(new Field("GatherStartTime", vo.getGatherStartTime()));
            vecFields.add(new Field("GatherEndTime", DatetimeUtils.getNowDateTimeString()));
            vecFields.add(new Field("sysid", vo.getSysid()));
            db.doInsert("wf_gather_RecordEnd", vecFields, conn);
            String backSql = "insert into wf_gather_action_recordEND select * from wf_gather_action_record where  InstanceID='" + vo.getInstanceID() + "' ";
            db.performSql(backSql, conn);
            String delSql = "delete from wf_gather_action_record where InstanceID='" + vo.getInstanceID() + "' ";
            db.performSql(delSql, conn);
        }
        catch (Exception e) {
            WfLog.runtimeException(this, "wfBackUpGather", e);
            throw e;
        }
        vo.setSign(0);
        vo.setTip("\u5907\u4efd\u4f1a\u529e\u4fe1\u606f\u6210\u529f\uff01");
        WfLog.log("eChain-\u4f1a\u529e", 0, "\u5907\u4efd\u4f1a\u529e\u4fe1\u606f\u6210\u529f\uff01");
        return vo;
    }

    public GatherVO wfResetProcessor(GatherVO vo, Connection conn) throws Exception {
        if (vo == null || vo.getInstanceID() == null || vo.getInstanceID().trim().equals("") || vo.getCurrentGatherUserList() == null || vo.getCurrentGatherUserList().trim().equals("") || conn == null) {
            GatherVO retObj = new GatherVO();
            vo.setSign(1);
            vo.setTip("\u4f1a\u529e\u5b9e\u4f8b\u7f16\u53f7\u3001\u4f1a\u529e\u53c2\u4e0e\u4eba\u3001\u6570\u636e\u5e93\u8fde\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
            WfLog.log("eChain-\u4f1a\u529e", 4, "\u4f1a\u529e\u5b9e\u4f8b\u7f16\u53f7\u3001\u4f1a\u529e\u53c2\u4e0e\u4eba\u3001\u6570\u636e\u5e93\u8fde\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
            return retObj;
        }
        String instanceID = vo.getInstanceID();
        String newCurrentGatherUserList = this.removeUserFlag(vo.getCurrentGatherUserList(), ";");
        DbControl db = DbControl.getInstance();
        try {
            vo = this.getGatherInstanceInfo(vo, conn);
            String oldCurrentGatherUserList = vo.getCurrentGatherUserList();
            String oldAllProcessor = vo.getAllProcessor();
            String gatherStartUserID = vo.getGatherStartUserID();
            String currentUserID = vo.getCurrentUserID();
            if (oldAllProcessor.split(";").length > oldCurrentGatherUserList.split(";").length) {
                vo.setSign(1);
                vo.setTip("\u8be5\u4f1a\u529e\u5df2\u7ecf\u88ab\u529e\u7406\u8fc7\uff0c\u4e0d\u5141\u8bb8\u91cd\u7f6e\u4f1a\u529e\u53c2\u4e0e\u4eba\uff01");
                WfLog.log("eChain-\u4f1a\u529e", 4, "\u8be5\u4f1a\u529e\u5df2\u7ecf\u88ab\u529e\u7406\u8fc7\uff0c\u4e0d\u5141\u8bb8\u91cd\u7f6e\u4f1a\u529e\u53c2\u4e0e\u4eba\uff01");
                return vo;
            }
            if (currentUserID == null || !currentUserID.equals(gatherStartUserID)) {
                vo.setSign(1);
                vo.setTip("\u8be5\u7528\u6237\u6ca1\u6709\u91cd\u7f6e\u4f1a\u529e\u53c2\u4e0e\u4eba\u6743\u9650\uff01");
                WfLog.log("eChain-\u4f1a\u529e", 0, "\u8be5\u7528\u6237\u6ca1\u6709\u91cd\u7f6e\u4f1a\u529e\u53c2\u4e0e\u4eba\u6743\u9650\uff01");
                return vo;
            }
            String newAllProcessorName = this.userID2Name(newCurrentGatherUserList, ";", conn);
            String conCurrentGatherUserList = "";
            String[] tmp = newCurrentGatherUserList.split(";");
            int i = 0;
            while (i < tmp.length) {
                conCurrentGatherUserList = String.valueOf(conCurrentGatherUserList) + virtualDept[i] + "_" + tmp[i] + ";";
                ++i;
            }
            Vector<Field> vec = new Vector<Field>();
            vec.add(new Field("CurrentGatherUserList", conCurrentGatherUserList));
            vec.add(new Field("AllProcessor", conCurrentGatherUserList));
            vec.add(new Field("AllProcessorName", newAllProcessorName));
            db.doUpdate("wf_instance_gather_property", vec, " InstanceID='" + instanceID + "' ", conn);
            vo.setAllProcessorName(newAllProcessorName);
            vo.setAllProcessor(newCurrentGatherUserList);
            vo.setCurrentGatherUserList(newCurrentGatherUserList);
        }
        catch (Exception e) {
            WfLog.runtimeException(this, "wfResetProcessor", e);
            throw e;
        }
        vo.setSign(0);
        vo.setTip("\u91cd\u7f6e\u4f1a\u529e\u53c2\u4e0e\u4eba\u4e3a\uff1a" + vo.getAllProcessorName() + " \u6210\u529f");
        WfLog.log("eChain-\u4f1a\u529e", 0, "\u91cd\u7f6e\u4f1a\u529e\u53c2\u4e0e\u4eba\u4e3a\uff1a" + vo.getAllProcessorName() + " \u6210\u529f");
        return vo;
    }

    public GatherVO wfCheckIsFinishGather(GatherVO vo, Connection conn) throws Exception {
        if (vo == null || vo.getInstanceID() == null || vo.getInstanceID().trim().equals("") || conn == null) {
            GatherVO retObj = new GatherVO();
            vo.setSign(1);
            vo.setTip("\u4f1a\u529e\u5b9e\u4f8b\u7f16\u53f7\u3001\u6570\u636e\u5e93\u8fde\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
            return retObj;
        }
        try {
            DbControl db = DbControl.getInstance();
            String currentGatherUserList = null;
            vo = this.getGatherInstanceInfo(vo, conn);
            currentGatherUserList = vo.getCurrentGatherUserList();
            if (currentGatherUserList != null && !currentGatherUserList.trim().equals("")) {
                vo.setSign(1);
                vo.setTip("\u4ecd\u6709\u4f1a\u529e\u53c2\u4e0e\u4eba\u672a\u529e\u7406");
                return vo;
            }
            vo.setSign(0);
            vo.setTip("\u6240\u6709\u4f1a\u529e\u53c2\u4e0e\u4eba\u90fd\u5df2\u7ecf\u529e\u7406\u5b8c\u6210");
        }
        catch (Exception e) {
            WfLog.runtimeException(this, "wfCheckIsFinishGather", e);
            throw e;
        }
        WfLog.log("eChain-\u4f1a\u529e", 0, "\u5224\u65ad\u662f\u5426\u53ef\u4ee5\u7ed3\u675f\u4f1a\u529e:" + (vo.getCurrentGatherUserList() == null || vo.getCurrentGatherUserList().length() <= 0 ? "\u53ef\u4ee5\u7ed3\u675f" : "\u4e0d\u53ef\u4ee5\u7ed3\u675f"));
        return vo;
    }

    public GatherVO getGatherInstanceInfo(GatherVO vo, Connection cn) throws Exception {
        DbControl db = DbControl.getInstance();
        if (vo == null || vo.getInstanceID() == null || vo.getInstanceID().trim().equals("") || cn == null) {
            GatherVO retObj = new GatherVO();
            vo.setSign(1);
            vo.setTip("\u4f1a\u529e\u5b9e\u4f8b\u7f16\u53f7\u3001\u6570\u636e\u5e93\u8fde\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
            WfLog.log("eChain-\u4f1a\u529e", 4, "\u4f1a\u529e\u5b9e\u4f8b\u7f16\u53f7\u3001\u6570\u636e\u5e93\u8fde\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
            return retObj;
        }
        boolean isEnd = false;
        try {
            String sqlStr = "select bizseqno from wf_instance_gather_property where InstanceID='" + vo.getInstanceID() + "'";
            Vector vecData = db.performQuery(sqlStr, cn);
            if (vecData.size() == 0) {
                isEnd = true;
            }
            String fields = "";
            if (!isEnd) {
                fields = "InstanceID,BeforeInstanceID,MainInstanceID,BizSeqNo,MainNodeID,MainNodeName,MainJobName,GatherStartUserID, GatherEndUserID,GatherTitle,GatherDesc,CurrentGatherUserList,AllProcessor,CurrentGatherProcessors,GatherStartTime, GatherStartUserName, GatherEndUserName, AllProcessorName ";
                sqlStr = "select " + fields + " from wf_instance_gather_property where InstanceID='" + vo.getInstanceID() + "' ";
            } else {
                fields = "InstanceID,BeforeInstanceID,MainInstanceID,BizSeqNo,MainNodeID,MainNodeName,MainJobName,GatherStartUserID, GatherEndUserID,GatherTitle,GatherDesc,GatherEndTime,AllProcessor,CurrentGatherProcessors,GatherStartTime, GatherStartUserName, GatherEndUserName, AllProcessorName ";
                sqlStr = "select " + fields + " from wf_gather_recordend where InstanceID='" + vo.getInstanceID() + "' ";
            }
            vecData = db.performQuery2(sqlStr, cn);
            if (vecData.size() <= 0) {
                throw new Exception("\u4e0d\u5b58\u5728\u8be5\u4f1a\u529e\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u4f20\u5165\u7684\u4f1a\u529e\u7684\u5b9e\u4f8b\u53f7[" + vo.getInstanceID() + "]\u662f\u5426\u6b63\u786e");
            }
            Map mapRow = (Map)vecData.elementAt(0);
            vo.setInstanceID((String)mapRow.get("InstanceID".toUpperCase()));
            vo.setBeforeInstanceID((String)mapRow.get("BeforeInstanceID".toUpperCase()));
            vo.setMainInstanceID((String)mapRow.get("MainInstanceID".toUpperCase()));
            vo.setBizSeqNo((String)mapRow.get("BizSeqNo".toUpperCase()));
            vo.setMainNodeID((String)mapRow.get("MainNodeID".toUpperCase()));
            vo.setMainNodeName((String)mapRow.get("MainNodeName".toUpperCase()));
            vo.setMainJobName((String)mapRow.get("MainJobName".toUpperCase()));
            vo.setGatherStartUserID((String)mapRow.get("GatherStartUserID".toUpperCase()));
            vo.setGatherEndUserID((String)mapRow.get("GatherEndUserID".toUpperCase()));
            vo.setGatherTitle((String)mapRow.get("GatherTitle".toUpperCase()));
            vo.setGatherDesc((String)mapRow.get("GatherDesc".toUpperCase()));
            vo.setCurrentGatherUserList((String)mapRow.get("CurrentGatherUserList".toUpperCase()));
            vo.setAllProcessor((String)mapRow.get("AllProcessor".toUpperCase()));
            vo.setCurrentGatherProcessors((String)mapRow.get("CurrentGatherProcessors".toUpperCase()));
            vo.setGatherStartTime((String)mapRow.get("GatherStartTime".toUpperCase()));
            vo.setGatherStartUserName((String)mapRow.get("GatherStartUserName".toUpperCase()));
            vo.setGatherEndUserName((String)mapRow.get("GatherEndUserName".toUpperCase()));
            vo.setAllProcessorName((String)mapRow.get("AllProcessorName".toUpperCase()));
            vo.setGatherEndTime((String)mapRow.get("GatherEndTime".toUpperCase()));
        }
        catch (Exception e) {
            WfLog.runtimeException(this, "getGatherInstanceInfo", e);
            throw e;
        }
        vo.setSign(0);
        vo.setTip("\u83b7\u53d6\u4f1a\u529e\u5b9e\u4f8b" + vo.getInstanceID() + "\u6210\u529f");
        WfLog.log("eChain-\u4f1a\u529e", 0, "\u83b7\u53d6\u4f1a\u529e\u5b9e\u4f8b" + vo.getInstanceID() + "\u6210\u529f");
        return vo;
    }

    public Vector<GatherActionVO> getGatherActions(GatherVO vo, Connection cn) throws Exception {
        DbControl db = DbControl.getInstance();
        if (vo == null || vo.getInstanceID() == null || vo.getInstanceID().trim().equals("")) {
            throw new Exception("\u4f1a\u529e\u5b9e\u4f8b\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (vo.getCurrentUserID() == null || vo.getCurrentUserID().trim().equals("")) {
            throw new Exception("\u5f53\u524d\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (cn == null) {
            throw new Exception("\u6570\u636e\u5e93\u8fde\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        GatherActionVO actionVO = vo.getGatherActionVO();
        if (actionVO == null) {
            actionVO = new GatherActionVO();
        }
        Vector<GatherActionVO> retVec = new Vector<GatherActionVO>();
        String instanceID = vo.getInstanceID();
        String commentType = actionVO.getCommentType();
        String endSign = "";
        try {
            String sqlStr = "select bizseqno from wf_instance_gather_property where InstanceID='" + instanceID + "'";
            Vector vecData = db.performQuery(sqlStr, cn);
            if (vecData.size() == 0) {
                endSign = "END";
            }
            String deptNo = this.getVirtualDept(instanceID, vo.getCurrentUserID(), cn);
            String fields = "ActionID,InstanceID,MainInstanceID,MainNodeID,MainNodeName,TransActor,ActTime,ActionName, Suggest,memo,NextActorID,TransActorName,CommentType,CommentLevel,VirtualDeptNo ";
            String whereSql = " where InstanceID='" + instanceID + "' ";
            if (commentType != null && !commentType.trim().equals("")) {
                whereSql = String.valueOf(whereSql) + " and CommentType='" + commentType + "'";
            }
            if (!VIR_DEPT_ALL.equals(deptNo)) {
                whereSql = String.valueOf(whereSql) + " and (VirtualDeptNo='" + deptNo + "' or CommentLevel='0')";
            }
            sqlStr = "select " + fields + " from wf_gather_action_record" + endSign + whereSql + "  order by ActTime asc";
            vecData = db.performQuery(sqlStr, cn);
            int i = 0;
            while (i < vecData.size()) {
                Vector vec = (Vector)vecData.elementAt(i);
                GatherActionVO obj = new GatherActionVO();
                obj.setActionID((String)vec.get(0));
                obj.setInstanceID((String)vec.get(1));
                obj.setMainInstanceID((String)vec.get(2));
                obj.setMainNodeID((String)vec.get(3));
                obj.setMainNodeName((String)vec.get(4));
                obj.setTransActor((String)vec.get(5));
                obj.setActTime((String)vec.get(6));
                obj.setActionName((String)vec.get(7));
                obj.setSuggest((String)vec.get(8));
                obj.setMemo((String)vec.get(9));
                obj.setNextActorID((String)vec.get(10));
                obj.setTransActorName((String)vec.get(11));
                obj.setCommentType((String)vec.get(12));
                obj.setCommentLevel((String)vec.get(13));
                obj.setVirtualDeptNo((String)vec.get(14));
                retVec.add(obj);
                ++i;
            }
        }
        catch (Exception e) {
            WfLog.runtimeException(this, "getGatherInstanceInfo", e);
            throw e;
        }
        WfLog.log("eChain-\u4f1a\u529e", 0, "\u53d6\u4f1a\u529e" + vo.getInstanceID() + "\u7684\u64cd\u4f5c\u75d5\u8ff9\u4e0e\u4f1a\u529e\u610f\u89c1\u6210\u529f");
        return retVec;
    }

    public String getGatherStatus(GatherVO vo, Connection cn) throws Exception {
        String currentGatherUserList;
        StringBuffer sb;
        block10: {
            Vector vecData;
            String sqlStr;
            String instanceID;
            DbControl db;
            block9: {
                db = DbControl.getInstance();
                if (vo == null || vo.getInstanceID() == null || vo.getInstanceID().trim().equals("")) {
                    throw new Exception("\u4f1a\u529e\u5b9e\u4f8b\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (vo.getCurrentUserID() == null || vo.getCurrentUserID().trim().equals("")) {
                    throw new Exception("\u5f53\u524d\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (cn == null) {
                    throw new Exception("\u6570\u636e\u5e93\u8fde\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
                }
                instanceID = vo.getInstanceID();
                sb = new StringBuffer();
                sqlStr = "select bizseqno from wf_instance_gather_property where InstanceID='" + instanceID + "'";
                vecData = db.performQuery(sqlStr, cn);
                if (vecData.size() != 0) break block9;
                return "\u8be5\u4f1a\u529e\u5df2\u529e\u7ed3";
            }
            sqlStr = "select CurrentGatherUserList from wf_instance_gather_property where InstanceID='" + instanceID + "' ";
            vecData = db.performQuery(sqlStr, cn);
            Vector vecRow = (Vector)vecData.elementAt(0);
            currentGatherUserList = (String)vecRow.elementAt(0);
            if (currentGatherUserList != null && !currentGatherUserList.trim().equals("")) break block10;
            return "\u8be5\u4f1a\u529e\u5df2\u63d0\u4ea4\u5230\u4f1a\u529e\u6c47\u603b\u4eba\uff01";
        }
        try {
            String[] userList = currentGatherUserList.split(";");
            int i = 0;
            while (i < userList.length) {
                OrgIF org;
                UserModel um;
                String userid = userList[i];
                if (userid.matches("0[A-Z]_\\S*")) {
                    userid = userid.substring(3);
                }
                String userName = (um = (org = OrgFactory.getInstance().getOrgClass()).getUserModel(userid, cn)) == null ? "" : um.getUsername();
                OrgModel om = org.getOrgModel(um == null ? "" : um.getOrgid(), cn);
                String orgName = om == null ? "" : om.getOrgname();
                sb.append("\u90e8\u95e8\uff1a" + orgName + "   \u5f53\u524d\u5904\u7406\u4eba\uff1a" + userName + ";");
                ++i;
            }
        }
        catch (Exception e) {
            WfLog.runtimeException(this, "getGatherStatus", e);
            throw e;
        }
        WfLog.log("eChain-\u4f1a\u529e", 0, "\u67e5\u770b\u4f1a\u529e\uff1a" + vo.getInstanceID() + "\u72b6\u6001\u6210\u529f");
        return sb.toString();
    }

    private String removeUserFlag(String userIDs, String split) {
        if (userIDs == null || userIDs.equals("")) {
            return userIDs;
        }
        if (split == null || split.equals("") || split.equals("null")) {
            if (userIDs.startsWith("U.")) {
                String userid = userIDs.substring(2);
                if (userid.endsWith(";")) {
                    return userid;
                }
                return String.valueOf(userid) + ";";
            }
            if (userIDs.endsWith(";")) {
                return userIDs;
            }
            return String.valueOf(userIDs) + ";";
        }
        String[] ids = userIDs.split(split);
        String retStr = "";
        int i = 0;
        while (i < ids.length) {
            String id = ids[i];
            retStr = id.startsWith("U.") ? String.valueOf(retStr) + id.substring(2) + ";" : String.valueOf(retStr) + id + ";";
            ++i;
        }
        return retStr;
    }

    protected String userID2Name(String userids, String splitFlag, Connection cn) {
        OrgIF orgIF = OrgFactory.getInstance().getOrgClass();
        String retNames = "";
        if (splitFlag == null || splitFlag.equals("")) {
            return orgIF.getUserModel(userids, cn) + ";";
        }
        String[] ids = userids.split(splitFlag);
        int i = 0;
        while (i < ids.length) {
            String name;
            String id = ids[i];
            if (id.startsWith("U.")) {
                id = id.substring(2);
            }
            if ((name = orgIF.getUserModel(id, cn).getUsername()) != null && !name.trim().equals("")) {
                retNames = String.valueOf(retNames) + name + ";";
            }
            ++i;
        }
        if (retNames.endsWith(";")) {
            retNames = retNames.substring(0, retNames.length() - 1);
        }
        return retNames;
    }

    private String userID2NameStrong(String userids, String splitFlag, Connection cn) {
        OrgIF orgIF = OrgFactory.getInstance().getOrgClass();
        String retNames = "";
        if (splitFlag == null || splitFlag.equals("")) {
            return orgIF.getUserModel(userids, cn) + ";";
        }
        String[] ids = userids.split(splitFlag);
        int i = 0;
        while (i < ids.length) {
            String orgName;
            UserModel um;
            String id = ids[i];
            if (id.startsWith("U.")) {
                id = id.substring(2);
            }
            String userName = (um = orgIF.getUserModel(id, cn)) == null ? "" : um.getUsername();
            OrgModel om = orgIF.getOrgModel(um.getOrgid(), cn);
            String string = orgName = om == null ? "" : om.getOrgname();
            if (userName != null && !userName.trim().equals("")) {
                retNames = String.valueOf(retNames) + orgName + "/" + userName + ";";
            }
            ++i;
        }
        if (retNames.endsWith(";")) {
            retNames = retNames.substring(0, retNames.length() - 1);
        }
        return retNames;
    }

    private String getVirtualDept(String instanceID, String userid, Connection cn) throws Exception {
        int i;
        String[] tmp;
        if (userid == null || userid.equals("")) {
            return userid;
        }
        GatherVO vo = new GatherVO();
        vo.setInstanceID(instanceID);
        vo = this.getGatherInstanceInfo(vo, cn);
        String startUserID = vo.getGatherStartUserID();
        String endUserID = vo.getGatherEndUserID();
        String currentGatherUserList = vo.getCurrentGatherUserList();
        String gatherProcessors = vo.getCurrentGatherProcessors();
        if (userid.equals(startUserID) || userid.equals(endUserID)) {
            return VIR_DEPT_ALL;
        }
        if (currentGatherUserList != null && currentGatherUserList.contains(String.valueOf(userid) + ";")) {
            tmp = currentGatherUserList.split(";");
            i = 0;
            while (i < tmp.length) {
                if (tmp[i].endsWith(userid)) {
                    return tmp[i].substring(0, 2);
                }
                ++i;
            }
        }
        if (gatherProcessors != null && gatherProcessors.contains(String.valueOf(userid) + ";")) {
            tmp = gatherProcessors.split(";");
            i = 0;
            while (i < tmp.length) {
                if (tmp[i].endsWith(userid)) {
                    return tmp[i].substring(0, 2);
                }
                ++i;
            }
        }
        return null;
    }

    public static void main(String[] args) {
        String s = "0A_U000000336";
        System.out.println(s.matches("0[A-Z]_\\S*"));
    }
}

