/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.echain.workflow.engine;

import com.ecc.echain.forms.FormFactory;
import com.ecc.echain.workflow.engine.EVO;
import com.ecc.echain.workflow.engine.WfEngine;
import com.ecc.echain.workflow.engine.WfStatistic;
import com.ecc.echain.workflow.engine.WfTrack;
import com.ecc.echain.workflow.engine.WorkFlowClient;
import com.ecc.echain.workflow.engine.WorkList;
import com.ecc.echain.workflow.engine.worklist.WorkListIF;
import com.ecc.echain.workflow.model.CommentVO;
import com.ecc.workflow.WorkFlowInterface;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class WFI
implements WorkFlowInterface {
    private static WFI _instance = new WFI();

    public static WFI getInstance() {
        return _instance;
    }

    public Map initWFByID(String wfid, String currentuserid, String InstanceID, String bizseqno, String wfjobname, String orgid, Map paramMap, Connection con) throws Exception {
        WfEngine we = WfEngine.getInstance();
        HashMap<String, String> hm = new HashMap<String, String>();
        EVO vo = new EVO();
        vo.setWFID(wfid);
        vo.setCurrentUserID(currentuserid);
        if (orgid != null && orgid.length() > 0) {
            vo.setOrgid(orgid);
        }
        if (InstanceID != null && InstanceID.length() > 0) {
            vo.setInstanceID(InstanceID);
        }
        vo.setBizseqno(bizseqno);
        if (wfjobname != null && wfjobname.length() > 0) {
            vo.setJobName(wfjobname);
        }
        if (con != null) {
            vo.setConnection(con);
        }
        vo = we.initializeWFWholeDocUNID(vo);
        hm.put("instanceid", vo.getInstanceID());
        hm.put("nodeid", vo.getNodeID());
        hm.put("formid", vo.getFormid());
        return hm;
    }

    public Map initWFBySign(String wfsign, String currentuserid, String InstanceID, String bizseqno, String wfjobname, String orgid, Map paramMap, Connection con) throws Exception {
        WfEngine we = WfEngine.getInstance();
        HashMap<String, String> hm = new HashMap<String, String>();
        EVO vo = new EVO();
        vo.setWFSign(wfsign);
        vo.setAppSign(wfsign);
        vo.setCurrentUserID(currentuserid);
        if (orgid != null && orgid.length() > 0) {
            vo.setOrgid(orgid);
        }
        if (InstanceID != null && InstanceID.length() > 0) {
            vo.setInstanceID(InstanceID);
        }
        vo.setBizseqno(bizseqno);
        if (wfjobname != null && wfjobname.length() > 0) {
            vo.setJobName(wfjobname);
        }
        if (paramMap != null) {
            vo.paramMap.putAll(paramMap);
        }
        if (paramMap != null && paramMap.get("formid") != null) {
            vo.setFormid((String)paramMap.get("formid"));
        }
        if (con != null) {
            vo.setConnection(con);
        }
        vo = we.initializeWFWholeDocUNID(vo);
        hm.put("instanceid", vo.getInstanceID());
        hm.put("nodeid", vo.getNodeID());
        hm.put("formid", vo.getFormid());
        hm.put("sign", String.valueOf(vo.getSign()));
        hm.put("tip", vo.getTip());
        return hm;
    }

    public Map wfSaveJob(String InstanceID, String currentuserid, Map paramMap, Connection con) throws Exception {
        WorkFlowClient wfc = WorkFlowClient.getInstance();
        HashMap<String, String> hm = new HashMap<String, String>();
        EVO vo = new EVO();
        vo.setInstanceID(InstanceID);
        vo.setCurrentUserID(currentuserid);
        if (paramMap != null) {
            vo.paramMap.putAll(paramMap);
        }
        if (paramMap != null && !paramMap.isEmpty() && paramMap.get("appsign") != null) {
            vo.setAppSign((String)paramMap.get("appsign"));
        }
        if (con != null) {
            vo.setConnection(con);
        }
        vo = wfc.wfSaveJob(vo);
        hm.put("sign", String.valueOf(vo.getSign()));
        hm.put("tip", vo.getTip());
        hm.put("wfsign", vo.getWFSign());
        hm.put("instanceid", InstanceID);
        hm.put("formid", vo.getFormid());
        return hm;
    }

    public Map wfCompleteJob(String InstanceID, String NodeID, String currentuserid, String NextNodeID, String NextNodeUser, Map paramMap, Connection con) throws Exception {
        WorkFlowClient wfc = WorkFlowClient.getInstance();
        HashMap<String, String> hm = new HashMap<String, String>();
        EVO vo = new EVO();
        vo.setInstanceID(InstanceID);
        if (NodeID != null && NodeID.length() > 0) {
            vo.setNodeID(NodeID);
        }
        vo.setCurrentUserID(currentuserid);
        if (NextNodeID != null && NextNodeID.length() > 0) {
            vo.setNextNodeID(NextNodeID);
        }
        if (NextNodeUser != null && NextNodeUser.length() > 0) {
            vo.setNextNodeUser(NextNodeUser);
        }
        if (paramMap != null) {
            vo.paramMap.putAll(paramMap);
        }
        if (paramMap != null && !paramMap.isEmpty() && paramMap.get("AnnounceUser") != null) {
            vo.setAnnounceUser((String)paramMap.get("AnnounceUser"));
        }
        if (con != null) {
            vo.setConnection(con);
        }
        vo = wfc.wfCompleteJob(vo);
        hm.put("sign", String.valueOf(vo.getSign()));
        hm.put("tip", vo.getTip());
        hm.put("nextnodeid", vo.getNextNodeID());
        hm.put("nextnodename", vo.getNextNodeName());
        hm.put("nextnodeuser", vo.getNextNodeUser());
        hm.put("wfsign", vo.getWFSign());
        hm.put("wfid", vo.getWFID());
        hm.put("formid", vo.getFormid());
        return hm;
    }

    public Map wfUrge(String InstanceID, String currentuserid, Map paramMap, Connection con) throws Exception {
        return null;
    }

    public Map instanceSignIn(String InstanceID, String currentuserid, Map paramMap, Connection con) throws Exception {
        WorkFlowClient wfc = WorkFlowClient.getInstance();
        HashMap<String, String> hm = new HashMap<String, String>();
        EVO vo = new EVO();
        vo.setInstanceID(InstanceID);
        vo.setCurrentUserID(currentuserid);
        if (paramMap != null) {
            vo.paramMap.putAll(paramMap);
        }
        if (con != null) {
            vo.setConnection(con);
        }
        vo = wfc.instanceSignIn(vo);
        hm.put("sign", String.valueOf(vo.getSign()));
        hm.put("tip", vo.getTip());
        hm.put("currentuserid", currentuserid);
        return hm;
    }

    public Map instanceSignOff(String InstanceID, String currentuserid, Map paramMap, Connection con) throws Exception {
        WorkFlowClient wfc = WorkFlowClient.getInstance();
        HashMap<String, String> hm = new HashMap<String, String>();
        EVO vo = new EVO();
        vo.setInstanceID(InstanceID);
        vo.setCurrentUserID(currentuserid);
        if (paramMap != null) {
            vo.paramMap.putAll(paramMap);
        }
        if (con != null) {
            vo.setConnection(con);
        }
        vo = wfc.instanceSignOff(vo);
        hm.put("sign", String.valueOf(vo.getSign()));
        hm.put("tip", vo.getTip());
        hm.put("currentuserid", currentuserid);
        return hm;
    }

    public Map wfChange(String InstanceID, String NodeID, String currentuserid, String NextNodeUser, Map paramMap, Connection con) throws Exception {
        return null;
    }

    public Map wfJump(String InstanceID, String NodeID, String currentuserid, String NextNodeID, String NextNodeUser, Map paramMap, Connection con) throws Exception {
        WorkFlowClient wfc = WorkFlowClient.getInstance();
        HashMap<String, String> hm = new HashMap<String, String>();
        EVO vo = new EVO();
        vo.setInstanceID(InstanceID);
        vo.setNodeID(NodeID);
        vo.setCurrentUserID(currentuserid);
        if (NextNodeID != null && NextNodeID.length() > 0) {
            vo.setNextNodeID(NextNodeID);
        }
        if (NextNodeUser != null && NextNodeUser.length() > 0) {
            vo.setNextNodeUser(NextNodeUser);
        }
        if (paramMap != null) {
            vo.paramMap.putAll(paramMap);
        }
        if (paramMap != null) {
            paramMap.isEmpty();
        }
        if (con != null) {
            vo.setConnection(con);
        }
        vo = wfc.wfJump(vo);
        hm.put("sign", String.valueOf(vo.getSign()));
        hm.put("tip", vo.getTip());
        hm.put("nextnodeid", vo.getNextNodeID());
        hm.put("nextnodename", vo.getNextNodeName());
        hm.put("nextnodeuser", vo.getNextNodeUser());
        return hm;
    }

    public Map wfEnd(String InstanceID, String NodeID, String currentuserid, Map paramMap, Connection con) throws Exception {
        WorkFlowClient wfc = WorkFlowClient.getInstance();
        HashMap<String, String> hm = new HashMap<String, String>();
        EVO vo = new EVO();
        vo.setInstanceID(InstanceID);
        vo.setNodeID(NodeID);
        vo.setCurrentUserID(currentuserid);
        if (paramMap != null) {
            vo.paramMap.putAll(paramMap);
        }
        if (paramMap != null && !paramMap.isEmpty() && paramMap.get("SPStatus") != null) {
            vo.setSPStatus((String)paramMap.get("SPStatus"));
        }
        if (con != null) {
            vo.setConnection(con);
        }
        vo = wfc.wfEnd(vo);
        hm.put("sign", String.valueOf(vo.getSign()));
        hm.put("tip", vo.getTip());
        return hm;
    }

    public Map wfReturnBack(String InstanceID, String currentuserid, Map paramMap, Connection con) throws Exception {
        WorkFlowClient wfc = WorkFlowClient.getInstance();
        HashMap<String, String> hm = new HashMap<String, String>();
        EVO vo = new EVO();
        vo.setInstanceID(InstanceID);
        vo.setCurrentUserID(currentuserid);
        if (paramMap != null) {
            vo.paramMap.putAll(paramMap);
        }
        if (paramMap != null && !paramMap.isEmpty() && paramMap.get("returnFirstNodeSign") != null && paramMap.get("returnFirstNodeSign").toString().equals("1")) {
            vo.setIsDraft("1");
        }
        if (con != null) {
            vo.setConnection(con);
        }
        vo = wfc.wfReturnBack(vo);
        hm.put("sign", String.valueOf(vo.getSign()));
        hm.put("tip", vo.getTip());
        hm.put("nextnodeid", vo.getNextNodeID());
        hm.put("nextnodename", vo.getNextNodeName());
        hm.put("nextnodeuser", vo.getNextNodeUser());
        hm.put("wfsign", vo.getWFSign());
        return hm;
    }

    public Map wfCallBack(String InstanceID, String NodeID, String currentuserid, String NextNodeID, String NextNodeUser, Map paramMap, Connection con) throws Exception {
        WorkFlowClient wfc = WorkFlowClient.getInstance();
        HashMap<String, String> hm = new HashMap<String, String>();
        EVO vo = new EVO();
        vo.setInstanceID(InstanceID);
        vo.setNodeID(NodeID);
        vo.setCurrentUserID(currentuserid);
        vo.setNextNodeID(NextNodeID);
        vo.setNextNodeUser(NextNodeUser);
        if (paramMap != null) {
            vo.paramMap.putAll(paramMap);
        }
        if (paramMap != null) {
            paramMap.isEmpty();
        }
        if (con != null) {
            vo.setConnection(con);
        }
        vo = wfc.wfCallBack(vo);
        hm.put("sign", String.valueOf(vo.getSign()));
        hm.put("tip", vo.getTip());
        hm.put("nextnodeid", vo.getNextNodeID());
        hm.put("nextnodename", vo.getNextNodeName());
        hm.put("nextnodeuser", vo.getNextNodeUser());
        return hm;
    }

    public Map wfTakeBack(String InstanceID, String currentuserid, Map paramMap, Connection con) throws Exception {
        WorkFlowClient wfc = WorkFlowClient.getInstance();
        HashMap<String, String> hm = new HashMap<String, String>();
        EVO vo = new EVO();
        vo.setInstanceID(InstanceID);
        vo.setCurrentUserID(currentuserid);
        if (paramMap != null) {
            vo.paramMap.putAll(paramMap);
        }
        if (paramMap != null) {
            paramMap.isEmpty();
        }
        if (con != null) {
            vo.setConnection(con);
        }
        vo = wfc.wfTakeBack(vo);
        hm.put("sign", String.valueOf(vo.getSign()));
        hm.put("tip", vo.getTip());
        hm.put("nextnodeid", vo.getNextNodeID());
        hm.put("nextnodename", vo.getNextNodeName());
        hm.put("nextnodeuser", vo.getNextNodeUser());
        hm.put("wfsign", vo.getWFSign());
        return hm;
    }

    public Map wfCancel(String InstanceID, String currentuserid, Map paramMap, Connection con) throws Exception {
        WorkFlowClient wfc = WorkFlowClient.getInstance();
        HashMap<String, String> hm = new HashMap<String, String>();
        EVO vo = new EVO();
        vo.setInstanceID(InstanceID);
        vo.setCurrentUserID(currentuserid);
        if (paramMap != null) {
            vo.paramMap.putAll(paramMap);
        }
        if (paramMap != null) {
            paramMap.isEmpty();
        }
        if (con != null) {
            vo.setConnection(con);
        }
        vo = wfc.wfCancel(vo);
        hm.put("sign", String.valueOf(vo.getSign()));
        hm.put("tip", vo.getTip());
        return hm;
    }

    public Map wfHang(String InstanceID, String currentuserid, Map paramMap, Connection con) throws Exception {
        WorkFlowClient wfc = WorkFlowClient.getInstance();
        HashMap<String, String> hm = new HashMap<String, String>();
        EVO vo = new EVO();
        vo.setInstanceID(InstanceID);
        vo.setCurrentUserID(currentuserid);
        if (paramMap != null) {
            vo.paramMap.putAll(paramMap);
        }
        if (paramMap != null) {
            paramMap.isEmpty();
        }
        if (con != null) {
            vo.setConnection(con);
        }
        vo = wfc.wfHang(vo);
        hm.put("sign", String.valueOf(vo.getSign()));
        hm.put("tip", vo.getTip());
        return hm;
    }

    public Map wfWake(String InstanceID, String currentuserid, Map paramMap, Connection con) throws Exception {
        WorkFlowClient wfc = WorkFlowClient.getInstance();
        HashMap<String, String> hm = new HashMap<String, String>();
        EVO vo = new EVO();
        vo.setInstanceID(InstanceID);
        vo.setCurrentUserID(currentuserid);
        if (paramMap != null) {
            vo.paramMap.putAll(paramMap);
        }
        if (paramMap != null) {
            paramMap.isEmpty();
        }
        if (con != null) {
            vo.setConnection(con);
        }
        vo = wfc.wfWake(vo);
        hm.put("sign", String.valueOf(vo.getSign()));
        hm.put("tip", vo.getTip());
        hm.put("nextnodeid", vo.getNextNodeID());
        hm.put("nextnodename", vo.getNextNodeName());
        hm.put("nextnodeuser", vo.getNextNodeUser());
        hm.put("wfsign", vo.getWFSign());
        return hm;
    }

    public Map wfWithdrawUser(String InstanceID, String NodeID, String currentuserid, String UserID, Map paramMap, Connection con) throws Exception {
        WorkFlowClient wfc = WorkFlowClient.getInstance();
        HashMap<String, String> hm = new HashMap<String, String>();
        EVO vo = new EVO();
        vo.setInstanceID(InstanceID);
        vo.setNodeID(NodeID);
        vo.setCurrentUserID(currentuserid);
        vo.setUserID(UserID);
        if (paramMap != null) {
            vo.paramMap.putAll(paramMap);
        }
        if (con != null) {
            vo.setConnection(con);
        }
        vo = wfc.wfWithdrawUser(vo);
        hm.put("sign", String.valueOf(vo.getSign()));
        hm.put("tip", vo.getTip());
        hm.put("nextnodeid", vo.getNextNodeID());
        hm.put("nextnodename", vo.getNextNodeName());
        hm.put("nextnodeuser", vo.getNextNodeUser());
        return hm;
    }

    public Map wfDelInstance(String InstanceID, String currentuserid, Map paramMap, Connection con) throws Exception {
        WorkFlowClient wfc = WorkFlowClient.getInstance();
        HashMap<String, String> hm = new HashMap<String, String>();
        EVO vo = new EVO();
        vo.setInstanceID(InstanceID);
        vo.setCurrentUserID(currentuserid);
        if (paramMap != null && !paramMap.isEmpty()) {
            vo.paramMap.putAll(paramMap);
        }
        if (con != null) {
            vo.setConnection(con);
        }
        vo = wfc.wfDelInstance(vo);
        hm.put("sign", String.valueOf(vo.getSign()));
        hm.put("tip", vo.getTip());
        return hm;
    }

    public Map wfReject(String InstanceID, String currentuserid, Map paramMap, Connection con) throws Exception {
        return new HashMap();
    }

    public Map getInstanceInfo(String InstanceID, String currentuserid, String NodeID, Map paramMap, Connection con) throws Exception {
        WorkFlowClient wfc = WorkFlowClient.getInstance();
        HashMap<String, Object> hm = new HashMap<String, Object>();
        EVO vo = new EVO();
        vo.setInstanceID(InstanceID);
        vo.setCurrentUserID(currentuserid);
        if (NodeID != null && NodeID.length() > 0) {
            vo.setNodeID(NodeID);
        }
        if (paramMap != null && !paramMap.isEmpty()) {
            vo.paramMap.putAll(paramMap);
        }
        if (con != null) {
            vo.setConnection(con);
        }
        vo = wfc.getInstanceInfo(vo);
        hm.put("instanceid", InstanceID);
        hm.put("currentuserid", currentuserid);
        hm.put("wfid", vo.getWFID());
        hm.put("wfname", vo.getWFName());
        hm.put("appid", vo.getAppID());
        hm.put("appname", vo.getAppName());
        hm.put("wfjobname", vo.getJobName());
        hm.put("appsign", vo.getAppSign());
        hm.put("spstatus", vo.getSPStatus());
        hm.put("prenodeid", vo.getPreNodeID());
        hm.put("prenodename", vo.getPreNodeName());
        hm.put("nodeid", vo.getNodeID());
        hm.put("nodename", vo.getNodeName());
        hm.put("wfstatus", vo.getWFStatus());
        hm.put("nodestatus", vo.getNodeStatus());
        hm.put("formid", vo.getFormid());
        hm.put("formflow", vo.getFormflow());
        hm.put("currentnodeuser", vo.getCurrentNodeUser());
        hm.put("author", vo.getAuthor());
        hm.put("preuser", vo.getPreUser());
        hm.put("nodestarttime", vo.getNodeStartTime());
        hm.put("nodeplanendtime", vo.getNodePlanEndTime());
        hm.put("isdraft", vo.getIsDraft());
        hm.put("isprocessed", vo.getIsProcessed());
        ArrayList alNNL = new ArrayList();
        ArrayList alNCFF = new ArrayList();
        ArrayList alAC = new ArrayList();
        if (vo.paramMap != null && !vo.paramMap.isEmpty()) {
            Vector vect;
            HashMap hmtmp;
            Map hmtmp2;
            if (vo.paramMap.get("getNextNodeList") != null) {
                EVO evotmp = (EVO)vo.paramMap.get("getNextNodeList");
                String nodeRouterType = evotmp.getNodeRouterType();
                if (evotmp.paramMap != null && !evotmp.paramMap.isEmpty()) {
                    for (String key : evotmp.paramMap.keySet()) {
                        hmtmp2 = (Map)evotmp.paramMap.get(key);
                        hmtmp = new HashMap();
                        hmtmp.put("nodeid", hmtmp2.get("nodeid"));
                        hmtmp.put("nodename", hmtmp2.get("nodename"));
                        hmtmp.put("nodeRouterType", nodeRouterType);
                        hmtmp.put("nodetype", hmtmp2.get("nodetype"));
                        hmtmp.put("routename", hmtmp2.get("routename"));
                        hmtmp.put("ifselectuser", hmtmp2.get("ifselectuser"));
                        hmtmp.put("routeseq", hmtmp2.get("routeseq"));
                        alNNL.add(hmtmp);
                    }
                }
            }
            if (vo.paramMap.get("getNodeControlFormField") != null && (hmtmp2 = (HashMap)vo.paramMap.get("getNodeControlFormField")) != null && !hmtmp2.isEmpty()) {
                for (String key : hmtmp2.keySet()) {
                    hmtmp = (HashMap)hmtmp2.get(key);
                    alNCFF.add(hmtmp);
                }
            }
            if (vo.paramMap.get("getAllComments") != null && (vect = (Vector)vo.paramMap.get("getAllComments")) != null && vect.size() > 0) {
                int i = 0;
                while (i < vect.size()) {
                    CommentVO cvo = (CommentVO)vect.elementAt(i);
                    hmtmp = new HashMap();
                    hmtmp.put("commentid", cvo.getCommentID());
                    hmtmp.put("nodeid", cvo.getNodeID());
                    hmtmp.put("nodename", cvo.getNodeName());
                    hmtmp.put("username", cvo.getUserName());
                    hmtmp.put("commenttime", cvo.getCommentTime());
                    hmtmp.put("commentcontent", cvo.getCommentContent());
                    alAC.add(hmtmp);
                    ++i;
                }
            }
        }
        hm.put("getNextNodeList", alNNL);
        hm.put("getNodeControlFormField", alNCFF);
        hm.put("getNodeControlFormAction", vo.paramMap.get("getNodeControlFormAction"));
        hm.put("getNodeFormData", vo.paramMap.get("getNodeFormData"));
        hm.put("getAllComments", alAC);
        return hm;
    }

    public List getNextNodeList(String InstanceID, String currentuserid, String NodeID, Map paramMap, Connection con) throws Exception {
        WorkFlowClient wfc = WorkFlowClient.getInstance();
        ArrayList<Map> al = new ArrayList<Map>();
        EVO vo = new EVO();
        vo.setInstanceID(InstanceID);
        vo.setCurrentUserID(currentuserid);
        vo.setNodeID(NodeID);
        if (paramMap != null) {
            vo.paramMap.putAll(paramMap);
        }
        if (con != null) {
            vo.setConnection(con);
        }
        vo = wfc.getNextNodeList(vo);
        String nodeRouterType = vo.getNodeRouterType();
        if (vo.paramMap != null && !vo.paramMap.isEmpty()) {
            for (String key : vo.paramMap.keySet()) {
                Map hm = (Map)vo.paramMap.get(key);
                hm.put("nodeRouterType", nodeRouterType);
                al.add(hm);
            }
        }
        return al;
    }

    public List getNodeUserList(String InstanceID, String currentuserid, String NodeID, Map paramMap, Connection con) throws Exception {
        WorkFlowClient wfc = WorkFlowClient.getInstance();
        ArrayList al = new ArrayList();
        EVO vo = new EVO();
        vo.setInstanceID(InstanceID);
        vo.setCurrentUserID(currentuserid);
        vo.setNodeID(NodeID);
        if (paramMap != null) {
            vo.paramMap.putAll(paramMap);
        }
        if (con != null) {
            vo.setConnection(con);
        }
        vo = wfc.getNodeUserList(vo);
        String multeitFlag = vo.getMulteitFlag();
        if (vo.paramMap != null && !vo.paramMap.isEmpty()) {
            for (String key : vo.paramMap.keySet()) {
                String value = (String)vo.paramMap.get(key);
                HashMap<String, String> hm = new HashMap<String, String>();
                hm.put("multeitFlag", multeitFlag);
                hm.put("userid", key);
                hm.put("username", value);
                al.add(hm);
            }
        }
        return al;
    }

    public Map getNodeAnnounceUserList(String InstanceID, String currentuserid, String NodeID, Map paramMap, Connection con) throws Exception {
        WorkFlowClient wfc = WorkFlowClient.getInstance();
        EVO vo = new EVO();
        vo.setInstanceID(InstanceID);
        vo.setCurrentUserID(currentuserid);
        vo.setNodeID(NodeID);
        if (paramMap != null) {
            vo.paramMap.putAll(paramMap);
        }
        if (con != null) {
            vo.setConnection(con);
        }
        vo = wfc.getAnnounceUserList(vo);
        return vo.paramMap;
    }

    public Map getInstanceNodeUserList(String InstanceID, String NodeID, String orgid, Map paramMap, Connection con) throws Exception {
        WorkFlowClient wfc = WorkFlowClient.getInstance();
        HashMap<String, String> hm = new HashMap<String, String>();
        EVO vo = new EVO();
        vo.setInstanceID(InstanceID);
        vo.setOrgid(orgid);
        vo.setNodeID(NodeID);
        if (con != null) {
            vo.setConnection(con);
        }
        vo = wfc.getInstanceNodeUserList(vo);
        if (vo.paramMap != null && !vo.paramMap.isEmpty()) {
            for (String key : vo.paramMap.keySet()) {
                String value = (String)vo.paramMap.get(key);
                hm.put(key, value);
            }
        }
        return hm;
    }

    public List getAllComments(String InstanceID, String currentuserid, Connection con) throws Exception {
        Vector vect;
        WorkFlowClient wfc = WorkFlowClient.getInstance();
        ArrayList al = new ArrayList();
        EVO vo = new EVO();
        CommentVO cvo = new CommentVO();
        cvo.setInstanceID(InstanceID);
        cvo.setUserID(currentuserid);
        vo.setCommentVO(cvo);
        if (con != null) {
            vo.setConnection(con);
        }
        if ((vect = wfc.getAllComments(vo)) != null && vect.size() > 0) {
            int i = 0;
            while (i < vect.size()) {
                cvo = (CommentVO)vect.elementAt(i);
                HashMap<String, String> hm = new HashMap<String, String>();
                hm.put("commentid", cvo.getCommentID());
                hm.put("nodeid", cvo.getNodeID());
                hm.put("nodename", cvo.getNodeName());
                hm.put("username", cvo.getUserName());
                hm.put("commenttime", cvo.getCommentTime());
                hm.put("commentcontent", cvo.getCommentContent());
                al.add(hm);
                ++i;
            }
        }
        return al;
    }

    public String getComment(String InstanceID, String NodeID, String currentuserid, Connection con) throws Exception {
        return null;
    }

    public boolean setComment(String InstanceID, String NodeID, String currentuserid, String SuggestContent, String SuggestControl, Connection con) throws Exception {
        WorkFlowClient wfc = WorkFlowClient.getInstance();
        boolean b = false;
        EVO vo = new EVO();
        CommentVO cvo = new CommentVO();
        cvo.setInstanceID(InstanceID);
        if (NodeID != null && NodeID.length() > 0) {
            cvo.setNodeID(NodeID);
        }
        cvo.setUserID(currentuserid);
        cvo.setCommentContent(SuggestContent);
        vo.setCommentVO(cvo);
        if (con != null) {
            vo.setConnection(con);
        }
        b = wfc.setComment(vo);
        return b;
    }

    public List getWorkFlowHistory(String InstanceID, String currentuserid, Connection con) throws Exception {
        Vector vect;
        WfTrack wt = WfTrack.getInstance();
        ArrayList al = new ArrayList();
        EVO vo = new EVO();
        vo.setInstanceID(InstanceID);
        vo.setCurrentUserID(currentuserid);
        if (con != null) {
            vo.setConnection(con);
        }
        if ((vect = wt.getWorkFlowHistory(vo)) != null && vect.size() > 0) {
            int i = 0;
            while (i < vect.size()) {
                EVO evotmp = (EVO)vect.elementAt(i);
                HashMap<String, String> hm = new HashMap<String, String>();
                hm.put("instanceid", InstanceID);
                hm.put("nodeid", evotmp.getNodeID());
                hm.put("nodename", evotmp.getNodeName());
                hm.put("username", evotmp.getUserName());
                hm.put("nodestarttime", evotmp.getNodeStartTime());
                hm.put("method", evotmp.getMethods());
                hm.put("nextnodeid", evotmp.getNextNodeID());
                hm.put("nextnodename", evotmp.getNextNodeName());
                hm.put("nextnodeuser", evotmp.getNextNodeUser());
                al.add(hm);
                ++i;
            }
        }
        return al;
    }

    public List getUserTodoWorkList(String currentuserid, String wfsign, String NodeID, Map paramMap, Connection con) throws Exception {
        Vector vect;
        WorkListIF wl = WorkList.getInstance();
        ArrayList al = new ArrayList();
        EVO vo = new EVO();
        vo.setCurrentUserID(currentuserid);
        if (wfsign != null && wfsign.length() > 0) {
            vo.setWFSign(wfsign);
        }
        if (NodeID != null && NodeID.length() > 0) {
            vo.setNodeID(NodeID);
        }
        if (paramMap != null && !paramMap.isEmpty()) {
            Map hmtmp;
            if (paramMap.get("fromRow") != null && paramMap.get("fromRow").toString().length() > 0) {
                vo.setFromRow(Integer.parseInt((String)paramMap.get("fromRow")));
            }
            if (paramMap.get("toRow") != null && paramMap.get("toRow").toString().length() > 0) {
                vo.setToRow(Integer.parseInt((String)paramMap.get("toRow")));
            }
            if (paramMap.get("appsign") != null && paramMap.get("appsign").toString().length() > 0) {
                vo.setAppSign((String)paramMap.get("appsign"));
            }
            if (paramMap.get("formid") != null && paramMap.get("formid").toString().length() > 0) {
                vo.setFormid((String)paramMap.get("formid"));
            }
            if (paramMap.get("conditionMap") != null && (hmtmp = (Map)paramMap.get("conditionMap")) != null && !hmtmp.isEmpty()) {
                vo.paramMap.putAll(hmtmp);
            }
        }
        if (con != null) {
            vo.setConnection(con);
        }
        if ((vect = wl.getUserAllTodoWorkList(vo)) != null && vect.size() > 0) {
            int i = 0;
            while (i < vect.size()) {
                EVO evotmp = (EVO)vect.elementAt(i);
                HashMap hm = new HashMap();
                this.setEVO2Map(hm, evotmp);
                al.add(hm);
                ++i;
            }
        }
        return al;
    }

    public List getUserDoneWorkList(String currentuserid, String wfsign, String NodeID, Map paramMap, Connection con) throws Exception {
        Vector vect;
        WorkListIF wl = WorkList.getInstance();
        ArrayList al = new ArrayList();
        EVO vo = new EVO();
        vo.setCurrentUserID(currentuserid);
        if (wfsign != null && wfsign.length() > 0) {
            vo.setWFSign(wfsign);
        }
        if (NodeID != null && NodeID.length() > 0) {
            vo.setNodeID(NodeID);
        }
        if (paramMap != null && !paramMap.isEmpty()) {
            Map hmtmp;
            if (paramMap.get("fromRow") != null && paramMap.get("fromRow").toString().length() > 0) {
                vo.setFromRow(Integer.parseInt((String)paramMap.get("fromRow")));
            }
            if (paramMap.get("toRow") != null && paramMap.get("toRow").toString().length() > 0) {
                vo.setToRow(Integer.parseInt((String)paramMap.get("toRow")));
            }
            if (paramMap.get("appsign") != null && paramMap.get("appsign").toString().length() > 0) {
                vo.setAppSign((String)paramMap.get("appsign"));
            }
            if (paramMap.get("formid") != null && paramMap.get("formid").toString().length() > 0) {
                vo.setFormid((String)paramMap.get("formid"));
            }
            if (paramMap.get("conditionMap") != null && (hmtmp = (Map)paramMap.get("conditionMap")) != null && !hmtmp.isEmpty()) {
                vo.paramMap.putAll(hmtmp);
            }
        }
        if (con != null) {
            vo.setConnection(con);
        }
        if ((vect = wl.getUserAllDoneWorkList(vo)) != null && vect.size() > 0) {
            int i = 0;
            while (i < vect.size()) {
                EVO evotmp = (EVO)vect.elementAt(i);
                HashMap hm = new HashMap();
                this.setEVO2Map(hm, evotmp);
                al.add(hm);
                ++i;
            }
        }
        return al;
    }

    public List getUserSignInWorkList(String currentuserid, String wfsign, String NodeID, Map paramMap, Connection con) throws Exception {
        Vector vect;
        WorkListIF wl = WorkList.getInstance();
        ArrayList al = new ArrayList();
        EVO vo = new EVO();
        vo.setCurrentUserID(currentuserid);
        if (wfsign != null && wfsign.length() > 0) {
            vo.setWFSign(wfsign);
        }
        if (NodeID != null && NodeID.length() > 0) {
            vo.setNodeID(NodeID);
        }
        if (paramMap != null && !paramMap.isEmpty()) {
            Map hmtmp;
            if (paramMap.get("fromRow") != null && paramMap.get("fromRow").toString().length() > 0) {
                vo.setFromRow(Integer.parseInt((String)paramMap.get("fromRow")));
            }
            if (paramMap.get("toRow") != null && paramMap.get("toRow").toString().length() > 0) {
                vo.setToRow(Integer.parseInt((String)paramMap.get("toRow")));
            }
            if (paramMap.get("conditionMap") != null && (hmtmp = (Map)paramMap.get("conditionMap")) != null && !hmtmp.isEmpty()) {
                vo.paramMap.putAll(hmtmp);
            }
        }
        if (con != null) {
            vo.setConnection(con);
        }
        if ((vect = wl.getUserAllSignInWorkList(vo)) != null && vect.size() > 0) {
            int i = 0;
            while (i < vect.size()) {
                EVO evotmp = (EVO)vect.elementAt(i);
                HashMap hm = new HashMap();
                this.setEVO2Map(hm, evotmp);
                al.add(hm);
                ++i;
            }
        }
        return al;
    }

    public List getUserAvailableWorkList(String currentuserid, String wfsign, String NodeID, Map paramMap, Connection con) throws Exception {
        Vector vect;
        WorkListIF wl = WorkList.getInstance();
        ArrayList al = new ArrayList();
        EVO vo = new EVO();
        vo.setCurrentUserID(currentuserid);
        if (wfsign != null && wfsign.length() > 0) {
            vo.setWFSign(wfsign);
        }
        if (NodeID != null && NodeID.length() > 0) {
            vo.setNodeID(NodeID);
        }
        if (paramMap != null && !paramMap.isEmpty()) {
            Map hmtmp;
            if (paramMap.get("fromRow") != null && paramMap.get("fromRow").toString().length() > 0) {
                vo.setFromRow(Integer.parseInt((String)paramMap.get("fromRow")));
            }
            if (paramMap.get("toRow") != null && paramMap.get("toRow").toString().length() > 0) {
                vo.setToRow(Integer.parseInt((String)paramMap.get("toRow")));
            }
            if (paramMap.get("conditionMap") != null && (hmtmp = (Map)paramMap.get("conditionMap")) != null && !hmtmp.isEmpty()) {
                vo.paramMap.putAll(hmtmp);
            }
        }
        if (con != null) {
            vo.setConnection(con);
        }
        if ((vect = wl.getUserAllAvailableWorkList(vo)) != null && vect.size() > 0) {
            int i = 0;
            while (i < vect.size()) {
                EVO evotmp = (EVO)vect.elementAt(i);
                HashMap hm = new HashMap();
                this.setEVO2Map(hm, evotmp);
                al.add(hm);
                ++i;
            }
        }
        return al;
    }

    public List getExceptionWorkList(String currentuserid, String wfsign, String NodeID, Map paramMap, Connection con) throws Exception {
        Vector vect;
        WorkListIF wl = WorkList.getInstance();
        ArrayList al = new ArrayList();
        EVO vo = new EVO();
        vo.setCurrentUserID(currentuserid);
        if (wfsign != null && wfsign.length() > 0) {
            vo.setWFSign(wfsign);
        }
        if (NodeID != null && NodeID.length() > 0) {
            vo.setNodeID(NodeID);
        }
        if (paramMap != null && !paramMap.isEmpty()) {
            Map hmtmp;
            if (paramMap.get("fromRow") != null && paramMap.get("fromRow").toString().length() > 0) {
                vo.setFromRow(Integer.parseInt((String)paramMap.get("fromRow")));
            }
            if (paramMap.get("toRow") != null && paramMap.get("toRow").toString().length() > 0) {
                vo.setToRow(Integer.parseInt((String)paramMap.get("toRow")));
            }
            if (paramMap.get("conditionMap") != null && (hmtmp = (Map)paramMap.get("conditionMap")) != null && !hmtmp.isEmpty()) {
                vo.paramMap.putAll(hmtmp);
            }
        }
        if (con != null) {
            vo.setConnection(con);
        }
        if ((vect = wl.getExceptionWorkList(vo)) != null && vect.size() > 0) {
            int i = 0;
            while (i < vect.size()) {
                EVO evotmp = (EVO)vect.elementAt(i);
                HashMap hm = new HashMap();
                this.setEVO2Map(hm, evotmp);
                al.add(hm);
                ++i;
            }
        }
        return al;
    }

    public List getWFStatusEndWorkList(String currentuserid, String wfsign, String NodeID, Map paramMap, Connection con) throws Exception {
        Vector vect;
        WorkListIF wl = WorkList.getInstance();
        ArrayList al = new ArrayList();
        EVO vo = new EVO();
        vo.setCurrentUserID(currentuserid);
        if (wfsign != null && wfsign.length() > 0) {
            vo.setWFSign(wfsign);
        }
        if (NodeID != null && NodeID.length() > 0) {
            vo.setNodeID(NodeID);
        }
        if (paramMap != null && !paramMap.isEmpty()) {
            Map hmtmp;
            if (paramMap.get("fromRow") != null && paramMap.get("fromRow").toString().length() > 0) {
                vo.setFromRow(Integer.parseInt((String)paramMap.get("fromRow")));
            }
            if (paramMap.get("toRow") != null && paramMap.get("toRow").toString().length() > 0) {
                vo.setToRow(Integer.parseInt((String)paramMap.get("toRow")));
            }
            if (paramMap.get("conditionMap") != null && (hmtmp = (Map)paramMap.get("conditionMap")) != null && !hmtmp.isEmpty()) {
                vo.paramMap.putAll(hmtmp);
            }
        }
        if (con != null) {
            vo.setConnection(con);
        }
        if ((vect = wl.getWFStatusEndWorkList(vo)) != null && vect.size() > 0) {
            int i = 0;
            while (i < vect.size()) {
                EVO evotmp = (EVO)vect.elementAt(i);
                HashMap hm = new HashMap();
                this.setEVO2Map(hm, evotmp);
                al.add(hm);
                ++i;
            }
        }
        return al;
    }

    public List getUserStartupWorkList(String currentuserid, String wfsign, String bDraft, String NodeID, Map paramMap, Connection con) throws Exception {
        Vector vect;
        WorkListIF wl = WorkList.getInstance();
        ArrayList al = new ArrayList();
        EVO vo = new EVO();
        vo.setCurrentUserID(currentuserid);
        if (wfsign != null && wfsign.length() > 0) {
            vo.setWFSign(wfsign);
        }
        if (bDraft != null && bDraft.length() > 0) {
            vo.setIsDraft(bDraft);
        }
        if (NodeID != null && NodeID.length() > 0) {
            vo.setNodeID(NodeID);
        }
        if (paramMap != null && !paramMap.isEmpty()) {
            Map hmtmp;
            if (paramMap.get("fromRow") != null && paramMap.get("fromRow").toString().length() > 0) {
                vo.setFromRow(Integer.parseInt((String)paramMap.get("fromRow")));
            }
            if (paramMap.get("toRow") != null && paramMap.get("toRow").toString().length() > 0) {
                vo.setToRow(Integer.parseInt((String)paramMap.get("toRow")));
            }
            if (paramMap.get("conditionMap") != null && (hmtmp = (Map)paramMap.get("conditionMap")) != null && !hmtmp.isEmpty()) {
                vo.paramMap.putAll(hmtmp);
            }
        }
        if (con != null) {
            vo.setConnection(con);
        }
        if ((vect = wl.getUserStartupWorkList(vo)) != null && vect.size() > 0) {
            int i = 0;
            while (i < vect.size()) {
                EVO evotmp = (EVO)vect.elementAt(i);
                HashMap hm = new HashMap();
                this.setEVO2Map(hm, evotmp);
                al.add(hm);
                ++i;
            }
        }
        return al;
    }

    public List getUserReturnBackWorkList(String currentuserid, String wfsign, String NodeID, Map paramMap, Connection con) throws Exception {
        return new ArrayList();
    }

    public List getUserCallBackWorkList(String currentuserid, String wfsign, String NodeID, Map paramMap, Connection con) throws Exception {
        return new ArrayList();
    }

    public List StatUserTodo(String currentuserid, Connection con) throws Exception {
        WorkListIF wl = WorkList.getInstance();
        EVO vo = new EVO();
        vo.setCurrentUserID(currentuserid);
        if (con != null) {
            vo.setConnection(con);
        }
        return wl.StatUserTodo(vo);
    }

    public List StatUserDone(String currentuserid, Connection con) throws Exception {
        WfStatistic ws = new WfStatistic();
        EVO vo = new EVO();
        vo.setCurrentUserID(currentuserid);
        if (con != null) {
            vo.setConnection(con);
        }
        return ws.StatUserDone(vo);
    }

    public List StatUserEnd(String currentuserid, Connection con) throws Exception {
        WfStatistic ws = new WfStatistic();
        EVO vo = new EVO();
        vo.setCurrentUserID(currentuserid);
        if (con != null) {
            vo.setConnection(con);
        }
        return ws.StatWFStatusEnd2(vo);
    }

    public List getWFNameList(String currentuserid, String sysid, String orgid, Map paramMap, Connection con) throws Exception {
        Vector vect;
        WorkFlowClient wfc = WorkFlowClient.getInstance();
        ArrayList al = new ArrayList();
        EVO vo = new EVO();
        vo.setCurrentUserID(currentuserid);
        vo.setOrgid(orgid);
        vo.setSysid(sysid);
        if (con != null) {
            vo.setConnection(con);
        }
        if ((vect = wfc.getWFNameList(vo)) != null && vect.size() > 0) {
            int i = 0;
            while (i < vect.size()) {
                EVO evotmp = (EVO)vect.elementAt(i);
                HashMap<String, String> hm = new HashMap<String, String>();
                hm.put("wfid", evotmp.getWFID());
                hm.put("wfname", evotmp.getWFName());
                hm.put("wfsign", evotmp.getWFSign());
                hm.put("wfver", evotmp.getTip());
                hm.put("appid", evotmp.getAppID());
                hm.put("appname", evotmp.getAppName());
                hm.put("formid", evotmp.getWFMainForm());
                hm.put("wfadmin", evotmp.getWFAdmin());
                hm.put("author", evotmp.getAuthor());
                al.add(hm);
                ++i;
            }
        }
        return al;
    }

    public Map getWFNodes(String InstanceID, String wfid, Connection con) throws Exception {
        WorkFlowClient wfc = WorkFlowClient.getInstance();
        EVO vo = new EVO();
        vo.setInstanceID(InstanceID);
        if (wfid != null && wfid.length() > 0) {
            vo.setWFID(wfid);
        }
        if (con != null) {
            vo.setConnection(con);
        }
        return wfc.getWFNodeList(vo);
    }

    public List getWFTreatedNodes(String InstanceID, String NodeID, String orgid, Connection con) throws Exception {
        WorkFlowClient wfc = WorkFlowClient.getInstance();
        EVO vo = new EVO();
        vo.setInstanceID(InstanceID);
        vo.setNodeID(NodeID);
        if (orgid != null && orgid.length() > 0) {
            vo.setOrgid(orgid);
        }
        if (con != null) {
            vo.setConnection(con);
        }
        return wfc.getWFTreatedNodeList(vo);
    }

    public Map getWFTreatedUsers(String InstanceID, String orgid, Connection con) throws Exception {
        return null;
    }

    public String getFormUrlByID(String formid) throws Exception {
        return FormFactory.getInstance().getFormClass().getFormModel(formid).getUrl();
    }

    private void setEVO2Map(Map hm, EVO vo) {
        hm.put("instanceid", vo.getInstanceID());
        hm.put("wfstatus", vo.getWFStatus());
        hm.put("wfid", vo.getWFID());
        hm.put("wfname", vo.getWFName());
        hm.put("wfsign", vo.getWFSign());
        hm.put("jobname", vo.getJobName());
        hm.put("wfstarttime", vo.getWFStartTime());
        hm.put("wfendtime", vo.getWFEndTime());
        hm.put("appid", vo.getAppID());
        hm.put("appname", vo.getAppName());
        hm.put("wfadmin", vo.getWFAdmin());
        hm.put("appsign", vo.getAppSign());
        hm.put("spstatus", vo.getSPStatus());
        hm.put("prenodeid", vo.getPreNodeID());
        hm.put("prenodename", vo.getPreNodeName());
        hm.put("nodeid", vo.getNodeID());
        hm.put("nodename", vo.getNodeName());
        hm.put("nodestatus", vo.getNodeStatus());
        hm.put("formid", vo.getFormid());
        hm.put("nodestarttime", vo.getNodeStartTime());
        hm.put("nodeplanendtime", vo.getNodePlanEndTime());
        hm.put("author", vo.getAuthor());
        hm.put("currentnodeuser", vo.getCurrentNodeUser());
        hm.put("preuser", vo.getPreUser());
        hm.put("fromrow", String.valueOf(vo.getFromRow()));
        hm.put("torow", String.valueOf(vo.getToRow()));
        hm.put("totalrow", String.valueOf(vo.getTotalRow()));
        hm.put("evo.paramMap", vo.paramMap);
    }
}

