/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.echain.workflow.engine;

import com.ecc.echain.db.DbControl;
import com.ecc.echain.ext.NodeUserListExtFactory;
import com.ecc.echain.ext.TaskPool;
import com.ecc.echain.log.WfLog;
import com.ecc.echain.org.OrgFactory;
import com.ecc.echain.org.OrgIF;
import com.ecc.echain.org.model.DepModel;
import com.ecc.echain.org.model.GroupModel;
import com.ecc.echain.org.model.OrgModel;
import com.ecc.echain.org.model.RoleModel;
import com.ecc.echain.org.model.UserModel;
import com.ecc.echain.util.StringUtils;
import com.ecc.echain.workflow.engine.EVO;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class OrgClass {
    private static OrgClass _instance = new OrgClass();

    private OrgClass() {
    }

    public static OrgClass getInstance() {
        return _instance;
    }

    public String convertPersonsList_str(String orgid, String originUserList, Connection cn) {
        String strResult = "";
        String strTemp = "";
        if (originUserList == null || originUserList.equals("")) {
            return "";
        }
        StringTokenizer st = new StringTokenizer(originUserList, ";");
        block15: while (st.hasMoreElements()) {
            strTemp = (String)st.nextElement();
            char s = strTemp.charAt(0);
            switch (s) {
                case 'U': {
                    strResult = String.valueOf(strResult) + ";" + strTemp.substring(2);
                    break;
                }
                case 'R': {
                    UserModel um;
                    List list;
                    try {
                        list = OrgFactory.getInstance().getOrgClass().getUsersByRole(orgid, strTemp.substring(2), cn);
                        int i = 0;
                        while (i < list.size()) {
                            um = (UserModel)list.get(i);
                            strResult = String.valueOf(strResult) + ";" + um.getUserid();
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        WfLog.log(4, "\u8bfb\u53d6\u89d2\u8272\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38");
                        e.printStackTrace();
                    }
                    continue block15;
                }
                case 'G': {
                    UserModel um;
                    List list;
                    try {
                        list = OrgFactory.getInstance().getOrgClass().getUsersByGroup(orgid, strTemp.substring(2), cn);
                        int i = 0;
                        while (i < list.size()) {
                            um = (UserModel)list.get(i);
                            strResult = String.valueOf(strResult) + ";" + um.getUserid();
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        WfLog.log(4, "\u8bfb\u53d6\u7fa4\u7ec4\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38");
                        e.printStackTrace();
                    }
                    continue block15;
                }
                case 'D': {
                    UserModel um;
                    List list;
                    try {
                        list = OrgFactory.getInstance().getOrgClass().getAllUsersByDep(orgid, strTemp.substring(2), cn);
                        int i = 0;
                        while (i < list.size()) {
                            um = (UserModel)list.get(i);
                            strResult = String.valueOf(strResult) + ";" + um.getUserid();
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        WfLog.log(4, "\u8bfb\u53d6\u90e8\u95e8\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38");
                        e.printStackTrace();
                    }
                    continue block15;
                }
                case 'O': {
                    UserModel um;
                    List list;
                    try {
                        list = OrgFactory.getInstance().getOrgClass().getAllUsersByOrg(strTemp.substring(2), cn);
                        int i = 0;
                        while (i < list.size()) {
                            um = (UserModel)list.get(i);
                            strResult = String.valueOf(strResult) + ";" + um.getUserid();
                            ++i;
                        }
                        continue block15;
                    }
                    catch (Exception e) {
                        WfLog.log(4, "\u8bfb\u53d6\u673a\u6784\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38");
                        e.printStackTrace();
                    }
                }
            }
        }
        if (!strResult.equals("")) {
            strResult = strResult.substring(1, strResult.length());
            strResult = StringUtils.delSameElement(strResult, ";");
        }
        return strResult;
    }

    public String convertPersonsList_str(EVO vo, String originUserList, String mode, Connection cn) {
        String orgid = vo.getOrgid();
        String InstanceID = vo.getInstanceID();
        String NodeID = vo.getNextNodeID();
        if (NodeID == null || NodeID.equals("")) {
            NodeID = vo.getNodeID();
        }
        String CurrentUserID = vo.getCurrentUserID();
        HashMap paramMap = vo.paramMap;
        StringBuffer strResult = new StringBuffer();
        String str = "";
        String strTemp = "";
        if (originUserList == null || originUserList.equals("")) {
            return "";
        }
        if (originUserList.equals("${alluser}")) {
            return originUserList;
        }
        if (mode != null && mode.equals("3")) {
            return originUserList;
        }
        if (mode != null && mode.equals("1")) {
            return this.convertPersonsList_strJ(vo, originUserList, paramMap, cn);
        }
        if (mode != null && mode.equals("2")) {
            return this.convertPersonsList_strJ2(vo, originUserList, paramMap, cn);
        }
        WfLog.log(0, "\u5f53\u524d\u529e\u7406\u4eba\u5e76\u96c6\u8ba1\u7b97\u8868\u8fbe\u5f0f\uff1a" + originUserList);
        StringTokenizer st = new StringTokenizer(originUserList, ";");
        block20: while (st.hasMoreElements()) {
            strTemp = (String)st.nextElement();
            if (strTemp == null || strTemp.equals("")) continue;
            char s = strTemp.charAt(0);
            switch (s) {
                case 'U': {
                    strResult.append(String.valueOf(strTemp) + ";");
                    break;
                }
                case 'T': {
                    strResult.append(String.valueOf(strTemp) + ";");
                    break;
                }
                case 'R': {
                    UserModel um;
                    List list;
                    strResult.append(String.valueOf(strTemp) + ";");
                    try {
                        list = OrgFactory.getInstance().getOrgClass().getUsersByRole(orgid, strTemp.substring(2), cn);
                        int i = 0;
                        while (i < list.size()) {
                            um = (UserModel)list.get(i);
                            strResult.append("U." + um.getUserid() + ";");
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        WfLog.log(4, "\u8bfb\u53d6\u89d2\u8272\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38");
                        e.printStackTrace();
                    }
                    continue block20;
                }
                case 'G': {
                    UserModel um;
                    List list;
                    strResult.append(String.valueOf(strTemp) + ";");
                    try {
                        list = OrgFactory.getInstance().getOrgClass().getUsersByGroup(orgid, strTemp.substring(2), cn);
                        int i = 0;
                        while (i < list.size()) {
                            um = (UserModel)list.get(i);
                            strResult.append("U." + um.getUserid() + ";");
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        WfLog.log(4, "\u8bfb\u53d6\u89d2\u8272\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38");
                        e.printStackTrace();
                    }
                    continue block20;
                }
                case 'D': {
                    UserModel um;
                    List list;
                    strResult.append(String.valueOf(strTemp) + ";");
                    try {
                        list = OrgFactory.getInstance().getOrgClass().getAllUsersByDep(orgid, strTemp.substring(2), cn);
                        int i = 0;
                        while (i < list.size()) {
                            um = (UserModel)list.get(i);
                            strResult.append("U." + um.getUserid() + ";");
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        WfLog.log(4, "\u8bfb\u53d6\u90e8\u95e8\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38");
                        e.printStackTrace();
                    }
                    continue block20;
                }
                case 'O': {
                    UserModel um;
                    List list;
                    strResult.append(String.valueOf(strTemp) + ";");
                    try {
                        list = OrgFactory.getInstance().getOrgClass().getAllUsersByOrg(strTemp.substring(2), cn);
                        int i = 0;
                        while (i < list.size()) {
                            um = (UserModel)list.get(i);
                            strResult.append("U." + um.getUserid() + ";");
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        WfLog.log(4, "\u8bfb\u53d6\u673a\u6784\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38");
                        e.printStackTrace();
                    }
                    continue block20;
                }
                case 'A': {
                    String aType = strTemp.substring(2);
                    Vector vect = this.getUserByRelational(orgid, aType, InstanceID, CurrentUserID, paramMap, cn);
                    int i = 0;
                    while (i < vect.size()) {
                        strResult.append("U." + (String)vect.elementAt(i) + ";");
                        ++i;
                    }
                    continue block20;
                }
                case 'X': {
                    List list;
                    if (vo.getConnection() == null) {
                        vo.setConnection(cn);
                    }
                    try {
                        list = NodeUserListExtFactory.getInstance().getIMPClass(strTemp.substring(2)).getNodeUserList(vo);
                        if (list == null || list.size() <= 0) continue block20;
                        int i = 0;
                        while (i < list.size()) {
                            strResult.append("U." + (String)list.get(i) + ";");
                            ++i;
                        }
                        continue block20;
                    }
                    catch (Exception e) {
                        WfLog.log(4, "\u8bfb\u53d6\u8282\u70b9\u529e\u7406\u4eba\u5217\u8868\u5e94\u7528\u6269\u5c55\u65f6\u53d1\u751f\u5f02\u5e38");
                        e.printStackTrace();
                    }
                }
            }
        }
        if (!strResult.toString().equals("")) {
            str = strResult.toString();
            str = str.substring(0, str.length() - 1);
            str = StringUtils.delSameElement(str, ";");
        }
        return str;
    }

    public String convertPersonsList_strJ(EVO vo, String originUserList, Map paramMap, Connection cn) {
        long time;
        WfLog.log(0, "\u5f53\u524d\u529e\u7406\u4eba\u5458\u4ea4\u96c6\u8ba1\u7b97\u8868\u8fbe\u5f0f\uff1a" + originUserList);
        String orgid = vo.getOrgid();
        String InstanceID = vo.getInstanceID();
        String CurrentUserID = vo.getCurrentUserID();
        StringBuffer strResult = new StringBuffer();
        String str = "";
        String strTemp = "";
        String strTP = "";
        StringTokenizer st = new StringTokenizer(originUserList, ";");
        ArrayList<String> ltmp = new ArrayList<String>();
        while (st.hasMoreElements()) {
            strTemp = (String)st.nextElement();
            if (strTemp == null || strTemp.equals("")) continue;
            strResult = new StringBuffer();
            char s = strTemp.charAt(0);
            switch (s) {
                case 'U': {
                    strResult.append(String.valueOf(strTemp) + ";");
                    break;
                }
                case 'T': {
                    strTP = String.valueOf(strTP) + strTemp + ";";
                    strResult.append(String.valueOf(strTemp) + ";");
                    break;
                }
                case 'R': {
                    UserModel um;
                    List list;
                    long time1 = System.currentTimeMillis();
                    strResult.append(String.valueOf(strTemp) + ";");
                    try {
                        list = OrgFactory.getInstance().getOrgClass().getUsersByRole(orgid, strTemp.substring(2), cn);
                        int i = 0;
                        while (i < list.size()) {
                            um = (UserModel)list.get(i);
                            strResult.append("U." + um.getUserid() + ";");
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        WfLog.log(4, "\u8bfb\u53d6\u89d2\u8272\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38");
                        e.printStackTrace();
                    }
                    break;
                }
                case 'G': {
                    UserModel um;
                    List list;
                    strResult.append(String.valueOf(strTemp) + ";");
                    try {
                        list = OrgFactory.getInstance().getOrgClass().getUsersByGroup(orgid, strTemp.substring(2), cn);
                        int i = 0;
                        while (i < list.size()) {
                            um = (UserModel)list.get(i);
                            strResult.append("U." + um.getUserid() + ";");
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        WfLog.log(4, "\u8bfb\u53d6\u89d2\u8272\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38");
                        e.printStackTrace();
                    }
                    break;
                }
                case 'D': {
                    UserModel um;
                    List list;
                    strResult.append(String.valueOf(strTemp) + ";");
                    try {
                        list = OrgFactory.getInstance().getOrgClass().getAllUsersByDep(orgid, strTemp.substring(2), cn);
                        int i = 0;
                        while (i < list.size()) {
                            um = (UserModel)list.get(i);
                            strResult.append("U." + um.getUserid() + ";");
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        WfLog.log(4, "\u8bfb\u53d6\u90e8\u95e8\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38");
                        e.printStackTrace();
                    }
                    break;
                }
                case 'O': {
                    UserModel um;
                    List list;
                    strResult.append(String.valueOf(strTemp) + ";");
                    try {
                        list = OrgFactory.getInstance().getOrgClass().getAllUsersByOrg(strTemp.substring(2), cn);
                        int i = 0;
                        while (i < list.size()) {
                            um = (UserModel)list.get(i);
                            strResult.append("U." + um.getUserid() + ";");
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        WfLog.log(4, "\u8bfb\u53d6\u90e8\u95e8\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38");
                        e.printStackTrace();
                    }
                    break;
                }
                case 'A': {
                    long time1 = System.currentTimeMillis();
                    String aType = strTemp.substring(2);
                    Vector vect = this.getUserByRelational(orgid, aType, InstanceID, CurrentUserID, paramMap, cn);
                    int i = 0;
                    while (i < vect.size()) {
                        strResult.append("U." + (String)vect.elementAt(i) + ";");
                        ++i;
                    }
                    break;
                }
                case 'X': {
                    List list;
                    if (vo.getConnection() == null) {
                        vo.setConnection(cn);
                    }
                    try {
                        list = NodeUserListExtFactory.getInstance().getIMPClass(strTemp.substring(2)).getNodeUserList(vo);
                        if (list == null || list.size() <= 0) break;
                        int i = 0;
                        while (i < list.size()) {
                            strResult.append("U." + (String)list.get(i) + ";");
                            ++i;
                        }
                        break;
                    }
                    catch (Exception e) {
                        WfLog.log(4, "\u8bfb\u53d6\u8282\u70b9\u529e\u7406\u4eba\u5217\u8868\u5e94\u7528\u6269\u5c55\u65f6\u53d1\u751f\u5f02\u5e38");
                        e.printStackTrace();
                    }
                }
            }
            time = System.currentTimeMillis();
            if (strResult.toString().equals("")) break;
            str = strResult.toString();
            str = str.substring(0, str.length() - 1);
            str = StringUtils.delSameElement(str, ";");
            ltmp.add(str);
        }
        if (ltmp.isEmpty()) {
            return "";
        }
        if (ltmp.size() == 1) {
            return (String)ltmp.get(0);
        }
        time = System.currentTimeMillis();
        str = (String)ltmp.get(0);
        int i = 1;
        while (i < ltmp.size()) {
            str = StringUtils.getSameElement(str, (String)ltmp.get(i), ";");
            ++i;
        }
        if (strTP.length() > 1) {
            str = String.valueOf(strTP) + str;
        }
        return str;
    }

    public String convertPersonsList_strJ2(EVO vo, String originUserList, Map paramMap, Connection cn) {
        WfLog.log(0, "\u5f53\u524d\u529e\u7406\u4eba\u5458\u7ec4\u95f4\u4ea4\u96c6\u8ba1\u7b97\u8868\u8fbe\u5f0f\uff1a" + originUserList);
        String orgid = vo.getOrgid();
        String InstanceID = vo.getInstanceID();
        String CurrentUserID = vo.getCurrentUserID();
        StringBuffer strResult = new StringBuffer();
        String strTemp = "";
        StringTokenizer st = new StringTokenizer(originUserList, ";");
        StringBuffer su = new StringBuffer();
        StringBuffer sr = new StringBuffer();
        StringBuffer sg = new StringBuffer();
        StringBuffer sd = new StringBuffer();
        StringBuffer so = new StringBuffer();
        StringBuffer sa = new StringBuffer();
        StringBuffer sx = new StringBuffer();
        StringBuffer stp = new StringBuffer();
        HashMap<String, String> zuTypeMap = new HashMap<String, String>();
        block20: while (st.hasMoreElements()) {
            strTemp = (String)st.nextElement();
            if (strTemp == null || strTemp.equals("")) continue;
            strResult = new StringBuffer();
            char s = strTemp.charAt(0);
            switch (s) {
                case 'U': {
                    strResult.append(String.valueOf(strTemp) + ";");
                    su.append(String.valueOf(strTemp) + ";");
                    zuTypeMap.put("U", "U");
                    break;
                }
                case 'T': {
                    stp.append(String.valueOf(strTemp) + ";");
                    zuTypeMap.put("T", "T");
                    break;
                }
                case 'R': {
                    UserModel um;
                    List list;
                    strResult.append(String.valueOf(strTemp) + ";");
                    zuTypeMap.put("R", "R");
                    try {
                        list = OrgFactory.getInstance().getOrgClass().getUsersByRole(orgid, strTemp.substring(2), cn);
                        int i = 0;
                        while (i < list.size()) {
                            um = (UserModel)list.get(i);
                            strResult.append("U." + um.getUserid() + ";");
                            sr.append("U." + um.getUserid() + ";");
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        WfLog.log(4, "\u8bfb\u53d6\u89d2\u8272\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38");
                        e.printStackTrace();
                    }
                    continue block20;
                }
                case 'G': {
                    UserModel um;
                    List list;
                    strResult.append(String.valueOf(strTemp) + ";");
                    zuTypeMap.put("G", "G");
                    try {
                        list = OrgFactory.getInstance().getOrgClass().getUsersByGroup(orgid, strTemp.substring(2), cn);
                        int i = 0;
                        while (i < list.size()) {
                            um = (UserModel)list.get(i);
                            strResult.append("U." + um.getUserid() + ";");
                            sg.append("U." + um.getUserid() + ";");
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        WfLog.log(4, "\u8bfb\u53d6\u89d2\u8272\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38");
                        e.printStackTrace();
                    }
                    continue block20;
                }
                case 'D': {
                    UserModel um;
                    List list;
                    strResult.append(String.valueOf(strTemp) + ";");
                    zuTypeMap.put("D", "D");
                    try {
                        list = OrgFactory.getInstance().getOrgClass().getAllUsersByDep(orgid, strTemp.substring(2), cn);
                        int i = 0;
                        while (i < list.size()) {
                            um = (UserModel)list.get(i);
                            strResult.append("U." + um.getUserid() + ";");
                            sd.append("U." + um.getUserid() + ";");
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        WfLog.log(4, "\u8bfb\u53d6\u90e8\u95e8\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38");
                        e.printStackTrace();
                    }
                    continue block20;
                }
                case 'O': {
                    UserModel um;
                    List list;
                    strResult.append(String.valueOf(strTemp) + ";");
                    zuTypeMap.put("O", "O");
                    try {
                        list = OrgFactory.getInstance().getOrgClass().getAllUsersByOrg(strTemp.substring(2), cn);
                        int i = 0;
                        while (i < list.size()) {
                            um = (UserModel)list.get(i);
                            strResult.append("U." + um.getUserid() + ";");
                            so.append("U." + um.getUserid() + ";");
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        WfLog.log(4, "\u8bfb\u53d6\u90e8\u95e8\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38");
                        e.printStackTrace();
                    }
                    continue block20;
                }
                case 'A': {
                    String aType = strTemp.substring(2);
                    zuTypeMap.put("A", "A");
                    Vector vect = this.getUserByRelational(orgid, aType, InstanceID, CurrentUserID, paramMap, cn);
                    int i = 0;
                    while (i < vect.size()) {
                        strResult.append("U." + (String)vect.elementAt(i) + ";");
                        sa.append("U." + (String)vect.elementAt(i) + ";");
                        ++i;
                    }
                    continue block20;
                }
                case 'X': {
                    List list;
                    zuTypeMap.put("X", "X");
                    if (vo.getConnection() == null) {
                        vo.setConnection(cn);
                    }
                    try {
                        list = NodeUserListExtFactory.getInstance().getIMPClass(strTemp.substring(2)).getNodeUserList(vo);
                        if (list == null || list.size() <= 0) continue block20;
                        int i = 0;
                        while (i < list.size()) {
                            strResult.append("U." + (String)list.get(i) + ";");
                            sx.append("U." + (String)list.get(i) + ";");
                            ++i;
                        }
                        continue block20;
                    }
                    catch (Exception e) {
                        WfLog.log(4, "\u8bfb\u53d6\u8282\u70b9\u529e\u7406\u4eba\u5217\u8868\u5e94\u7528\u6269\u5c55\u65f6\u53d1\u751f\u5f02\u5e38");
                        e.printStackTrace();
                    }
                }
            }
        }
        if (strResult.toString().equals("")) {
            return "";
        }
        String str = strResult.toString();
        str = str.substring(0, str.length() - 1);
        str = StringUtils.delSameElement(str, ";");
        if (zuTypeMap.containsKey("U")) {
            String strSu = su.toString();
            if (strSu.length() > 0) {
                strSu = strSu.substring(0, strSu.length() - 1);
            }
            str = StringUtils.getSameElement(str, strSu, ";");
        }
        if (zuTypeMap.containsKey("R")) {
            String strSr = sr.toString();
            if (strSr.length() > 0) {
                strSr = strSr.substring(0, strSr.length() - 1);
            }
            str = StringUtils.getSameElement(str, strSr, ";");
        }
        if (zuTypeMap.containsKey("G")) {
            String strSg = sg.toString();
            if (strSg.length() > 0) {
                strSg = strSg.substring(0, strSg.length() - 1);
            }
            str = StringUtils.getSameElement(str, strSg, ";");
        }
        if (zuTypeMap.containsKey("D")) {
            String strSd = sd.toString();
            if (strSd.length() > 0) {
                strSd = strSd.substring(0, strSd.length() - 1);
            }
            str = StringUtils.getSameElement(str, strSd, ";");
        }
        if (zuTypeMap.containsKey("O")) {
            String strSo = so.toString();
            if (strSo.length() > 0) {
                strSo = strSo.substring(0, strSo.length() - 1);
            }
            str = StringUtils.getSameElement(str, strSo, ";");
        }
        if (zuTypeMap.containsKey("A")) {
            String strSa = sa.toString();
            if (strSa.length() > 0) {
                strSa = strSa.substring(0, strSa.length() - 1);
            }
            str = StringUtils.getSameElement(str, strSa, ";");
        }
        if (zuTypeMap.containsKey("X")) {
            String strSx = sx.toString();
            if (strSx.length() > 0) {
                strSx = strSx.substring(0, strSx.length() - 1);
            }
            str = StringUtils.getSameElement(str, strSx, ";");
        }
        if (zuTypeMap.containsKey("T")) {
            String strStp = stp.toString();
            if (strStp.length() > 0) {
                strStp = strStp.substring(0, strStp.length() - 1);
            }
            str = String.valueOf(str) + ";" + strStp;
        }
        return str;
    }

    public String convertPersonsList_str_ids(EVO vo, String originUserList, Map paramMap, Connection cn) {
        String orgid = vo.getOrgid();
        String InstanceID = vo.getInstanceID();
        String CurrentUserID = vo.getCurrentUserID();
        String strResult = "";
        String strTemp = "";
        if (originUserList == null || originUserList.equals("")) {
            return "";
        }
        StringTokenizer st = new StringTokenizer(originUserList, ";");
        block19: while (st.hasMoreElements()) {
            strTemp = (String)st.nextElement();
            char s = strTemp.charAt(0);
            switch (s) {
                case 'U': {
                    strResult = String.valueOf(strResult) + strTemp.substring(2) + ";";
                    break;
                }
                case 'R': {
                    UserModel um;
                    List list;
                    try {
                        list = OrgFactory.getInstance().getOrgClass().getUsersByRole(orgid, strTemp.substring(2), cn);
                        int i = 0;
                        while (i < list.size()) {
                            um = (UserModel)list.get(i);
                            strResult = String.valueOf(strResult) + um.getUserid() + ";";
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        WfLog.log(4, "\u8bfb\u53d6\u89d2\u8272\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38");
                        e.printStackTrace();
                    }
                    continue block19;
                }
                case 'G': {
                    UserModel um;
                    List list;
                    try {
                        list = OrgFactory.getInstance().getOrgClass().getUsersByGroup(orgid, strTemp.substring(2), cn);
                        int i = 0;
                        while (i < list.size()) {
                            um = (UserModel)list.get(i);
                            strResult = String.valueOf(strResult) + um.getUserid() + ";";
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        WfLog.log(4, "\u8bfb\u53d6\u89d2\u8272\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38");
                        e.printStackTrace();
                    }
                    continue block19;
                }
                case 'D': {
                    UserModel um;
                    List list;
                    try {
                        list = OrgFactory.getInstance().getOrgClass().getAllUsersByDep(orgid, strTemp.substring(2), cn);
                        int i = 0;
                        while (i < list.size()) {
                            um = (UserModel)list.get(i);
                            strResult = String.valueOf(strResult) + um.getUserid() + ";";
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        WfLog.log(4, "\u8bfb\u53d6\u90e8\u95e8\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38");
                        e.printStackTrace();
                    }
                    continue block19;
                }
                case 'O': {
                    UserModel um;
                    List list;
                    try {
                        list = OrgFactory.getInstance().getOrgClass().getAllUsersByOrg(strTemp.substring(2), cn);
                        int i = 0;
                        while (i < list.size()) {
                            um = (UserModel)list.get(i);
                            strResult = String.valueOf(strResult) + um.getUserid() + ";";
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        WfLog.log(4, "\u8bfb\u53d6\u673a\u6784\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38");
                        e.printStackTrace();
                    }
                    continue block19;
                }
                case 'A': {
                    String aType = strTemp.substring(2);
                    Vector vect = this.getUserByRelational(orgid, aType, InstanceID, CurrentUserID, paramMap, cn);
                    int i = 0;
                    while (i < vect.size()) {
                        strResult = String.valueOf(strResult) + (String)vect.elementAt(i) + ";";
                        ++i;
                    }
                    continue block19;
                }
                case 'X': {
                    List list;
                    if (vo.getConnection() == null) {
                        vo.setConnection(cn);
                    }
                    try {
                        list = NodeUserListExtFactory.getInstance().getIMPClass(strTemp.substring(2)).getNodeUserList(vo);
                        if (list == null || list.size() <= 0) continue block19;
                        int i = 0;
                        while (i < list.size()) {
                            strResult = String.valueOf(strResult) + (String)list.get(i) + ";";
                            ++i;
                        }
                        continue block19;
                    }
                    catch (Exception e) {
                        WfLog.log(4, "\u8bfb\u53d6\u8282\u70b9\u529e\u7406\u4eba\u5217\u8868\u5e94\u7528\u6269\u5c55\u65f6\u53d1\u751f\u5f02\u5e38");
                        e.printStackTrace();
                    }
                }
            }
        }
        if (!strResult.equals("")) {
            strResult = strResult.substring(0, strResult.length() - 1);
            strResult = StringUtils.delSameElement(strResult, ";");
        }
        return strResult;
    }

    public Vector getUserByRelational(String orgid, String aType, String InstanceID, String userid, Map paramMap, Connection cn) {
        long time = System.currentTimeMillis();
        Vector<String> vecResult = new Vector<String>();
        DbControl db = DbControl.getInstance();
        String SqlStr = "";
        String strtmp = "";
        try {
            if (aType.equals("01")) {
                SqlStr = "select author from wf_instance_whole_property where InstanceID='" + InstanceID + "'";
                Vector vecData = db.performQuery(SqlStr, cn);
                Vector vecRow = (Vector)vecData.elementAt(0);
                vecResult.addElement((String)vecRow.elementAt(0));
            } else if (aType.equals("02")) {
                SqlStr = "select WFAdmin from wf_instance_whole_property where InstanceID='" + InstanceID + "'";
                Vector vecData = db.performQuery(SqlStr, cn);
                Vector vecRow = (Vector)vecData.elementAt(0);
                strtmp = (String)vecRow.elementAt(0);
                String[] strlist = StringUtils.split(strtmp, ";");
                int i = 0;
                while (i < strlist.length) {
                    vecResult.addElement(strlist[i]);
                    ++i;
                }
            } else if (aType.equals("03")) {
                SqlStr = "select PreProcessorList from wf_instance_node_property where InstanceID='" + InstanceID + "'";
                Vector vecData = db.performQuery(SqlStr, cn);
                int k = 0;
                while (k < vecData.size()) {
                    Vector vecRow = (Vector)vecData.elementAt(k);
                    strtmp = (String)vecRow.elementAt(0);
                    String[] strlist = StringUtils.split(strtmp, ";");
                    int i = 0;
                    while (i < strlist.length) {
                        vecResult.addElement(strlist[i]);
                        ++i;
                    }
                    ++k;
                }
            } else if (aType.equals("04")) {
                List list = OrgFactory.getInstance().getOrgClass().getSuperiorUsers(orgid, userid, cn);
                int i = 0;
                while (i < list.size()) {
                    UserModel um = (UserModel)list.get(i);
                    vecResult.addElement(um.getUserid());
                    ++i;
                }
            } else if (aType.equals("05")) {
                SqlStr = "select AllProcessor from wf_instance_node_property where InstanceID='" + InstanceID + "'";
                Vector vecData = db.performQuery(SqlStr, cn);
                int k = 0;
                while (k < vecData.size()) {
                    Vector vecRow = (Vector)vecData.elementAt(k);
                    strtmp = (String)vecRow.elementAt(0);
                    String[] strlist = StringUtils.split(strtmp, ";");
                    int i = 0;
                    while (i < strlist.length) {
                        vecResult.addElement(strlist[i]);
                        ++i;
                    }
                    ++k;
                }
            } else if (aType.equals("06")) {
                List list = OrgFactory.getInstance().getOrgClass().getSameOrgUsers(orgid, userid, cn);
                int i = 0;
                while (i < list.size()) {
                    UserModel um = (UserModel)list.get(i);
                    vecResult.addElement(um.getUserid());
                    ++i;
                }
            } else if (aType.equals("07")) {
                List list = OrgFactory.getInstance().getOrgClass().getJuniorUsers(orgid, userid, cn);
                int i = 0;
                while (i < list.size()) {
                    UserModel um = (UserModel)list.get(i);
                    vecResult.addElement(um.getUserid());
                    ++i;
                }
            } else if (aType.equals("08")) {
                List list = OrgFactory.getInstance().getOrgClass().getOrgLeaders(orgid, cn);
                int i = 0;
                while (i < list.size()) {
                    UserModel um = (UserModel)list.get(i);
                    vecResult.addElement(um.getUserid());
                    ++i;
                }
            } else if (aType.equals("09")) {
                List list = OrgFactory.getInstance().getOrgClass().getOrgDirectors(orgid, cn);
                int i = 0;
                while (i < list.size()) {
                    UserModel um = (UserModel)list.get(i);
                    vecResult.addElement(um.getUserid());
                    ++i;
                }
            } else if (aType.startsWith("10")) {
                String ExtendeNodeID = aType.substring(3);
                if (ExtendeNodeID == null || ExtendeNodeID.equals("")) {
                    return vecResult;
                }
                SqlStr = "select WFID from wf_main_record where InstanceID='" + InstanceID + "'";
                Vector vecData = db.performQuery(SqlStr, cn);
                Vector vecRow2 = (Vector)vecData.elementAt(0);
                String WFID = (String)vecRow2.elementAt(0);
                String[] nodeids = ExtendeNodeID.split(",");
                StringBuffer sb = new StringBuffer();
                sb.append("(");
                int i = 0;
                while (i < nodeids.length) {
                    sb.append("'" + WFID + "_" + nodeids[i] + "',");
                    ++i;
                }
                String inNodeId = sb.toString();
                if (inNodeId.endsWith(",")) {
                    inNodeId = inNodeId.substring(0, inNodeId.length() - 1);
                }
                inNodeId = String.valueOf(inNodeId) + " )";
                SqlStr = "select CurrentNodeUser from wf_node_record where InstanceID='" + InstanceID + "' and NodeID in " + inNodeId;
                vecData = db.performQuery(SqlStr, cn);
                for (Vector vecRow2 : vecData) {
                    String[] slist = ((String)vecRow2.elementAt(0)).split(";");
                    int k = 0;
                    while (k < slist.length) {
                        vecResult.addElement(slist[k]);
                        ++k;
                    }
                }
            } else if (aType.startsWith("11")) {
                Vector vecData;
                String FieldName = aType.substring(3);
                if (FieldName == null || FieldName.equals("")) {
                    return vecResult;
                }
                boolean isFind = false;
                if (paramMap != null && !paramMap.isEmpty() && paramMap.get(FieldName) != null && !paramMap.get(FieldName).toString().equals("")) {
                    String[] slist = paramMap.get(FieldName).toString().split(";");
                    int k = 0;
                    while (k < slist.length) {
                        vecResult.addElement(slist[k]);
                        ++k;
                    }
                    isFind = true;
                }
                if (!isFind && (vecData = db.performQuery(SqlStr = "select formdata from wf_instance_whole_property where InstanceID='" + InstanceID + "'", cn)) != null && vecData.size() > 0) {
                    Vector vecRow = (Vector)vecData.elementAt(0);
                    String formdata = (String)vecRow.elementAt(0);
                    HashMap hm = StringUtils.convertStrToHashMap(formdata);
                    if ((formdata = (String)hm.get(FieldName)) != null && !formdata.equals("")) {
                        String[] slist = formdata.split(";");
                        int k = 0;
                        while (k < slist.length) {
                            vecResult.addElement(slist[k]);
                            ++k;
                        }
                    }
                }
            } else if (aType.startsWith("12")) {
                String baseOrgid = null;
                SqlStr = "select orgid from wf_instance_whole_property where InstanceID='" + InstanceID + "'";
                Vector vecData = db.performQuery(SqlStr, cn);
                if (vecData != null && vecData.size() > 0) {
                    Vector vecRow = (Vector)vecData.elementAt(0);
                    baseOrgid = (String)vecRow.elementAt(0);
                }
                if (baseOrgid != null && baseOrgid.length() > 0) {
                    List list = OrgFactory.getInstance().getOrgClass().getSameOrgLineUsers(orgid, cn);
                    int i = 0;
                    while (i < list.size()) {
                        UserModel um = (UserModel)list.get(i);
                        vecResult.addElement(um.getUserid());
                        ++i;
                    }
                }
            } else if (aType.startsWith("13")) {
                List list = OrgFactory.getInstance().getOrgClass().getUpDownOrgUsers(orgid, cn);
                int i = 0;
                while (i < list.size()) {
                    UserModel um = (UserModel)list.get(i);
                    vecResult.addElement(um.getUserid());
                    ++i;
                }
            } else if (aType.startsWith("14")) {
                List list = OrgFactory.getInstance().getOrgClass().getUpUpOrgDownOrgUsers(orgid, cn);
                int i = 0;
                while (i < list.size()) {
                    UserModel um = (UserModel)list.get(i);
                    vecResult.addElement(um.getUserid());
                    ++i;
                }
            } else if (aType.startsWith("15")) {
                List list = OrgFactory.getInstance().getOrgClass().getUpUpOrgUsers(orgid, cn);
                int i = 0;
                while (i < list.size()) {
                    UserModel um = (UserModel)list.get(i);
                    vecResult.addElement(um.getUserid());
                    ++i;
                }
            } else if (aType.startsWith("16")) {
                List list = OrgFactory.getInstance().getOrgClass().getUpAndUpUpOrgUsers(orgid, cn);
                int i = 0;
                while (i < list.size()) {
                    UserModel um = (UserModel)list.get(i);
                    vecResult.addElement(um.getUserid());
                    ++i;
                }
            } else if (aType.startsWith("17")) {
                List list = OrgFactory.getInstance().getOrgClass().getSampeAndUpOrgUsers(orgid, cn);
                int i = 0;
                while (i < list.size()) {
                    UserModel um = (UserModel)list.get(i);
                    vecResult.addElement(um.getUserid());
                    ++i;
                }
            } else if (aType.startsWith("18")) {
                List list = OrgFactory.getInstance().getOrgClass().getSampeOrgOrDeptUsers(orgid, cn);
                int i = 0;
                while (i < list.size()) {
                    UserModel um = (UserModel)list.get(i);
                    vecResult.addElement(um.getUserid());
                    ++i;
                }
            }
        }
        catch (Exception e) {
            WfLog.log(4, "\u6309\u5173\u7cfb\u8bfb\u53d6\u4eba\u5458\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38");
            e.printStackTrace();
        }
        return vecResult;
    }

    public Vector getPersonsList(String orgid, String originUserList, String InstanceID, String UserName, Map paramMap, Connection cn) {
        Vector<String> vecResult = new Vector<String>();
        String strResult = "";
        String strTemp = "";
        if (originUserList == null || originUserList.equals("")) {
            return vecResult;
        }
        boolean sign = false;
        StringTokenizer st = new StringTokenizer(originUserList, ";");
        block17: while (st.hasMoreElements()) {
            strTemp = (String)st.nextElement();
            char s = strTemp.charAt(0);
            switch (s) {
                case 'U': {
                    strResult = String.valueOf(strResult) + ";" + strTemp.substring(2);
                    break;
                }
                case 'T': {
                    strResult = String.valueOf(strResult) + ";" + strTemp;
                    break;
                }
                case 'R': {
                    UserModel um;
                    List list;
                    sign = true;
                    try {
                        list = OrgFactory.getInstance().getOrgClass().getUsersByRole(orgid, strTemp.substring(2), cn);
                        int i = 0;
                        while (i < list.size()) {
                            um = (UserModel)list.get(i);
                            strResult = String.valueOf(strResult) + ";" + um.getUserid();
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        WfLog.log(4, "\u8bfb\u53d6\u89d2\u8272\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38");
                        e.printStackTrace();
                    }
                    continue block17;
                }
                case 'G': {
                    UserModel um;
                    List list;
                    sign = true;
                    try {
                        list = OrgFactory.getInstance().getOrgClass().getUsersByGroup(orgid, strTemp.substring(2), cn);
                        int i = 0;
                        while (i < list.size()) {
                            um = (UserModel)list.get(i);
                            strResult = String.valueOf(strResult) + ";" + um.getUserid();
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        WfLog.log(4, "\u8bfb\u53d6\u7fa4\u7ec4\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38");
                        e.printStackTrace();
                    }
                    continue block17;
                }
                case 'D': {
                    UserModel um;
                    List list;
                    sign = true;
                    try {
                        list = OrgFactory.getInstance().getOrgClass().getAllUsersByDep(orgid, strTemp.substring(2), cn);
                        int i = 0;
                        while (i < list.size()) {
                            um = (UserModel)list.get(i);
                            strResult = String.valueOf(strResult) + ";" + um.getUserid();
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        WfLog.log(4, "\u8bfb\u53d6\u90e8\u95e8\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38");
                        e.printStackTrace();
                    }
                    continue block17;
                }
                case 'O': {
                    UserModel um;
                    List list;
                    sign = true;
                    try {
                        list = OrgFactory.getInstance().getOrgClass().getAllUsersByOrg(strTemp.substring(2), cn);
                        int i = 0;
                        while (i < list.size()) {
                            um = (UserModel)list.get(i);
                            strResult = String.valueOf(strResult) + ";" + um.getUserid();
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        WfLog.log(4, "\u8bfb\u53d6\u673a\u6784\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38");
                        e.printStackTrace();
                    }
                    continue block17;
                }
                case 'A': {
                    String aType = strTemp.substring(2);
                    Vector vect = this.getUserByRelational(orgid, aType, InstanceID, UserName, paramMap, cn);
                    int i = 0;
                    while (i < vect.size()) {
                        strResult = String.valueOf(strResult) + ";" + (String)vect.elementAt(i);
                        ++i;
                    }
                    continue block17;
                }
            }
        }
        if (!strResult.equals("")) {
            strResult = strResult.substring(1, strResult.length());
            strResult = StringUtils.delSameElement(strResult, ";");
        }
        if (sign) {
            vecResult.addElement("1");
        } else {
            vecResult.addElement("0");
        }
        vecResult.addElement(strResult);
        return vecResult;
    }

    public String getNameByID(String orgid, String id, Connection cn) {
        OrgIF oubo = OrgFactory.getInstance().getOrgClass();
        if (id == null || id.equals("") || id.equals("-") || id.length() < 3) {
            return "-";
        }
        String sid = id.substring(2);
        char s = id.charAt(0);
        switch (s) {
            case 'U': {
                UserModel um = oubo.getUserModel(orgid, sid, cn);
                if (um == null) {
                    um = oubo.getUserModel(sid, cn);
                }
                if (um == null) {
                    WfLog.log(0, "\u3010\u4e0d\u5b58\u5728\u7684\u7528\u6237\u3011,sid=" + sid);
                    sid = "\u3010\u4e0d\u5b58\u5728\u7684\u7528\u6237\u3011";
                    break;
                }
                sid = um.getUsername();
                break;
            }
            case 'R': {
                RoleModel rm = oubo.getRoleModel(orgid, sid, cn);
                if (rm == null) {
                    WfLog.log(0, "\u3010\u4e0d\u660e\u786e\u7684\u89d2\u8272\u3011,sid=" + sid);
                    sid = "\u3010\u4e0d\u660e\u786e\u7684\u89d2\u8272\u3011";
                    break;
                }
                sid = rm.getRolename();
                break;
            }
            case 'G': {
                GroupModel gm = oubo.getGroupModel(orgid, sid, cn);
                if (gm == null) {
                    WfLog.log(0, "\u3010\u4e0d\u5b58\u5728\u7684\u7fa4\u7ec4\u3011,sid=" + sid);
                    sid = "\u3010\u4e0d\u5b58\u5728\u7684\u7fa4\u7ec4\u3011";
                    break;
                }
                sid = String.valueOf(gm.getGroupname()) + "\u3010\u7fa4\u7ec4\u3011";
                break;
            }
            case 'D': {
                DepModel dm = oubo.getDepModel(orgid, sid, cn);
                if (dm == null) {
                    WfLog.log(0, "\u3010\u4e0d\u5b58\u5728\u7684\u90e8\u95e8\u3011,sid=" + sid);
                    sid = "\u3010\u4e0d\u5b58\u5728\u7684\u90e8\u95e8\u3011";
                    break;
                }
                sid = String.valueOf(dm.getDepname()) + "\u3010\u90e8\u95e8\u3011";
                break;
            }
            case 'O': {
                OrgModel om = oubo.getOrgModel(sid, cn);
                if (om == null) {
                    WfLog.log(0, "\u3010\u4e0d\u5b58\u5728\u7684\u673a\u6784\u3011,sid=" + sid);
                    sid = "\u3010\u4e0d\u5b58\u5728\u7684\u673a\u6784\u3011";
                    break;
                }
                sid = String.valueOf(om.getOrgname()) + "\u3010\u673a\u6784\u3011";
                break;
            }
            case 'T': {
                sid = new TaskPool().getTaskPoolName(sid, cn);
            }
        }
        return sid;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getUserNameByUserID(String UserID, Connection cn) {
        String UserName = "";
        UserModel um = new UserModel();
        String strtmp = "";
        if (UserID == null) return "-";
        if (UserID.equals("")) return "-";
        if (UserID.equals("-")) {
            return "-";
        }
        if (UserID.startsWith("T.")) {
            return new TaskPool().getTaskPoolName(UserID, cn);
        }
        try {
            StringTokenizer st = new StringTokenizer(UserID.trim(), ";");
            if (st.countTokens() > 10) {
                return UserID.trim();
            }
            while (true) {
                if (!st.hasMoreElements()) {
                    return UserName.substring(0, UserName.length() - 1);
                }
                strtmp = (String)st.nextElement();
                try {
                    if (strtmp.contains("@")) {
                        strtmp = strtmp.replaceAll("@", "");
                    }
                    if (strtmp.startsWith("U.")) {
                        strtmp = strtmp.substring(2);
                    }
                    um = OrgFactory.getInstance().getOrgClass().getUserModel(strtmp, cn);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (um == null || um.getUsername() == null || um.getUsername().equals("")) {
                    UserName = String.valueOf(UserName) + strtmp + ";";
                    continue;
                }
                UserName = String.valueOf(UserName) + um.getUsername() + ";";
            }
        }
        catch (Exception e) {
            WfLog.log(4, "\u3010Error\u3011\u53d6\u5f97\u529e\u7406\u4eba\u5f02\u5e38\uff0c\u65b9\u6cd5\uff1agetUserNameByUserID()");
        }
        return UserName;
    }

    public String getUserEmail(String orgid, String userid, Connection cn) {
        if (userid == null || userid.equals("")) {
            return "";
        }
        return OrgFactory.getInstance().getOrgClass().getUserEmail(orgid, userid, cn);
    }
}

