/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.echain.workflow.cache;

import com.ecc.echain.log.WfLog;
import com.ecc.echain.util.WfPropertyManager;
import com.ecc.echain.workflow.model.VO_wf_node_property;
import com.ecc.echain.workflow.model.VO_wf_whole_property;
import com.ecc.echain.workflow.model.WfModelFactory;
import com.yucheng.cmis.cache.CacheClient;
import com.yucheng.cmis.exception.CmisDaoException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;

public class WFCache {
    public static boolean useCache = false;
    public static final String REDIS_WFCACHE_HMWFCACHE = "WF:WFCACHE:HMWFCACHE";
    public static final String REDIS_WFCACHE_HMWFNODECACHE = "WF:WFCACHE:HMWFNODECACHE";
    public static final String REDIS_WFCACHE_HMWFLIST = "WF:WFCACHE:HMWFLIST";
    public static final String REDIS_WFCACHE_HMFORMFIELDSETS = "WF:WFCACHE:HMFORMFIELDSETS";
    public static final String REDIS_WFCACHE_HMFORMACTIONSETS = "WF:WFCACHE:HMFORMACTIONSETS";
    public static final String REDIS_WFCACHE_HMWFSIGN2WFID = "WF:WFCACHE:HMWFSIGN2WFID";
    private static WFCache instance;
    public boolean reload = false;
    private Map hmWFCache = new Hashtable();
    private Map hmWFNodeCache = new Hashtable();
    private Map hmWFList = new Hashtable();
    private Map hmFormFieldSets = new Hashtable();
    private Map hmFormActionSets = new Hashtable();
    private Map hmWFSign2WFID = new Hashtable();

    private WFCache() {
    }

    public static synchronized WFCache getInstance() {
        if (instance == null) {
            WfLog.log(2, "\u3010eChain_engine_wfcache_createInstance\u3011\u521b\u5efa\u6d41\u7a0b\u7f13\u5b58");
            instance = new WFCache();
            instance.loadData();
        } else if (WFCache.instance.reload) {
            instance.loadData();
        }
        return instance;
    }

    public VO_wf_whole_property getCacheWFObj(String WFID) {
        String wfid = WFID;
        if (WFID.indexOf("_") != -1) {
            wfid = WFID.substring(0, WFID.indexOf("_"));
        }
        if (useCache) {
            if (this.getHmWFCache().containsKey(wfid)) {
                return (VO_wf_whole_property)this.getHmWFCache().get(wfid);
            }
            return this.putWFData(wfid);
        }
        if (this.hmWFCache.containsKey(wfid)) {
            return (VO_wf_whole_property)this.hmWFCache.get(wfid);
        }
        return this.putWFData(wfid);
    }

    public VO_wf_whole_property getCacheWFObjByWFSign(String wfsign) {
        WfLog.log(0, "getCacheWFObjByWFSign\uff1a" + wfsign);
        if (wfsign == null || wfsign.equals("")) {
            return null;
        }
        String wfid = null;
        wfid = useCache ? this.getHmWFSign2WFID().get(wfsign).toString() : (String)this.hmWFSign2WFID.get(wfsign);
        if (wfid == null || wfid.equals("")) {
            System.err.println("\u3010error\u3011\u65e0\u6cd5\u627e\u5230\u6d41\u7a0b\u6807\u8bc6\u4e3a\uff1a" + wfsign + " \u6240\u5bf9\u5e94\u7684\u6d41\u7a0bID");
            return null;
        }
        return this.getCacheWFObj(wfid);
    }

    public VO_wf_node_property getNodeProperty(String NodeID) {
        if (useCache) {
            Map nodeMap = this.getHmWFNodeCache();
            if (nodeMap.containsKey(NodeID)) {
                return (VO_wf_node_property)nodeMap.get(NodeID);
            }
            String WFID = NodeID.substring(0, NodeID.indexOf("_"));
            this.putWFData(WFID);
            return (VO_wf_node_property)nodeMap.get(NodeID);
        }
        if (this.hmWFNodeCache.containsKey(NodeID)) {
            return (VO_wf_node_property)this.hmWFNodeCache.get(NodeID);
        }
        String WFID = NodeID.substring(0, NodeID.indexOf("_"));
        this.putWFData(WFID);
        return (VO_wf_node_property)this.hmWFNodeCache.get(NodeID);
    }

    private String loadData() {
        try {
            useCache = WfPropertyManager.getInstance().wfcachedbinit;
            return WfModelFactory.getInstance().getIMPClass().parseAllModel(this);
        }
        catch (Exception e) {
            System.err.println("\u3010Exception\u3011\u52a0\u8f7d\u6d41\u7a0b\u7f13\u5b58\u4fe1\u606f\u5f02\u5e38\uff0c\u51fa\u9519\u4fe1\u606f\u5982\u4e0b\uff1a");
            e.printStackTrace();
            return "\u52a0\u8f7d\u6d41\u7a0b\u7f13\u5b58\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u63a7\u5236\u53f0\u4fe1\u606f\uff01";
        }
    }

    public VO_wf_whole_property putWFData(String wfid) {
        try {
            return WfModelFactory.getInstance().getIMPClass().parseModel(this, wfid);
        }
        catch (Exception e) {
            System.err.println("\u3010Exception\u3011\u52a0\u8f7d\u6d41\u7a0b\u7f13\u5b58\u4fe1\u606f\u5f02\u5e38\uff0c\u51fa\u9519\u4fe1\u606f\u5982\u4e0b\uff1a");
            e.printStackTrace();
            return null;
        }
    }

    private void delWFData(String WFID) {
        if (this.hmWFCache.containsKey(WFID)) {
            this.hmWFCache.remove(WFID);
        }
    }

    private void clearWFData() {
        this.hmWFCache.clear();
    }

    public void reloadFlag() {
        this.reload = true;
    }

    public String reloadData() {
        return this.loadData();
    }

    public Map getWFCacheMap() {
        if (useCache) {
            try {
                Serializable obj = CacheClient.getSingleSerObject((String)REDIS_WFCACHE_HMWFCACHE);
                if (obj == null) {
                    return new Hashtable();
                }
                return (Map)((Object)obj);
            }
            catch (CmisDaoException e) {
                throw new RuntimeException(e);
            }
        }
        return this.hmWFCache;
    }

    public Map getWFList() {
        if (useCache) {
            try {
                Serializable obj = CacheClient.getSingleSerObject((String)REDIS_WFCACHE_HMWFLIST);
                if (obj == null) {
                    return new Hashtable();
                }
                return (Map)((Object)obj);
            }
            catch (CmisDaoException e) {
                throw new RuntimeException(e);
            }
        }
        return this.hmWFList;
    }

    public Map getHmWFCache() {
        if (useCache) {
            try {
                Serializable obj = CacheClient.getSingleSerObject((String)REDIS_WFCACHE_HMWFCACHE);
                if (obj == null) {
                    return new Hashtable();
                }
                return (Map)((Object)obj);
            }
            catch (CmisDaoException e) {
                throw new RuntimeException(e);
            }
        }
        return this.hmWFCache;
    }

    public void putHmWFCache4Redis(String wfid, VO_wf_whole_property obj) {
        try {
            Map tmpMap = this.getHmWFCache();
            tmpMap.put(wfid, obj);
            CacheClient.setSingleSerObject((String)REDIS_WFCACHE_HMWFCACHE, (Object)tmpMap);
        }
        catch (CmisDaoException e) {
            throw new RuntimeException(e);
        }
    }

    public void setHmWFCache(Map hmWFCache) {
        if (useCache) {
            try {
                CacheClient.setSingleSerObject((String)REDIS_WFCACHE_HMWFCACHE, (Object)hmWFCache);
            }
            catch (CmisDaoException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.hmWFCache = hmWFCache;
        }
    }

    public Map getHmWFNodeCache() {
        if (useCache) {
            try {
                Serializable obj = CacheClient.getSingleSerObject((String)REDIS_WFCACHE_HMWFNODECACHE);
                if (obj == null) {
                    return new Hashtable();
                }
                return (Map)((Object)obj);
            }
            catch (CmisDaoException e) {
                throw new RuntimeException(e);
            }
        }
        return this.hmWFNodeCache;
    }

    public void putHmWFNodeCache4Redis(String nodeid, VO_wf_node_property nobj) {
        try {
            Map tmpMap = this.getHmWFNodeCache();
            tmpMap.put(nodeid, nobj);
            CacheClient.setSingleSerObject((String)REDIS_WFCACHE_HMWFNODECACHE, (Object)tmpMap);
        }
        catch (CmisDaoException e) {
            throw new RuntimeException(e);
        }
    }

    public void setHmWFNodeCache(Map hmWFNodeCache) {
        if (useCache) {
            try {
                CacheClient.setSingleSerObject((String)REDIS_WFCACHE_HMWFNODECACHE, (Object)hmWFNodeCache);
            }
            catch (CmisDaoException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.hmWFNodeCache = hmWFNodeCache;
        }
    }

    private Map getHmWFList() {
        if (useCache) {
            try {
                Serializable obj = CacheClient.getSingleSerObject((String)REDIS_WFCACHE_HMWFLIST);
                if (obj == null) {
                    return new Hashtable();
                }
                return (Map)((Object)obj);
            }
            catch (CmisDaoException e) {
                throw new RuntimeException(e);
            }
        }
        return this.hmWFList;
    }

    public void putHmWFList4Redis(String wfname, Map map) {
        try {
            Map tmpMap = this.getWFList();
            tmpMap.put(wfname, map);
            CacheClient.setSingleSerObject((String)REDIS_WFCACHE_HMWFLIST, (Object)tmpMap);
        }
        catch (CmisDaoException e) {
            throw new RuntimeException(e);
        }
    }

    public Map getSingleHmWFList(String wfname) {
        try {
            Serializable obj = CacheClient.getSingleSerObject((String)REDIS_WFCACHE_HMWFLIST);
            if (obj == null) {
                return new Hashtable();
            }
            return (Map)((Object)obj);
        }
        catch (CmisDaoException e) {
            throw new RuntimeException(e);
        }
    }

    public void setHmWFList(Map hmWFList) {
        if (useCache) {
            try {
                CacheClient.setSingleSerObject((String)REDIS_WFCACHE_HMWFLIST, (Object)hmWFList);
            }
            catch (CmisDaoException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.hmWFList = hmWFList;
        }
    }

    public Map getHmFormFieldSets() {
        if (useCache) {
            try {
                Serializable obj = CacheClient.getSingleSerObject((String)REDIS_WFCACHE_HMFORMFIELDSETS);
                if (obj == null) {
                    return new Hashtable();
                }
                return (Map)((Object)obj);
            }
            catch (CmisDaoException e) {
                throw new RuntimeException(e);
            }
        }
        return this.hmFormFieldSets;
    }

    public void setHmFormFieldSets(Map hmFormFieldSets) {
        if (useCache) {
            try {
                CacheClient.setSingleSerObject((String)REDIS_WFCACHE_HMFORMFIELDSETS, (Object)hmFormFieldSets);
            }
            catch (CmisDaoException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.hmFormFieldSets = hmFormFieldSets;
        }
    }

    public void putHmFormFieldSets4Redis(String key, Map map) {
        try {
            Map tmpMap = this.getHmFormFieldSets();
            tmpMap.put(key, map);
            CacheClient.setSingleSerObject((String)REDIS_WFCACHE_HMFORMFIELDSETS, (Object)tmpMap);
        }
        catch (CmisDaoException e) {
            throw new RuntimeException(e);
        }
    }

    public Map getHmFormActionSets() {
        if (useCache) {
            try {
                Serializable obj = CacheClient.getSingleSerObject((String)REDIS_WFCACHE_HMFORMACTIONSETS);
                if (obj == null) {
                    return new Hashtable();
                }
                return (Map)((Object)obj);
            }
            catch (CmisDaoException e) {
                throw new RuntimeException(e);
            }
        }
        return this.hmFormActionSets;
    }

    public void setHmFormActionSets(Map hmFormActionSets) {
        if (useCache) {
            try {
                CacheClient.setSingleSerObject((String)REDIS_WFCACHE_HMFORMACTIONSETS, (Object)hmFormActionSets);
            }
            catch (CmisDaoException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.hmFormActionSets = hmFormActionSets;
        }
    }

    public void putHmFormActionSets4Redis(String key, Map map) {
        try {
            Map tmpMap = this.getHmFormActionSets();
            tmpMap.put(key, map);
            CacheClient.setSingleSerObject((String)REDIS_WFCACHE_HMFORMACTIONSETS, (Object)tmpMap);
        }
        catch (CmisDaoException e) {
            throw new RuntimeException(e);
        }
    }

    public Map getHmWFSign2WFID() {
        if (useCache) {
            try {
                Serializable obj = CacheClient.getSingleSerObject((String)REDIS_WFCACHE_HMWFSIGN2WFID);
                if (obj == null) {
                    return new Hashtable();
                }
                return (Map)((Object)obj);
            }
            catch (CmisDaoException e) {
                throw new RuntimeException(e);
            }
        }
        return this.hmWFSign2WFID;
    }

    public void setHmWFSign2WFID(Map hmWFSign2WFID) {
        if (useCache) {
            try {
                CacheClient.setSingleSerObject((String)REDIS_WFCACHE_HMWFSIGN2WFID, (Object)hmWFSign2WFID);
            }
            catch (CmisDaoException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.hmWFSign2WFID = hmWFSign2WFID;
        }
    }

    public void putHmWFSign2WFID4Redis(String wfsign, String wfid) {
        if (useCache) {
            try {
                Map tmpMap = this.getHmWFSign2WFID();
                tmpMap.put(wfsign, wfsign);
                CacheClient.setSingleSerObject((String)REDIS_WFCACHE_HMWFSIGN2WFID, (Object)tmpMap);
            }
            catch (CmisDaoException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.hmWFSign2WFID = this.hmWFSign2WFID;
        }
    }
}

