/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.echain.workflow.cache;

import com.ecc.echain.db.DbControl;
import com.ecc.echain.log.WfLog;
import com.ecc.echain.util.StringUtils;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;

public class ParamMapCache {
    private static ParamMapCache instance;
    private static boolean reload;
    private Hashtable hmPMCache = new Hashtable();

    static {
        reload = false;
    }

    private ParamMapCache() {
    }

    public static synchronized ParamMapCache getInstance() {
        if (instance == null) {
            WfLog.log(2, "\u3010eChain_engine_paramMapcache_createInstance\u3011\u521b\u5efaformdata\u7f13\u5b58");
            instance = new ParamMapCache();
            instance.loadData();
        } else if (reload) {
            instance.loadData();
        }
        return instance;
    }

    public HashMap getCacheObj(String InstanceID, Connection cn) {
        if (this.hmPMCache.containsKey(InstanceID)) {
            return (HashMap)this.hmPMCache.get(InstanceID);
        }
        return this.putPMData(InstanceID, cn);
    }

    private void loadData() {
        WfLog.log(2, "\u3010eChain_engine_paramMapcache_loadData\u3011\u5f00\u59cb\u52a0\u8f7dformdata\u7f13\u5b58\u4fe1\u606f");
        this.hmPMCache.clear();
        DbControl db = DbControl.getInstance();
        Connection cn = null;
        int totalnum = 0;
        try {
            try {
                cn = db.getConnection();
                Vector vecData = db.performQuery("select instanceid,formdata from wf_instance_whole_property", cn);
                if (vecData != null && vecData.size() > 0) {
                    int i = 0;
                    while (i < vecData.size()) {
                        Vector vecRow = (Vector)vecData.elementAt(i);
                        this.hmPMCache.put((String)vecRow.elementAt(0), StringUtils.convertStrToHashMap((String)vecRow.elementAt(1)));
                        ++totalnum;
                        ++i;
                    }
                }
                reload = false;
                WfLog.log(2, "\u3010eChain_engine_paramMapcache_loadData\u3011\u52a0\u8f7d\u7528\u6237\u7f13\u5b58\u4fe1\u606f\u5b8c\u6bd5\uff0c\u5171\u52a0\u8f7d" + totalnum + "\u6761\u4fe1\u606f;");
            }
            catch (Exception e) {
                WfLog.log(4, "\u3010Exception\u3011\u52a0\u8f7dformdata\u7f13\u5b58\u4fe1\u606f\u5f02\u5e38\uff0c\u51fa\u9519\u4fe1\u606f\u5982\u4e0b\uff1a");
                e.printStackTrace();
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e2) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                db.freeConnection(cn);
            }
            catch (Exception e) {
                WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                e.printStackTrace();
            }
        }
    }

    private HashMap putPMData(String InstanceID, Connection cn) {
        if (this.hmPMCache.containsKey(InstanceID)) {
            this.hmPMCache.remove(InstanceID);
        }
        WfLog.log(2, "\u52a0\u8f7dformdata\u7f13\u5b58\uff0cInstanceID:" + InstanceID);
        DbControl db = DbControl.getInstance();
        HashMap hm = new HashMap();
        try {
            Vector vecData = db.performQuery("select formdata from wf_instance_whole_property where InstanceID='" + InstanceID + "'", cn);
            if (vecData != null && vecData.size() > 0) {
                Vector vecRow = (Vector)vecData.elementAt(0);
                hm = StringUtils.convertStrToHashMap((String)vecRow.elementAt(0));
                this.hmPMCache.put(InstanceID, hm);
            }
        }
        catch (Exception e) {
            WfLog.log(4, "\u3010Exception\u3011\u52a0\u8f7dformdata\u7f13\u5b58\u4fe1\u606f\u5f02\u5e38\uff0c\u51fa\u9519\u4fe1\u606f\u5982\u4e0b\uff1a");
            e.printStackTrace();
        }
        return hm;
    }

    public void putPMData(String InstanceID, HashMap hm) {
        this.hmPMCache.put(InstanceID, hm);
    }

    public void reloadFlag() {
        reload = true;
    }

    public void reloadData() {
        this.loadData();
    }
}

