/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.echain.workflow.cache;

import com.ecc.echain.db.DbControl;
import com.ecc.echain.log.WfLog;
import com.ecc.echain.org.OrgFactory;
import com.ecc.echain.org.model.OrgModel;
import com.ecc.echain.util.WfPropertyManager;
import java.sql.Connection;
import java.util.LinkedHashMap;
import java.util.Map;

public class OUCache {
    private static OUCache instance;
    private static boolean reload;
    public OrgModel rootOrgModel = null;
    public Map hmOMCache = new LinkedHashMap();
    public Map hmRMCache = new LinkedHashMap();
    public Map hmGMCache = new LinkedHashMap();
    public Map hmUMCache = new LinkedHashMap();

    static {
        reload = false;
    }

    private OUCache() {
    }

    public static synchronized OUCache getInstance() {
        if (instance == null) {
            WfLog.log(2, "\u3010eChain_engine_oucache_createInstance\u3011\u521b\u5efa\u7528\u6237\u7f13\u5b58");
            instance = new OUCache();
            instance.loadData();
        } else if (reload) {
            instance.loadData();
        }
        return instance;
    }

    private void loadData() {
        WfLog.log(2, "\u3010eChain_engine_oucache_loadData\u3011\u5f00\u59cb\u52a0\u8f7d\u7528\u6237\u7f13\u5b58\u4fe1\u606f");
        Runtime.getRuntime().gc();
        long currMemory = Runtime.getRuntime().freeMemory();
        Connection cn = null;
        DbControl db = DbControl.getInstance();
        try {
            try {
                cn = db.getConnection();
                WfPropertyManager.getInstance().isOUCache = false;
                OrgFactory.getInstance().getOrgClass().loadOUCache(this, cn);
                WfPropertyManager.getInstance().isOUCache = true;
                reload = false;
                WfLog.log(2, "\u3010eChain_engine_oucache_loadData\u3011\u52a0\u8f7d\u7528\u6237\u7f13\u5b58\u4fe1\u606f\u5b8c\u6bd5;");
                WfLog.log(2, "\u52a0\u8f7d\u7528\u6237\u7f13\u5b58\u5360\u7528\u5185\u5b58\u7a7a\u95f4\u5927\u7ea6\uff1a" + (currMemory - Runtime.getRuntime().freeMemory()) / 1024L + "K");
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e2) {
                    WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                db.freeConnection(cn);
            }
            catch (Exception e) {
                WfLog.log(4, "\u91ca\u653e\u5f53\u524d\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u5f02\u5e38");
                e.printStackTrace();
            }
        }
    }

    public void reloadFlag() {
        reload = true;
    }

    public void reloadData() {
        this.loadData();
    }
}

