/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.echain.util;

import com.ecc.echain.util.WfPropertyManager;
import java.net.InetAddress;
import java.security.SecureRandom;

public class UNIDProducer {
    private String midString;
    private SecureRandom seeder;

    public UNIDProducer() {
        this.init();
    }

    private void init() {
        try {
            if (WfPropertyManager.getInstance().standalone) {
                this.midString = "";
            } else {
                InetAddress inet = InetAddress.getLocalHost();
                byte[] bytes = inet.getAddress();
                String hexAddress = this.hexFormat(this.getInt(bytes), 8);
                String hash = this.hexFormat(System.identityHashCode(this), 8);
                this.midString = String.valueOf(hexAddress) + hash;
            }
            this.seeder = new SecureRandom();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getUNID() {
        StringBuffer buf = new StringBuffer();
        long time = System.currentTimeMillis();
        int timeLow = (int)time & 0xFFFFFFFF;
        int node = this.seeder.nextInt();
        buf.append(this.hexFormat(timeLow, 8)).append(this.midString).append(this.hexFormat(node, 8));
        return buf.toString();
    }

    private String hexFormat(int number, int digits) {
        String hex = Integer.toHexString(number).toUpperCase();
        if (hex.length() >= digits) {
            return hex.substring(0, digits);
        }
        int padding = digits - hex.length();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < padding) {
            buf.append("0");
            ++i;
        }
        buf.append(hex);
        return buf.toString();
    }

    private int getInt(byte[] bytes) {
        int size = bytes.length > 32 ? 32 : bytes.length;
        int result = 0;
        int i = size - 1;
        while (i >= 0) {
            result = i == size - 1 ? (result += bytes[i]) : (result += bytes[i] << 4 * (size - 1 - i));
            --i;
        }
        return result;
    }

    public static void main(String[] args) {
        UNIDProducer UNIDProducer1 = new UNIDProducer();
        String UNID = UNIDProducer1.getUNID();
        System.out.println("UNID: " + UNID);
        System.out.println("UNID\u957f\u5ea6: " + UNID.length());
        int node = UNIDProducer1.seeder.nextInt();
        String str = UNIDProducer1.hexFormat(node, 8);
        System.out.println("\u53d6\u5f97\u7684\u968f\u673a\u6570\u662f\uff1a" + node + "\uff1b\u8f6c\u6362\u540e\uff1a" + str);
    }
}

