/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.echain.util;

import com.ecc.echain.util.WfPropertyManager;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class StringUtils {
    public static final String convertToChinese(String input) {
        String str = "";
        try {
            str = new String(input.getBytes("iso-8859-1"), "GB18030");
        }
        catch (Exception e) {
            str = input;
        }
        return str;
    }

    public static final String convertToChineseUTF(String input) {
        String str = "";
        try {
            str = new String(input.getBytes("iso-8859-1"), "UTF-8");
        }
        catch (Exception e) {
            str = input;
        }
        return str;
    }

    public static final String convertToANSI(String input) {
        String str = "";
        try {
            str = new String(input.getBytes("GBK"), "iso-8859-1");
        }
        catch (Exception e) {
            str = input;
        }
        return str;
    }

    public static final String iso2gb(String input) {
        String str = input;
        if (input == null || input.equals("")) {
            return input;
        }
        if (WfPropertyManager.getInstance().iso2gb) {
            try {
                str = new String(input.getBytes("iso-8859-1"), "GBK");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return str;
    }

    public static final String gb2iso(String input) {
        String str = input;
        if (input == null || input.equals("")) {
            return input;
        }
        if (WfPropertyManager.getInstance().iso2gb) {
            try {
                str = new String(input.getBytes("GBK"), "iso-8859-1");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return str;
    }

    public static String GB2312toUTF(String inPara) {
        String rtStr = new String("");
        if (inPara == null) {
            inPara = "";
        }
        int i = 0;
        while (i < inPara.length()) {
            char temChr = inPara.charAt(i);
            int ascChr = temChr + '\u0000';
            System.out.println(ascChr);
            System.out.println(Integer.toBinaryString(ascChr));
            rtStr = String.valueOf(rtStr) + "&#x" + Integer.toHexString(ascChr) + ";";
            ++i;
        }
        return rtStr;
    }

    public static String toGB2312(String inPara) {
        System.out.println("\u539f\u6765\u7684\u5b57\u7b26\u4e32\u4e3a\uff1a" + inPara);
        if (inPara == null) {
            inPara = "";
        }
        try {
            char[] temp = inPara.toCharArray();
            byte[] b = new byte[temp.length];
            System.out.println("\u5206\u6210char[]\u540e\u5b57\u7b26\u4e32\u7684\u4e3a\uff1a" + temp.toString());
            System.out.println("\u4f20\u9012\u5b57\u7b26\u4e32\u7684\u957f\u5ea6\u4e3a\uff1a" + temp.length);
            int i = 0;
            while (i < temp.length) {
                b[i] = (byte)temp[i];
                ++i;
            }
            String destString = new String(b, "GB2312");
            System.out.println(destString);
            return destString;
        }
        catch (UnsupportedEncodingException e) {
            return "\u4e0d\u652f\u6301\u7684\u5b57\u7b26\u7f16\u7801";
        }
    }

    private static final String getLimitedLengthString(String input, int length) {
        String tempStr = "";
        tempStr = input;
        if (tempStr == null || tempStr.equals("")) {
            tempStr = "&nbsp;";
        }
        if (length < 0) {
            return tempStr;
        }
        int iEnd = tempStr.length();
        if (iEnd > length) {
            tempStr = tempStr.substring(0, length);
            tempStr = String.valueOf(tempStr) + "\uff0e\uff0e\uff0e";
        }
        return tempStr;
    }

    public static final String getHperLinkString(String description, String url, int length) {
        String tempStr = "";
        if (description == null || description == "") {
            description = "";
        }
        if (url == null || url == "") {
            url = "#";
        }
        tempStr = "<a href=" + url + " title=" + description + " >";
        tempStr = String.valueOf(tempStr) + StringUtils.getLimitedLengthString(description, length) + "</a>  ";
        return tempStr;
    }

    public static final String replace(String line, String oldString, String newString) {
        int srcLength;
        String temp = "";
        int i = 0;
        int j = 0;
        if (oldString == null || oldString.equals("")) {
            return line;
        }
        if (newString == null || newString.equals("")) {
            return line;
        }
        line = line.trim();
        oldString = oldString.trim();
        newString = newString.trim();
        int oldLength = oldString.length();
        int totalLength = srcLength = line.length();
        while (i < totalLength) {
            j = line.indexOf(oldString, i);
            if (j == -1) {
                temp = String.valueOf(temp) + line.substring(i, srcLength);
                break;
            }
            temp = String.valueOf(temp) + line.substring(i, j) + newString;
            j = i = j + oldLength;
        }
        return temp;
    }

    public static final String escapeTextToHTML(String input) {
        if (input == null || input.length() == 0) {
            return input;
        }
        StringBuffer buf = new StringBuffer(input.length());
        char ch = ' ';
        int i = 0;
        while (i < input.length()) {
            ch = input.charAt(i);
            if (ch == '<') {
                buf.append("&lt;");
            } else if (ch == '>') {
                buf.append("&gt;");
            } else if (ch == ' ') {
                buf.append("&nbsp;");
            } else if (ch == '\t') {
                if (input.charAt(i + 1) == '\n') {
                    ++i;
                    buf.append("<br>");
                }
            } else {
                buf.append(ch);
            }
            ++i;
        }
        return buf.toString();
    }

    public static final String escapeHTMLToText(String input) {
        String temp = "";
        temp = input;
        if (input == null || input.equals("")) {
            return temp;
        }
        temp = StringUtils.replace(temp, "&nbsp;", " ");
        temp = StringUtils.replace(temp, "<br>", "\r\n");
        temp = StringUtils.replace(temp, "&gt;", ">");
        temp = StringUtils.replace(temp, "&lt;", "<");
        return temp;
    }

    public static final String NullToEmpty(String input) {
        if (input == null) {
            return "";
        }
        return input.trim();
    }

    public static final String formatIntLength(int input, int length) {
        String strResult = null;
        if (Integer.toString(input).length() >= length) {
            strResult = Integer.toString(input);
        } else {
            String zero = "";
            int i = 0;
            while (i < length - Integer.toString(input).length()) {
                zero = String.valueOf(zero) + "0";
                ++i;
            }
            strResult = String.valueOf(zero) + input;
        }
        return strResult;
    }

    public static final boolean isNumberFormat(String strinput) {
        boolean result = true;
        try {
            Float.parseFloat(strinput);
        }
        catch (NumberFormatException e) {
            result = false;
        }
        return result;
    }

    public static final int getPosition(String[] strArr, String str) {
        int result = -1;
        int i = 0;
        while (i < strArr.length) {
            if (strArr[i].equalsIgnoreCase(str)) {
                result = i;
                break;
            }
            ++i;
        }
        return result;
    }

    public static boolean isPartOf(Vector vecTotal, Vector vecPart) {
        boolean result = true;
        int i = 0;
        while (i < vecPart.size()) {
            int j = 0;
            while (j < vecTotal.size()) {
                if (((String)vecPart.elementAt(i)).equalsIgnoreCase((String)vecTotal.elementAt(j))) break;
                if (j == vecTotal.size() - 1) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static boolean isPartOf(String strTotal, String strPart, String splitSign) {
        boolean result = false;
        String tmp = "";
        if (strTotal == null || strTotal.equals("") || strTotal.equals("null")) {
            return false;
        }
        if (strPart == null || strPart.equals("") || strPart.equals("null")) {
            return false;
        }
        if (splitSign == null || splitSign.equals("") || splitSign.equals("null")) {
            return false;
        }
        strTotal = strTotal.trim();
        strPart = strPart.trim();
        StringTokenizer st = new StringTokenizer(strTotal, splitSign);
        while (st.hasMoreElements()) {
            tmp = (String)st.nextElement();
            if (!tmp.equals(strPart)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static String delSubStr(String strTotal, String strDel, String splitSign) {
        String resultStr = "";
        resultStr = StringUtils.delSubStr2(strTotal, strDel, splitSign);
        if (resultStr.length() > 1) {
            resultStr = resultStr.substring(0, resultStr.length() - 1);
        }
        return resultStr;
    }

    public static String delSubStr2(String strTotal, String strDel, String splitSign) {
        String resultStr = "";
        strTotal = strTotal.trim();
        strDel = strDel.trim();
        StringTokenizer st = new StringTokenizer(strTotal, splitSign);
        while (st.hasMoreElements()) {
            String strTemp = (String)st.nextElement();
            if (strTemp.equals(strDel)) continue;
            resultStr = String.valueOf(resultStr) + strTemp + ";";
        }
        return resultStr;
    }

    public static int getElementsNUM(String strTotal, String splitSign) {
        int k = 0;
        if (strTotal == null || strTotal.equals("") || splitSign == null || splitSign.equals("")) {
            return 0;
        }
        strTotal = strTotal.trim();
        StringTokenizer st = new StringTokenizer(strTotal, splitSign);
        while (st.hasMoreElements()) {
            ++k;
            st.nextElement();
        }
        return k;
    }

    public static int getElementsNUM(String strTotal, String subStr, String splitSign) {
        int k = 0;
        if (strTotal == null || strTotal.equals("") || subStr == null || subStr.equals("") || splitSign == null || splitSign.equals("")) {
            return 0;
        }
        String s = "";
        strTotal = strTotal.trim();
        subStr = subStr.trim();
        StringTokenizer st = new StringTokenizer(strTotal, splitSign);
        while (st.hasMoreElements()) {
            s = (String)st.nextElement();
            if (!s.equals(subStr)) continue;
            ++k;
        }
        return k;
    }

    public static String getFirstElement(String strTotal, String splitSign) {
        String resultStr = "";
        strTotal = strTotal.trim();
        StringTokenizer st = new StringTokenizer(strTotal, splitSign);
        while (st.hasMoreElements()) {
            resultStr = (String)st.nextElement();
            if (resultStr != null && !resultStr.equals("")) break;
        }
        return resultStr;
    }

    public static String delSameElement(String strTotal, String splitSign) {
        String resultStr = "";
        String strtmp = "";
        ArrayList list = new ArrayList();
        if (strTotal == null || strTotal.equals("") || splitSign == null || splitSign.equals("")) {
            return "";
        }
        strTotal = strTotal.trim();
        String[] strlist = strTotal.split(splitSign);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        int i = 0;
        while (i < strlist.length) {
            map.put(strlist[i], strlist[i]);
            ++i;
        }
        StringBuffer sb = new StringBuffer();
        for (String key : map.keySet()) {
            sb.append(";" + key);
        }
        if (!sb.toString().equals("")) {
            resultStr = sb.toString();
            resultStr = resultStr.substring(1, resultStr.length());
        }
        return resultStr;
    }

    public static String delSameElement(String strTotal1, String strTotal2, String splitSign) {
        if (strTotal1 == null || strTotal1.equals("")) {
            return "";
        }
        if (strTotal2 == null || strTotal2.equals("") || splitSign == null || splitSign.equals("")) {
            return strTotal1;
        }
        String resultStr = "";
        String strtmp = "";
        strTotal1 = strTotal1.trim();
        strTotal2 = strTotal2.trim();
        String[] strlist1 = strTotal1.split(splitSign);
        String[] strlist2 = strTotal2.split(splitSign);
        int i = 0;
        while (i < strlist1.length) {
            strtmp = strlist1[i];
            if (strtmp != null && !strtmp.equals("") && !strtmp.equals("null")) {
                boolean bFind = false;
                int j = 0;
                while (j < strlist2.length) {
                    if (strlist2[j].equals(strtmp)) {
                        bFind = true;
                        break;
                    }
                    ++j;
                }
                if (!bFind) {
                    resultStr = String.valueOf(resultStr) + ";" + strtmp;
                }
            }
            ++i;
        }
        if (!resultStr.equals("")) {
            resultStr = resultStr.substring(1);
        }
        return resultStr;
    }

    public static String getSameElement(String strTotal1, String strTotal2, String splitSign) {
        String resultStr = "";
        String strtmp = "";
        if (strTotal1 == null || strTotal1.equals("") || strTotal2 == null || strTotal2.equals("") || splitSign == null || splitSign.equals("")) {
            return "";
        }
        strTotal1 = strTotal1.trim();
        strTotal2 = strTotal2.trim();
        String[] strlist1 = strTotal1.split(splitSign);
        String[] strlist2 = strTotal2.split(splitSign);
        int i = 0;
        while (i < strlist1.length) {
            strtmp = strlist1[i];
            if (strtmp != null && !strtmp.equals("") && !strtmp.equals("null")) {
                boolean bFind = false;
                int j = 0;
                while (j < strlist2.length) {
                    if (strlist2[j].equals(strtmp)) {
                        bFind = true;
                        break;
                    }
                    ++j;
                }
                if (bFind) {
                    resultStr = String.valueOf(resultStr) + ";" + strtmp;
                }
            }
            ++i;
        }
        if (!resultStr.equals("")) {
            resultStr = resultStr.substring(1);
        }
        return resultStr;
    }

    public static final String convertToCipher(String input) {
        if (input == null || input.equals("")) {
            return "";
        }
        String str = new BASE64Encoder().encode(input.getBytes());
        return str;
    }

    public static final String convertToPlainness(String input) {
        if (input == null || input.equals("")) {
            return "";
        }
        String str = "";
        try {
            byte[] bt = new BASE64Decoder().decodeBuffer(input.trim());
            str = new String(bt);
        }
        catch (Exception e) {
            str = "";
        }
        return str;
    }

    public static final HashMap convertStrToHashMap(String input) {
        HashMap<String, String> hm = new HashMap<String, String>();
        if (input == null || input.equals("")) {
            return hm;
        }
        input = input.trim();
        if (WfPropertyManager.getInstance().parammapiso2gb) {
            input = StringUtils.convertToChinese(input);
        }
        StringTokenizer st = new StringTokenizer(input, "~");
        while (st.hasMoreElements()) {
            String s = (String)st.nextElement();
            if (s == null || s.equals("")) continue;
            try {
                String key = s.substring(0, s.indexOf("="));
                String value = s.substring(s.indexOf("=") + 1, s.length());
                hm.put(key, value.equals("null") ? null : value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return hm;
    }

    public static final String convertHashMapToStr(HashMap hm) {
        String str = "";
        if (hm == null || hm.isEmpty()) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        for (String key : hm.keySet()) {
            if (key == null || key.equals("_emp_context")) continue;
            String value = hm.get(key) == null ? "null" : (String)hm.get(key);
            sb.append("~" + key + "=" + value);
        }
        if (sb.length() > 2) {
            str = sb.substring(1);
            if (WfPropertyManager.getInstance().parammapiso2gb) {
                str = StringUtils.convertToANSI(str);
            }
        }
        return str;
    }

    public static final String convertSpecificalSignStr(String input, String splitSign, HashMap hm) {
        if (splitSign == null || splitSign.equals("") || hm == null || hm.isEmpty()) {
            return input;
        }
        StringTokenizer st = new StringTokenizer("_" + input + "_", splitSign);
        int n = st.countTokens();
        int i = 0;
        while (st.hasMoreElements()) {
            String key = (String)st.nextElement();
            if (++i >= n || i % 2 != 0 || hm.get(key) == null) continue;
            input = input.replaceAll(String.valueOf(splitSign) + key + splitSign, (String)hm.get(key));
        }
        return input;
    }

    public static final String[] split(String input, String splitSign) {
        if (input == null || input.equals("") || splitSign == null || splitSign.equals("")) {
            return null;
        }
        ArrayList<String> al = new ArrayList<String>();
        if (input.indexOf(splitSign) == -1) {
            al.add(input);
        } else {
            String stmp = input;
            while (stmp.indexOf(splitSign) != -1) {
                al.add(stmp.substring(0, stmp.indexOf(splitSign)));
                stmp = stmp.substring(stmp.indexOf(splitSign) + 1);
            }
            al.add(stmp);
        }
        String[] s = new String[al.size()];
        int i = 0;
        while (i < al.size()) {
            s[i] = (String)al.get(i);
            ++i;
        }
        return s;
    }

    public static void main(String[] args) throws Exception {
        String s = "0001";
        System.out.println(new String("q\u5218\u666f\u5e94".getBytes(), 0, 4, "GB2312"));
        int kk = Integer.parseInt(s) + 10;
        s = "0000" + String.valueOf(kk);
        s = s.substring(s.length() - 4, s.length());
        System.out.println("=====" + s);
        String str = "\u963f\u745f\u5200\u6cd5\u65af\u8482\u82acsadfd.asas.,dcc()\uff08\u968f\u98ce\u5012\u901f\u5ea6\uff09,.\uff0c\u3002~!@#$%^&*()_+|g,;'gf[]sdf";
        String str2 = StringUtils.convertToCipher(str);
        String str3 = StringUtils.convertToPlainness(str2);
        System.out.println(String.valueOf(str) + "====" + str2 + "====" + str3);
        s = "\u5ba2\u6237\uff1a%crd_zhsx_sq__khmc%\u7684\u6388\u4fe1\u7533\u8bf7\uff0c\u9650\u989d\uff1a%crd_zhsx_sq__sxxe%";
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("crd_zhsx_sq__khmc", "\u5218\u666f\u5e94");
        hm.put("crd_zhsx_sq__sxxe", "3");
        System.out.println("==" + StringUtils.convertSpecificalSignStr(s, "%", hm));
        System.out.println(StringUtils.delSubStr("aa;bb;;cc;", "dd", ";"));
        System.out.println(StringUtils.delSameElement("aa;bb;;cc;aa;;dd;", ";"));
        System.out.println(StringUtils.convertToCipher("\u4f1a\u7b7e\u8282\u70b9\u610f\u89c1lisi"));
    }
}

