/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.echain.util;

import com.ecc.echain.log.WfLog;
import com.ecc.echain.util.CalendarUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DatetimeUtils {
    public static final String getDateString(Date date) {
        SimpleDateFormat formattxt = new SimpleDateFormat("yyyy-MM-dd");
        return formattxt.format(date);
    }

    public static final String getDateTimeString(Date date) {
        SimpleDateFormat formattxt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formattxt.format(date);
    }

    public static final String getNowDateTimeString() {
        SimpleDateFormat formattxt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formattxt.format(new Date());
    }

    public static final String getNowDateString() {
        SimpleDateFormat formattxt = new SimpleDateFormat("yyyy-MM-dd");
        return formattxt.format(new Date());
    }

    public static final String getNowTimeString() {
        SimpleDateFormat formattxt = new SimpleDateFormat("HH:mm:ss");
        return formattxt.format(new Date());
    }

    public static final Date getDate(String dateTimeString) {
        SimpleDateFormat formattxt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = formattxt.parse(dateTimeString);
        }
        catch (Exception e) {
            WfLog.log(4, e.getMessage());
            date = new Date();
        }
        return date;
    }

    public static final String getLastYearString(Date date) {
        Calendar lastYear = Calendar.getInstance();
        lastYear.setTime(date);
        lastYear.add(1, -1);
        return DatetimeUtils.getDateString(lastYear.getTime());
    }

    public static final String getLastMonthString(Date date) {
        Calendar lastMonth = Calendar.getInstance();
        lastMonth.setTime(date);
        lastMonth.add(2, -1);
        return DatetimeUtils.getDateString(lastMonth.getTime());
    }

    public static final String getLastWeekString(Date date) {
        Calendar lastWeek = Calendar.getInstance();
        lastWeek.setTime(date);
        lastWeek.add(11, -168);
        return DatetimeUtils.getDateString(lastWeek.getTime());
    }

    public static final String getYesterdayString(Date date) {
        Calendar yesterday = Calendar.getInstance();
        yesterday.setTime(date);
        yesterday.add(11, -24);
        return DatetimeUtils.getDateString(yesterday.getTime());
    }

    public static final String getDateString(int k) {
        Calendar yesterday = Calendar.getInstance();
        yesterday.add(11, 24 * k);
        return DatetimeUtils.getDateString(yesterday.getTime());
    }

    public static final String getNoLineNowDateString() {
        Date date = new Date();
        SimpleDateFormat formattxt = new SimpleDateFormat("yyyyMMdd");
        return formattxt.format(date);
    }

    public static final String getNoLineNowTimeString() {
        Date date = new Date();
        SimpleDateFormat formattxt = new SimpleDateFormat("HHmmss");
        return formattxt.format(date);
    }

    public static final String getNowTimeStamp() {
        Date date = new Date();
        SimpleDateFormat formattxt = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss_SSS");
        return formattxt.format(date);
    }

    public static final long convertLongTime(String space) {
        if (space == null || space.length() < 2) {
            return 0L;
        }
        long time = 0L;
        char ss = space.charAt(0);
        int extent = Integer.parseInt(space.substring(1, space.length()));
        switch (ss) {
            case 'D': {
                time = extent * 24 * 3600 * 1000;
                break;
            }
            case 'd': {
                time = extent * 24 * 3600 * 1000;
                break;
            }
            case 'H': {
                time = extent * 3600 * 1000;
                break;
            }
            case 'h': {
                time = extent * 3600 * 1000;
            }
        }
        return time;
    }

    public static final String convertDateTimeString(String originalString, String space, String sign) {
        if (originalString == null || originalString.equals("")) {
            return "";
        }
        SimpleDateFormat formattxt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date d = null;
        long extent = Integer.parseInt(space.substring(1, space.length()));
        char ss = space.charAt(0);
        try {
            long time;
            block27: {
                block26: {
                    d = formattxt.parse(originalString);
                    time = d.getTime();
                    if (!sign.equals("before")) break block26;
                    switch (ss) {
                        case 'D': {
                            time -= extent * 24L * 3600L * 1000L;
                            break;
                        }
                        case 'd': {
                            if (extent > 10L) {
                                extent = 10L;
                                WfLog.log(4, "\uff1d\uff1d\uff1d\uff1d\uff1d\u5f53\u524d\u6d41\u7a0b\u5b9a\u4e49\u4e0d\u6b63\u5e38\uff08\u6d41\u7a0b\u529e\u7406\u671f\u9650\u8fc7\u957f\uff09\uff0c\u5c06\u4e25\u91cd\u5f71\u54cd\u670d\u52a1\u5668\u6027\u80fd\uff0c\u8bf7\u5c3d\u5feb\u901a\u77e5\u7cfb\u7edf\u7ba1\u7406\u5458\u4fee\u6539\uff01\uff1d\uff1d\uff1d\uff1d\uff1d");
                            }
                            int range = 86400000;
                            int k = 0;
                            while ((long)k < extent) {
                                if (!CalendarUtils.getInstance().isWorkDay(time -= (long)range)) continue;
                                ++k;
                            }
                            break block27;
                        }
                        case 'H': {
                            time -= extent * 3600L * 1000L;
                            break;
                        }
                        case 'h': {
                            if (extent > 10L) {
                                extent = 10L;
                                WfLog.log(4, "\uff1d\uff1d\uff1d\uff1d\uff1d\u5f53\u524d\u6d41\u7a0b\u5b9a\u4e49\u4e0d\u6b63\u5e38\uff08\u6d41\u7a0b\u529e\u7406\u671f\u9650\u8fc7\u957f\uff0c\u5efa\u8bae\u4f7f\u7528\u5de5\u4f5c\u65e5\uff09\uff0c\u5c06\u4e25\u91cd\u5f71\u54cd\u670d\u52a1\u5668\u6027\u80fd\uff0c\u8bf7\u5c3d\u5feb\u901a\u77e5\u7cfb\u7edf\u7ba1\u7406\u5458\u4fee\u6539\uff01\uff1d\uff1d\uff1d\uff1d\uff1d");
                            }
                            int range = 3600000;
                            int k = 0;
                            while ((long)k < extent) {
                                time -= (long)range;
                                while (!CalendarUtils.getInstance().isWorkDay(time)) {
                                    time -= 86400000L;
                                }
                                if (!CalendarUtils.getInstance().isWorkTime(time)) continue;
                                ++k;
                            }
                            break block1;
                        }
                    }
                    break block27;
                }
                if (sign.equals("after")) {
                    switch (ss) {
                        case 'D': {
                            time += extent * 24L * 3600L * 1000L;
                            break;
                        }
                        case 'd': {
                            if (extent > 30L) {
                                extent = 30L;
                                WfLog.log(4, "\uff1d\uff1d\uff1d\uff1d\uff1d\u5f53\u524d\u6d41\u7a0b\u5b9a\u4e49\u4e0d\u6b63\u5e38\uff08\u6d41\u7a0b\u529e\u7406\u671f\u9650\u8fc7\u957f\uff09\uff0c\u5c06\u4e25\u91cd\u5f71\u54cd\u670d\u52a1\u5668\u6027\u80fd\uff0c\u8bf7\u5c3d\u5feb\u901a\u77e5\u7cfb\u7edf\u7ba1\u7406\u5458\u4fee\u6539\uff01\uff1d\uff1d\uff1d\uff1d\uff1d");
                            }
                            int range = 86400000;
                            int k = 0;
                            while ((long)k < extent) {
                                if (!CalendarUtils.getInstance().isWorkDay(time += (long)range)) continue;
                                ++k;
                            }
                            break;
                        }
                        case 'H': {
                            time += extent * 3600L * 1000L;
                            break;
                        }
                        case 'h': {
                            if (extent > 30L) {
                                extent = 30L;
                                WfLog.log(4, "\uff1d\uff1d\uff1d\uff1d\uff1d\u5f53\u524d\u6d41\u7a0b\u5b9a\u4e49\u4e0d\u6b63\u5e38\uff08\u6d41\u7a0b\u529e\u7406\u671f\u9650\u8fc7\u957f\uff0c\u5efa\u8bae\u4f7f\u7528\u5de5\u4f5c\u65e5\uff09\uff0c\u5c06\u4e25\u91cd\u5f71\u54cd\u670d\u52a1\u5668\u6027\u80fd\uff0c\u8bf7\u5c3d\u5feb\u901a\u77e5\u7cfb\u7edf\u7ba1\u7406\u5458\u4fee\u6539\uff01\uff1d\uff1d\uff1d\uff1d\uff1d");
                            }
                            int range = 3600000;
                            int k = 0;
                            while ((long)k < extent) {
                                time += (long)range;
                                while (!CalendarUtils.getInstance().isWorkDay(time)) {
                                    time += 86400000L;
                                }
                                if (!CalendarUtils.getInstance().isWorkTime(time)) continue;
                                ++k;
                            }
                            break;
                        }
                    }
                }
            }
            d = new Date(time);
            return formattxt.format(d);
        }
        catch (Exception e) {
            WfLog.log(4, "\u6267\u884cconvertDateTimeString\uff08\uff09\u65b9\u6cd5\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
            e.printStackTrace();
            return originalString;
        }
    }

    public static final boolean isTimeOver(String nowtime, String NotificationTime) {
        try {
            SimpleDateFormat formattxt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date d1 = formattxt.parse(nowtime);
            Date d2 = formattxt.parse(NotificationTime);
            return d1.after(d2);
        }
        catch (Exception e) {
            WfLog.log(4, "\u6267\u884cisTimeOver\uff08\uff09\u65b9\u6cd5\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
            e.printStackTrace();
            return false;
        }
    }

    public static final boolean isTimeValid(String nowtime, String BeginTime, String EndTime) {
        try {
            SimpleDateFormat formattxt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date d0 = formattxt.parse(nowtime);
            Date d1 = formattxt.parse(BeginTime);
            Date d2 = formattxt.parse(EndTime);
            return d0.after(d1) && d2.after(d0);
        }
        catch (Exception e) {
            WfLog.log(4, "isTimeValid\uff08\uff09\u65b9\u6cd5\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
            e.printStackTrace();
            return false;
        }
    }

    public static final long countTime(Date ds, Date de) {
        long d1 = ds.getTime();
        long d2 = de.getTime();
        return d2 - d1;
    }

    public static final long countTime(String ds, String de) {
        long d1 = DatetimeUtils.getDate(ds).getTime();
        long d2 = DatetimeUtils.getDate(de).getTime();
        return d2 - d1;
    }

    public static final int countTimeByInt(String ds, String de) {
        long d1 = DatetimeUtils.getDate(ds).getTime();
        long d2 = DatetimeUtils.getDate(de).getTime();
        return Integer.parseInt(String.valueOf((d2 - d1) / 1000L));
    }

    public static final String countTimeToString(long time) {
        String str = "";
        if (time < 60L) {
            return String.valueOf(time) + "\u79d2";
        }
        str = String.valueOf(time % 60L) + "\u79d2";
        long lt = time / 60L;
        str = String.valueOf(lt % 60L) + "\u5206" + str;
        if (lt >= 60L) {
            str = String.valueOf((lt /= 60L) % 60L) + "\u5c0f\u65f6" + str;
            if (lt >= 60L) {
                str = String.valueOf(lt /= 24L) + "\u5929" + str;
            }
        }
        return str;
    }

    public static final List getWeekEnd(String year) {
        SimpleDateFormat formattxt = new SimpleDateFormat("yyyyMMdd");
        int y = Integer.parseInt(year);
        ArrayList<String> al = new ArrayList<String>();
        Calendar c = Calendar.getInstance();
        c.setLenient(false);
        c.set(y, 11, 31);
        int daynum = c.get(6);
        c.clear();
        c.set(y, 0, 1);
        int i = 0;
        while (i < daynum) {
            int dow = c.get(7);
            if (dow == 1 || dow == 7) {
                al.add(formattxt.format(c.getTime()));
            }
            c.add(5, 1);
            ++i;
        }
        return al;
    }

    public static final String getNextWorkDate(String curDate) {
        int dow;
        if (curDate == null || curDate.length() != 8) {
            System.err.println("\u65e0\u6548\u7684\u65e5\u671f\u683c\u5f0fFor:" + curDate);
            return null;
        }
        int y = Integer.parseInt(curDate.substring(0, 4));
        int m = Integer.parseInt(curDate.substring(4, 6));
        int d = Integer.parseInt(curDate.substring(6, 8));
        Calendar c = Calendar.getInstance();
        c.setLenient(true);
        c.set(y, --m, d);
        do {
            c.add(5, 1);
        } while ((dow = c.get(7)) == 1 || dow == 7);
        SimpleDateFormat formattxt = new SimpleDateFormat("yyyyMMdd");
        return formattxt.format(c.getTime());
    }

    public static final String getPreWorkDate(String curDate) {
        int dow;
        if (curDate == null || curDate.length() != 8) {
            System.err.println("\u65e0\u6548\u7684\u65e5\u671f\u683c\u5f0fFor:" + curDate);
            return null;
        }
        int y = Integer.parseInt(curDate.substring(0, 4));
        int m = Integer.parseInt(curDate.substring(4, 6));
        int d = Integer.parseInt(curDate.substring(6, 8));
        Calendar c = Calendar.getInstance();
        c.setLenient(true);
        c.set(y, --m, d);
        do {
            c.add(5, -1);
        } while ((dow = c.get(7)) == 1 || dow == 7);
        SimpleDateFormat formattxt = new SimpleDateFormat("yyyyMMdd");
        return formattxt.format(c.getTime());
    }

    public static final List getDateList(String begindate, String enddate, String castweek) {
        ArrayList<String> al = new ArrayList<String>();
        if (begindate == null || begindate.equals("") || begindate.length() != 8 || enddate == null || enddate.equals("") || enddate.length() != 8) {
            return al;
        }
        SimpleDateFormat formattxt = new SimpleDateFormat("yyyyMMdd");
        Calendar cs = Calendar.getInstance();
        cs.set(Integer.parseInt(begindate.substring(0, 4)), Integer.parseInt(begindate.substring(4, 6)) - 1, Integer.parseInt(begindate.substring(6, 8)));
        Calendar ce = Calendar.getInstance();
        ce.set(Integer.parseInt(enddate.substring(0, 4)), Integer.parseInt(enddate.substring(4, 6)) - 1, Integer.parseInt(enddate.substring(6, 8)));
        if (ce.before(cs)) {
            return al;
        }
        Calendar cc = Calendar.getInstance();
        cc.setTimeInMillis(cs.getTimeInMillis());
        boolean b = true;
        while (b) {
            int dow = cc.get(7) - 1;
            if (castweek.indexOf(String.valueOf(dow)) != -1) {
                al.add(formattxt.format(cc.getTime()));
            }
            if (cc.before(ce)) {
                cc.add(5, 1);
                continue;
            }
            b = false;
        }
        return al;
    }

    public static final List getDateList(String begindate, String enddate) {
        ArrayList<String> wdList = new ArrayList<String>();
        if (begindate == null || begindate.equals("") || begindate.length() != 8 || enddate == null || enddate.equals("") || enddate.length() != 8) {
            return wdList;
        }
        SimpleDateFormat formattxt = new SimpleDateFormat("yyyyMMdd");
        Calendar cs = Calendar.getInstance();
        cs.set(Integer.parseInt(begindate.substring(0, 4)), Integer.parseInt(begindate.substring(4, 6)) - 1, Integer.parseInt(begindate.substring(6, 8)));
        Calendar ce = Calendar.getInstance();
        ce.set(Integer.parseInt(enddate.substring(0, 4)), Integer.parseInt(enddate.substring(4, 6)) - 1, Integer.parseInt(enddate.substring(6, 8)));
        if (ce.before(cs)) {
            return wdList;
        }
        Calendar cc = Calendar.getInstance();
        cc.setTimeInMillis(cs.getTimeInMillis());
        CalendarUtils calUtils = CalendarUtils.getInstance();
        boolean b = true;
        while (b) {
            if (calUtils.isWorkDay(cc.getTimeInMillis())) {
                wdList.add(formattxt.format(cc.getTime()));
            }
            if (cc.before(ce)) {
                cc.add(5, 1);
                continue;
            }
            b = false;
        }
        return wdList;
    }

    public static int countDays(String begindate, String enddate) {
        int i = 1;
        SimpleDateFormat formattxt = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c = Calendar.getInstance();
        c.set(Integer.parseInt(begindate.substring(0, 4)), Integer.parseInt(begindate.substring(5, 7)) - 1, Integer.parseInt(begindate.substring(8, 10)));
        Calendar ce = Calendar.getInstance();
        ce.set(Integer.parseInt(enddate.substring(0, 4)), Integer.parseInt(enddate.substring(5, 7)) - 1, Integer.parseInt(enddate.substring(8, 10)));
        while (c.before(ce)) {
            ++i;
            c.add(5, 1);
        }
        return i;
    }

    public static void main(String[] args) throws Exception {
        List al = DatetimeUtils.getDateList("20100401", "20100530", "1,2,3,4,5");
        int i = 0;
        while (i < al.size()) {
            System.out.print(al.get(i) + ",");
            ++i;
        }
        WfLog.log(2, DatetimeUtils.getNowTimeString());
    }
}

