/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.echain.util;

import com.ecc.echain.log.WfLog;
import com.ecc.echain.util.WfPropertyManager;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class CalendarUtils {
    private static CalendarUtils _instance;
    protected String WorkingDay;
    protected String WorkTimeStart;
    protected String WorkTimeEnd;
    protected int wts;
    protected int wte;
    protected Map fdHM = new HashMap();

    public static final synchronized CalendarUtils getInstance() {
        if (_instance == null) {
            String classname = WfPropertyManager.getInstance().calendarclass;
            WfLog.log(2, "\u5b9e\u4f8b\u5316CalendarUtils\u5b9e\u73b0\u7c7b\uff1a" + classname);
            try {
                _instance = (CalendarUtils)Class.forName(classname).newInstance();
                _instance.loadDate();
            }
            catch (Exception e) {
                WfLog.log(4, "\u65e0\u6cd5\u521b\u5efaCalendarUtils\u5b9e\u73b0\u7c7b\uff1a" + classname + ",\u8be5\u7c7b\u5fc5\u987b\u7ee7\u627f\u81eacom.ecc.echain.util.CalendarUtils\uff0c\u8bf7\u68c0\u67e5\u60a8\u7684\u8bbe\u7f6e\u662f\u5426\u6b63\u786e\uff01");
            }
        }
        return _instance;
    }

    public boolean isWorkDay(long nowtime) {
        Date d = new Date(nowtime);
        String s = String.valueOf(d.getDay());
        return this.WorkingDay.lastIndexOf(s) != -1;
    }

    public boolean isWorkTime(long nowtime) {
        Date d = new Date(nowtime);
        int dd = d.getHours() * 60 + d.getMinutes();
        return dd >= this.wts && dd <= this.wte;
    }

    protected void loadDate() {
        this.WorkingDay = WfPropertyManager.getInstance().WorkingDay;
        this.WorkTimeStart = WfPropertyManager.getInstance().WorkTimeStart;
        this.WorkTimeEnd = WfPropertyManager.getInstance().WorkTimeEnd;
        int wts_h = Integer.parseInt(this.WorkTimeStart.substring(0, this.WorkTimeStart.length() - 3));
        int wts_m = Integer.parseInt(this.WorkTimeStart.substring(this.WorkTimeStart.length() - 2, this.WorkTimeStart.length()));
        this.wts = wts_h * 60 + wts_m;
        int wte_h = Integer.parseInt(this.WorkTimeEnd.substring(0, this.WorkTimeEnd.length() - 3));
        int wte_m = Integer.parseInt(this.WorkTimeEnd.substring(this.WorkTimeEnd.length() - 2, this.WorkTimeEnd.length()));
        this.wte = wte_h * 60 + wte_m;
    }
}

