/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.echain.org;

import com.ecc.echain.log.WfLog;
import com.ecc.echain.org.OrgFactory;
import com.ecc.echain.org.OrgIF;
import com.ecc.echain.org.model.DepModel;
import com.ecc.echain.org.model.GroupModel;
import com.ecc.echain.org.model.OrgModel;
import com.ecc.echain.org.model.RoleModel;
import com.ecc.echain.org.model.UserModel;
import com.ecc.echain.workflow.cache.OUCache;
import com.ecc.echain.workflow.model.WFClient;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class OrgIPM
implements OrgIF {
    @Override
    public OrgModel getRootOrg(Connection con) {
        return OUCache.getInstance().rootOrgModel;
    }

    @Override
    public List getAllBaseOrgs(Connection con) {
        return OUCache.getInstance().rootOrgModel.getOrgList();
    }

    @Override
    public List getDirectSubOrgs(String orgid, Connection con) {
        OrgModel om = (OrgModel)OUCache.getInstance().hmOMCache.get(orgid);
        if (om == null) {
            return new ArrayList();
        }
        return om.getOrgList();
    }

    @Override
    public List getAllSubOrgs(String orgid, Connection con) {
        OrgModel om = (OrgModel)OUCache.getInstance().hmOMCache.get(orgid);
        if (om == null) {
            return new ArrayList();
        }
        return om.getAllorgList();
    }

    @Override
    public OrgModel getParentOrg(String orgid, Connection con) {
        OrgModel om = (OrgModel)OUCache.getInstance().hmOMCache.get(orgid);
        if (om == null) {
            return null;
        }
        return (OrgModel)OUCache.getInstance().hmOMCache.get(om.getSuporgid());
    }

    @Override
    public OrgModel getOrgModel(String orgid, Connection con) {
        return (OrgModel)OUCache.getInstance().hmOMCache.get(orgid);
    }

    @Override
    public List getAllOrgs(Connection con) {
        ArrayList list = new ArrayList();
        list.addAll(OUCache.getInstance().hmOMCache.values());
        return list;
    }

    @Override
    public List getDirectDepsByOrg(String orgid, Connection con) {
        OrgModel om = (OrgModel)OUCache.getInstance().hmOMCache.get(orgid);
        if (om == null) {
            return new ArrayList();
        }
        return om.getDepList();
    }

    @Override
    public List getAllDepsByOrg(String orgid, Connection con) {
        OrgModel om = (OrgModel)OUCache.getInstance().hmOMCache.get(orgid);
        if (om == null) {
            return new ArrayList();
        }
        return om.getAlldepList();
    }

    @Override
    public List getDirectSubDepsByDep(String orgid, String depid, Connection con) {
        OrgModel om = (OrgModel)OUCache.getInstance().hmOMCache.get(orgid);
        if (om == null) {
            return new ArrayList();
        }
        return om.getDepModel(depid).getDepList();
    }

    @Override
    public List getAllSubDepsByDep(String orgid, String depid, Connection con) {
        OrgModel om = (OrgModel)OUCache.getInstance().hmOMCache.get(orgid);
        if (om == null) {
            return new ArrayList();
        }
        return om.getDepModel(depid).getAlldepList();
    }

    @Override
    public DepModel getParentDep(String orgid, String depid, Connection con) {
        OrgModel om = (OrgModel)OUCache.getInstance().hmOMCache.get(orgid);
        if (om == null) {
            return null;
        }
        return om.getDepModel(om.getDepModel(depid).getSupdepid());
    }

    @Override
    public DepModel getDepModel(String orgid, String depid, Connection con) {
        OrgModel om = (OrgModel)OUCache.getInstance().hmOMCache.get(orgid);
        if (om == null) {
            return null;
        }
        return om.getDepModel(depid);
    }

    @Override
    public List getDirectUsersByOrg(String orgid, Connection con) {
        OrgModel om = (OrgModel)OUCache.getInstance().hmOMCache.get(orgid);
        if (om == null) {
            return new ArrayList();
        }
        return om.getUserList();
    }

    @Override
    public List getAllUsersByOrg(String orgid, Connection con) {
        OrgModel om = (OrgModel)OUCache.getInstance().hmOMCache.get(orgid);
        if (om == null) {
            return new ArrayList();
        }
        return om.getAlluserList();
    }

    @Override
    public List getDirectUsersByDep(String orgid, String depid, Connection con) {
        OrgModel om = (OrgModel)OUCache.getInstance().hmOMCache.get(orgid);
        if (om == null) {
            return new ArrayList();
        }
        return om.getDepModel(depid).getUserList();
    }

    @Override
    public List getAllUsersByDep(String orgid, String depid, Connection con) {
        OrgModel om = (OrgModel)OUCache.getInstance().hmOMCache.get(orgid);
        if (om == null) {
            return new ArrayList();
        }
        return om.getDepModel(depid).getAlluserList();
    }

    @Override
    public UserModel getUserModel(String orgid, String userid, Connection con) {
        OrgModel om = (OrgModel)OUCache.getInstance().hmOMCache.get(orgid);
        if (om == null) {
            return this.getUserModel(userid, con);
        }
        UserModel um = om.getUserModel(userid);
        if (um == null) {
            return this.getUserModel(userid, con);
        }
        return um;
    }

    @Override
    public UserModel getUserModel(String userid, Connection con) {
        return (UserModel)OUCache.getInstance().hmUMCache.get(userid);
    }

    @Override
    public String getOrgIdByUser(String userid, Connection con) {
        String orgid = null;
        try {
            orgid = this.getUserModel(userid, con).getOrgid();
        }
        catch (Exception e) {
            orgid = null;
        }
        return orgid;
    }

    @Override
    public UserModel isValidUser(String orgid, String userid, String password, Connection con) {
        if (userid == null || userid.equals("")) {
            return null;
        }
        OrgIF org = OrgFactory.getInstance().getOrgClass();
        UserModel um = org.getUserModel(userid, con);
        if (um.getPassword() != null && um.getPassword().equals(password)) {
            return um;
        }
        return null;
    }

    @Override
    public List getOrgLeaders(String orgid, Connection con) {
        return null;
    }

    @Override
    public List getOrgDirectors(String orgid, Connection con) {
        return null;
    }

    @Override
    public List getDepLeaders(String orgid, String depid, Connection con) {
        return null;
    }

    @Override
    public List getDepDirectors(String orgid, String depid, Connection con) {
        return null;
    }

    @Override
    public List getAllBaseRoles(Connection con) {
        ArrayList list = new ArrayList();
        list.addAll(OUCache.getInstance().hmRMCache.values());
        return list;
    }

    @Override
    public List getAllRoles(Connection con) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(OUCache.getInstance().hmRMCache.values());
        for (String orgid : OUCache.getInstance().hmOMCache.keySet()) {
            OrgModel om = (OrgModel)OUCache.getInstance().hmOMCache.get(orgid);
            list.addAll(om.getRoleList());
        }
        return list;
    }

    @Override
    public List getAllRoles(String orgid, Connection con) {
        OrgModel om = (OrgModel)OUCache.getInstance().hmOMCache.get(orgid);
        if (om == null) {
            return new ArrayList();
        }
        return om.getRoleList();
    }

    @Override
    public List getAllRoles(String orgid, String depid, Connection con) {
        OrgModel om = (OrgModel)OUCache.getInstance().hmOMCache.get(orgid);
        if (om == null) {
            return new ArrayList();
        }
        return om.getDepModel(depid).getRoleList();
    }

    @Override
    public RoleModel getRoleModel(String orgid, String roleid, Connection con) {
        if (orgid == null || orgid.equals("")) {
            return (RoleModel)OUCache.getInstance().hmRMCache.get(roleid);
        }
        RoleModel rm = ((OrgModel)OUCache.getInstance().hmOMCache.get(orgid)).getRoleModel(roleid);
        if (rm != null) {
            return rm;
        }
        return (RoleModel)OUCache.getInstance().hmRMCache.get(roleid);
    }

    @Override
    public List getUsersByRole(String orgid, String roleid, Connection con) {
        RoleModel rm;
        if (orgid == null || orgid.equals("")) {
            rm = (RoleModel)OUCache.getInstance().hmRMCache.get(roleid);
        } else {
            rm = ((OrgModel)OUCache.getInstance().hmOMCache.get(orgid)).getRoleModel(roleid);
            if (rm == null) {
                rm = (RoleModel)OUCache.getInstance().hmRMCache.get(roleid);
            }
        }
        if (rm == null) {
            return null;
        }
        return rm.getUserList();
    }

    @Override
    public List getRolesByUser(String orgid, String userid, Connection con) {
        OrgModel om = (OrgModel)OUCache.getInstance().hmOMCache.get(orgid);
        if (om == null) {
            return new ArrayList();
        }
        return om.getUserModel(userid).getRoleList();
    }

    @Override
    public List getAllBaseGroups(Connection con) {
        ArrayList list = new ArrayList();
        list.addAll(OUCache.getInstance().hmGMCache.values());
        return list;
    }

    @Override
    public List getAllGroups(Connection con) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(OUCache.getInstance().hmGMCache.values());
        for (String orgid : OUCache.getInstance().hmOMCache.keySet()) {
            OrgModel om = (OrgModel)OUCache.getInstance().hmOMCache.get(orgid);
            list.addAll(om.getGroupList());
        }
        return list;
    }

    @Override
    public List getAllGroups(String orgid, Connection con) {
        OrgModel om = (OrgModel)OUCache.getInstance().hmOMCache.get(orgid);
        if (om == null) {
            return new ArrayList();
        }
        return om.getGroupList();
    }

    @Override
    public List getAllGroups(String orgid, String depid, Connection con) {
        OrgModel om = (OrgModel)OUCache.getInstance().hmOMCache.get(orgid);
        if (om == null) {
            return new ArrayList();
        }
        return om.getDepModel(depid).getGroupList();
    }

    @Override
    public GroupModel getGroupModel(String orgid, String groupid, Connection con) {
        if (orgid == null || orgid.equals("")) {
            return (GroupModel)OUCache.getInstance().hmGMCache.get(groupid);
        }
        GroupModel gm = ((OrgModel)OUCache.getInstance().hmOMCache.get(orgid)).getGroupModel(groupid);
        if (gm != null) {
            return gm;
        }
        return (GroupModel)OUCache.getInstance().hmRMCache.get(groupid);
    }

    @Override
    public List getUsersByGroup(String orgid, String groupid, Connection con) {
        GroupModel gm;
        if (orgid == null || orgid.equals("")) {
            gm = (GroupModel)OUCache.getInstance().hmGMCache.get(groupid);
        } else {
            gm = ((OrgModel)OUCache.getInstance().hmOMCache.get(orgid)).getGroupModel(groupid);
            if (gm == null) {
                gm = (GroupModel)OUCache.getInstance().hmGMCache.get(groupid);
            }
        }
        if (gm == null) {
            return null;
        }
        return gm.getUserList();
    }

    @Override
    public List getGroupByUser(String orgid, String userid, Connection con) {
        OrgModel om = (OrgModel)OUCache.getInstance().hmOMCache.get(orgid);
        if (om == null) {
            return new ArrayList();
        }
        return om.getUserModel(userid).getGroupList();
    }

    @Override
    public String getGrantor(String orgid, String userid, String appid, Connection con) {
        return null;
    }

    @Override
    public List getSuperiorUsers(String orgid, String userid, Connection con) {
        DepModel dm;
        OrgModel om = (OrgModel)OUCache.getInstance().hmOMCache.get(orgid);
        if (om == null) {
            return new ArrayList();
        }
        UserModel um = om.getUserModel(userid);
        if (um != null && um.getDepid() != null && um.getDepid().length() > 0 && (dm = this.getParentDep(orgid, um.getDepid(), con)) != null) {
            return dm.getUserList();
        }
        return new ArrayList();
    }

    @Override
    public List getJuniorUsers(String orgid, String userid, Connection con) {
        OrgModel om = (OrgModel)OUCache.getInstance().hmOMCache.get(orgid);
        if (om == null) {
            return new ArrayList();
        }
        ArrayList<UserModel> al = new ArrayList<UserModel>();
        UserModel um = om.getUserModel(userid);
        if (um != null && um.getDepid() != null && um.getDepid().length() > 0) {
            List list = this.getDirectSubDepsByDep(orgid, um.getDepid(), con);
            int i = 0;
            while (i < list.size()) {
                DepModel dm = (DepModel)list.get(i);
                al.addAll(dm.getUserList());
                ++i;
            }
        }
        return al;
    }

    @Override
    public List getSameDepUsers(String orgid, String userid, Connection con) {
        OrgModel om = (OrgModel)OUCache.getInstance().hmOMCache.get(orgid);
        if (om == null) {
            return new ArrayList();
        }
        UserModel um = om.getUserModel(userid);
        if (um != null && um.getDepid() != null && um.getDepid().length() > 0) {
            return this.getDepModel(orgid, um.getDepid(), con).getUserList();
        }
        return null;
    }

    @Override
    public List getSameOrgUsers(String orgid, String userid, Connection con) {
        OrgModel om = (OrgModel)OUCache.getInstance().hmOMCache.get(orgid);
        if (om == null) {
            return new ArrayList();
        }
        return om.getAlluserList();
    }

    @Override
    public String getUserEmail(String orgid, String userid, Connection con) {
        if (userid == null || userid.equals("")) {
            return null;
        }
        if (userid.indexOf(";") == -1) {
            return this.getUserModel(orgid, userid, con).getEmail();
        }
        OrgModel om = (OrgModel)OUCache.getInstance().hmOMCache.get(orgid);
        String strResult = "";
        StringTokenizer st = new StringTokenizer(userid, ";");
        while (st.hasMoreElements()) {
            String key = (String)st.nextElement();
            UserModel um = om.getUserModel(key);
            strResult = String.valueOf(strResult) + ";" + um.getEmail();
        }
        if (strResult.length() > 1) {
            strResult = strResult.substring(1);
        }
        return strResult;
    }

    @Override
    public void loadOUCache(OUCache oucache, Connection con) {
        oucache.hmOMCache.clear();
        oucache.hmRMCache.clear();
        oucache.hmGMCache.clear();
        oucache.hmUMCache.clear();
        try {
            InputStream is = null;
            try {
                is = new FileInputStream("eChainOU.xml");
            }
            catch (Exception e) {
                is = this.getClass().getResourceAsStream("/eChainOU.xml");
            }
            if (is != null) {
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build(is);
                List orgList = doc.getRootElement().getChildren("org");
                int k = 0;
                while (k < orgList.size()) {
                    int j;
                    UserModel usermodel;
                    String userid;
                    Element user;
                    Element org = (Element)orgList.get(k);
                    String orgid = org.getAttributeValue("id");
                    OrgModel orgmodel = new OrgModel();
                    orgmodel.setOrgid(orgid);
                    orgmodel.setOrgname(org.getAttributeValue("name"));
                    orgmodel.setOrgstatus(0);
                    oucache.hmOMCache.put(orgid, orgmodel);
                    if (org.getAttributeValue("suporgid") == null || org.getAttributeValue("suporgid").equals("")) {
                        orgmodel.setSuporgid(null);
                        orgmodel.setOrglevel(0);
                        oucache.rootOrgModel = orgmodel;
                    } else {
                        orgmodel.setSuporgid(org.getAttributeValue("suporgid"));
                        if (oucache.hmOMCache.containsKey(org.getAttributeValue("suporgid"))) {
                            ((OrgModel)oucache.hmOMCache.get(org.getAttributeValue("suporgid"))).getOrgList().add(orgmodel);
                            OrgModel omtmp = orgmodel;
                            while (omtmp.getSuporgid() != null) {
                                if (!oucache.hmOMCache.containsKey(omtmp.getSuporgid())) break;
                                omtmp = (OrgModel)oucache.hmOMCache.get(omtmp.getSuporgid());
                                omtmp.getAllorgList().add(orgmodel);
                            }
                        }
                    }
                    List userList = org.getChildren("user");
                    int j2 = 0;
                    while (j2 < userList.size()) {
                        user = (Element)userList.get(j2);
                        userid = user.getAttributeValue("id");
                        usermodel = new UserModel();
                        usermodel.setUserid(userid);
                        usermodel.setUsername(user.getAttributeValue("name"));
                        usermodel.setDepid(null);
                        usermodel.setOrgid(orgid);
                        usermodel.setPassword(user.getAttributeValue("password"));
                        usermodel.setEmail(user.getAttributeValue("email"));
                        usermodel.setMobile(user.getAttributeValue("mobile"));
                        orgmodel.getUserList().add(usermodel);
                        orgmodel.getAlluserList().add(usermodel);
                        oucache.hmUMCache.put(userid, usermodel);
                        ++j2;
                    }
                    List depList = org.getChildren("dep");
                    int i = 0;
                    while (i < depList.size()) {
                        Element dep = (Element)depList.get(i);
                        String depid = dep.getAttributeValue("id");
                        DepModel depmodel = new DepModel();
                        depmodel.setDepid(depid);
                        depmodel.setDepname(dep.getAttributeValue("name"));
                        depmodel.setOrgid(orgid);
                        depmodel.setDepstatus(0);
                        if (dep.getAttributeValue("supdepid") == null || dep.getAttributeValue("supdepid").equals("")) {
                            depmodel.setSupdepid(null);
                            orgmodel.getDepList().add(depmodel);
                            orgmodel.getAlldepList().add(depmodel);
                        } else {
                            depmodel.setSupdepid(dep.getAttributeValue("supdepid"));
                            orgmodel.getAlldepList().add(depmodel);
                            DepModel supdm = orgmodel.getDepModel(dep.getAttributeValue("supdepid"));
                            if (supdm != null) {
                                supdm.getDepList().add(depmodel);
                                supdm.getAlldepList().add(depmodel);
                                while (supdm.getSupdepid() != null) {
                                    if ((supdm = orgmodel.getDepModel(supdm.getSupdepid())) == null) break;
                                    supdm.getAlldepList().add(depmodel);
                                }
                            }
                        }
                        userList = dep.getChildren("user");
                        j = 0;
                        while (j < userList.size()) {
                            user = (Element)userList.get(j);
                            userid = user.getAttributeValue("id");
                            usermodel = new UserModel();
                            usermodel.setUserid(userid);
                            usermodel.setUsername(user.getAttributeValue("name"));
                            usermodel.setDepid(depid);
                            usermodel.setOrgid(orgid);
                            usermodel.setPassword(user.getAttributeValue("password"));
                            usermodel.setEmail(user.getAttributeValue("email"));
                            usermodel.setMobile(user.getAttributeValue("mobile"));
                            orgmodel.getAlluserList().add(usermodel);
                            depmodel.getUserList().add(usermodel);
                            depmodel.getAlluserList().add(usermodel);
                            oucache.hmUMCache.put(userid, usermodel);
                            ++j;
                        }
                        ++i;
                    }
                    List roleList = org.getChildren("role");
                    i = 0;
                    while (i < roleList.size()) {
                        Element role = (Element)roleList.get(i);
                        String roleid = role.getAttributeValue("id");
                        RoleModel rolemodel = new RoleModel();
                        rolemodel.setRoleid(roleid);
                        rolemodel.setRolename(role.getAttributeValue("name"));
                        rolemodel.setRoletype(role.getAttributeValue("type"));
                        rolemodel.setOrgid(orgid);
                        rolemodel.setDepid(null);
                        rolemodel.isBaseFlag = false;
                        orgmodel.getRoleList().add(rolemodel);
                        userList = role.getChildren("user");
                        j = 0;
                        while (j < userList.size()) {
                            user = (Element)userList.get(j);
                            userid = user.getAttributeValue("id");
                            usermodel = orgmodel.getUserModel(userid);
                            if (usermodel != null) {
                                rolemodel.getUserList().add(usermodel);
                                usermodel.getRoleList().add(rolemodel);
                            }
                            ++j;
                        }
                        ++i;
                    }
                    List groupList = org.getChildren("group");
                    i = 0;
                    while (i < groupList.size()) {
                        Element group = (Element)groupList.get(i);
                        String groupid = group.getAttributeValue("id");
                        GroupModel groupmodel = new GroupModel();
                        groupmodel.setGroupid(groupid);
                        groupmodel.setGroupname(group.getAttributeValue("name"));
                        groupmodel.setGrouptype(group.getAttributeValue("type"));
                        groupmodel.setOrgid(orgid);
                        groupmodel.setDepid(null);
                        groupmodel.isBaseFlag = false;
                        orgmodel.getGroupList().add(groupmodel);
                        userList = group.getChildren("user");
                        j = 0;
                        while (j < userList.size()) {
                            user = (Element)userList.get(j);
                            userid = user.getAttributeValue("id");
                            usermodel = orgmodel.getUserModel(userid);
                            if (usermodel != null) {
                                groupmodel.getUserList().add(usermodel);
                                usermodel.getGroupList().add(groupmodel);
                            }
                            ++j;
                        }
                        ++i;
                    }
                    ++k;
                }
            }
        }
        catch (Exception e) {
            WfLog.log(4, "\u3010Exception\u3011\u52a0\u8f7d\u7528\u6237\u7f13\u5b58\u4fe1\u606f\u5f02\u5e38\uff0c\u51fa\u9519\u4fe1\u606f\u5982\u4e0b\uff1a");
            e.printStackTrace();
        }
    }

    @Override
    public List getAllWFClient(String status, Connection con) {
        WFClient client = new WFClient();
        client.setClientName("\u6d41\u7a0b\u7f3a\u7701\u5ba2\u6237\u7aef");
        client.setClientSign("echain");
        ArrayList<WFClient> list = new ArrayList<WFClient>();
        list.add(client);
        return list;
    }

    @Override
    public List<UserModel> queryUserModelsByName(String name, Connection con) {
        ArrayList<UserModel> list = new ArrayList<UserModel>();
        try {
            if (name == null) {
                return list;
            }
            Map map = OUCache.getInstance().hmUMCache;
            for (String userid : map.keySet()) {
                UserModel um = (UserModel)map.get(userid);
                if (um.getUsername() == null || !um.getUsername().startsWith(name)) continue;
                list.add(um);
            }
            return list;
        }
        catch (Exception e) {
            WfLog.log(4, "\u3010Exception\u3011 \u6839\u636e\u7528\u6237\u540d\u79f0\u6a21\u7cca\u5339\u914d\u5f02\u5e38\uff0c\u51fa\u9519\u4fe1\u606f\u5982\u4e0b\uff1a");
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List getUpUpOrgUsers(String orgid, Connection con) {
        return new ArrayList();
    }

    @Override
    public List getUpUpOrgDownOrgUsers(String orgid, Connection con) {
        return new ArrayList();
    }

    @Override
    public List getUpDownOrgUsers(String orgid, Connection con) {
        return new ArrayList();
    }

    @Override
    public List getRolesByName(String orgid, String roleName, Connection con) {
        return new ArrayList();
    }

    @Override
    public List getSameOrgLine(String orgid, Connection con) {
        return new ArrayList();
    }

    @Override
    public List getSameOrgLineUsers(String orgid, Connection con) {
        return new ArrayList();
    }

    @Override
    public String getDeptOrgid(String orgid, Connection con) {
        return null;
    }

    @Override
    public List getSubDeptByOrgid(String orgid, Connection con) {
        return new ArrayList();
    }

    @Override
    public List getUpAndUpUpOrgUsers(String orgid, Connection con) {
        return new ArrayList();
    }

    @Override
    public List getSampeAndUpOrgUsers(String orgid, Connection con) {
        return new ArrayList();
    }

    @Override
    public List getSampeOrgOrDeptUsers(String orgid, Connection con) {
        return new ArrayList();
    }
}

