/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.echain.log;

import com.ecc.echain.log.Log;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class WfLog {
    public static final int DEBUG = 0;
    public static final int TRACE = 1;
    public static final int INFO = 2;
    public static final int WARNING = 3;
    public static final int ERROR = 4;
    public static final int FATAL = 5;
    public static String[] typeInfo = new String[]{"DEBUG", "TRACE", "INFO", "WARNING", "ERROR", "FATAL"};
    private static Log logInstance = null;

    public static void log(int type, String message) {
        WfLog.log("eChain", type, message, null);
    }

    public static void log(int type, String message, Throwable te) {
        WfLog.log("eChain", type, message, te);
    }

    public static void log(String component, int type, String message) {
        WfLog.log(component, type, message, null);
    }

    public static void log(String component, int type, String message, Throwable te) {
        if (logInstance == null) {
            StringBuffer buf = new StringBuffer();
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss ");
            buf.append(fmt.format(Calendar.getInstance().getTime()));
            buf.append(System.currentTimeMillis() % 1000L);
            buf.append(" ");
            buf.append(component);
            buf.append(" ");
            buf.append(typeInfo[type]);
            buf.append(" ");
            buf.append(message);
            if (te != null) {
                StringWriter sw = new StringWriter();
                te.printStackTrace(new PrintWriter(sw));
                buf.append(sw.getBuffer());
            }
            System.out.println(buf.toString());
        } else {
            logInstance.log(component, type, message, te);
        }
    }

    public static void init(String logImplClass, String logSettingFile) {
        try {
            logInstance = (Log)Class.forName(logImplClass).newInstance();
            logInstance.init(logSettingFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void paramException(Object obj, String method, Object vo) {
        String classname = "";
        classname = obj == null ? "com.ecc.echain.workflow.engine.*" : (obj instanceof String ? obj.toString() : obj.getClass().getName());
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n");
        buffer.append("\u8c03\u7528\u5f02\u5e38\uff0c\u539f\u56e0\uff1a\u4f20\u5165\u7684\u53c2\u6570\u975e\u6cd5,\u8be6\u7ec6\u4fe1\u606f\u5982\u4e0b\uff1a\n");
        buffer.append("======================================================================\n");
        buffer.append("\u7c7b\uff1a" + classname + "\uff1b\u65b9\u6cd5\uff1a" + method + "()\n");
        buffer.append("\u83b7\u5f97\u7684\u53c2\u6570\uff1a" + vo.toString() + "\n");
        buffer.append("======================================================================\n");
        WfLog.log(4, buffer.toString());
    }

    public static void runtimeException(Object obj, String method, Exception e) {
        String classname = "";
        classname = obj == null ? "com.ecc.echain.workflow.engine.*" : (obj instanceof String ? obj.toString() : obj.getClass().getName());
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n");
        buffer.append("\u8fd0\u884c\u65f6\u5f02\u5e38,\u8be6\u7ec6\u4fe1\u606f\u5982\u4e0b\uff1a\n");
        buffer.append("======================================================================\n");
        buffer.append("\u7c7b\uff1a" + classname + "\uff1b\u65b9\u6cd5\uff1a" + method + "()\n");
        buffer.append("\u5f02\u5e38\u5806\u6808\u4fe1\u606f\u5982\u4e0b\uff1a\n");
        StackTraceElement[] trace = e.getStackTrace();
        StringWriter sw = new StringWriter(1024);
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.close();
        buffer.append(sw.toString());
        buffer.append("======================================================================\n");
        WfLog.log(4, buffer.toString());
    }
}

