/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.echain.jci;

import com.ecc.echain.jci.JCIFactory;
import com.ecc.echain.log.WfLog;
import com.ecc.echain.util.WfPropertyManager;
import com.ecc.echain.workflow.engine.EVO;
import java.lang.reflect.Method;
import java.util.Hashtable;
import org.apache.commons.jci.readers.MemoryResourceReader;
import org.apache.commons.jci.readers.ResourceReader;
import org.apache.commons.jci.stores.MemoryResourceStore;
import org.apache.commons.jci.stores.ResourceStore;
import org.apache.commons.jci.stores.ResourceStoreClassLoader;

public class JCIEval {
    private static JCIEval instance;
    private Hashtable hmCodeToClass = null;
    private int seqnum;

    private JCIEval() {
    }

    public static synchronized JCIEval getInstance() {
        if (instance == null) {
            instance = new JCIEval();
            JCIEval.instance.hmCodeToClass = new Hashtable();
            JCIEval.instance.seqnum = 0;
            JCIFactory.getInstance().setJciClassname(WfPropertyManager.getInstance().jciclass);
        }
        return instance;
    }

    private synchronized int getNextSeqNum() {
        return this.seqnum++;
    }

    public Object invoke(String source, EVO evo) throws Exception {
        if (source == null || source.equals("")) {
            return null;
        }
        Class javaclass = (Class)this.hmCodeToClass.get(source);
        if (javaclass == null) {
            try {
                String classname = "EChainJava" + this.getNextSeqNum();
                StringBuffer javaStrBuffer = new StringBuffer();
                javaStrBuffer.append("package com.ecc.echain.jci;");
                javaStrBuffer.append("import java.lang.*;");
                javaStrBuffer.append("import java.util.*;");
                javaStrBuffer.append("import java.sql.Connection;");
                javaStrBuffer.append("import com.ecc.echain.db.DbControl;");
                javaStrBuffer.append("import com.ecc.echain.component.*;");
                javaStrBuffer.append("import com.ecc.echain.util.*;");
                javaStrBuffer.append("import com.ecc.echain.workflow.engine.*;");
                javaStrBuffer.append("import com.ecc.echain.log.*;");
                javaStrBuffer.append("import com.ecc.echain.ext.WFVar;");
                javaStrBuffer.append("public class " + classname + " {");
                javaStrBuffer.append(source);
                javaStrBuffer.append("}");
                MemoryResourceReader src = new MemoryResourceReader();
                MemoryResourceStore dst = new MemoryResourceStore();
                ClassLoader parentClassLoader = Thread.currentThread().getContextClassLoader();
                if (parentClassLoader == null) {
                    parentClassLoader = this.getClass().getClassLoader();
                }
                ResourceStoreClassLoader classLoader = new ResourceStoreClassLoader(parentClassLoader, new ResourceStore[]{dst});
                classname = "com.ecc.echain.jci." + classname;
                JCIFactory.getInstance().getJciClass().compile(classname, javaStrBuffer, (ResourceReader)src, (ResourceStore)dst, (ClassLoader)classLoader, null);
                javaclass = classLoader.loadClass(classname);
                this.hmCodeToClass.put(source, javaclass);
            }
            catch (Exception e) {
                WfLog.log(4, "\u52a8\u6001\u7f16\u8bd1\u811a\u672c\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                e.printStackTrace();
                throw e;
            }
        }
        Class[] argtypes = new Class[]{evo.getClass()};
        Method m = javaclass.getMethod("invoke", argtypes);
        Object[] arglist = new Object[]{evo};
        Object retval = m.invoke(javaclass.newInstance(), arglist);
        return retval;
    }
}

