/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.echain.ext.mq.apache;

import com.ecc.echain.log.WfLog;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import org.apache.activemq.ActiveMQConnectionFactory;

public class MQQueueSender {
    private String queueName;
    private QueueConnectionFactory queueConnFactory;
    private QueueConnection queueConn;
    private QueueSession queueSession;
    private Queue queue;
    private MessageProducer producer;
    private String topicName;
    private TopicConnectionFactory topicConnFactory;
    private TopicConnection topicConn;
    private TopicSession topicSession;
    private TopicPublisher pub;
    private String clientID;
    private boolean queueSessionFlag = false;
    private boolean topicSessionFlag = false;

    public MQQueueSender(QueueConnectionFactory queueConnFactory, String queueName) {
        this.queueConnFactory = queueConnFactory;
        this.queueName = queueName;
    }

    public MQQueueSender(TopicConnectionFactory topicConnFactory, String topicName, String clientID) {
        this.topicConnFactory = topicConnFactory;
        this.topicName = topicName;
        this.clientID = clientID;
    }

    public void createTopicConnection(boolean sessionFlag) throws Exception {
        long startTime = System.currentTimeMillis();
        this.topicSessionFlag = sessionFlag;
        if (this.topicName == null) {
            throw new Exception("\u4e3b\u9898\u540dtopicName\u6ca1\u6709\u5b9a\u4e49");
        }
        try {
            this.topicConn = this.topicConnFactory.createTopicConnection();
            if (this.clientID != null && this.clientID.trim().equals("")) {
                this.topicConn.setClientID(this.clientID);
            }
            this.topicConn.start();
            this.topicSession = this.topicConn.createTopicSession(sessionFlag, 1);
            this.pub = this.topicSession.createPublisher(this.topicSession.createTopic(this.topicName));
        }
        catch (Exception e) {
            WfLog.log("eChain-MQ", 4, "\u521b\u5efaPub/Sub\u6a21\u5f0f\u7684MQ\u8fde\u63a5\u51fa\u9519:" + e.getMessage());
            WfLog.runtimeException(this, "createTopicConnection", e);
            throw e;
        }
        WfLog.log("eChain-MQ", 0, "\u521b\u5efaPub/Sub\u6a21\u5f0f\u7684MQ\u8fde\u63a5\u6210\u529f\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime));
    }

    public void createPTPConnection(boolean sessionFlag) throws Exception {
        long startTime = System.currentTimeMillis();
        this.queueSessionFlag = sessionFlag;
        if (this.queueName == null) {
            throw new Exception("\u961f\u5217\u540d\u6ca1\u6709\u5b9a\u4e49");
        }
        this.queueConn = this.queueConnFactory.createQueueConnection();
        this.queueConn.start();
        this.queueSession = this.queueConn.createQueueSession(sessionFlag, 1);
        this.queue = this.queueSession.createQueue(this.queueName);
        try {
            this.producer = this.queueSession.createProducer((Destination)this.queue);
        }
        catch (Exception e) {
            WfLog.log("eChain-MQ", 4, "\u521b\u5efaPTP\u6a21\u5f0f\u7684MQ\u8fde\u63a5\u51fa\u9519\uff1a" + e.getMessage());
            WfLog.runtimeException(this, "createPTPConnection", e);
            throw e;
        }
        WfLog.log("eChain-MQ", 0, "\u521b\u5efaPTP\u6a21\u5f0f\u7684MQ\u8fde\u63a5\u6210\u529f\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime));
    }

    public boolean sendMapByPTP(Map sendMap) {
        long startTime = System.currentTimeMillis();
        try {
            MapMessage msg = this.queueSession.createMapMessage();
            for (String key : sendMap.keySet()) {
                Object value = sendMap.get(key);
                msg.setObject(key, value);
            }
            this.producer.send((Message)msg);
        }
        catch (Exception e) {
            WfLog.log("eChain-MQ", 4, "\u53d1\u9001PTP\u6a21\u5f0f\u7684MQ\u6d88\u606f\u51fa\u9519:" + e.getMessage());
            WfLog.runtimeException(this, "sendMapByPTP", e);
            return false;
        }
        WfLog.log("eChain-MQ", 0, "\u53d1\u9001PTP\u6a21\u5f0f\u7684MQ\u6d88\u606f\u6210\u529f\u961f\u5217\u540d:" + this.queueName + ",\u8017\u65f6:" + (System.currentTimeMillis() - startTime));
        return true;
    }

    public boolean sendMapbyTopic(Map sendMap) {
        long startTime = System.currentTimeMillis();
        try {
            MapMessage msg = this.topicSession.createMapMessage();
            for (String key : sendMap.keySet()) {
                Object value = sendMap.get(key);
                msg.setObject(key, value);
            }
            this.pub.send((Message)msg);
        }
        catch (Exception e) {
            WfLog.log("eChain-MQ", 4, "\u53d1\u9001Pub/Sub\u6a21\u5f0f\u7684MQ\u6d88\u606f\u51fa\u9519:" + e.getMessage());
            WfLog.runtimeException(this, "sendMapbyTopic", e);
            return false;
        }
        WfLog.log("eChain-MQ", 0, "\u53d1\u9001Pub/Sub\u6a21\u5f0f\u7684MQ\u6d88\u606f\u6210\u529f,\u8017\u65f6:" + (System.currentTimeMillis() - startTime));
        return true;
    }

    public boolean sendTextByPTP(String sendText) {
        long startTime = System.currentTimeMillis();
        try {
            TextMessage msg = this.queueSession.createTextMessage(sendText);
            this.producer.send((Message)msg);
        }
        catch (JMSException e) {
            WfLog.log("eChain-MQ", 4, "\u53d1\u9001PTP\u6a21\u5f0f\u7684MQ\u6d88\u606f\u51fa\u9519:" + e.getMessage());
            WfLog.runtimeException(this, "sendTextByPTP", (Exception)((Object)e));
            return false;
        }
        WfLog.log("eChain-MQ", 0, "\u53d1\u9001PTP\u6a21\u5f0f\u7684MQ\u6d88\u606f\u6210\u529f,\u961f\u5217\u540d:" + this.queueName + ",\u8017\u65f6:" + (System.currentTimeMillis() - startTime));
        return true;
    }

    public boolean sendTextByTopic(String sendText) {
        long startTime = System.currentTimeMillis();
        try {
            TextMessage msg = this.topicSession.createTextMessage(sendText);
            this.producer.send((Message)msg);
        }
        catch (JMSException e) {
            WfLog.log("eChain-MQ", 4, "\u53d1\u9001Pub/Sub\u6a21\u5f0f\u7684MQ\u6d88\u606f\u51fa\u9519:" + e.getMessage());
            WfLog.runtimeException(this, "sendTextByTopic", (Exception)((Object)e));
            return false;
        }
        WfLog.log("eChain-MQ", 0, "\u53d1\u9001Pub/Sub\u6a21\u5f0f\u7684MQ\u6d88\u606f\u6210\u529f:" + (System.currentTimeMillis() - startTime));
        return true;
    }

    public void mqCommit() throws Exception {
        try {
            if (this.queueSessionFlag && this.queueSession != null) {
                this.queueSession.commit();
            }
            if (this.topicSessionFlag && this.topicSession != null) {
                this.topicSession.commit();
            }
        }
        catch (Exception e) {
            WfLog.log("eChain-MQ", 4, "\u63d0\u4ea4MQ\u4e8b\u52a1\u51fa\u9519:" + e.getMessage());
            WfLog.runtimeException(this, "mqCommit", e);
            throw e;
        }
    }

    public void RollBack() throws Exception {
        try {
            if (this.queueSessionFlag && this.queueSession != null) {
                this.queueSession.rollback();
            }
            if (this.topicSessionFlag && this.topicSession != null) {
                this.topicSession.rollback();
            }
        }
        catch (Exception e) {
            WfLog.log("eChain-MQ", 4, "\u56de\u6edaMQ\u4e8b\u52a1\u51fa\u9519:" + e.getMessage());
            WfLog.runtimeException(this, "RollBack", e);
            throw e;
        }
    }

    public void close() throws Exception {
        long startTime = System.currentTimeMillis();
        try {
            if (this.producer != null) {
                this.producer.close();
            }
            if (this.pub != null) {
                this.pub.close();
            }
        }
        catch (Exception ex) {
            WfLog.log("eChain-MQ", 4, "\u9500\u6bc1MQ \u6d88\u606f\u751f\u4ea7\u8005\u51fa\u9519:" + ex);
            WfLog.log(4, "\u5173\u95edMQ Producer\u51fa\u9519...", ex);
        }
        try {
            if (this.queueSession != null) {
                this.queueSession.close();
            }
            if (this.topicSession != null) {
                this.topicSession.close();
            }
        }
        catch (Exception ex) {
            WfLog.log("eChain-MQ", 4, "\u9500\u6bc1MQ Session\u51fa\u9519:" + ex);
            WfLog.log(4, "\u5173\u95edMQ\u8fde\u63a5 Session\u51fa\u9519...", ex);
        }
        try {
            if (this.queueConn != null) {
                this.queueConn.close();
            }
            if (this.topicConn != null) {
                this.topicConn.close();
            }
        }
        catch (Exception ex) {
            WfLog.log("eChain-MQ", 4, "\u9500\u6bc1MQ \u8fde\u63a5\u51fa\u9519:" + ex);
            WfLog.log(4, "\u5173\u95edMQ\u8fde\u63a5 Connection\u51fa\u9519...", ex);
        }
        WfLog.log("eChain-MQ", 0, "\u9500\u6bc1MQ\u76f8\u5173\u8d44\u6e90\u6210\u529f,\u8017\u65f6:" + (System.currentTimeMillis() - startTime));
    }

    public static void main(String[] args) throws Exception {
        MQQueueSender queue = new MQQueueSender((TopicConnectionFactory)new ActiveMQConnectionFactory("tcp://localhost:61616"), "mq_topic_my", "mq_sj");
        queue.createTopicConnection(true);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("123", "DDD");
        map.put("456", "222");
        map.put("789", "333");
        boolean isTure = queue.sendMapbyTopic(map);
        queue.topicSession.commit();
        queue.close();
        if (isTure) {
            System.out.println("\u53d1\u9001\u6210\u529f...");
        }
    }
}

