/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.echain.ext;

import com.ecc.echain.db.DbControl;
import com.ecc.echain.log.WfLog;
import com.ecc.echain.org.OrgFactory;
import com.ecc.echain.org.model.OrgModel;
import com.ecc.echain.util.WfPropertyManager;
import com.ecc.echain.workflow.engine.EVO;
import com.ecc.echain.workflow.exception.WFException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class WFVar {
    private static WFVar _instance = new WFVar();
    public Map mapName2ID = new LinkedHashMap();

    private WFVar() {
        this.initVar(null);
    }

    public static WFVar getInstance() {
        return _instance;
    }

    public String fetchVar(String varName, EVO evo) throws WFException {
        if (!this.mapName2ID.containsKey(varName)) {
            throw new WFException("\u6d41\u7a0b\u53d8\u91cf\u3010" + varName + "\u3011\u4e0d\u5b58\u5728");
        }
        String varid = (String)this.mapName2ID.get(varName);
        String orgid = evo.getOrgid();
        if (orgid == null || orgid.equals("")) {
            throw new WFException("\u6d41\u7a0b\u4f20\u503c\u5bf9\u8c61EVO\u4e2d\u65e0\u6cd5\u83b7\u53d6\u673a\u6784\u53f7\u4fe1\u606f");
        }
        DbControl db = DbControl.getInstance();
        Connection cn = null;
        String retS = null;
        boolean bClose = false;
        try {
            try {
                Vector vecData;
                cn = evo.getConnection();
                if (cn == null) {
                    cn = db.getConnection();
                    bClose = true;
                }
                if ((vecData = db.performQuery("select varvalue from wf_orgvar where orgid='" + orgid + "' and varid='" + varid + "'", cn)) != null && vecData.size() > 0) {
                    retS = (String)((Vector)vecData.elementAt(0)).elementAt(0);
                } else {
                    String suporgid = null;
                    OrgModel om = OrgFactory.getInstance().getOrgClass().getParentOrg(orgid, cn);
                    if (om != null) {
                        suporgid = om.getOrgid();
                    }
                    while (suporgid != null) {
                        vecData = db.performQuery("select varvalue from wf_orgvar where orgid='" + suporgid + "' and varid='" + varid + "'", cn);
                        if (vecData != null && vecData.size() > 0) {
                            retS = (String)((Vector)vecData.elementAt(0)).elementAt(0);
                            break;
                        }
                        om = OrgFactory.getInstance().getOrgClass().getParentOrg(suporgid, cn);
                        suporgid = om != null ? om.getOrgid() : null;
                    }
                }
                if (retS == null) {
                    vecData = db.performQuery("select varvalue from wf_var where varid='" + varid + "'", cn);
                    retS = (String)((Vector)vecData.elementAt(0)).elementAt(0);
                }
            }
            catch (Exception e) {
                throw new WFException("\u83b7\u53d6\u6d41\u7a0b\u53d8\u91cf\u503c\u5f02\u5e38\uff0c\u53d8\u91cf\u540d\u79f0\uff1a" + varName + "\uff1b\u673a\u6784\u53f7\uff1a" + orgid + "\uff1b");
            }
        }
        finally {
            if (bClose && cn != null) {
                try {
                    db.freeConnection(cn);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return retS;
    }

    public void initVar(String sysid) {
        block15: {
            this.mapName2ID.clear();
            DbControl db = DbControl.getInstance();
            Connection cn = null;
            try {
                try {
                    Vector vecData;
                    cn = db.getConnection();
                    String sqlstr = "select varid,varname from wf_var";
                    if (sysid != null && sysid.length() > 0) {
                        sqlstr = String.valueOf(sqlstr) + " where sysid='" + sysid + "'";
                    }
                    if ((vecData = db.performQuery(sqlstr, cn)) != null && vecData.size() > 0) {
                        int i = 0;
                        while (i < vecData.size()) {
                            Vector vecRow = (Vector)vecData.elementAt(i);
                            this.mapName2ID.put((String)vecRow.elementAt(1), (String)vecRow.elementAt(0));
                            ++i;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (cn == null) break block15;
                    try {
                        db.freeConnection(cn);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (cn != null) {
                    try {
                        db.freeConnection(cn);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public Vector query(String sysid) {
        Vector vecData;
        block13: {
            DbControl db = DbControl.getInstance();
            Connection cn = null;
            vecData = null;
            try {
                try {
                    cn = db.getConnection();
                    String sqlstr = "select varid,varname,vardesc,varvalue from wf_var";
                    if (sysid != null && sysid.length() > 0) {
                        sqlstr = String.valueOf(sqlstr) + " where sysid='" + sysid + "'";
                    }
                    vecData = db.performQuery(sqlstr, cn);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (cn == null) break block13;
                    try {
                        db.freeConnection(cn);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (cn != null) {
                    try {
                        db.freeConnection(cn);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return vecData;
    }

    public boolean addBefCheck(String varid) {
        boolean flag;
        block18: {
            flag = false;
            if (varid == null || varid.length() == 0) {
                return flag;
            }
            DbControl db = DbControl.getInstance();
            Connection cn = null;
            Vector vecData = null;
            try {
                try {
                    cn = db.getConnection();
                    String sqlstr = "select varid from wf_var";
                    if (varid != null && varid.length() > 0) {
                        sqlstr = String.valueOf(sqlstr) + " where varid='" + varid + "'";
                    }
                    if ((vecData = db.performQuery(sqlstr, cn)) != null && vecData.size() > 0) {
                        flag = true;
                    }
                }
                catch (Exception e) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                    e.printStackTrace();
                    if (cn == null) break block18;
                    try {
                        db.freeConnection(cn);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (cn != null) {
                    try {
                        db.freeConnection(cn);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return flag;
    }

    public void add(Vector vecFields) {
        block17: {
            if (vecFields == null || vecFields.isEmpty()) {
                return;
            }
            DbControl db = DbControl.getInstance();
            Connection cn = null;
            try {
                try {
                    cn = db.getConnection();
                    db.doInsert("wf_var", vecFields, cn);
                    this.initVar(null);
                    if (!WfPropertyManager.getInstance().autocommit) {
                        cn.commit();
                    }
                }
                catch (Exception e) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                    e.printStackTrace();
                    if (cn == null) break block17;
                    try {
                        db.freeConnection(cn);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (cn != null) {
                    try {
                        db.freeConnection(cn);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void del(String varid) {
        block17: {
            if (varid == null || varid.equals("")) {
                return;
            }
            DbControl db = DbControl.getInstance();
            Connection cn = null;
            try {
                try {
                    cn = db.getConnection();
                    db.performSql("delete from wf_var where varid='" + varid + "'", cn);
                    this.initVar(null);
                    if (!WfPropertyManager.getInstance().autocommit) {
                        cn.commit();
                    }
                }
                catch (Exception e) {
                    try {
                        if (!WfPropertyManager.getInstance().autocommit) {
                            WfLog.log(4, "\u5904\u7406\u8fc7\u7a0b\u5f02\u5e38\uff0c\u5f00\u59cb\u6267\u884c\u56de\u6eda");
                            cn.rollback();
                        }
                    }
                    catch (Exception ee) {
                        WfLog.log(4, "\u56de\u6eda\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                        ee.printStackTrace();
                    }
                    e.printStackTrace();
                    if (cn == null) break block17;
                    try {
                        db.freeConnection(cn);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (cn != null) {
                    try {
                        db.freeConnection(cn);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public List getOrgVarList(String sysid, String orgid, String varid) {
        ArrayList<EVO> list;
        block17: {
            DbControl db = DbControl.getInstance();
            Connection cn = null;
            list = new ArrayList<EVO>();
            try {
                try {
                    Vector vecData;
                    cn = db.getConnection();
                    String sqlstr = "select orgid,orgname,varid,varname,varvalue from wf_orgvar where 1=1";
                    if (sysid != null && sysid.length() > 0) {
                        sqlstr = String.valueOf(sqlstr) + " and sysid='" + sysid + "'";
                    }
                    if (orgid != null && orgid.length() > 0) {
                        sqlstr = String.valueOf(sqlstr) + " and orgid='" + orgid + "'";
                    }
                    if (varid != null && varid.length() > 0) {
                        sqlstr = String.valueOf(sqlstr) + " and varid='" + varid + "'";
                    }
                    if ((vecData = db.performQuery(sqlstr, cn)) != null && vecData.size() > 0) {
                        int i = 0;
                        while (i < vecData.size()) {
                            Vector vecRow = (Vector)vecData.elementAt(i);
                            EVO evo = new EVO();
                            evo.setOrgid((String)vecRow.elementAt(0));
                            evo.setOrgname((String)vecRow.elementAt(1));
                            evo.setFieldID((String)vecRow.elementAt(2));
                            evo.setFieldName((String)vecRow.elementAt(3));
                            evo.setFieldContent((String)vecRow.elementAt(4));
                            list.add(evo);
                            ++i;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (cn == null) break block17;
                    try {
                        db.freeConnection(cn);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (cn != null) {
                    try {
                        db.freeConnection(cn);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return list;
    }

    public boolean addOrgVar(String sysid, String orgid, String orgname, String varid, String varname, String varvalue) {
        boolean b;
        block13: {
            DbControl db = DbControl.getInstance();
            Connection cn = null;
            b = false;
            try {
                try {
                    cn = db.getConnection();
                    b = db.performSql("insert into wf_orgvar(orgid,orgname,varid,varname,varvalue,sysid) values('" + orgid + "','" + orgname + "','" + varid + "','" + varname + "','" + varvalue + "','" + sysid + "')", cn);
                    if (!WfPropertyManager.getInstance().autocommit) {
                        cn.commit();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (cn == null) break block13;
                    try {
                        db.freeConnection(cn);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (cn != null) {
                    try {
                        db.freeConnection(cn);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return b;
    }

    public boolean updateOrgVar(String sysid, String orgid, String varid, String varvalue) {
        boolean b;
        block13: {
            DbControl db = DbControl.getInstance();
            Connection cn = null;
            b = false;
            try {
                try {
                    cn = db.getConnection();
                    b = db.performSql("update wf_orgvar set varvalue='" + varvalue + "' where orgid='" + orgid + "' and varid='" + varid + "'", cn);
                    if (!WfPropertyManager.getInstance().autocommit) {
                        cn.commit();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (cn == null) break block13;
                    try {
                        db.freeConnection(cn);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (cn != null) {
                    try {
                        db.freeConnection(cn);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return b;
    }

    public boolean delOrgVar(String orgid, String varid) {
        boolean b;
        block13: {
            DbControl db = DbControl.getInstance();
            Connection cn = null;
            b = false;
            try {
                try {
                    cn = db.getConnection();
                    b = db.performSql("delete from wf_orgvar where orgid='" + orgid + "' and varid='" + varid + "'", cn);
                    if (!WfPropertyManager.getInstance().autocommit) {
                        cn.commit();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (cn == null) break block13;
                    try {
                        db.freeConnection(cn);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (cn != null) {
                    try {
                        db.freeConnection(cn);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return b;
    }
}

