/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.echain.db.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.ecc.echain.db.datasource.EChainDataSource;
import com.ecc.echain.log.WfLog;
import com.ecc.echain.util.Config;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.sql.DataSource;

public class EChainDruidDataSource
implements EChainDataSource {
    public static final String DATASOURCE_CONFIG_FILE_KEY = "datasourceconfigfile";
    public static final String DATASOURCE_DRUID_PREX = "jdbc.druid.";
    public static final String DATASOURCE_DRUID_DEFAULT_CONFIG_FILE = "echain_datasource";
    private static EChainDruidDataSource thisObj;
    private DruidDataSource druidDataSource;
    private int initStatus = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EChainDruidDataSource instance() {
        if (thisObj != null) return thisObj;
        Class<EChainDruidDataSource> clazz = EChainDruidDataSource.class;
        synchronized (EChainDruidDataSource.class) {
            thisObj = new EChainDruidDataSource();
            // ** MonitorExit[var0] (shouldn't be in output)
            return thisObj;
        }
    }

    @Override
    public synchronized void init() {
        if (this.initStatus == 0) {
            this.initStatus = 1;
            String configFileName = null;
            try {
                configFileName = Config.getSystemInfo(DATASOURCE_CONFIG_FILE_KEY);
            }
            catch (Exception e) {
                WfLog.log(4, e.getMessage(), e);
                configFileName = DATASOURCE_DRUID_DEFAULT_CONFIG_FILE;
            }
            this.init(configFileName, DATASOURCE_DRUID_PREX);
            WfLog.log(2, "----EChainDruidDataSource\u521d\u59cb\u5316\u5b8c\u6bd5----");
        } else {
            WfLog.log(2, "----EChainDruidDataSource\u5df2\u7ecf\u521d\u59cb\u5316\u5b8c\u6bd5\uff0c\u4e0d\u91cd\u65b0\u521d\u59cb\u5316----");
        }
        this.initStatus = 2;
    }

    protected void init(String configFileName, String configPrex) {
        Map<String, String> propsMap = this.getProps(configFileName);
        this.druidDataSource = new DruidDataSource();
        this.setConfigValues(DruidDataSource.class, this.druidDataSource, propsMap, configPrex);
    }

    protected <T> void setConfigValues(Class<T> clazz, T obj, Map<String, String> propsMap, String configPrex) {
        Method[] methods;
        HashMap<String, String> lowPropMap = new HashMap<String, String>();
        Set<Map.Entry<String, String>> propEntrySet = propsMap.entrySet();
        int configPrexIndex = configPrex.length();
        for (Map.Entry<String, String> entry : propEntrySet) {
            lowPropMap.put(entry.getKey().substring(configPrexIndex).toLowerCase(), entry.getValue());
        }
        Method[] methodArray = methods = clazz.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            String fieldName;
            String value;
            Method method = methodArray[n2];
            if (method.getName().startsWith("set") && (value = (String)lowPropMap.get(fieldName = method.getName().substring(3).toLowerCase())) != null) {
                this.invokeSetMethod(obj, method, value);
            }
            ++n2;
        }
    }

    protected void invokeSetMethod(Object obj, Method method, String value) {
        if (method.getParameterTypes() != null && method.getParameterTypes().length == 1) {
            Class<?>[] paramTypes = method.getParameterTypes();
            Class<?> paramType = paramTypes[0];
            this.invokeSetMethodByType(obj, method, paramType, value);
        }
    }

    protected void invokeSetMethodByType(Object obj, Method method, Class<?> paramType, String value) {
        try {
            if ("java.lang.String".equals(paramType.getName())) {
                method.invoke(obj, value);
                WfLog.log(2, "----" + method.getName() + ":" + value + "----");
            } else if ("boolean".equals(paramType.getName()) || "java.lang.Boolean".equals(paramType.getName())) {
                method.invoke(obj, Boolean.valueOf(value));
                WfLog.log(2, "----" + method.getName() + ":" + value + "----");
            } else if ("int".equals(paramType.getName()) || "java.lang.Integer".equals(paramType.getName())) {
                method.invoke(obj, Integer.valueOf(value));
                WfLog.log(2, "----" + method.getName() + ":" + value + "----");
            } else if ("long".equals(paramType.getName()) || "java.lang.Long".equals(paramType.getName())) {
                method.invoke(obj, Long.valueOf(value));
                WfLog.log(2, "----" + method.getName() + ":" + value + "----");
            } else {
                WfLog.log(2, "----\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b:" + paramType.getName() + "----");
            }
        }
        catch (Exception e) {
            WfLog.log(4, e.getMessage(), e);
        }
    }

    @Override
    public DataSource getDataSource() {
        return this.druidDataSource;
    }

    @Override
    public Connection getConnection() {
        try {
            return this.druidDataSource.getConnection();
        }
        catch (SQLException e) {
            WfLog.log(4, e.getMessage(), e);
            return null;
        }
    }

    @Override
    public void destory() {
        this.druidDataSource.close();
        this.druidDataSource = null;
    }

    protected Map<String, String> getProps(String configFileName) {
        HashMap<String, String> propMap = new HashMap<String, String>();
        ResourceBundle rsBundle = ResourceBundle.getBundle(configFileName);
        Set<String> keySet = rsBundle.keySet();
        for (String key : keySet) {
            String value = rsBundle.getString(key);
            propMap.put(key, value);
        }
        return propMap;
    }
}

