/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.echain.db.datasource;

import com.ecc.echain.db.datasource.EChainDataSource;
import com.ecc.echain.db.datasource.EChainDruidDataSource;
import com.ecc.echain.log.WfLog;
import com.ecc.echain.util.Config;

public class EChainDataSourceFactory {
    public static final String DATASOURCE_TYPE_KEY = "datasourcetype";
    public static final String DATASOURCE_TYPE_DRUID = "druid";
    private static EChainDataSourceFactory thisObj;

    private EChainDataSourceFactory() {
    }

    public static EChainDataSourceFactory instance() {
        if (thisObj == null) {
            thisObj = new EChainDataSourceFactory();
        }
        return thisObj;
    }

    public EChainDataSource getDataSource() {
        String dsType = null;
        try {
            dsType = Config.getSystemInfo(DATASOURCE_TYPE_KEY);
        }
        catch (Exception e) {
            WfLog.log(4, e.getMessage(), e);
            dsType = DATASOURCE_TYPE_DRUID;
        }
        if (DATASOURCE_TYPE_DRUID.equals(dsType)) {
            return EChainDruidDataSource.instance();
        }
        WfLog.log(4, "----" + dsType + " \u7c7b\u578b\u7684jdbcSource\u4e0d\u652f\u6301----");
        return null;
    }
}

