/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.echain.db;

import com.ecc.echain.db.datasource.EChainDataSource;
import com.ecc.echain.db.datasource.EChainDataSourceFactory;
import com.ecc.echain.log.WfLog;
import com.ecc.echain.util.Field;
import com.ecc.echain.util.StringUtils;
import com.ecc.echain.util.WfPropertyManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

public class DbControl {
    public static final int INSERT = 0;
    public static final int UPDATE = 1;
    private static DbControl instance;
    private int clients = 0;
    DataSource ds = null;

    public boolean performSql(String strSql, Connection cn) throws Exception {
        boolean blnResult;
        block9: {
            blnResult = false;
            try {
                Statement stmt = null;
                if (cn != null) {
                    try {
                        try {
                            stmt = cn.createStatement();
                            WfLog.log(0, "====performSql:" + strSql);
                            blnResult = stmt.execute(strSql);
                            break block9;
                        }
                        catch (Exception e) {
                            throw new Exception(e.toString());
                        }
                    }
                    finally {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                }
                WfLog.log(4, "===========\u6ca1\u6709\u5f97\u5230\u6570\u636e\u5e93\u8fde\u63a5\uff01===========");
                throw new Exception("\u6ca1\u6709\u5f97\u5230\u6570\u636e\u5e93\u8fde\u63a5\uff01");
            }
            catch (Exception ex) {
                WfLog.log(4, "\u6267\u884cdb.performSql()\u65b9\u6cd5\u5f02\u5e38\uff0c\u8bed\u53e5\uff1a" + strSql);
                throw ex;
            }
        }
        return blnResult;
    }

    public Vector performQueryHashMap(String tableName, Vector vecFields, String strWhere, Connection cn) throws Exception {
        Vector vecData;
        block12: {
            vecData = new Vector();
            String strSql = "";
            int i = 0;
            while (i < vecFields.size()) {
                strSql = String.valueOf(strSql) + (String)vecFields.elementAt(i) + ",";
                ++i;
            }
            strSql = strSql.substring(0, strSql.length() - 1);
            strSql = "select " + strSql + " from " + tableName + " where " + strWhere;
            Statement stmt = null;
            if (cn != null) {
                try {
                    try {
                        stmt = cn.createStatement();
                        WfLog.log(0, "====performQueryHashMap:" + strSql);
                        ResultSet rs = stmt.executeQuery(strSql);
                        ResultSetMetaData rsmdQuery = rs.getMetaData();
                        int iColnum = rsmdQuery.getColumnCount();
                        while (rs.next()) {
                            HashMap<String, String> hmRow = new HashMap<String, String>();
                            int i2 = 0;
                            while (i2 < iColnum) {
                                String strFieldValue = rs.getString(i2 + 1);
                                hmRow.put((String)vecFields.elementAt(i2), strFieldValue);
                                ++i2;
                            }
                            vecData.addElement(hmRow);
                            hmRow = null;
                        }
                        rs.close();
                        break block12;
                    }
                    catch (Exception e) {
                        WfLog.log(4, "\u6267\u884cdb.performQueryHashMap()\u65b9\u6cd5\u5f02\u5e38\uff0c\u8bed\u53e5\uff1a" + strSql);
                        throw e;
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            WfLog.log(4, "===========\u6ca1\u6709\u5f97\u5230\u6570\u636e\u5e93\u8fde\u63a5\uff01===========");
            throw new Exception("\u6ca1\u6709\u5f97\u5230\u6570\u636e\u5e93\u8fde\u63a5\uff01");
        }
        return vecData;
    }

    public Vector performQuery(String strSql, Connection cn) throws Exception {
        Vector vecData;
        block12: {
            vecData = new Vector();
            Statement stmt = null;
            ResultSet rs = null;
            if (cn != null) {
                try {
                    try {
                        stmt = cn.createStatement();
                        WfLog.log(0, "====performQuery:" + strSql);
                        rs = stmt.executeQuery(strSql);
                        ResultSetMetaData rsmdQuery = rs.getMetaData();
                        int iColnum = rsmdQuery.getColumnCount();
                        while (rs.next()) {
                            Vector<String> vecRow = new Vector<String>();
                            int i = 1;
                            while (i <= iColnum) {
                                String strFieldValue = rs.getString(i);
                                vecRow.addElement(strFieldValue);
                                ++i;
                            }
                            vecData.addElement(vecRow);
                            vecRow = null;
                        }
                        break block12;
                    }
                    catch (Exception e) {
                        WfLog.log(4, "\u6267\u884cdb.performQuery()\u65b9\u6cd5\u5f02\u5e38\uff0c\u8bed\u53e5\uff1a" + strSql);
                        throw e;
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            WfLog.log(4, "===========\u6ca1\u6709\u5f97\u5230\u6570\u636e\u5e93\u8fde\u63a5\uff01===========");
            throw new Exception("\u6ca1\u6709\u5f97\u5230\u6570\u636e\u5e93\u8fde\u63a5\uff01");
        }
        return vecData;
    }

    public Vector performQuery2(String strSql, Connection cn) throws Exception {
        Vector<HashMap<String, String>> vecData;
        block12: {
            HashMap<String, String> rowMap = new HashMap<String, String>();
            vecData = new Vector<HashMap<String, String>>();
            Statement stmt = null;
            ResultSet rs = null;
            if (cn != null) {
                try {
                    try {
                        stmt = cn.createStatement();
                        WfLog.log(0, "====performQuery2:" + strSql);
                        rs = stmt.executeQuery(strSql);
                        ResultSetMetaData rsmdQuery = rs.getMetaData();
                        int iColnum = rsmdQuery.getColumnCount();
                        while (rs.next()) {
                            rowMap = new HashMap();
                            int i = 1;
                            while (i <= iColnum) {
                                String columnName = rsmdQuery.getColumnName(i);
                                String columnValue = rs.getString(columnName);
                                rowMap.put(columnName, columnValue);
                                ++i;
                            }
                            vecData.add(rowMap);
                        }
                        break block12;
                    }
                    catch (Exception e) {
                        WfLog.log(4, "\u6267\u884cdb.performQuery()\u65b9\u6cd5\u5f02\u5e38\uff0c\u8bed\u53e5\uff1a" + strSql);
                        throw e;
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            WfLog.log(4, "===========\u6ca1\u6709\u5f97\u5230\u6570\u636e\u5e93\u8fde\u63a5\uff01===========");
            throw new Exception("\u6ca1\u6709\u5f97\u5230\u6570\u636e\u5e93\u8fde\u63a5\uff01");
        }
        return vecData;
    }

    public Vector performQueryRS(String strSql, Connection cn) throws Exception {
        Vector<String> vecFieldTypes;
        block11: {
            ResultSet rs = null;
            vecFieldTypes = new Vector<String>();
            try {
                Statement stmt = null;
                if (cn != null) {
                    try {
                        try {
                            stmt = cn.createStatement();
                            rs = stmt.executeQuery(strSql);
                            ResultSetMetaData rsmd = rs.getMetaData();
                            int i = 1;
                            while (i <= rsmd.getColumnCount()) {
                                vecFieldTypes.addElement(Integer.toString(rsmd.getColumnType(i)));
                                ++i;
                            }
                            break block11;
                        }
                        catch (Exception e) {
                            throw new Exception(e.toString());
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                }
                WfLog.log(4, "===========\u6ca1\u6709\u5f97\u5230\u6570\u636e\u5e93\u8fde\u63a5\uff01===========");
                throw new Exception("\u6ca1\u6709\u5f97\u5230\u6570\u636e\u5e93\u8fde\u63a5\uff01");
            }
            catch (Exception ex) {
                WfLog.log(4, "\u6267\u884cdb.performQueryRS()\u65b9\u6cd5\u5f02\u5e38\uff0c\u8bed\u53e5\uff1a" + strSql);
                throw ex;
            }
        }
        return vecFieldTypes;
    }

    public boolean performBathSql(Vector vecSql, Connection cn) throws Exception {
        boolean blnResult;
        block10: {
            blnResult = false;
            try {
                Statement stmt = null;
                if (cn != null) {
                    try {
                        try {
                            stmt = cn.createStatement();
                            int i = 0;
                            while (i < vecSql.size()) {
                                String strSql = (String)vecSql.elementAt(i);
                                WfLog.log(0, "====performBathSql:" + strSql);
                                stmt.execute(strSql);
                                ++i;
                            }
                            blnResult = true;
                            break block10;
                        }
                        catch (Exception e) {
                            throw new Exception(e.toString());
                        }
                    }
                    finally {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                }
                WfLog.log(4, "===========\u6ca1\u6709\u5f97\u5230\u6570\u636e\u5e93\u8fde\u63a5\uff01===========");
                throw new Exception("\u6ca1\u6709\u5f97\u5230\u6570\u636e\u5e93\u8fde\u63a5\uff01");
            }
            catch (Exception ex) {
                WfLog.log(4, "\u6267\u884cdb.performBathSql()\u65b9\u6cd5\u5f02\u5e38\uff0c\u8bed\u53e5\uff1a" + vecSql);
                throw ex;
            }
        }
        return blnResult;
    }

    public void doDelete(String tableName, String whereClause, Connection cn) throws Exception {
        String deleteSql = "delete from " + tableName + " where " + whereClause;
        this.performSql(deleteSql, cn);
    }

    public void doDelete(String tableName, Vector vecWhere, Connection cn) throws Exception {
        Statement ps = null;
        try {
            String psql = "delete from " + tableName + " where 1=1";
            String selectSql = "select ";
            Vector vecFieldTypes = new Vector();
            int i = 0;
            while (i < vecWhere.size()) {
                Field field = (Field)vecWhere.elementAt(i);
                selectSql = String.valueOf(selectSql) + field.getFieldName() + ",";
                psql = String.valueOf(psql) + " and " + field.getFieldName() + "=?";
                ++i;
            }
            selectSql = selectSql.substring(0, selectSql.length() - 1);
            selectSql = String.valueOf(selectSql) + " from " + tableName + " where 1=2";
            vecFieldTypes = this.performQueryRS(selectSql, cn);
            WfLog.log(0, "====doDelete:" + psql);
            ps = cn.prepareStatement(psql);
            int t = 1;
            int i2 = 0;
            while (i2 < vecWhere.size()) {
                String v = ((Field)vecWhere.elementAt(i2)).getFieldValue();
                t = Integer.parseInt((String)vecFieldTypes.elementAt(i2));
                if (!StringUtils.NullToEmpty(v).equals("")) {
                    if (t == 1 || t == 12) {
                        ps.setString(i2 + 1, v);
                    } else if (t == 4 || t == 5 || t == -5) {
                        ps.setInt(i2 + 1, Integer.parseInt(v));
                    } else if (t == 2) {
                        ps.setDouble(i2 + 1, Double.parseDouble(v));
                    } else if (t == 3) {
                        ps.setBigDecimal(i2 + 1, new BigDecimal(v));
                    } else if (t == 8 || t == 7) {
                        ps.setDouble(i2 + 1, Double.parseDouble(v));
                    } else if (t == 6) {
                        ps.setFloat(i2 + 1, Float.parseFloat(v));
                    } else {
                        ps.setObject(i2 + 1, v, t);
                    }
                } else {
                    ps.setNull(i2 + 1, t);
                }
                ++i2;
            }
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public void doInsert(String tableName, Vector vecFields, Connection cn) throws Exception {
        Statement ps = null;
        try {
            try {
                String psql = "insert into " + tableName + "(";
                String strHeadTemp = "";
                String selectSql = "select ";
                Vector vecFieldTypes = new Vector();
                int i = 0;
                while (i < vecFields.size()) {
                    Field field = (Field)vecFields.elementAt(i);
                    selectSql = String.valueOf(selectSql) + field.getFieldName() + ",";
                    psql = String.valueOf(psql) + field.getFieldName() + ",";
                    strHeadTemp = String.valueOf(strHeadTemp) + ",?";
                    ++i;
                }
                psql = psql.substring(0, psql.length() - 1);
                psql = String.valueOf(psql) + ") values (" + strHeadTemp.substring(1) + ")";
                selectSql = selectSql.substring(0, selectSql.length() - 1);
                selectSql = String.valueOf(selectSql) + " from " + tableName + " where 1=2";
                vecFieldTypes = this.performQueryRS(selectSql, cn);
                WfLog.log(0, "====doInsert:" + psql);
                ps = cn.prepareStatement(psql);
                int t = 1;
                int i2 = 0;
                while (i2 < vecFields.size()) {
                    String v = ((Field)vecFields.elementAt(i2)).getFieldValue();
                    t = Integer.parseInt((String)vecFieldTypes.elementAt(i2));
                    if (!StringUtils.NullToEmpty(v).equals("")) {
                        if (t == 1 || t == 12) {
                            ps.setString(i2 + 1, v);
                        } else if (t == 4 || t == 5 || t == -5) {
                            ps.setInt(i2 + 1, Integer.parseInt(v));
                        } else if (t == 2) {
                            ps.setDouble(i2 + 1, Double.parseDouble(v));
                        } else if (t == 3) {
                            ps.setBigDecimal(i2 + 1, new BigDecimal(v));
                        } else if (t == 8 || t == 7) {
                            ps.setDouble(i2 + 1, Double.parseDouble(v));
                        } else if (t == 6) {
                            ps.setFloat(i2 + 1, Float.parseFloat(v));
                        } else {
                            ps.setObject(i2 + 1, v, t);
                        }
                    } else {
                        ps.setNull(i2 + 1, t);
                    }
                    ++i2;
                }
                ps.executeUpdate();
            }
            catch (Exception e) {
                WfLog.log(4, "\u6267\u884cdoInsert\u65b9\u6cd5\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a " + e.toString());
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public void doInsertByMap(String tableName, HashMap hm, Connection cn) throws Exception {
        Statement ps = null;
        try {
            try {
                String insertHead = "insert into " + tableName + "(";
                String insertTail = "";
                Iterator it = hm.keySet().iterator();
                String key = "";
                String value = "";
                Vector<String> v = new Vector<String>();
                while (it.hasNext()) {
                    key = (String)it.next();
                    value = (String)hm.get(key);
                    insertHead = String.valueOf(insertHead) + key + ",";
                    insertTail = String.valueOf(insertTail) + "?,";
                    v.add(value);
                }
                insertHead = insertHead.substring(0, insertHead.length() - 1);
                insertTail = insertTail.substring(0, insertTail.length() - 1);
                String insertSql = String.valueOf(insertHead) + ") values (" + insertTail + ")";
                WfLog.log(0, "====doInsertByMap:" + insertSql);
                ps = cn.prepareStatement(insertSql);
                int i = 0;
                while (i < v.size()) {
                    ps.setString(i + 1, (String)v.elementAt(i));
                    ++i;
                }
                ps.executeUpdate();
            }
            catch (Exception e) {
                WfLog.log(4, "\u6267\u884cdoInsertByMap\u65b9\u6cd5\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a " + e.toString());
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public void doInsertByMap2(String tableName, HashMap hm, Connection cn) throws Exception {
        try {
            String insertHead = "insert into " + tableName + "(";
            String insertTail = "";
            Iterator it = hm.keySet().iterator();
            String key = "";
            String value = "";
            while (it.hasNext()) {
                key = (String)it.next();
                value = (String)hm.get(key);
                insertHead = String.valueOf(insertHead) + key + ",";
                insertTail = value == null || value.equals("null") || value.equals("") ? String.valueOf(insertTail) + "null," : String.valueOf(insertTail) + "'" + value + "',";
            }
            insertHead = insertHead.substring(0, insertHead.length() - 1);
            insertTail = insertTail.substring(0, insertTail.length() - 1);
            String insertSql = String.valueOf(insertHead) + ") values (" + insertTail + ")";
            this.performSql(insertSql, cn);
        }
        catch (Exception e) {
            WfLog.log(4, "\u6267\u884cdoInsertByMap\u65b9\u6cd5\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a " + e.toString());
            e.printStackTrace();
            throw e;
        }
    }

    public void doUpdate(String tableName, Vector vecFields, String whereClause, Connection cn) throws Exception {
        Statement ps = null;
        try {
            String psql = "update " + tableName + " set ";
            String selectSql = "select ";
            Vector vecFieldTypes = new Vector();
            int i = 0;
            while (i < vecFields.size()) {
                Field field = (Field)vecFields.elementAt(i);
                selectSql = String.valueOf(selectSql) + field.getFieldName() + ",";
                psql = String.valueOf(psql) + field.getFieldName() + "=?,";
                ++i;
            }
            psql = String.valueOf(psql.substring(0, psql.length() - 1)) + " where " + whereClause;
            selectSql = selectSql.substring(0, selectSql.length() - 1);
            selectSql = String.valueOf(selectSql) + " from " + tableName + " where 1=2";
            vecFieldTypes = this.performQueryRS(selectSql, cn);
            WfLog.log(0, "====doUpdate=" + psql);
            ps = cn.prepareStatement(psql);
            int t = 1;
            int i2 = 0;
            while (i2 < vecFields.size()) {
                String v = ((Field)vecFields.elementAt(i2)).getFieldValue();
                t = Integer.parseInt((String)vecFieldTypes.elementAt(i2));
                if (!StringUtils.NullToEmpty(v).equals("")) {
                    if (t == 1 || t == 12) {
                        ps.setString(i2 + 1, v);
                    } else if (t == 4 || t == 5 || t == -5) {
                        ps.setInt(i2 + 1, Integer.parseInt(v));
                    } else if (t == 2) {
                        ps.setDouble(i2 + 1, Double.parseDouble(v));
                    } else if (t == 3) {
                        ps.setBigDecimal(i2 + 1, new BigDecimal(v));
                    } else if (t == 8 || t == 7) {
                        ps.setDouble(i2 + 1, Double.parseDouble(v));
                    } else if (t == 6) {
                        ps.setFloat(i2 + 1, Float.parseFloat(v));
                    } else {
                        ps.setObject(i2 + 1, v, t);
                    }
                } else {
                    ps.setNull(i2 + 1, t);
                }
                ++i2;
            }
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public void doUpdate(String tableName, Vector vecFields, Vector vecWhere, Connection cn) throws Exception {
        Statement ps = null;
        try {
            Field field;
            String psql = "update " + tableName + " set ";
            String selectSql = "select ";
            Vector vecFieldTypes = new Vector();
            int i = 0;
            while (i < vecFields.size()) {
                field = (Field)vecFields.elementAt(i);
                selectSql = String.valueOf(selectSql) + field.getFieldName() + ",";
                psql = String.valueOf(psql) + field.getFieldName() + "=?,";
                ++i;
            }
            psql = String.valueOf(psql.substring(0, psql.length() - 1)) + " where 1=1";
            i = 0;
            while (i < vecWhere.size()) {
                field = (Field)vecWhere.elementAt(i);
                selectSql = String.valueOf(selectSql) + field.getFieldName() + ",";
                psql = String.valueOf(psql) + " and " + field.getFieldName() + "=?";
                ++i;
            }
            selectSql = selectSql.substring(0, selectSql.length() - 1);
            selectSql = String.valueOf(selectSql) + " from " + tableName + " where 1=2";
            vecFieldTypes = this.performQueryRS(selectSql, cn);
            WfLog.log(0, "====doUpdate:" + psql);
            ps = cn.prepareStatement(psql);
            int t = 1;
            int i2 = 0;
            while (i2 < vecFields.size() + vecWhere.size()) {
                String v = i2 < vecFields.size() ? ((Field)vecFields.elementAt(i2)).getFieldValue() : ((Field)vecWhere.elementAt(i2 - vecFields.size())).getFieldValue();
                t = Integer.parseInt((String)vecFieldTypes.elementAt(i2));
                if (!StringUtils.NullToEmpty(v).equals("")) {
                    if (t == 1 || t == 12) {
                        ps.setString(i2 + 1, v);
                    } else if (t == 4 || t == 5 || t == -5) {
                        ps.setInt(i2 + 1, Integer.parseInt(v));
                    } else if (t == 2) {
                        ps.setDouble(i2 + 1, Double.parseDouble(v));
                    } else if (t == 3) {
                        ps.setBigDecimal(i2 + 1, new BigDecimal(v));
                    } else if (t == 8 || t == 7) {
                        ps.setDouble(i2 + 1, Double.parseDouble(v));
                    } else if (t == 6) {
                        ps.setFloat(i2 + 1, Float.parseFloat(v));
                    } else {
                        ps.setObject(i2 + 1, v, t);
                    }
                } else {
                    ps.setNull(i2 + 1, t);
                }
                ++i2;
            }
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public boolean WriteClob(String pkey, String content) throws Exception {
        boolean blnResult = false;
        Connection cn = null;
        try {
            try {
                DataSource ds = this.getDataSource();
                cn = ds.getConnection();
                Vector vecData = this.performQuery("select pkey from wf_clob where pkey='" + pkey + "'", cn);
                blnResult = vecData.size() > 0 ? this.WriteClob(pkey, content, 1, cn) : this.WriteClob(pkey, content, 0, cn);
            }
            catch (Exception ex) {
                blnResult = false;
                throw new Exception(ex.toString());
            }
        }
        finally {
            try {
                if (cn != null) {
                    cn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return blnResult;
    }

    public boolean WriteClob(String pkey, String content, Connection cn) throws Exception {
        boolean blnResult = false;
        try {
            Vector vecData = this.performQuery("select pkey from wf_clob where pkey='" + pkey + "'", cn);
            blnResult = vecData.size() > 0 ? this.WriteClob(pkey, content, 1, cn) : this.WriteClob(pkey, content, 0, cn);
        }
        catch (Exception ex) {
            blnResult = false;
            throw new Exception(ex.toString());
        }
        return blnResult;
    }

    public boolean WriteClob(String pkey, String content, int sign) throws Exception {
        boolean blnResult = false;
        Connection cn = null;
        try {
            try {
                DataSource ds = this.getDataSource();
                cn = ds.getConnection();
                blnResult = this.WriteClob(pkey, content, sign, cn);
            }
            catch (Exception ex) {
                blnResult = false;
                throw new Exception(ex.toString());
            }
        }
        finally {
            try {
                if (cn != null) {
                    cn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return blnResult;
    }

    public boolean WriteClob(String pkey, String content, int sign, Connection cn) throws Exception {
        boolean blnResult = false;
        try {
            WfPropertyManager wpm = WfPropertyManager.getInstance();
            String dbType = wpm.DataBaseVersion;
            if (dbType != null && dbType.equalsIgnoreCase("Oracle")) {
                blnResult = this.WriteClobForOracle(pkey, content, sign, cn);
            } else if (dbType != null && (dbType.equalsIgnoreCase("SQL Server") || dbType.equalsIgnoreCase("MSSQL") || dbType.equalsIgnoreCase("Informix") || dbType.equalsIgnoreCase("Derby"))) {
                blnResult = this.WriteClobForSQLServer(pkey, content, sign, cn);
            } else {
                WfLog.log(4, "\u4e0d\u53ef\u8bc6\u522b\u7684\u6570\u636e\u5e93\u7c7b\u578b:" + dbType);
                blnResult = false;
            }
        }
        catch (Exception ex) {
            blnResult = false;
            WfLog.log(4, ex.getStackTrace() + ex.toString());
            throw new Exception(ex.toString());
        }
        return blnResult;
    }

    public boolean WriteBlob(String pkey, Object content) throws Exception {
        boolean blnResult = false;
        Connection cn = null;
        try {
            try {
                DataSource ds = this.getDataSource();
                cn = ds.getConnection();
                Vector vecData = this.performQuery("select pkey from wf_blob where pkey='" + pkey + "'", cn);
                blnResult = vecData.size() > 0 ? this.WriteBlob(pkey, content, 1, cn) : this.WriteBlob(pkey, content, 0, cn);
            }
            catch (Exception ex) {
                blnResult = false;
                throw new Exception(ex.toString());
            }
        }
        finally {
            try {
                if (cn != null) {
                    cn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return blnResult;
    }

    public boolean WriteBlob(String pkey, Object content, Connection cn) throws Exception {
        boolean blnResult = false;
        try {
            Vector vecData = this.performQuery("select pkey from wf_blob where pkey='" + pkey + "'", cn);
            blnResult = vecData.size() > 0 ? this.WriteBlob(pkey, content, 1, cn) : this.WriteBlob(pkey, content, 0, cn);
        }
        catch (Exception ex) {
            blnResult = false;
            throw new Exception(ex.toString());
        }
        return blnResult;
    }

    public boolean WriteBlob(String pkey, Object content, int sign) throws Exception {
        boolean blnResult = false;
        Connection cn = null;
        try {
            try {
                DataSource ds = this.getDataSource();
                cn = ds.getConnection();
                blnResult = this.WriteBlob(pkey, content, sign, cn);
            }
            catch (Exception ex) {
                blnResult = false;
                throw new Exception(ex.toString());
            }
        }
        finally {
            try {
                if (cn != null) {
                    cn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return blnResult;
    }

    public boolean WriteBlob(String pkey, Object content, int sign, Connection cn) throws Exception {
        boolean blnResult = false;
        try {
            WfPropertyManager wpm = WfPropertyManager.getInstance();
            String dbType = wpm.DataBaseVersion;
            if (dbType != null && dbType.equalsIgnoreCase("Oracle")) {
                blnResult = this.WriteBlobForOracle(pkey, content, sign, cn);
            } else if (dbType != null && (dbType.equalsIgnoreCase("SQL Server") || dbType.equalsIgnoreCase("MSSQL") || dbType.equalsIgnoreCase("Informix") || dbType.equalsIgnoreCase("Derby"))) {
                blnResult = this.WriteBlobForSQLServer(pkey, content, sign, cn);
            } else {
                WfLog.log(4, "\u4e0d\u53ef\u8bc6\u522b\u7684\u6570\u636e\u5e93\u7c7b\u578b:" + dbType);
                blnResult = false;
            }
        }
        catch (Exception ex) {
            blnResult = false;
            WfLog.log(4, ex.getStackTrace() + ex.toString());
            throw new Exception(ex.toString());
        }
        return blnResult;
    }

    public boolean WriteClobForOracle(String pkey, String content, int sign, Connection cn) throws Exception {
        boolean blnResult = false;
        WfPropertyManager wpm = WfPropertyManager.getInstance();
        Connection con = null;
        try {
            try {
                Statement sql;
                ResultSet rs;
                Class.forName("oracle.jdbc.driver.OracleDriver");
                con = DriverManager.getConnection("jdbc:oracle:thin:@" + wpm.WF_DB_IP + ":1521:" + wpm.WF_DB_Name, wpm.WF_DB_UserName, wpm.WF_DB_PassWord);
                con.setAutoCommit(false);
                if (sign == 0) {
                    PreparedStatement ps = con.prepareStatement("insert into wf_clob(pkey,content) values(?,EMPTY_CLOB())");
                    ps.setString(1, pkey);
                    ps.executeUpdate();
                    ps.close();
                }
                if ((rs = (sql = con.createStatement()).executeQuery("select content from wf_clob where pkey='" + pkey + "' for update")).next()) {
                    CLOB clob = (CLOB)rs.getClob(1);
                    BufferedWriter out = new BufferedWriter(clob.getCharacterOutputStream());
                    out.write(content);
                    out.flush();
                    out.close();
                }
                rs.close();
                sql.close();
                blnResult = true;
            }
            catch (SQLException e) {
                blnResult = false;
                WfLog.log(4, "\u65e0\u6cd5\u8fde\u63a5\u6570\u636e\u5e93\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                e.printStackTrace();
                throw new Exception(e.toString());
            }
            catch (IOException ioe) {
                blnResult = false;
                WfLog.log(4, "IO\u8bfb\u5199\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                ioe.printStackTrace();
                throw new Exception(ioe.toString());
            }
            catch (Exception ex) {
                blnResult = false;
                ex.printStackTrace();
                throw new Exception(ex.toString());
            }
        }
        finally {
            if (con != null) {
                try {
                    con.commit();
                    con.close();
                }
                catch (Exception ee) {
                    WfLog.log(4, "Error:\u65e0\u6cd5\u6b63\u5e38\u91ca\u653e\u6570\u636e\u5e93\u8fde\u63a5");
                }
            }
        }
        return blnResult;
    }

    public boolean WriteBlobForOracle(String pkey, Object content, int sign, Connection cn) throws Exception {
        boolean blnResult = false;
        WfPropertyManager wpm = WfPropertyManager.getInstance();
        Connection con = null;
        try {
            try {
                Statement sql;
                ResultSet rs;
                Class.forName("oracle.jdbc.driver.OracleDriver");
                con = DriverManager.getConnection("jdbc:oracle:thin:@" + wpm.WF_DB_IP + ":1521:" + wpm.WF_DB_Name, wpm.WF_DB_UserName, wpm.WF_DB_PassWord);
                con.setAutoCommit(false);
                if (sign == 0) {
                    PreparedStatement ps = con.prepareStatement("insert into wf_blob(pkey,content) values(?,EMPTY_BLOB())");
                    ps.setString(1, pkey);
                    ps.executeUpdate();
                    ps.close();
                }
                if ((rs = (sql = con.createStatement()).executeQuery("select content from wf_blob where pkey='" + pkey + "' for update")).next()) {
                    BLOB blob = (BLOB)rs.getBlob(1);
                    ObjectOutputStream out = new ObjectOutputStream(blob.getBinaryOutputStream());
                    out.writeObject(content);
                    out.flush();
                    out.close();
                }
                rs.close();
                sql.close();
                blnResult = true;
            }
            catch (SQLException e) {
                blnResult = false;
                WfLog.log(4, "\u65e0\u6cd5\u8fde\u63a5\u6570\u636e\u5e93\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                e.printStackTrace();
                throw new Exception(e.toString());
            }
            catch (IOException ioe) {
                blnResult = false;
                WfLog.log(4, "IO\u8bfb\u5199\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                ioe.printStackTrace();
                throw new Exception(ioe.toString());
            }
            catch (Exception ex) {
                blnResult = false;
                ex.printStackTrace();
                throw new Exception(ex.toString());
            }
        }
        finally {
            if (con != null) {
                try {
                    con.commit();
                    con.close();
                }
                catch (Exception ee) {
                    WfLog.log(4, "Error:\u65e0\u6cd5\u6b63\u5e38\u91ca\u653e\u6570\u636e\u5e93\u8fde\u63a5");
                }
            }
        }
        return blnResult;
    }

    public boolean WriteClobForSQLServer(String pkey, String content, int sign, Connection cn) throws Exception {
        boolean blnResult = false;
        try {
            if (sign == 0) {
                PreparedStatement ps = cn.prepareStatement("insert into wf_clob(pkey,content) values(?,?)");
                ps.setString(1, pkey);
                ps.setString(2, content);
                ps.executeUpdate();
                ps.close();
            } else if (sign == 1) {
                PreparedStatement ps = cn.prepareStatement("update wf_clob set content=? where pkey=?");
                ps.setString(1, content);
                ps.setString(2, pkey);
                ps.executeUpdate();
                ps.close();
            }
            blnResult = true;
        }
        catch (Exception ex) {
            blnResult = false;
            ex.printStackTrace();
            throw new Exception(ex.toString());
        }
        return blnResult;
    }

    public boolean WriteBlobForSQLServer(String pkey, Object content, int sign, Connection cn) throws Exception {
        boolean blnResult = false;
        try {
            if (sign == 0) {
                PreparedStatement ps = cn.prepareStatement("insert into wf_blob(pkey,content) values(?,?)");
                ps.setString(1, pkey);
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                ObjectOutputStream oOut = new ObjectOutputStream(byteOut);
                oOut.writeObject(content);
                oOut.flush();
                byte[] outs = byteOut.toByteArray();
                ps.setBytes(2, outs);
                ps.executeUpdate();
                ps.close();
            } else if (sign == 1) {
                PreparedStatement ps = cn.prepareStatement("update wf_blob set content=? where pkey=?");
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                ObjectOutputStream oOut = new ObjectOutputStream(byteOut);
                oOut.writeObject(content);
                oOut.flush();
                byte[] outs = byteOut.toByteArray();
                ps.setBytes(1, outs);
                ps.setString(2, pkey);
                ps.executeUpdate();
                ps.close();
            }
            blnResult = true;
        }
        catch (Exception ex) {
            blnResult = false;
            ex.printStackTrace();
            throw new Exception(ex.toString());
        }
        return blnResult;
    }

    public String ReadClob(String pkey) throws Exception {
        Connection cn = null;
        String content = "";
        try {
            try {
                DataSource ds = this.getDataSource();
                cn = ds.getConnection();
                content = this.ReadClob(pkey, cn);
            }
            catch (Exception ex) {
                throw new Exception(ex.toString());
            }
        }
        finally {
            try {
                if (cn != null) {
                    cn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return content;
    }

    public String ReadClob(String pkey, Connection cn) throws Exception {
        String content = "";
        try {
            WfPropertyManager wpm = WfPropertyManager.getInstance();
            String dbType = wpm.DataBaseVersion;
            if (dbType != null && dbType.equalsIgnoreCase("Oracle")) {
                content = this.ReadClobForOracle(pkey, cn);
            } else if (dbType != null && (dbType.equalsIgnoreCase("SQL Server") || dbType.equalsIgnoreCase("MSSQL") || dbType.equalsIgnoreCase("Informix") || dbType.equalsIgnoreCase("Derby"))) {
                content = this.ReadClobForSQLServer(pkey, cn);
            } else {
                WfLog.log(4, "\u4e0d\u53ef\u8bc6\u522b\u7684\u6570\u636e\u5e93\u7c7b\u578b:" + dbType);
            }
        }
        catch (Exception ex) {
            WfLog.log(4, ex.getStackTrace() + ex.toString());
            throw new Exception(ex.toString());
        }
        return content;
    }

    public Object ReadBlob(String pkey) throws Exception {
        Connection cn = null;
        Object content = null;
        try {
            try {
                DataSource ds = this.getDataSource();
                cn = ds.getConnection();
                content = this.ReadBlob(pkey, cn);
            }
            catch (Exception ex) {
                throw new Exception(ex.toString());
            }
        }
        finally {
            try {
                if (cn != null) {
                    cn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return content;
    }

    public Object ReadBlob(String pkey, Connection cn) throws Exception {
        Object content = null;
        try {
            WfPropertyManager wpm = WfPropertyManager.getInstance();
            String dbType = wpm.DataBaseVersion;
            if (dbType != null && (dbType.equalsIgnoreCase("Oracle") || dbType.equalsIgnoreCase("SQL Server") || dbType.equalsIgnoreCase("MSSQL") || dbType.equalsIgnoreCase("Informix") || dbType.equalsIgnoreCase("Derby"))) {
                content = this.ReadBlobForSQLServerAndOracle(pkey, cn);
            } else {
                WfLog.log(4, "\u4e0d\u53ef\u8bc6\u522b\u7684\u6570\u636e\u5e93\u7c7b\u578b:" + dbType);
            }
        }
        catch (Exception ex) {
            WfLog.log(4, ex.getStackTrace() + ex.toString());
            throw new Exception(ex.toString());
        }
        return content;
    }

    public String ReadClobForOracle(String pkey, Connection cn) throws Exception {
        String content = "";
        try {
            PreparedStatement ps = cn.prepareStatement("select content from wf_clob where pkey='" + pkey + "'");
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                String c;
                CLOB clob = (CLOB)rs.getClob(1);
                BufferedReader in = new BufferedReader(clob.getCharacterStream());
                StringBuffer sb = new StringBuffer();
                while ((c = in.readLine()) != null) {
                    sb.append(c);
                }
                in.close();
                content = new String(sb);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            WfLog.log(4, ex.getStackTrace() + ex.toString());
            throw new Exception(ex.toString());
        }
        return content;
    }

    public String ReadClobForSQLServer(String pkey, Connection cn) throws Exception {
        String content = "";
        try {
            PreparedStatement ps = cn.prepareStatement("select content from wf_clob where pkey='" + pkey + "'");
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                content = rs.getString(1);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            throw new Exception(ex.toString());
        }
        return content;
    }

    public Object ReadBlobForSQLServerAndOracle(String pkey, Connection cn) throws Exception {
        Object content = null;
        try {
            PreparedStatement ps = cn.prepareStatement("select content from wf_blob where pkey='" + pkey + "'");
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                InputStream is = rs.getBinaryStream(1);
                ObjectInputStream oIn = new ObjectInputStream(is);
                content = oIn.readObject();
                is.close();
                oIn.close();
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            throw new Exception(ex.toString());
        }
        return content;
    }

    public DataSource getDataSource() throws Exception {
        if (this.ds != null) {
            return this.ds;
        }
        WfPropertyManager wpm = WfPropertyManager.getInstance();
        if (wpm.connecttype.equals("datasource")) {
            this.ds = this.getJDBCDataSource();
        } else {
            String jndi_name = WfPropertyManager.getInstance().DataSource_JNDIName;
            this.ds = this.getJNDIDataSource(jndi_name);
        }
        return this.ds;
    }

    private DataSource getJDBCDataSource() throws Exception {
        EChainDataSource dataSource = EChainDataSourceFactory.instance().getDataSource();
        dataSource.init();
        return dataSource.getDataSource();
    }

    private DataSource getJNDIDataSource(String jndi_name) throws Exception {
        String appservertype = "";
        String factory = "";
        String url = "";
        try {
            appservertype = WfPropertyManager.getInstance().appservertype;
            factory = WfPropertyManager.getInstance().Context_INITIAL_CONTEXT_FACTORY;
            url = WfPropertyManager.getInstance().Context_PROVIDER_URL;
            Context ctx = null;
            Hashtable<String, String> env = new Hashtable<String, String>();
            if (appservertype == null || appservertype.equals("")) {
                throw new RuntimeException("\u65e0\u6cd5\u8bc6\u522b\u7684\u670d\u52a1\u5668\u7c7b\u578b\uff1a" + appservertype);
            }
            if (appservertype.equals("tomcat")) {
                InitialContext initCtx = new InitialContext();
                ctx = (Context)initCtx.lookup("java:comp/env");
            } else if (appservertype.equals("weblogic")) {
                env.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
                env.put("java.naming.provider.url", url);
                ctx = new InitialContext(env);
            } else if (appservertype.equals("jboss")) {
                env.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
                env.put("java.naming.provider.url", url);
                ctx = new InitialContext(env);
            } else if (appservertype.equals("websphere")) {
                ctx = new InitialContext();
            } else if (appservertype.equals("common")) {
                env.put("java.naming.factory.initial", factory);
                env.put("java.naming.provider.url", url);
                ctx = new InitialContext(env);
            } else {
                throw new RuntimeException("\u65e0\u6cd5\u8bc6\u522b\u7684\u670d\u52a1\u5668\u7c7b\u578b\uff1a" + appservertype);
            }
            return (DataSource)ctx.lookup(jndi_name);
        }
        catch (Exception e) {
            System.err.println("\u3010Error\u3011\u83b7\u53d6\u6570\u636e\u6e90\u5931\u8d25\uff0c\u914d\u7f6e\u4fe1\u606f\u5982\u4e0b\uff1a");
            System.err.println("appservertype=" + appservertype + "; factory=" + factory + "; url=" + url + "; jndi_name=" + jndi_name + ";");
            System.err.println("\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
            e.printStackTrace();
            throw e;
        }
    }

    public static synchronized DbControl getInstance() {
        if (instance == null) {
            instance = new DbControl();
        }
        return instance;
    }

    private DbControl() {
        this.init();
    }

    private void init() {
        if (this.ds != null) {
            return;
        }
        try {
            this.getDataSource();
        }
        catch (Exception e) {
            System.err.println("\u521d\u59cb\u5316\u6570\u636e\u5e93\u5904\u7406\u7c7bDbControl\u5f02\u5e38,\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
            e.printStackTrace();
        }
    }

    public Connection getConnection() throws Exception {
        try {
            Connection cn = null;
            WfPropertyManager wpm = WfPropertyManager.getInstance();
            if (wpm.connecttype == null || wpm.connecttype.equals("jndi")) {
                cn = this.getDataSource().getConnection();
            } else if (wpm.connecttype.equals("jdbc") && wpm.DataBaseVersion.equalsIgnoreCase("oracle")) {
                Class.forName("oracle.jdbc.driver.OracleDriver");
                cn = DriverManager.getConnection("jdbc:oracle:thin:@" + wpm.WF_DB_IP + ":1521:" + wpm.WF_DB_Name, wpm.WF_DB_UserName, wpm.WF_DB_PassWord);
            } else if (wpm.connecttype.equals("datasource")) {
                cn = this.getDataSource().getConnection();
            }
            if (cn == null) {
                throw new Exception("\u83b7\u53d6\u8fde\u63a5\u5931\u8d25\u3002\u3002\u3002\u3002");
            }
            if (!WfPropertyManager.getInstance().autocommit) {
                cn.setAutoCommit(false);
            }
            ++this.clients;
            return cn;
        }
        catch (Exception e) {
            System.err.println("\u83b7\u53d6\u8fde\u63a5\u5931\u8d25\u3002\u3002\u3002\u3002");
            e.printStackTrace();
            throw e;
        }
    }

    public Connection getConnection(String jndi_name) throws Exception {
        try {
            Connection cn = this.getJNDIDataSource(jndi_name).getConnection();
            ++this.clients;
            return cn;
        }
        catch (Exception e) {
            System.err.println("\u83b7\u53d6\u8fde\u63a5\u5931\u8d25\u3002\u3002\u3002\u3002");
            e.printStackTrace();
            throw e;
        }
    }

    public Connection getConnection(String driverclass, String url, String DBUser, String pwd) throws Exception {
        try {
            Class.forName(driverclass);
            Connection cn = DriverManager.getConnection(url, DBUser, pwd);
            ++this.clients;
            return cn;
        }
        catch (Exception e) {
            System.err.println("\u83b7\u53d6\u8fde\u63a5\u5931\u8d25\u3002\u3002\u3002\u3002");
            e.printStackTrace();
            throw e;
        }
    }

    public boolean freeConnection(Connection cn) throws Exception {
        if (cn != null) {
            try {
                cn.close();
                --this.clients;
                return true;
            }
            catch (SQLException e) {
                WfLog.log(4, "\u3010\u8b66\u544a\u3011\u65e0\u6cd5\u6b63\u5e38\u91ca\u653e\u8fde\u63a5\uff0c\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a");
                e.printStackTrace();
                throw e;
            }
        }
        WfLog.log(4, "freeConnection\u4f20\u5165\u7684\u8fde\u63a5\u4e3anull");
        return false;
    }

    public int getClients() {
        return this.clients;
    }
}

