/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.echain.component;

import com.ecc.echain.component.PopupAuthenticator;
import com.ecc.echain.log.WfLog;
import com.ecc.echain.util.WfPropertyManager;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class MailComponent {
    public boolean sendMail(String sender, String addressee, String subject, String content) {
        if (addressee == null || addressee.length() < 1 || content == null || content.length() < 1) {
            return false;
        }
        String fromAddr = WfPropertyManager.getInstance().fromaddr;
        String fromName = sender;
        String username = WfPropertyManager.getInstance().username;
        String password = WfPropertyManager.getInstance().password;
        String smtp = WfPropertyManager.getInstance().smtp;
        try {
            Properties props = new Properties();
            props.put("mail.smtp.auth", "true");
            props.put("mail.smtp.host", smtp);
            PopupAuthenticator auth = new PopupAuthenticator(username, password);
            Session session = Session.getDefaultInstance((Properties)props, (Authenticator)auth);
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(fromAddr, fromName));
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)addressee));
            msg.setSentDate(new Date());
            msg.setSubject(subject);
            msg.setText(String.valueOf(content) + "\n<--------------------\u8bf7\u52ff\u76f4\u63a5\u56de\u590d\u8be5\u90ae\u4ef6----------------------->");
            Transport transport = session.getTransport("smtp");
            transport.connect(smtp, username, password);
            Transport.send((Message)msg);
            transport.close();
            return true;
        }
        catch (Exception e) {
            WfLog.log(2, "====\u53d1\u9001\u90ae\u4ef6\u5931\u8d25====");
            e.printStackTrace();
            return false;
        }
    }

    public Map receiveMail(String POP3Server, String username, String password, boolean delSign) {
        HashMap<String, String> hm = new HashMap<String, String>();
        try {
            Properties props = new Properties();
            props.put("mail.smtp.auth", "true");
            props.put("mail.smtp.host", POP3Server);
            PopupAuthenticator auth = new PopupAuthenticator(username, password);
            Session session = Session.getDefaultInstance((Properties)props, (Authenticator)auth);
            Store store = session.getStore("pop3");
            store.connect(POP3Server, username, password);
            Folder folder = store.getFolder("INBOX");
            folder.open(2);
            Message[] message = folder.getMessages();
            int i = 0;
            while (i < message.length) {
                InternetAddress[] address = (InternetAddress[])((MimeMessage)message[i]).getFrom();
                String from = address[0].getAddress();
                String subject = ((MimeMessage)message[i]).getSubject();
                hm.put(String.valueOf(i + 1) + ":" + subject, from);
                if (delSign) {
                    message[i].setFlag(Flags.Flag.DELETED, true);
                }
                ++i;
            }
            folder.close(true);
            store.close();
        }
        catch (Exception e) {
            WfLog.log(2, "====\u63a5\u6536\u90ae\u4ef6\u5931\u8d25====");
            e.printStackTrace();
        }
        return hm;
    }

    public static void main(String[] args) {
        MailComponent mc = new MailComponent();
        Map hm = mc.receiveMail("pop.163.com", "newbies", "830374", false);
        for (String subject : hm.keySet()) {
            String from = (String)hm.get(subject);
            WfLog.log(2, "from==" + from + ";  subject==" + subject);
        }
    }
}

