/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.xssfilter;

import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    public XssHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public String getHeader(String name) {
        return this.xssEncode(super.getHeader(name));
    }

    public String getParameter(String name) {
        return this.xssEncode(super.getParameter(name));
    }

    public String[] getParameterValues(String name) {
        String[] values = super.getParameterValues(name);
        if (values != null) {
            int length = values.length;
            String[] escapseValues = new String[length];
            for (int i = 0; i < length; ++i) {
                escapseValues[i] = this.xssEncode(values[i]);
            }
            return escapseValues;
        }
        return super.getParameterValues(name);
    }

    public String xssEncode(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        String result = this.stripXSS(s);
        if (null != result) {
            result = this.escape(result);
        }
        return result;
    }

    public String escape(String s) {
        StringBuilder sb = new StringBuilder(s.length() + 16);
        block8: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '>': {
                    sb.append('\uff1e');
                    continue block8;
                }
                case '<': {
                    sb.append('\uff1c');
                    continue block8;
                }
                case '\'': {
                    sb.append('\u2018');
                    continue block8;
                }
                case '\"': {
                    sb.append('\u201c');
                    continue block8;
                }
                case '\\': {
                    sb.append('\uff3c');
                    continue block8;
                }
                case '%': {
                    sb.append('\uff05');
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private String stripXSS(String value) {
        if (value != null) {
            value = value.replaceAll("", "");
            Pattern scriptPattern = Pattern.compile("<script>(.*?)</script>", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("src[\r\n]*=[\r\n]*\\'(.*?)\\'", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("src[\r\n]*=[\r\n]*\\\"(.*?)\\\"", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("</script>", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("<script(.*?)>", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("eval\\((.*?)\\)", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("expression\\((.*?)\\)", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("javascript:", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("vbscript:", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("onload(.*?)=", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("<iframe>(.*?)</iframe>", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("</iframe>", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("<iframe(.*?)>", 42);
            value = scriptPattern.matcher(value).replaceAll("");
        }
        return value;
    }
}

