/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.pub.util;

import com.yucheng.cmis.pub.util.Jboss6VFS;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceUtils {
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String FILE_URL_PREFIX = "file:";
    public static final String URL_PROTOCOL_FILE = "file";
    public static final String URL_PROTOCOL_VFS = "vfs";
    public static final String URL_PROTOCOL_JAR = "jar";
    public static final String URL_PROTOCOL_ZIP = "zip";
    public static final String URL_PROTOCOL_VFSZIP = "vfszip";
    public static final String URL_PROTOCOL_WSJAR = "wsjar";
    public static final String URL_PROTOCOL_CODE_SOURCE = "code-source";
    public static final String JAR_URL_SEPARATOR = "!/";

    public static boolean isUrl(String resourceLocation) {
        if (resourceLocation == null) {
            return false;
        }
        if (resourceLocation.startsWith(CLASSPATH_URL_PREFIX)) {
            return true;
        }
        try {
            new URL(resourceLocation);
            return true;
        }
        catch (MalformedURLException ex) {
            return false;
        }
    }

    public static URL getURL(String resourceLocation) throws FileNotFoundException {
        Validate.notEmpty((String)resourceLocation);
        if (resourceLocation.startsWith(CLASSPATH_URL_PREFIX)) {
            String path = resourceLocation.substring(CLASSPATH_URL_PREFIX.length());
            URL url = ResourceUtils.getClassLoader().getResource(resourceLocation);
            if (url == null) {
                String description = "class path resource [" + path + "]";
                throw new FileNotFoundException(description + " cannot be resolved to URL because it does not exist");
            }
            return url;
        }
        try {
            return new URL(resourceLocation);
        }
        catch (MalformedURLException ex) {
            try {
                return new File(resourceLocation).toURI().toURL();
            }
            catch (MalformedURLException ex2) {
                throw new FileNotFoundException("Resource location [" + resourceLocation + "] is neither a URL not a well-formed file path");
            }
        }
    }

    public static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static File getFile(String resourceLocation) throws FileNotFoundException {
        Validate.notEmpty((String)resourceLocation);
        if (resourceLocation.startsWith(CLASSPATH_URL_PREFIX)) {
            String path = resourceLocation.substring(CLASSPATH_URL_PREFIX.length());
            String description = "class path resource [" + path + "]";
            URL url = ResourceUtils.getClassLoader().getResource(path);
            if (url == null) {
                throw new FileNotFoundException(description + " cannot be resolved to absolute file path " + "because it does not reside in the file system");
            }
            return ResourceUtils.getFile(url, description);
        }
        try {
            return ResourceUtils.getFile(new URL(resourceLocation));
        }
        catch (MalformedURLException ex) {
            return new File(resourceLocation);
        }
    }

    public static File getFile(URL resourceUrl) throws FileNotFoundException {
        return ResourceUtils.getFile(resourceUrl, "URL");
    }

    public static File getFile(URL resourceUrl, String description) throws FileNotFoundException {
        Validate.notNull((Object)resourceUrl);
        if (URL_PROTOCOL_FILE.equals(resourceUrl.getProtocol())) {
            try {
                return new File(ResourceUtils.toURI(resourceUrl).getSchemeSpecificPart());
            }
            catch (URISyntaxException ex) {
                return new File(resourceUrl.getFile());
            }
        }
        if (URL_PROTOCOL_VFS.equals(resourceUrl.getProtocol())) {
            try {
                return Jboss6VFS.getPhysicalFile(resourceUrl);
            }
            catch (Exception e) {
                throw new FileNotFoundException(e.toString());
            }
        }
        throw new FileNotFoundException(description + " cannot be resolved to absolute file path " + "because it does not reside in the file system: " + resourceUrl);
    }

    public static File getFile(URI resourceUri) throws FileNotFoundException {
        return ResourceUtils.getFile(resourceUri, "URI");
    }

    public static File getFile(URI resourceUri, String description) throws FileNotFoundException {
        Validate.notNull((Object)resourceUri);
        if (!URL_PROTOCOL_FILE.equals(resourceUri.getScheme())) {
            throw new FileNotFoundException(description + " cannot be resolved to absolute file path " + "because it does not reside in the file system: " + resourceUri);
        }
        return new File(resourceUri.getSchemeSpecificPart());
    }

    public static boolean isJarURL(URL url) {
        String protocol = url.getProtocol();
        return URL_PROTOCOL_JAR.equals(protocol) || URL_PROTOCOL_ZIP.equals(protocol) || URL_PROTOCOL_VFSZIP.equals(protocol) || URL_PROTOCOL_WSJAR.equals(protocol) || URL_PROTOCOL_CODE_SOURCE.equals(protocol) && url.getPath().indexOf(JAR_URL_SEPARATOR) != -1;
    }

    public static URL extractJarFileURL(URL jarUrl) throws MalformedURLException {
        String urlFile = jarUrl.getFile();
        int separatorIndex = urlFile.indexOf(JAR_URL_SEPARATOR);
        if (separatorIndex != -1) {
            String jarFile = urlFile.substring(0, separatorIndex);
            try {
                return new URL(jarFile);
            }
            catch (MalformedURLException ex) {
                if (!jarFile.startsWith("/")) {
                    jarFile = "/" + jarFile;
                }
                return new URL(FILE_URL_PREFIX + jarFile);
            }
        }
        return jarUrl;
    }

    public static URI toURI(URL url) throws URISyntaxException {
        return ResourceUtils.toURI(url.toString());
    }

    public static URI toURI(String location) throws URISyntaxException {
        return new URI(StringUtils.replace((String)location, (String)" ", (String)"%20"));
    }

    public static List<String> scanResourceFiles(String resourcePath, String fileNameEndWith) throws IOException {
        ArrayList<String> resources = new ArrayList<String>();
        Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(resourcePath);
        while (dirs.hasMoreElements()) {
            URL url = dirs.nextElement();
            String protocol = url.getProtocol();
            if (URL_PROTOCOL_FILE.equals(protocol)) {
                ResourceUtils.getPathResources(resourcePath, url.getFile(), resources, fileNameEndWith);
                continue;
            }
            if (URL_PROTOCOL_VFS.equals(protocol)) {
                System.out.println("-------------url:" + url);
                ResourceUtils.getVFSResources(url, resourcePath, resources, fileNameEndWith);
                continue;
            }
            if (!URL_PROTOCOL_JAR.equals(protocol)) continue;
            JarFile jarFile = ((JarURLConnection)url.openConnection()).getJarFile();
            ResourceUtils.getJarResources(jarFile, resourcePath, resources, fileNameEndWith);
        }
        return resources;
    }

    protected static void getPathResources(String resourcePath, String filePath, List<String> resources, final String fileNameEndWith) {
        File[] dirFiles;
        File dir = new File(filePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        if (!resourcePath.endsWith("/")) {
            resourcePath = resourcePath + "/";
        }
        for (File file : dirFiles = dir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                boolean acceptDir = file.isDirectory();
                boolean acceptClass = file.getName().toLowerCase().endsWith(fileNameEndWith.toLowerCase());
                return acceptDir || acceptClass;
            }
        })) {
            if (file.isDirectory()) {
                ResourceUtils.getPathResources(resourcePath + file.getName(), file.getAbsolutePath(), resources, fileNameEndWith);
                continue;
            }
            String resourceSimpleName = file.getName();
            resources.add(resourcePath + resourceSimpleName);
        }
    }

    protected static void getJarResources(JarFile jarFile, String filepath, List<String> resources, String fileNameEndWith) throws IOException {
        ArrayList<JarEntry> jarEntryList = new ArrayList<JarEntry>();
        Enumeration<JarEntry> enumes = jarFile.entries();
        while (enumes.hasMoreElements()) {
            JarEntry entry = enumes.nextElement();
            if (!entry.getName().startsWith(filepath) || !entry.getName().toLowerCase().endsWith(fileNameEndWith.toLowerCase())) continue;
            jarEntryList.add(entry);
        }
        for (JarEntry entry : jarEntryList) {
            String resourceName = entry.getName();
            try {
                resources.add(resourceName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected static void getVFSResources(URL url, String resourcePath, List<String> resources, String fileNameEndWith) throws IOException {
        String path = resourcePath;
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        Jboss6VFS.VirtualFile virtualFile = Jboss6VFS.VFS.getChild(url);
        List<Jboss6VFS.VirtualFile> children = virtualFile.getChildren();
        for (Jboss6VFS.VirtualFile cvf : children) {
            if (cvf.isDirectory()) {
                ResourceUtils.getVFSResources(cvf.toURL(), path + cvf.getPathNameRelativeTo(virtualFile), resources, fileNameEndWith);
                continue;
            }
            String fileName = cvf.getPathNameRelativeTo(virtualFile);
            if (!fileName.toLowerCase().endsWith(fileNameEndWith.toLowerCase())) continue;
            resources.add(path + cvf.getPathNameRelativeTo(virtualFile));
        }
    }
}

