/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.pub.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    public static final String DATE_PATTERN = "yyyy-MM-dd";

    public static String addDays(String curDate, int days) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        Date date = sdf.parse(curDate);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, days);
        Date newDate = calendar.getTime();
        return sdf.format(newDate);
    }

    public static String addMonths(String curDate, int months) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        Date date = sdf.parse(curDate);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, months);
        Date newDate = calendar.getTime();
        return sdf.format(newDate);
    }

    public static String addYears(String curDate, int years) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        Date date = sdf.parse(curDate);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, years);
        Date newDate = calendar.getTime();
        return sdf.format(newDate);
    }

    public static int getMonth(String curDate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        Date date = sdf.parse(curDate);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int month = calendar.get(2);
        return month + 1;
    }

    public static String getMonthStr(String curDate) throws ParseException {
        int month = DateUtil.getMonth(curDate);
        if (month < 10) {
            return "0" + month;
        }
        return "" + month;
    }

    public static int getDayOfMonth(String curDate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        Date date = sdf.parse(curDate);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayOfMonth = calendar.get(5);
        return dayOfMonth;
    }

    public static String getDayOfMonthStr(String curDate) throws ParseException {
        int dayOfMonth = DateUtil.getDayOfMonth(curDate);
        if (dayOfMonth < 10) {
            return "0" + dayOfMonth;
        }
        return "" + dayOfMonth;
    }

    public static int getYear(String curDate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        Date date = sdf.parse(curDate);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        return year;
    }

    public static int getMonthDays(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, 1);
        int maximum = calendar.getActualMaximum(5);
        return maximum;
    }

    public static String getCurDateStr() {
        return DateUtil.getCurDateStr(DATE_PATTERN);
    }

    public static String getCurDateStr(String pattern) {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        String strDate = sdf.format(date);
        return strDate;
    }

    public static String[] getSpaceMonths(String curDate, int monthSpace, int dateCount) throws ParseException {
        String[] dates = new String[dateCount];
        String tempDate = curDate;
        for (int i = 0; i < dateCount; ++i) {
            dates[i] = tempDate;
            tempDate = DateUtil.addMonths(curDate, monthSpace * (i + 1));
        }
        return dates;
    }

    public static int getQuarterOfMonth(int month) {
        if (month > 12 || month <= 0) {
            return 0;
        }
        return month % 3 == 0 ? month / 3 : month / 3 + 1;
    }

    public static int getCurDateDaysOfCurQuarter(String curDate) throws ParseException {
        String firstDay = DateUtil.getFirstDayOfCurQuarter(curDate);
        int betweenDays = DateUtil.getBetweenDays(firstDay, curDate);
        return betweenDays + 1;
    }

    public static String getLastDayOfCurQuarter(String curDate) throws ParseException {
        int year = DateUtil.getYear(curDate);
        int month = DateUtil.getMonth(curDate);
        int quarter = DateUtil.getQuarterOfMonth(month);
        int lastMonth = quarter * 3;
        int lastDay = DateUtil.getMonthDays(year, lastMonth);
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, lastMonth - 1);
        calendar.set(5, lastDay);
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        return sdf.format(calendar.getTime());
    }

    public static String getFirstDayOfCurQuarter(String curDate) throws ParseException {
        int year = DateUtil.getYear(curDate);
        int month = DateUtil.getMonth(curDate);
        int quarter = DateUtil.getQuarterOfMonth(month);
        int firstMonth = quarter * 3 - 2;
        int firstDay = 1;
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, firstMonth - 1);
        calendar.set(5, firstDay);
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        return sdf.format(calendar.getTime());
    }

    public static String getLastMonthCurDayOfCurQuarter(String curDate) throws ParseException {
        int month = DateUtil.getMonth(curDate);
        int quarter = DateUtil.getQuarterOfMonth(month);
        int lastMonth = quarter * 3;
        String lastMonthCurDay = DateUtil.addMonths(curDate, lastMonth - month);
        return lastMonthCurDay;
    }

    public static int getHalfYearOfMonth(int month) {
        if (month > 12 || month <= 0) {
            return 0;
        }
        return month <= 6 ? 1 : 2;
    }

    public static String getLastMonthCurDayOfCurHalfYear(String curDate) throws ParseException {
        int month = DateUtil.getMonth(curDate);
        int halfYear = DateUtil.getHalfYearOfMonth(month);
        int lastMonth = halfYear * 6;
        String lastMonthCurDay = DateUtil.addMonths(curDate, lastMonth - month);
        return lastMonthCurDay;
    }

    public static String getLastMonthCurDayOfYear(String curDate) throws ParseException {
        int month = DateUtil.getMonth(curDate);
        int lastMonth = 12;
        String lastMonthCurDay = DateUtil.addMonths(curDate, lastMonth - month);
        return lastMonthCurDay;
    }

    public static int getBetweenDays(String curDate1, String curDate2) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        Date date1 = sdf.parse(curDate1);
        Date date2 = sdf.parse(curDate2);
        long bTime = date2.getTime() - date1.getTime();
        return Math.abs(Long.valueOf(bTime / 86400000L).intValue());
    }

    public static int getBetweenMonths(String curDate1, String curDate2) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        Date date1 = sdf.parse(curDate1);
        Date date2 = sdf.parse(curDate2);
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        if (date2.getTime() > date1.getTime()) {
            c1.setTime(date1);
            c2.setTime(date2);
        } else {
            c2.setTime(date1);
            c1.setTime(date2);
        }
        int months = 0;
        while (DateUtil.compareMonth(c1, c2) < 0) {
            ++months;
            c1.add(2, 1);
        }
        return months;
    }

    private static int compareMonth(Calendar c1, Calendar c2) {
        int year1 = c1.get(1);
        int year2 = c2.get(1);
        int month1 = c1.get(2);
        int month2 = c2.get(2);
        if (year1 > year2) {
            return 1;
        }
        if (year2 > year1) {
            return -1;
        }
        if (month1 > month2) {
            return 1;
        }
        if (month1 < month2) {
            return -1;
        }
        return 0;
    }

    public static void main(String[] args) throws ParseException {
        System.out.println(DateUtil.getBetweenDays("2017-03-01", "2017-02-01"));
    }
}

