/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.xssfilter;

import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    public XssHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public String getHeader(String name) {
        return this.xssEncode(super.getHeader(name));
    }

    public String getParameter(String name) {
        return this.xssEncode(super.getParameter(name));
    }

    public String[] getParameterValues(String name) {
        String[] values = super.getParameterValues(name);
        if (values != null) {
            int length = values.length;
            String[] escapseValues = new String[length];
            int i = 0;
            while (i < length) {
                escapseValues[i] = this.xssEncode(values[i]);
                ++i;
            }
            return escapseValues;
        }
        return super.getParameterValues(name);
    }

    public String xssEncode(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        String result = this.stripXSS(s);
        if (result != null) {
            result = this.escape(result);
        }
        return result;
    }

    public String escape(String s) {
        StringBuilder sb = new StringBuilder(s.length() + 16);
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '>': {
                    sb.append('\uff1e');
                    break;
                }
                case '<': {
                    sb.append('\uff1c');
                    break;
                }
                case '\'': {
                    sb.append('\u2018');
                    break;
                }
                case '\"': {
                    sb.append('\u201c');
                    break;
                }
                case '\\': {
                    sb.append('\uff3c');
                    break;
                }
                case '%': {
                    sb.append('\uff05');
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private String stripXSS(String value) {
        if (value != null) {
            value = value.replaceAll("", "");
            Pattern scriptPattern = Pattern.compile("<script>(.*?)</script>", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("src[\r\n]*=[\r\n]*\\'(.*?)\\'", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("src[\r\n]*=[\r\n]*\\\"(.*?)\\\"", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("</script>", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("<script(.*?)>", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("eval\\((.*?)\\)", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("expression\\((.*?)\\)", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("javascript:", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("vbscript:", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("onload(.*?)=", 42);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("<iframe>(.*?)</iframe>", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("</iframe>", 2);
            value = scriptPattern.matcher(value).replaceAll("");
            scriptPattern = Pattern.compile("<iframe(.*?)>", 42);
            value = scriptPattern.matcher(value).replaceAll("");
        }
        return value;
    }
}

