/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.pub.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Random;
import java.util.StringTokenizer;

public class TimeUtil {
    private static final String SEPARATELine = "-";
    private static final String SEPARATEAT = "@";
    private static final String SEPARATEPOINT = ".";
    private static final String SEPARATECOLON = ":";
    private static final TimeUtil instance = new TimeUtil();
    public static final String DTPattern = "yyyy-MM-dd HH:mm:ss ";

    public static final TimeUtil getInstance() {
        return instance;
    }

    public static String getDate(String dateStr, int cz) {
        int yy = Integer.parseInt(dateStr.substring(0, 4), 10);
        int mm = Integer.parseInt(dateStr.substring(4, 6), 10);
        int dd = Integer.parseInt(dateStr.substring(6, 8), 10);
        java.sql.Date d = new java.sql.Date(yy - 1900, mm - 1, dd + cz);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        return sdf.format(d);
    }

    public static int getCurrentMonth(String dateStr) {
        String[] date = dateStr.split(SEPARATELine);
        return Integer.parseInt(date[1], 10);
    }

    public static String getCurMonth(String dateStr) {
        return dateStr.substring(4, 6);
    }

    public static String getMonth(String dateStr) {
        return dateStr.substring(5, 7);
    }

    public static String getCurDay(String dateStr) {
        return dateStr.substring(6);
    }

    public static String getCurYear(String dateStr) {
        return dateStr.substring(0, 4);
    }

    public static String getCurYM(String dateStr) {
        return dateStr.substring(0, 6);
    }

    public static String removeZero(String dateStr) {
        String rv = dateStr;
        if (rv.indexOf("0") == 0) {
            rv = rv.substring(1);
        }
        return rv;
    }

    public static int getMonthDays(int year, int month) {
        int days = 1;
        boolean isrn = year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
        switch (month) {
            case 1: {
                days = 31;
                break;
            }
            case 2: {
                if (isrn) {
                    days = 29;
                    break;
                }
                days = 28;
                break;
            }
            case 3: {
                days = 31;
                break;
            }
            case 4: {
                days = 30;
                break;
            }
            case 5: {
                days = 31;
                break;
            }
            case 6: {
                days = 30;
                break;
            }
            case 7: {
                days = 31;
                break;
            }
            case 8: {
                days = 31;
                break;
            }
            case 9: {
                days = 30;
                break;
            }
            case 10: {
                days = 31;
                break;
            }
            case 11: {
                days = 30;
                break;
            }
            case 12: {
                days = 31;
            }
        }
        return days;
    }

    public static int getMonthDays(String currDate, int year, int month) {
        int days = 1;
        String[] date = currDate.split(SEPARATELine);
        days = Integer.parseInt(date[0]) == year && Integer.parseInt(date[1]) == month ? Integer.parseInt(date[2]) : TimeUtil.getMonthDays(year, month);
        return days;
    }

    public static int getCurrentYear(String dateStr) {
        String[] date = dateStr.split(SEPARATELine);
        return Integer.parseInt(date[0], 10);
    }

    public static int getCurrentDay(String dateStr) {
        String[] date = dateStr.split(SEPARATELine);
        return Integer.parseInt(date[2], 10);
    }

    public static int getJiDuDays(String dateStr) {
        int days = 0;
        String[] date = dateStr.split(SEPARATELine);
        int day = Integer.parseInt(date[2], 10);
        int yy = Integer.parseInt(date[0], 10);
        boolean isrn = yy % 4 == 0 && yy % 100 != 0 || yy % 400 == 0;
        switch (Integer.parseInt(date[1], 10)) {
            case 1: {
                days = day;
                break;
            }
            case 2: {
                days = 31 + day;
                break;
            }
            case 3: {
                if (isrn) {
                    days = 60 + day;
                    break;
                }
                days = 59 + day;
                break;
            }
            case 4: {
                days = day;
                break;
            }
            case 5: {
                days = 30 + day;
                break;
            }
            case 6: {
                days = 61 + day;
                break;
            }
            case 7: {
                days = day;
                break;
            }
            case 8: {
                days = 31 + day;
                break;
            }
            case 9: {
                days = 62 + day;
                break;
            }
            case 10: {
                days = day;
                break;
            }
            case 11: {
                days = 31 + day;
                break;
            }
            case 12: {
                days = 61 + day;
            }
        }
        return days;
    }

    public static int getBetweenDays(String beginDate, String endDate) {
        int sum = 0;
        int beginYear = TimeUtil.getCurrentYear(beginDate);
        int beginMonth = TimeUtil.getCurrentMonth(beginDate);
        int beginDay = TimeUtil.getCurrentDay(beginDate);
        int endYear = TimeUtil.getCurrentYear(endDate);
        int endMonth = TimeUtil.getCurrentMonth(endDate);
        int endDay = TimeUtil.getCurrentDay(endDate);
        String startDateStr = String.valueOf(TimeUtil.bYearZero(beginYear)) + TimeUtil.bZero(beginMonth) + "01";
        int sumMonth = (endYear - beginYear + 1) * 12 - beginMonth - (12 - endMonth);
        int i = 0;
        while (i < sumMonth) {
            String dateStr = TimeUtil.getDateStr(startDateStr, i);
            sum += TimeUtil.getMonthDays(TimeUtil.getCurrentYear(dateStr), TimeUtil.getCurrentMonth(dateStr));
            ++i;
        }
        sum = sum - beginDay + endDay;
        return sum;
    }

    public static String getDateStr(String dateStr, int hkm) {
        String reDateStr = "";
        int yy = Integer.parseInt(dateStr.substring(0, 4), 10);
        int mm = Integer.parseInt(dateStr.substring(4, 6), 10);
        int dd = Integer.parseInt(dateStr.substring(6, 8), 10);
        int yy2 = 0;
        int mm2 = 0;
        int dd2 = dd;
        if ((mm + hkm) % 12 == 0) {
            yy2 = yy + (mm + hkm) / 12 - 1;
            mm2 = 12;
        } else if ((mm + hkm) % 12 == 1) {
            yy2 = yy + (mm + hkm) / 12;
            mm2 = 1;
        } else {
            yy2 = yy + (mm + hkm) / 12;
            mm2 = (mm + hkm) % 12;
        }
        reDateStr = String.valueOf(String.valueOf(yy2)) + SEPARATELine + TimeUtil.bZero(mm2) + SEPARATELine + TimeUtil.bZero(dd2);
        return reDateStr;
    }

    public static String bZero(int sz) {
        return sz < 10 ? "0" + String.valueOf(sz) : String.valueOf(sz);
    }

    public static String bYearZero(int y) {
        if (y < 10) {
            return "000" + String.valueOf(y);
        }
        if (y < 100) {
            return "00" + String.valueOf(y);
        }
        if (y < 1000) {
            return "0" + String.valueOf(y);
        }
        return String.valueOf(y);
    }

    public static int compareDate(String date1, String date2) {
        boolean i = false;
        String[] date1Array = date1.split(SEPARATELine);
        String[] date2Array = date2.split(SEPARATELine);
        java.sql.Date date11 = new java.sql.Date(Integer.parseInt(date1Array[0], 10), Integer.parseInt(date1Array[1], 10), Integer.parseInt(date1Array[2], 10));
        java.sql.Date date22 = new java.sql.Date(Integer.parseInt(date2Array[0], 10), Integer.parseInt(date2Array[1], 10), Integer.parseInt(date2Array[2], 10));
        return date11.compareTo(date22);
    }

    public static Date strToDate(String dateStr) {
        String[] dateArray = dateStr.split(SEPARATELine);
        Date date = new Date(Integer.parseInt(dateArray[0], 10) - 1900, Integer.parseInt(dateArray[1], 10) - 1, Integer.parseInt(dateArray[2], 10));
        return date;
    }

    public static String dateToStr(Date date) {
        String str = "";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            str = sdf.format(date);
        }
        catch (Exception ex) {
            str = "";
        }
        return str;
    }

    public static String dateToStr(Date date, String fgf) {
        String str = "";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy" + fgf + "MM" + fgf + "dd");
            str = sdf.format(date);
        }
        catch (Exception ex) {
            str = "";
        }
        return str;
    }

    public static String getCurDate() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String strDate = sdf.format(date);
        return strDate;
    }

    public static String getCurDate(String formatString) {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat(formatString);
        String strDate = sdf.format(date);
        return strDate;
    }

    public static String getCurTimeStamp() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd@kk:mm:ss.S");
        String strStamp = sdf.format(date);
        return strStamp;
    }

    private static String getCurTimeStamp2() {
        Calendar rightNow = Calendar.getInstance();
        int DD = rightNow.get(5);
        int YYYY = rightNow.get(1);
        int hh = rightNow.get(11);
        int mm = rightNow.get(12);
        int ss = rightNow.get(13);
        int ms = rightNow.get(14);
        String strTimeStamp = null;
        String strYYYY = null;
        String strMM = null;
        String strDD = null;
        String strhh = null;
        String strmm = null;
        String strss = null;
        String strms = null;
        if (YYYY < 10) {
            strYYYY = "000" + String.valueOf(YYYY);
        } else if (YYYY < 100 && YYYY >= 10) {
            strYYYY = "00" + String.valueOf(YYYY);
        } else if (YYYY < 1000 && YYYY >= 100) {
            strYYYY = "0" + String.valueOf(YYYY);
        } else if (YYYY < 10000 && YYYY >= 1000) {
            strYYYY = String.valueOf(YYYY);
        }
        strDD = String.valueOf(DD).length() == 1 ? "0" + String.valueOf(DD) : String.valueOf(DD);
        strhh = String.valueOf(hh).length() == 1 ? "0" + String.valueOf(hh) : String.valueOf(hh);
        strmm = String.valueOf(mm).length() == 1 ? "0" + String.valueOf(mm) : String.valueOf(mm);
        strss = String.valueOf(ss).length() == 1 ? "0" + String.valueOf(ss) : String.valueOf(ss);
        if (ms < 10) {
            strms = "00" + String.valueOf(ms);
        } else if (ms < 100 && ms >= 10) {
            strms = "0" + String.valueOf(ms);
        } else if (ms < 1000 && ms >= 100) {
            strms = String.valueOf(ms);
        }
        strTimeStamp = String.valueOf(strYYYY) + SEPARATELine + strMM + SEPARATELine + SEPARATELine + strDD;
        strTimeStamp = String.valueOf(strTimeStamp) + SEPARATEAT;
        strTimeStamp = String.valueOf(strTimeStamp) + strhh + SEPARATECOLON + strmm + SEPARATECOLON + strss;
        strTimeStamp = String.valueOf(strTimeStamp) + SEPARATEPOINT + strms;
        return strTimeStamp;
    }

    public static String getLastDateOfQuarter(String date) {
        String year = date.substring(0, 4);
        String month = date.substring(5, 7);
        String day = date.substring(7);
        String quarter = "";
        switch (Integer.parseInt(month)) {
            case 1: 
            case 2: 
            case 3: {
                quarter = "03";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                quarter = "06";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                quarter = "09";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                quarter = "12";
            }
        }
        return String.valueOf(year) + quarter + day;
    }

    public static String getLastDateOfYear(String date) {
        String year = String.valueOf(Integer.parseInt(date.substring(0, 4)));
        String day = date.substring(8);
        return String.valueOf(year) + "12" + day;
    }

    public static boolean checkDate1BeforeDate2(String date1, String date2) {
        Date d2;
        Date d1 = TimeUtil.strToDate(date1);
        return d1.before(d2 = TimeUtil.strToDate(date2));
    }

    public static String getQuarter(String str) {
        String rv = "";
        switch (Integer.parseInt(str)) {
            case 1: 
            case 2: 
            case 3: {
                rv = "1";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                rv = "2";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                rv = "3";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                rv = "4";
            }
        }
        return rv;
    }

    public static String getHelfYear(String str) {
        String rv = "";
        switch (Integer.parseInt(str)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                rv = "1";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                rv = "2";
            }
        }
        return rv;
    }

    private static String ADD_DATE(int optype, String date, int num) {
        String st_return = "";
        try {
            DateFormat daf_date = DateFormat.getDateInstance(2, Locale.CHINA);
            daf_date.parse(date);
            Calendar calendar = daf_date.getCalendar();
            calendar.add(optype, num);
            if (optype == 2) {
                calendar.add(5, -1);
            }
            String st_m = "";
            String st_d = "";
            int y = calendar.get(1);
            int m = calendar.get(2) + 1;
            int d = calendar.get(5);
            st_m = m <= 9 ? "0" + m : "" + m;
            st_d = d <= 9 ? "0" + d : "" + d;
            st_return = String.valueOf(y) + SEPARATELine + st_m + SEPARATELine + st_d;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return st_return;
    }

    private static String ADD_DATE2(int optype, String date, int num) {
        String st_return = "";
        try {
            DateFormat daf_date = DateFormat.getDateInstance(2, Locale.CHINA);
            daf_date.parse(date);
            Calendar calendar = daf_date.getCalendar();
            calendar.add(optype, num);
            if (optype == 2) {
                calendar.add(5, 0);
            }
            String st_m = "";
            String st_d = "";
            int y = calendar.get(1);
            int m = calendar.get(2) + 1;
            int d = calendar.get(5);
            st_m = m <= 9 ? "0" + m : "" + m;
            st_d = d <= 9 ? "0" + d : "" + d;
            st_return = String.valueOf(y) + SEPARATELine + st_m + SEPARATELine + st_d;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return st_return;
    }

    public static String ADD_DAY(String date, int n) {
        return TimeUtil.ADD_DATE(5, date, n);
    }

    public static String ADD_MONTH(String date, int n) {
        return TimeUtil.ADD_DATE(2, date, n);
    }

    public static String ADD_MONTH2(String date, int n) {
        return TimeUtil.ADD_DATE2(2, date, n);
    }

    public static String ADD_YEAR(String date, int n) {
        return TimeUtil.ADD_DATE(1, date, n);
    }

    public static String getPeryyMMdd(String yyMMdd, String termType) {
        String rv = yyMMdd;
        Calendar calendar = Calendar.getInstance();
        String m = TimeUtil.getCurMonth(yyMMdd);
        String y = TimeUtil.getCurYear(yyMMdd);
        String d = TimeUtil.getCurDay(yyMMdd);
        int year = Integer.parseInt(y);
        int month = Integer.parseInt(TimeUtil.removeZero(m));
        int date = Integer.parseInt(TimeUtil.removeZero(d));
        calendar.set(year, month, date);
        switch (Integer.parseInt(termType)) {
            case 1: {
                calendar.add(2, -2);
                break;
            }
            case 2: {
                calendar.add(2, -4);
                break;
            }
            case 3: {
                calendar.add(2, -7);
                break;
            }
            case 4: {
                calendar.add(2, -13);
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        rv = sdf.format(calendar.getTime());
        return rv;
    }

    public static String[] getPerNyyMMdd(String yyMMdd, String termType, int term) {
        String[] rv = new String[term];
        Calendar calendar = Calendar.getInstance();
        String m = TimeUtil.getCurMonth(yyMMdd);
        String y = TimeUtil.getCurYear(yyMMdd);
        String d = TimeUtil.getCurDay(yyMMdd);
        int year = Integer.parseInt(y);
        int month = Integer.parseInt(TimeUtil.removeZero(m));
        int date = Integer.parseInt(TimeUtil.removeZero(d));
        rv[0] = yyMMdd;
        int i = 0;
        while (i < term - 1) {
            calendar.set(year, month, date);
            switch (Integer.parseInt(termType)) {
                case 1: {
                    calendar.add(2, -(2 + i));
                    break;
                }
                case 2: {
                    calendar.add(2, -(4 + i * 3));
                    break;
                }
                case 3: {
                    calendar.add(2, -(7 + i * 6));
                    break;
                }
                case 4: {
                    calendar.add(2, -(13 + i * 12));
                }
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            rv[i + 1] = sdf.format(calendar.getTime());
            ++i;
        }
        return rv;
    }

    public static int countMonth(String yyMMdd1, String yyMMdd2) {
        String startDate = yyMMdd1;
        String endDate = yyMMdd2;
        int rv = 0;
        if (Long.parseLong(startDate) > Long.parseLong(endDate)) {
            String tmp = endDate;
            endDate = startDate;
            startDate = tmp;
        }
        int yy1 = Integer.parseInt(startDate.substring(0, 4));
        int mm1 = Integer.parseInt(startDate.substring(4, 6));
        int dd1 = Integer.parseInt(startDate.substring(6));
        int yy2 = Integer.parseInt(endDate.substring(0, 4));
        int mm2 = Integer.parseInt(endDate.substring(4, 6));
        int dd2 = Integer.parseInt(endDate.substring(6));
        rv = (yy2 - yy1) * 12 + (mm2 - mm1);
        return rv;
    }

    public static String getRandomNum(int length) {
        String rt = "";
        int i = 0;
        while (i < length) {
            Random r = new Random();
            rt = String.valueOf(rt) + String.valueOf(r.nextInt(9));
            ++i;
        }
        return rt;
    }

    public static String getCharacterAndNumber(int length) {
        String rt = "";
        Random random = new Random();
        int i = 0;
        while (i < length) {
            String charOrNum;
            String string = charOrNum = random.nextInt(2) % 2 == 0 ? "char" : "num";
            if ("char".equalsIgnoreCase(charOrNum)) {
                int choice = random.nextInt(2) % 2 == 0 ? 65 : 97;
                rt = String.valueOf(rt) + (char)(choice + random.nextInt(26));
            } else if ("num".equalsIgnoreCase(charOrNum)) {
                rt = String.valueOf(rt) + String.valueOf(random.nextInt(10));
            }
            ++i;
        }
        return rt;
    }

    public static String getPK() {
        String rt = "";
        rt = String.valueOf(rt) + TimeUtil.getCurTimeStamp4PK();
        rt = String.valueOf(rt) + TimeUtil.getCharacterAndNumber(15);
        return rt;
    }

    public static String getCurTimeStamp4PK() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddkkmmssSSS");
        String strStamp = sdf.format(date);
        return strStamp;
    }

    public static String getYesterday(String date) {
        try {
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
            Calendar cal = Calendar.getInstance();
            Date d = sf.parse(date);
            cal.setTime(d);
            cal.set(5, cal.get(5) - 1);
            date = sf.format(cal.getTime());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public static String getDateTime(String pattern) {
        String dateTime = "";
        Calendar calender = Calendar.getInstance();
        if (pattern == null || pattern.equals("")) {
            pattern = DTPattern;
        }
        SimpleDateFormat sf = new SimpleDateFormat(pattern);
        dateTime = sf.format(calender.getTime());
        return dateTime;
    }

    public static int getBetweenYears(String startDate, String endDate) {
        int yearNum = 0;
        int startYear = TimeUtil.getCurrentYear(startDate);
        int endYear = TimeUtil.getCurrentYear(endDate);
        int startMonth = TimeUtil.getCurrentMonth(startDate);
        int endMonth = TimeUtil.getCurrentMonth(endDate);
        int startDay = TimeUtil.getCurrentDay(startDate);
        int endDay = TimeUtil.getCurrentDay(endDate);
        yearNum = endYear - startYear;
        if (yearNum > 0) {
            if (endMonth < startMonth) {
                --yearNum;
            } else if (endMonth == startMonth && endDay < startDay) {
                --yearNum;
            }
        }
        return yearNum;
    }

    public static String getDateStrByDate(String dateStr, int hkm) {
        String reDateStr = "";
        int yy = Integer.parseInt(dateStr.substring(0, 4), 10);
        int mm = Integer.parseInt(dateStr.substring(5, 7), 10);
        int dd = Integer.parseInt(dateStr.substring(8, 10), 10);
        int yy2 = 0;
        int mm2 = 0;
        int dd2 = dd;
        if ((mm + hkm) % 12 == 0) {
            yy2 = yy + (mm + hkm) / 12 - 1;
            mm2 = 12;
        } else if ((mm + hkm) % 12 == 1) {
            yy2 = yy + (mm + hkm) / 12;
            mm2 = 1;
        } else {
            yy2 = yy + (mm + hkm) / 12;
            mm2 = (mm + hkm) % 12;
        }
        reDateStr = String.valueOf(String.valueOf(yy2)) + SEPARATELine + TimeUtil.bZero(mm2) + SEPARATELine + TimeUtil.bZero(dd2);
        return reDateStr;
    }

    public static int getBetweenYearsByYM(String startDate, int year, int month) {
        int yearNum = 0;
        int startYear = TimeUtil.getCurrentYear(startDate);
        int startMonth = TimeUtil.getCurrentMonth(startDate);
        yearNum = year - startYear;
        if (yearNum > 0 && month < startMonth) {
            --yearNum;
        }
        return yearNum;
    }

    public static String getDateDiff(long times) {
        long oneDay = 86400000L;
        long oneHou = 3600000L;
        long oneMin = 60000L;
        long day = times / oneDay;
        long hours = times % oneDay / oneHou;
        long mint = times % oneDay % oneHou / oneMin;
        String outStr = day > 0L ? String.valueOf(day) + "\u5929" + hours + "\u5c0f\u65f6" + mint + "\u5206\u949f" : (hours > 0L ? String.valueOf(hours) + "\u5c0f\u65f6" + mint + "\u5206\u949f" : (mint > 0L ? String.valueOf(mint) + "\u5206\u949f" : "0\u5206\u949f"));
        return outStr;
    }

    public static String getDateOfCountMonth(String date, int count) {
        Calendar cal = TimeUtil.getCalendarObject(date);
        cal.add(2, count);
        return new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH).format(cal.getTime());
    }

    public static Calendar getCalendarObject(String date) {
        StringTokenizer str = new StringTokenizer(date, SEPARATELine);
        int year = Integer.parseInt(str.nextToken());
        int month = Integer.parseInt(str.nextToken());
        int day = Integer.parseInt(str.nextToken());
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, day);
        return cal;
    }

    public static String formatStrDt(String dateStr) {
        String str = "";
        try {
            String year = dateStr.substring(0, 4);
            String month = dateStr.substring(5, 7);
            String day = dateStr.substring(8, 10);
            str = String.valueOf(year) + month + day;
        }
        catch (Exception ex) {
            str = "";
        }
        return str;
    }

    public static int getMonthSpace(String date1, String date2) {
        int result = 0;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Calendar c1 = Calendar.getInstance();
            Calendar c2 = Calendar.getInstance();
            c1.setTime(sdf.parse(date1));
            c2.setTime(sdf.parse(date2));
            result = c2.get(2) - c1.get(2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result == 0 ? 1 : Math.abs(result);
    }

    public static String getLastDayOfMonth(String date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String month = date.substring(5, 7);
        String year = date.substring(0, 4);
        int days = 1;
        boolean isrn = Integer.parseInt(year) % 4 == 0 && Integer.parseInt(year) % 100 != 0 || Integer.parseInt(year) % 400 == 0;
        switch (Integer.parseInt(month)) {
            case 1: {
                days = 31;
                break;
            }
            case 2: {
                if (isrn) {
                    days = 29;
                    break;
                }
                days = 28;
                break;
            }
            case 3: {
                days = 31;
                break;
            }
            case 4: {
                days = 30;
                break;
            }
            case 5: {
                days = 31;
                break;
            }
            case 6: {
                days = 30;
                break;
            }
            case 7: {
                days = 31;
                break;
            }
            case 8: {
                days = 31;
                break;
            }
            case 9: {
                days = 30;
                break;
            }
            case 10: {
                days = 31;
                break;
            }
            case 11: {
                days = 30;
                break;
            }
            case 12: {
                days = 31;
            }
        }
        String last_date = String.valueOf(date.substring(0, 7)) + SEPARATELine + days;
        return last_date;
    }

    public static String getFirthDayOfMonth(String date) {
        String s = String.valueOf(date.substring(0, 7)) + "-01";
        return s;
    }
}

