/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.view;

import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.log.EMPLog;
import com.ecc.emp.session.SessionManager;
import com.ecc.emp.web.servlet.view.JSPView;
import com.yucheng.cmis.view.RedirectParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RedirectView
extends JSPView {
    private List params;

    public void render(Map model, HttpServletRequest request, HttpServletResponse response, String jspRootPath) {
        try {
            SessionManager sessionManager;
            String path = this.getUrl();
            if (!this.getUrl().startsWith("/")) {
                path = String.valueOf(jspRootPath) + this.getUrl();
            }
            if ((sessionManager = (SessionManager)request.getAttribute(EMPConstance.ATTR_SESSION_MGR)) != null) {
                path = sessionManager.encodeURL(request, response, path, "GET");
            }
            this.setModelToRequest(model, request);
            if (this.params != null) {
                StringBuffer buf = new StringBuffer();
                int i = 0;
                while (i < this.params.size()) {
                    RedirectParam param = (RedirectParam)this.params.get(i);
                    String paramName = param.getParamName();
                    String paramValue = param.getParamValue(request);
                    if (i != 0) {
                        buf.append("&");
                    }
                    buf.append(paramName).append("=").append(paramValue);
                    ++i;
                }
                path = path.indexOf("?") != -1 ? String.valueOf(path) + "&" + buf.toString() : String.valueOf(path) + "?" + buf.toString();
            }
            RequestDispatcher dispatcher = request.getRequestDispatcher(response.encodeRedirectURL(path));
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.ERROR, (int)0, (String)("Failed to render to " + this.getUrl()), (Throwable)e);
        }
    }

    public void addRedirectParam(RedirectParam param) {
        if (this.params == null) {
            this.params = new ArrayList();
        }
        this.params.add(param);
    }
}

