/*
 * Decompiled with CFR 0.152.
 */
package com.yucheng.cmis.view;

import com.ecc.emp.core.Context;
import com.ecc.emp.core.EMPConstance;
import com.ecc.emp.data.IndexedCollection;
import com.ecc.emp.data.KeyedCollection;
import com.ecc.emp.log.EMPLog;
import com.ecc.emp.web.servlet.view.AbstractView;
import com.yucheng.cmis.cache.CacheClient;
import com.yucheng.cmis.view.excel.ExcelColumn;
import com.yucheng.cmis.view.excel.ExcelSheet;
import com.yucheng.cmis.view.excel.ExcelWorkbook;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class ExcelView
extends AbstractView {
    private String fileName;
    private short headFont = (short)700;
    private short bodyFont = 0;
    private int maxColSize = 8000;
    private int maxCalColSize = 10000;
    private ExcelWorkbook excelWorkbook;

    public void render(Map model, HttpServletRequest request, HttpServletResponse response, String rootPath) {
        try {
            Context context = (Context)model.get(EMPConstance.ATTR_CONTEXT);
            this.writeExcelByPOI(context, request, response, rootPath);
        }
        catch (Exception e) {
            EMPLog.log((String)EMPConstance.EMP_MVC, (int)EMPLog.ERROR, (int)0, (String)"Failed to return the excelView!", (Throwable)e);
        }
    }

    protected String getDisplayName(String value, String iCollName, Context context) {
        if (StringUtils.isBlank((String)value) || StringUtils.isBlank((String)iCollName)) {
            return value;
        }
        String decoratedValue = value;
        try {
            IndexedCollection iColl = CacheClient.getDictByType((Context)context, (String)iCollName);
            if (iColl == null) {
                EMPLog.log((String)"CMIS", (int)EMPLog.WARNING, (int)0, (String)("\u4f7f\u7528\u5b57\u5178\u4fee\u9970\u6570\u636e\u65f6\u51fa\u9519\uff01\u4e0d\u5b58\u5728\u540d\u4e3a" + iCollName + "\u7684\u5b57\u5178\u9879\uff01"));
                return value;
            }
            int i = 0;
            while (i < iColl.size()) {
                KeyedCollection kColl = (KeyedCollection)iColl.get(i);
                String enname = (String)kColl.getDataValue("enname");
                if (value.equals(enname)) {
                    String cnname;
                    decoratedValue = cnname = (String)kColl.getDataValue("cnname");
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            EMPLog.log((String)"CMIS", (int)EMPLog.WARNING, (int)0, (String)"\u4f7f\u7528\u5b57\u5178\u4fee\u9970\u6570\u636e\u65f6\u51fa\u9519\uff01", (Throwable)e);
        }
        return decoratedValue;
    }

    public void writeExcelByPOI(Context context, HttpServletRequest request, HttpServletResponse response, String rootPath) throws Exception {
        HSSFWorkbook workbook = new HSSFWorkbook();
        List excelSheets = this.excelWorkbook.getExcelSheets();
        HSSFCellStyle cellStyleTitle = workbook.createCellStyle();
        HSSFCellStyle cellStyle_body = workbook.createCellStyle();
        int i = 0;
        while (i < excelSheets.size()) {
            ExcelSheet excelSheet = (ExcelSheet)excelSheets.get(i);
            String iCollName = excelSheet.getICollName();
            IndexedCollection iColl = (IndexedCollection)context.getDataElement(iCollName);
            HSSFSheet sheet = workbook.createSheet(excelSheet.getName());
            HSSFFont fontHead = workbook.createFont();
            fontHead.setBoldweight(this.headFont);
            fontHead.setBoldweight((short)700);
            fontHead.setFontHeightInPoints((short)11);
            fontHead.setColor((short)9);
            cellStyleTitle.setFont(fontHead);
            cellStyleTitle.setFillPattern((short)1);
            cellStyleTitle.setFillForegroundColor((short)55);
            cellStyleTitle.setAlignment((short)2);
            cellStyleTitle.setVerticalAlignment((short)6);
            List excelColumns = excelSheet.getExcelColumns();
            int[] columnsLen = new int[excelColumns.size()];
            int calColLenSize = 0;
            boolean isTitle = excelSheet.isTitle();
            if (isTitle) {
                HSSFRow row = sheet.createRow(0);
                row.setHeight((short)450);
                int k = 0;
                while (k < excelColumns.size()) {
                    ExcelColumn excelColumn = (ExcelColumn)excelColumns.get(k);
                    HSSFCell cell = row.createCell(k);
                    cell.setCellStyle(cellStyleTitle);
                    cell.setCellType(1);
                    cell.setCellValue(excelColumn.name);
                    ++calColLenSize;
                    int relLen = this.getLength(excelColumn.name);
                    if (relLen < this.maxColSize) {
                        sheet.setColumnWidth(k, relLen);
                        columnsLen[k] = relLen;
                    } else {
                        sheet.setColumnWidth(k, this.maxColSize);
                        columnsLen[k] = this.maxColSize;
                    }
                    ++k;
                }
            }
            HSSFFont font_body = workbook.createFont();
            font_body.setBoldweight(this.bodyFont);
            cellStyle_body.setFont(font_body);
            cellStyle_body.setWrapText(true);
            int j = 0;
            while (j < iColl.size()) {
                KeyedCollection kColl = (KeyedCollection)iColl.get(j);
                HSSFRow row = null;
                row = isTitle ? sheet.createRow(j + 1) : sheet.createRow(j);
                int k = 0;
                while (k < excelColumns.size()) {
                    String cellType;
                    ExcelColumn excelColumn = (ExcelColumn)excelColumns.get(k);
                    String dataName = excelColumn.dataName;
                    HSSFCell cell = row.createCell(k);
                    String value = String.valueOf(kColl.getDataValue(dataName));
                    if (value == null || value.equals("null")) {
                        value = excelColumn.defalutValue;
                    }
                    if (value == null || value.equals("null")) {
                        value = "";
                    }
                    if ("numeric".equals(cellType = excelColumn.cellType)) {
                        cell.setCellType(0);
                        cell.setCellValue(new Double(value).doubleValue());
                    } else if ("formula".equals(cellType)) {
                        cell.setCellType(2);
                        cell.setCellValue(value);
                    } else {
                        String dictName = excelColumn.dictName;
                        if (dictName != null) {
                            value = this.getDisplayName(value, dictName, context);
                        }
                        cell.setCellStyle(cellStyle_body);
                        cell.setCellType(1);
                        cell.setCellValue(value);
                    }
                    if (calColLenSize <= this.maxCalColSize) {
                        ++calColLenSize;
                        int relLen = this.getLength(value);
                        if (relLen < this.maxColSize && relLen > columnsLen[k]) {
                            sheet.setColumnWidth(k, relLen);
                            columnsLen[k] = relLen;
                        } else if (relLen > this.maxColSize) {
                            sheet.setColumnWidth(k, this.maxColSize);
                            columnsLen[k] = this.maxColSize;
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        String fileName = this.excelWorkbook.getFileName();
        String contentType = "application/msexcel";
        response.setContentType(contentType);
        response.addHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        ServletOutputStream servletOS = response.getOutputStream();
        workbook.write((OutputStream)servletOS);
        servletOS.flush();
        servletOS.close();
        response.flushBuffer();
    }

    private final int getLength(String str) {
        int defAddLenA = 300;
        int defAddLenB = 500;
        if (str == null) {
            return 4;
        }
        int zhCount = 0;
        int retLength = 0;
        char[] charArray = str.toCharArray();
        int i = 0;
        while (i < charArray.length) {
            if (charArray[i] >= '\u4e00' && charArray[i] <= '\u9fbb') {
                ++zhCount;
            }
            ++i;
        }
        retLength = str.length() * defAddLenA + zhCount * defAddLenB;
        return retLength;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public ExcelWorkbook getExcelWorkbook() {
        return this.excelWorkbook;
    }

    public void setExcelWorkbook(ExcelWorkbook excelWorkbook) {
        this.excelWorkbook = excelWorkbook;
    }

    public short getBodyFont() {
        return this.bodyFont;
    }

    public void setBodyFont(short bodyFont) {
        this.bodyFont = bodyFont;
    }

    public short getHeadFont() {
        return this.headFont;
    }

    public void setHeadFont(short headFont) {
        this.headFont = headFont;
    }
}

